/***************************************************************************
 *                                                                         *
 *   FAZCUT.C    (CMDUTL.C)                                                *
 *                                                                         *
 *   Copyright (C) 1984, 1986, 1991 GALACTICOMM, Inc. All Rights Reserved. *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "fazdat.h"
#include "galfaz.h"

extern char *fazatr;

STATIC void updctr(void);
STATIC void tinla(void);
STATIC void sptgrp(int class,int count,int oclass[]);
STATIC void zapthe(void);

void
game(void)                    /* main <CR>-input handler when in game      */
{
     if (urgc == 0) {
          btuxmt(pyrctr,fazatr);
          if (usrptr->flags&ABOIP) {
               btuxmt(pyrctr,"\r");
          }
          else {
               btuxmt(pyrctr,"...Type \"help\" for help.\r");
          }
     }
     else {
          zapthe();
          sttptr=pyrptr->sttptr;
          if (hasmkey(FAZKEY)) {
               if (!(*(sttptr->cmhdlr))()) {
                    updctr();
                    return;
               }
          }
          if (!stdcmd()) {
               updctr();
               return;
          }
          if (urgc == 1) {
               *urgv[0]=toupper(*urgv[0]);
               mspstg("...%s what?\r",urgv[0]);
          }
          else if (stgcmp(urgv[0],"because") == 0) {
               addmbf("...That's a lousy reason!\r");
          }
          else if (*urgv[0] == 'i') {
               addmbf("...Why explain your problems to a machine?\r");
          }
          else if (urgc == 2) {
               recomb();
               mspstg("...What good does it do to %s?\r",urgv[0]);
          }
          else if (urgc == 3) {
               recomb();
               mspstg("...Why would you want to %s?\r",urgv[0]);
          }
          else if (urgc == 4) {
               recomb();
               mspstg("...How do you expect to %s?\r",urgv[0]);
          }
          else {
               addmbf("...Oh, baloney!\r");
          }
          if (pyrptr->newflg&FLOBIT) {
               addmbf("   (Type \"help\" for help.)\r");
               pyrptr->newflg&=~FLOBIT;
          }
          gibber();
          infoth((pyrptr->logon&SEXBIT) ? "mumbling incoherently to himself" :
                                          "mumbling incoherently to herself");
     }
}

STATIC void
updctr(void)                  /* update object counters for delayed effects */
{
     for (objidx=0 ; objidx < pyrptr->nobjs ; objidx++) {
          if (pyrptr->pobjct[objidx] != 0) {
               if (--(pyrptr->pobjct[objidx]) == 0) {
                    (*(pyrptr->pyrobj[objidx]->objtvc))();
               }
          }
     }
}

int
move(dstspt,lvmsg,entmsg)     /* movement utility w/msgs to others         */
struct state *dstspt;
char *lvmsg,*entmsg;
{
     if (urgc > 1) {
          return(1);
     }
     if (dstspt == NULL) {
          btuxmt(pyrctr,"...You can't go that way.\r");
          infoth("crashing around blindly");
     }
     else {
          lvstt(lvmsg);
          ntrstt(dstspt,entmsg);
     }
     return(0);
}

int
shove(dstspt,lvdir,entmsg)    /* shove utility w/msgs to others            */
struct state *dstspt;
char *lvdir,*entmsg;
{
     struct player **tmpypp;
     struct player *prpsav;
     int prcsav;

     if (dstspt == NULL) {
          mspstg("...%s crashes against the ",othpyr->auxhdl);
          mspstg("%s wall!\r",lvdir);
          gibber();
          mspstg("***\r%s has just shoved you against the ",pyrptr->auxhdl);
          mspstg("%s wall!\r",lvdir);
          outpyr(othpyr);
          mspstg("***\r%s has just shoved ",pyrptr->auxhdl);
          addmbf(othpyr->auxhdl);
          mspstg(" against the %s wall!\r",lvdir);
          outexc(othpyr);
     }
     else {
          mspstg("...You caught %s by surprise!\r",othpyr->auxhdl);
          gibber();
          mspstg("***\r%s has just shoved you away to the ",pyrptr->auxhdl);
          mspstg("%s!\r",lvdir);
          outpyr(othpyr);
          mspstg("***\r%s has just shoved ",pyrptr->auxhdl);
          addmbf(othpyr->auxhdl);
          mspstg(" away to the %s!\r",lvdir);
          outexc(othpyr);
          tmpypp=&(othpyr->sttptr->plhead);
          while (*tmpypp != othpyr) {
               tmpypp=&((**tmpypp).nxtpyr);
          }
          *tmpypp=othpyr->nxtpyr;
          prpsav=pyrptr;
          prcsav=pyrctr;
          pyrptr=othpyr;
          pyrctr=(int)(othpyr-pyrarr);
          ntrstt(dstspt,entmsg);
          pyrptr=prpsav;
          pyrctr=prcsav;
     }
     return(0);
}

void
ntrstt(svcptr,txtptr)         /* enter-a-state utility, with msg to others */
struct state *svcptr;
char *txtptr;
{
     int i,j,k;

     pyrptr->logon|=INGAME;
     pyrptr->nxtpyr=svcptr->plhead;
     svcptr->plhead=pyrptr;
     pyrptr->sttptr=svcptr;
     if (!invis(pyrptr)) {
          mspstg("***\r%s has just ",pyrptr->auxhdl);
          addmbf(txtptr);
          addmbf("!\r");
          fazoth();
     }
     if (pyrptr->logon&BRFBIT) {
          mspstg("...You're %s.",svcptr->sdscrp);
          whther();
          whoher();
          gibber();
          return;
     }
     for (i=0 ; i < NVSTMN ; ) {
          if (pyrptr->vsttes[i++] == svcptr->sttmsg) {
               mspstg("...You're %s.",svcptr->sdscrp);
               whther();
               whoher();
               gibber();
               return;
          }
     }
     for (i=0,j=0 ; i < NVSTMN ; i++) {
          if (--(pyrptr->vages[i]) < j) {
               j=pyrptr->vages[i];
               k=i;
          }
     }
     pyrptr->vages[k]=0;
     pyrptr->vsttes[k]=(svcptr->sttmsg);
     prfmsg(svcptr->sttmsg);
     whther();
     whoher();
     gibber();
}

void
whoher(void)                  /* "who's here?" - id of others to player    */
{
     int ctr;
     int frcflg;

     frcflg=hold(&objcts[42]);
     ctr=0;
     othpyr=pyrptr->sttptr->plhead;
     while (1) {
          if (othpyr != pyrptr) {
               if (!invis(othpyr) || frcflg) {
                    ctr+=1;
               }
          }
          if ((othpyr=othpyr->nxtpyr) == NULL) {
               break;
          }
     }
     if (ctr == 0) {
          return;
     }
     if (ctr == 1) {
          --ctr;
     }
     othpyr=pyrptr->sttptr->plhead;
     while (1) {
          if (othpyr != pyrptr) {
               if (!invis(othpyr) || frcflg) {
                    if (invis(othpyr)) {
                         mspstg("%s (your fracas hums for a moment)",
                              othpyr->plyrid);
                    }
                    else {
                         addmbf(othpyr->auxhdl);
                    }
                    if (--ctr > 1) {
                         addmbf(", ");
                    }
                    else if (ctr == 1) {
                         addmbf(" and ");
                    }
                    else if (ctr == 0) {
                         addmbf(" are here.\r");
                         break;
                    }
                    else if (ctr < 0) {
                         addmbf(" is here.\r");
                         break;
                    }
               }
          }
          othpyr=othpyr->nxtpyr;
     }
}

void
whther(void)                  /* "what's here" - id of objects to player   */
{
     int i,j,k,l;
     int oclass[NOBJST],oclcnt[NOBJST+1],oclrep[NOBJST+1];

     if ((j=pyrptr->sttptr->nobjs) != 0) {
          for (i=0 ; i < j ; i++) {
               oclass[i]=0;
          }
          k=0;
          for (i=0 ; i < j ; i++) {
               if (oclass[i] == 0
                 && (pyrptr->sttptr->sttobj[i]->flags&OBJNVS) == 0) {
                    oclass[i]=++k;
                    oclrep[k]=i;
                    oclcnt[k]=1;
                    for (l=i+1 ; l < j ; l++) {
                         if (pyrptr->sttptr->sttobj[l]->positn ==
                             pyrptr->sttptr->sttobj[i]->positn) {
                              oclass[l]=k;
                              oclcnt[k]+=1;
                         }
                    }
               }
          }
          if (k != 0) {
               addmbf("  There is a ");
               for (i=1 ;; i++) {
                    sptgrp(i,oclcnt[i],oclass);
                    mobjps(pyrptr->sttptr->sttobj[oclrep[i]]);
                    if (i == k) {
                         addmbf(".\r");
                         break;
                    }
                    else if (i == k-1) {
                         addmbf(" and a ");
                    }
                    else {
                         addmbf(", a ");
                    }
               }
          }
          else {
               tinla();
          }
     }
     else {
          tinla();
     }
     noistt=0;
}

STATIC void
tinla(void)                   /* "there is nothing lying around" utility   */
{
     if (noistt == -1) {
          addmbf("There is nothing lying around.");
     }
     addmbf("\r");
}

STATIC void
sptgrp(class,count,oclass)    /* spit out a group of objects to player     */
int class,count,oclass[];
{
     int i,ndun;

     for (i=0,ndun=0 ;; i++) {
          if (oclass[i] == class) {
               addmbf(pyrptr->sttptr->sttobj[i]->name);
               if (++ndun == count) {
                    break;
               }
               else if (ndun == count-1) {
                    addmbf(" and a ");
               }
               else {
                    addmbf(", a ");
               }
          }
     }
}

void
mobjps(zbjptr)                /* make object position relative to state    */
struct object *zbjptr;
{
     mspstg(zbjptr->positn,pyrptr->sttptr->sobjlc);
}

void
lvstt(txtptr)                 /* leave-state utility, with msg to others   */
char *txtptr;
{
     struct player **tmpypp;

     pyrptr->logon&=~INGAME;
     tmpypp=&(pyrptr->sttptr->plhead);
     while (*tmpypp != pyrptr) {
          tmpypp=&((**tmpypp).nxtpyr);
     }
     *tmpypp=pyrptr->nxtpyr;
     if (pyrptr->sttptr->plhead != NULL) {
          if (!invis(pyrptr)) {
               mspstg("***\r%s has just ",pyrptr->auxhdl);
               addmbf(txtptr);
               addmbf("!\r");
               fazoth();
          }
     }
}

STATIC void
zapthe(void)                  /* remove "the" and "a" from input line      */
{
     zapwrd("the");
     zapwrd("a");
}

void
zapwrd(word)                  /* remove a specified word from input line   */
char *word;
{
     int i,j;

     for (i=1 ; i < urgc-1 ; i++) {
          if (stgcmp(urgv[i],word) == 0) {
               *arge[i+1]=' ';
               urgc-=1;
               for (j=i ; j < urgc ; j++) {
                    urgv[j]=urgv[j+1];
                    arge[j+1]=arge[j+2];
               }
          }
     }
}

void
donthv(void)                  /* you-don't-have-one input rejection        */
{
     btuxmt(pyrctr,"...You can't, you aren't holding one.\r");
     infoth("hallucinating a little");
}

void
ainthr(argno)                 /* "he ain't there" input rejection          */
int argno;
{
     if (stgcmp(urgv[argno],"Some") == 0
       || stgcmp(urgv[argno],"Unseen") == 0
       || stgcmp(urgv[argno],"Force") == 0) {
          btuxmt(pyrctr,"...The force is unseen!\r");
     }
     else {
          mspstg("...You can't, %s doesn't appear to be here.\r",urgv[argno]);
          gibber();
     }
     infoth("clutching at phantoms");
}

int
holdng(obj)                   /* return true if player is holding object   */
struct object *obj;
{
     for (objidx=0 ; objidx < pyrptr->nobjs ; objidx++) {
          if (pyrptr->pyrobj[objidx] == obj) {
               return(1);
          }
     }
     return(0);
}

int
hold(obj)                     /* same as above but with local objidx       */
struct object *obj;
{
     int objidx;

     for (objidx=0 ; objidx < pyrptr->nobjs ; objidx++) {
          if (pyrptr->pyrobj[objidx] == obj) {
               return(1);
          }
     }
     return(0);
}

int
hldoth(obj)                   /* see if the "other" guy is holding a object */
struct object *obj;
{
     int objidx;

     for (objidx=0 ; objidx < othpyr->nobjs ; objidx++) {
          if (othpyr->pyrobj[objidx] == obj) {
               return(1);
          }
     }
     return(0);
}

int
invis(pyrp)                   /* return true if player is invisible        */
struct player *pyrp;
{
     return(pyrp->auxhdl[4] == 32);
}

int
iszleen(pyrp)                 /* return true if player is a zleen          */
struct player *pyrp;
{
     return(strlen(pyrp->auxhdl) > 9 && !invis(pyrp));
}
