/***************************************************************************
 *                                                                         *
 *   FAZCST.C    (CMDSTF.C)                                                *
 *                                                                         *
 *   Copyright (C) 1984, 1986, 1991 GALACTICOMM, Inc. All Rights Reserved. *
 *                 1992                                                    *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "fazdat.h"
#include "galfaz.h"

static struct kwctab {        /* user command keyword table data structure */
     char *kyword;                 /* command verb                         */
     int (*subadr)();              /* handler address                      */
     char payonl;                  /* live-users-only flag                 */
} *kwcptr;

STATIC int drprtn(void);
STATIC int drputl(void);
STATIC int throwr(void);
STATIC void thrutl(void);
STATIC int invcmd(void);
STATIC int looker(void);
STATIC int jckpls(void);
STATIC void speclk(void);
STATIC void larnd(void);
STATIC int whortn(void);
STATIC void nnutl(char *relat);
STATIC int brfrtn(void);
STATIC int unbrtn(void);
STATIC int assemb(void);
STATIC void assutl(void);
STATIC int sitrtn(void);
STATIC int liertn(void);
STATIC int stnrtn(void);
STATIC int lghrtn(void);
STATIC int shfrtn(void);
STATIC int pshrtn(void);
STATIC int aimrtn(void);
STATIC void pfish(void);
STATIC int kckrtn(void);
STATIC int tnkrtn(void);
STATIC int reartn(void);
STATIC int opnrtn(void);
STATIC int clsrtn(void);
STATIC int digrtn(void);
STATIC int usertn(void);
STATIC int sqzrtn(void);
STATIC int jmprtn(void);
STATIC int clbrtn(void);
STATIC int upyrtn(void);
STATIC int fckrtn(void);
STATIC int swgrtn(void);
STATIC int wrtrtn(void);
STATIC int smkrtn(void);
STATIC int nocndo(int msgno);
STATIC int clprtn(void);
STATIC int snkrtn(void);
STATIC int grnrtn(void);
STATIC int smlrtn(void);
STATIC int nodrtn(void);
STATIC int blhrtn(void);
STATIC int pourtn(void);
STATIC int frwrtn(void);
STATIC int ptwrtn(void);
STATIC int smprtn(void);
STATIC int snrrtn(void);
STATIC int snortn(void);
STATIC int gwlrtn(void);
STATIC int wnkrtn(void);
STATIC int grirtn(void);
STATIC int grortn(void);
STATIC int gntrtn(void);
STATIC int hssrtn(void);
STATIC int boortn(void);
STATIC int scwrtn(void);
STATIC int bnkrtn(void);
STATIC int gigrtn(void);
STATIC int clkrtn(void);
STATIC int glrrtn(void);
STATIC int ywnrtn(void);
STATIC int trdrtn(void);
STATIC int bowrtn(void);
STATIC int snzrtn(void);
STATIC int cryrtn(void);
STATIC int sihrtn(void);
STATIC int srgrtn(void);
STATIC int drlrtn(void);
STATIC int pntrtn(void);
STATIC int fdgrtn(void);
STATIC int gsprtn(void);
STATIC int whzrtn(void);
STATIC int gglrtn(void);
STATIC int humrtn(void);
STATIC int brprtn(void);
STATIC int frtrtn(void);
STATIC int tlprtn(void);
STATIC int dncrtn(void);
STATIC int inject(void);
STATIC int shvrtn(void);
STATIC int mvgowk(void);
STATIC int spctch(void);
STATIC int helper(void);
STATIC struct kwctab *binkwc(char *stgptr,struct kwctab table[],int length);


static
struct kwtab  *kwtptr;        /* scratch keyword table ptr                 */
static
struct kwntab *kwnptr;        /* scratch keyword-numeric table ptr         */

char *
zhisher(pyrp)                 /* return "his", "her", or "its", as approp. */
struct player *pyrp;
{
     return((invis(pyrp) || iszleen(pyrp)) ? "its" :
                                ((pyrp->logon&SEXBIT) ? "his" : "her"));
}

char *
zheshe(pyrp)                  /* return "he", "she", or "it", as approp.   */
struct player *pyrp;
{
     return((invis(pyrp) || iszleen(pyrp)) ? "it" :
                                ((pyrp->logon&SEXBIT) ? "he" : "she"));
}

struct state *
fndpyr(hdlstg)                /* find player, return state (room) ptr      */
char *hdlstg;
{
     *hdlstg=toupper(*hdlstg);
     for (othpyr=pyrarr; othpyr != pyrarr+nterms ; othpyr++) {
          if ((othpyr->logon&INGAME)
            && stgcmp(othpyr->plyrid,hdlstg) == 0) {
               return(othpyr->sttptr);
          }
     }
     *hdlstg=tolower(*hdlstg);
     return(NULL);
}

struct player *
fndhdl(schstg)                /* find handle, return player ptr            */
char *schstg;
{
     struct player *tmpypt;

     *schstg=toupper(*schstg);
     tmpypt=pyrptr->sttptr->plhead;
     if (hold(&objcts[42])) {
          while (1) {
               if (nmatch(schstg,tmpypt->plyrid)) {
                    return(tmpypt);
               }
               if ((tmpypt=tmpypt->nxtpyr) == NULL) {
                    return(NULL);
               }
          }
     }
     else {
          while (1) {
               if (nmatch(schstg,tmpypt->auxhdl) && !invis(tmpypt)) {
                    return(tmpypt);
               }
               if ((tmpypt=tmpypt->nxtpyr) == NULL) {
                    return(NULL);
               }
          }
     }
}

struct object *
fnobjp(stgptr,pyrptr)         /* find object in specified player's hands   */
char *stgptr;
struct player *pyrptr;
{
     for (objidx=0 ; objidx < pyrptr->nobjs ; objidx++) {
          if (nmatch(stgptr,pyrptr->pyrobj[objidx]->name)) {
               return(pyrptr->pyrobj[objidx]);
          }
     }
     return(NULL);
}

struct object *
sfnobjs(stgptr,statpt)        /* find object in specified state (room)     */
char *stgptr;
struct state *statpt;
{
     for (objidx=0 ; objidx < statpt->nobjs ; objidx++) {
          if (nmatch(stgptr,statpt->sttobj[objidx]->name)) {
               return(statpt->sttobj[objidx]);
          }
     }
     return(NULL);
}

struct object *
fnobjs(stgptr)                /* find object in current player's state     */
char *stgptr;
{
     return(sfnobjs(stgptr,pyrptr->sttptr));
}

STATIC int
drprtn(void)                  /* "drop" command handler                    */
{
     if ((urgc == 1 || stgcmp(urgv[1],"it") == 0) && pyrptr->nobjs == 1) {
          objidx=0;
          zbjptr=pyrptr->pyrobj[0];
          drputl();
     }
     else if (urgc == 2 && stgcmp(urgv[1],"all") == 0) {
          if (pyrptr->nobjs == 0) {
               btuxmt(pyrctr,"...You aren't holding anything.\r");
               infoth("looking perplexed");
          }
          else {
               objidx=0;
               while (pyrptr->nobjs != 0) {
                    zbjptr=pyrptr->pyrobj[0];
                    if (drputl()) {
                         break;
                    }
               }
          }
     }
     else if (urgc != 2) {
          return(1);
     }
     else if ((zbjptr=fnobjp(urgv[1],pyrptr)) == NULL) {
          donthv();
     }
     else {
          drputl();
     }
     return(0);
}

STATIC int
drputl(void)                  /* drop command handler utility              */
{
     if (pyrptr->sttptr->nobjs >= NOBJST) {
          mspstg("...The %s",zbjptr->name);
          addmbf(" seems to want to stay in your hands.\r");
          gibber();
          return(1);
     }
     else {
          mspstg("...Okay, you dropped the %s.\r",zbjptr->name);
          gibber();
          mspstg("***\r%s has just dropped a ",pyrptr->auxhdl);
          mspstg("%s.\r",zbjptr->name);
          fazoth();
          rmvobp(pyrptr,objidx);
          insobs(zbjptr);
          return(0);
     }
}

STATIC int
throwr(void)                  /* "throw" command handler                   */
{
     if (urgc == 2) {
          btuxmt(pyrctr,"...At who?\r");
          infoth("getting violent");
     }
     else if (fndhdl(urgv[1]) != NULL) {
          return(shvrtn());
     }
     else {
          *urgv[1]=tolower(*urgv[1]);
          if (urgc != 4 || (stgcmp(urgv[2],"at") != 0
            && stgcmp(urgv[2],"to") != 0)) {
               return(1);
          }
          else if ((zbjptr=fnobjp(urgv[1],pyrptr)) == NULL) {
               donthv();
          }
          else if ((othpyr=fndhdl(urgv[3])) == NULL) {
               ainthr(3);
          }
          else {
               thrutl();
          }
     }
     return(0);
}

STATIC void
thrutl(void)                  /* throw command handler utility             */
{
     if (pyrptr->sttptr->nobjs >= NOBJST) {
          mspstg("...The %s",zbjptr->name);
          addmbf(" seems to want to stay in your hands.\r");
          gibber();
     }
     else {
          btuxmt(pyrctr,"...Uh-oh, you missed!\r");
          mspstg("***\r%s just tried to ",pyrptr->auxhdl);
          mspstg("%s ",urgv[0]);
          mspstg("%s ",zhisher(pyrptr));
          addmbf(zbjptr->name);
          mspstg(" %s you, but missed!\r",urgv[2]);
          outpyr(othpyr);
          mspstg("***\r%s just tried to ",pyrptr->auxhdl);
          mspstg("%s ",urgv[0]);
          mspstg("%s ",zhisher(pyrptr));
          addmbf(zbjptr->name);
          mspstg(" %s ",urgv[2]);
          mspstg("%s, but missed!\r",othpyr->auxhdl);
          outexc(othpyr);
          rmvobp(pyrptr,objidx);
          insobs(zbjptr);
     }
}

void
rmvobp(pyrptr,wchone)         /* remove object from player's inventory     */
struct player *pyrptr;
int wchone;
{
     if (pyrptr->pyrobj[wchone] == &objcts[62]) {
          fashoo(pyrptr);
     }
     if (--(pyrptr->nobjs) != wchone) {
          pyrptr->pyrobj[wchone]=pyrptr->pyrobj[pyrptr->nobjs];
          pyrptr->pobjct[wchone]=pyrptr->pobjct[pyrptr->nobjs];
     }
}

void
insobp(pyrptr,zbjptr,count)   /* insert object into player's inventory     */
struct player *pyrptr;
struct object *zbjptr;
int count;
{
     pyrptr->pobjct[pyrptr->nobjs]=count;
     pyrptr->pyrobj[(pyrptr->nobjs)++]=zbjptr;
}

void
srmvobs(wchone,statpt)        /* remove object from a specified state      */
int wchone;
struct state *statpt;
{
     if (--(statpt->nobjs) != wchone) {
          statpt->sttobj[wchone]=statpt->sttobj[statpt->nobjs];
     }
}

void
rmvobs(wchone)                /* remove object from current player's state */
int wchone;
{
     srmvobs(wchone,pyrptr->sttptr);
}

void
insobs(zbjptr)                /* insert object in current player's state   */
struct object *zbjptr;
{
     pyrptr->sttptr->sttobj[pyrptr->sttptr->nobjs++]=zbjptr;
}

STATIC int
invcmd(void)                  /* "inventory" command handler               */
{
     invrtn();
     infoth("taking inventory");
     return(0);
}

STATIC int
looker(void)                  /* "look" and "examine" command handler      */
{
     int i,j;

     if (urgc > 1) {
          zapwrd("to");
          zapwrd("at");
          zapwrd("in");
          zapwrd("into");
          zapwrd("inside");
          zapwrd("under");
          zapwrd("for");
     }
     if (urgc == 2) {
          if ((zbjptr=fnobjp(urgv[1],pyrptr)) != NULL) {
               speclk();
          }
          else if ((zbjptr=fnobjs(urgv[1])) != NULL) {
               jabber(zbjptr->objmsg);
               mspstg("***\r%s is looking at the ",pyrptr->auxhdl);
               mspstg("%s.\r",zbjptr->name);
               fazoth();
          }
          else if ((othpyr=fndhdl(urgv[1])) != NULL) {
               if (invis(othpyr)) {
                    if (!hldoth(&objcts[62])) {
                         fashoo(othpyr);
                    }
                    jabber(FAZ1249);
                    mspstg("...%s",othpyr->plyrid);
               }
               else {
                    mspstg("...%s",othpyr->auxhdl);
               }
               j=othpyr->nobjs;
               if (iszleen(othpyr)) {
                    prfmsg(FAZ1699);
               }
               else if (j == 0) {
                    prfmsg((othpyr->logon&SEXBIT) ? FAZ1700 : FAZ1600);
               }
               else {
                    prfmsg(min(68,((int)(othpyr->pyrobj[0]-objcts)))+
                       ((othpyr->logon&SEXBIT) ? FAZ1701 : FAZ1601));
               }
               if (j != 0 && hldoth(&objcts[54]) == 0) {
                    addmbf(" appears to be holding a ");
                    i=0;
                    while(1) {
                         addmbf(othpyr->pyrobj[i]->name);
                         if (++i == j) {
                              addmbf(".\r");
                              break;
                         }
                         else if (i == j-1) {
                              addmbf(" and a ");
                         }
                         else {
                              addmbf(", a ");
                         }
                    }
               }
               else {
                    addmbf(" does not appear to be holding anything.\r");
               }
               gibber();
               mspstg("***\r%s is looking at ",pyrptr->auxhdl);
               if (othpyr == pyrptr) {
                    addmbf((pyrptr->logon&SEXBIT) ? "himself.\r" : "herself.\r");
                    fazoth();
               }
               else {
                    mspstg("%s.\r",othpyr->auxhdl);
                    outexc(othpyr);
                    mspstg("***\r%s is looking you over.\r",pyrptr->auxhdl);
                    outpyr(othpyr);
               }
          }
          else if (nmatch(urgv[1],"Brief")) {
               addmbf("...");
               noistt=-1;
               whther();
               whoher();
               gibber();
               infoth("furtively glancing around");
          }
          else {
               larnd();
          }
     }
     else {
          larnd();
     }
     return(0);
}

STATIC int
jckpls(void)                  /* Sysop-privileged item conjuring command   */
{
     if (urgc == 3 && strcmp(urgv[2],"pls") == 0) {
          if (pyrptr->nobjs < NOBJHD && (usrptr->flags&MASTER)) {
               for (zbjptr=objcts ; zbjptr < objcts+70 ; zbjptr++) {
                    if (nmatch(urgv[1],zbjptr->name)) {
                         insobp(pyrptr,zbjptr,0);
                         btuxmt(pyrctr,"...You got it.\r");
                         return(0);
                    }
               }
          }
     }
     return(1);
}

STATIC void
speclk(void)                  /* special look-at-object utility            */
{
     int i;

     if (zbjptr == &objcts[63]
       && ((i=(int)((pyrptr->sttptr)-states)) > 284 || i < 277)) {
          addmbf("...The readout on the ceeveese says ");
          mspstg("%d.\r",i);
          gibber();
     }
     else {
          jabber(zbjptr->objmsg);
     }
     mspstg("***\r%s is examining ",pyrptr->auxhdl);
     addmbf(zhisher(pyrptr));
     mspstg(" %s.\r",zbjptr->name);
     fazoth();
}

STATIC void
larnd(void)                   /* "look around" handler                     */
{
     prfmsg(pyrptr->sttptr->sttmsg);
     whther();
     whoher();
     gibber();
     infoth("looking around");
}

STATIC int
whortn(void)                  /* who/what/where/etc. command handler       */
{
     *urgv[0]=toupper(*urgv[0]);
     mspstg("...%s do you think?\r",urgv[0]);
     gibber();
     infoth("looking philosophical");
     return(0);
}

int
ntnice(void)                  /* not-nice thing to do to person or thing   */
{
     if (urgc == 1) {
          return(1);
     }
     if ((zbjptr=fnobjp(urgv[1],pyrptr)) != NULL) {
          nnutl(zhisher(pyrptr));
     }
     else if ((zbjptr=fnobjs(urgv[1])) != NULL) {
          nnutl("the");
     }
     else if ((othpyr=fndhdl(urgv[1])) != NULL) {
          mspstg("...A blue force field springs up, protecting %s.\r",
               othpyr->auxhdl);
          gibber();
          zntifo();
     }
     else {
          ainthr(1);
     }
     return(0);
}

STATIC void
nnutl(relat)                  /* not-nice utility                          */
char *relat;
{
     mspstg("...Oh, the %s doesn't like that!\r",zbjptr->name);
     gibber();
     mspstg("***\r%s is trying to ",pyrptr->auxhdl);
     addmbf(urgv[0]);
     mspstg(" %s",relat);
     mspstg(" %s!\r",zbjptr->name);
     fazoth();
}

void
zntifo(void)                  /* notify object of direct action and others */
{
     mspstg("***\r%s is trying to ",pyrptr->auxhdl);
     mspstg("%s you!\r",urgv[0]);
     outpyr(othpyr);
     mspstg("***\r%s is trying to ",pyrptr->auxhdl);
     addmbf(urgv[0]);
     mspstg(" %s!\r",othpyr->auxhdl);
     outexc(othpyr);
}

STATIC int
brfrtn(void)                  /* turn "brief" mode on or off               */
{
     if (urgc == 1 || stgcmp(urgv[1],"on") == 0) {
          pyrptr->logon|=BRFBIT;
          btuxmt(pyrctr,"...Okay, brief descriptions from now on.\r");
     }
     else if (urgc == 2 && stgcmp(urgv[1],"off") == 0) {
          unbrtn();
     }
     else {
          return(1);
     }
     return(0);
}

STATIC int
unbrtn(void)                  /* turn "brief" mode off                     */
{
     int i;

     pyrptr->logon&=(~BRFBIT);
     btuxmt(pyrctr,"...Okay, long descriptions from now on.\r");
     for (i=0 ; i < NVSTMN ; i++) {
          pyrptr->vsttes[i]=0;
     }
     return(0);
}

STATIC int
assemb(void)                  /* "assemble" and "attach" command handler   */
{
     int i,j;
     struct object *obj1;

     zapwrd("together");
     if (urgc < 4) {
          return(1);
     }
     if (stgcmp(urgv[2],"with") == 0
       || stgcmp(urgv[2],"to") == 0
       || stgcmp(urgv[2],"and") == 0
       || *urgv[2] == '&'
       || stgcmp(urgv[2],"onto") == 0
       || stgcmp(urgv[2],"into") == 0
       || stgcmp(urgv[2],"on") == 0) {
          j=1;
          if ((zbjptr=fnobjp(urgv[1],pyrptr)) != NULL) {
               obj1=zbjptr;
               j=3;
               if ((zbjptr=fnobjp(urgv[3],pyrptr)) != NULL) {
                    if (obj1 != zbjptr) {
                         for (i=0 ; i < NOBJMS ; i++) {
                              if (zbjptr->mothrs[i] != 0
                                   && (zbjptr->mothrs[i]->dghtr1 == obj1
                                   || zbjptr->mothrs[i]->dghtr2 == obj1)) {
                                   rmvobp(pyrptr,objidx);
                                   fnobjp(urgv[1],pyrptr);
                                   rmvobp(pyrptr,objidx);
                                   zbjptr=zbjptr->mothrs[i];
                                   insobp(pyrptr,zbjptr,0);
                                   assutl();
                                   return(0);
                              }
                         }
                    }
                    btuxmt(pyrctr,"...They don't seem to fit together.\n");
                    mspstg("***\r%s is trying to assemble something.\r",pyrptr->auxhdl);
                    fazoth();
                    return(0);
               }
          }
          mspstg("...You can't, you aren't holding a %s.\r",urgv[j]);
          gibber();
          infoth("fumbling around a little");
          return(0);
     }
     return(1);
}

STATIC void
assutl(void)                  /* assemble/attach command utility           */
{
     mspstg("...They appear to fit together, making a %s!\r",zbjptr->name);
     gibber();
     mspstg("***\r%s has just constructed a ",pyrptr->auxhdl);
     mspstg("%s!\r",zbjptr->name);
     fazoth();
}

int
zdsass(void)                  /* "disassemble" and "split" command handler */
{
     zapwrd("apart");
     if (urgc == 1) {
          return(1);
     }
     else if ((zbjptr=fnobjp(urgv[1],pyrptr)) == NULL) {
          donthv();
     }
     else if (pyrptr->nobjs >= NOBJHD) {
          btuxmt(pyrctr,"...Your hands are too full to grasp it properly.\r");
          infoth("looking around in chagrin");
     }
     else if (zbjptr->dghtr1 == NULL) {
          btuxmt(pyrctr,"...It doesn't seem to want to come apart.\r");
          infoth("somewhat perturbed");
     }
     else {
          mspstg("...It breaks cleanly apart into a %s",zbjptr->dghtr1->name);
          mspstg(" and a %s.\r",zbjptr->dghtr2->name);
          gibber();
          mspstg("***\r%s has just disassembled ",pyrptr->auxhdl);
          addmbf(zhisher(pyrptr));
          mspstg(" %s!\r",zbjptr->name);
          fazoth();
          rmvobp(pyrptr,objidx);
          insobp(pyrptr,zbjptr->dghtr1,0);
          insobp(pyrptr,zbjptr->dghtr2,0);
     }
     return(0);
}

void
infoth(infstg)                /* inform others about something             */
char *infstg;
{
     mspstg("***\r%s is ",pyrptr->auxhdl);
     mspstg(infstg,zhisher(pyrptr));
     addmbf(".\r");
     fazoth();
}

STATIC int
sitrtn(void)                  /* "sit" command handler                     */
{
     mspstg("...Okay, you're now sitting %s.\r",pyrptr->sttptr->sobjlc);
     gibber();
     infoth("sitting down to rest");
     return(0);
}

STATIC int
liertn(void)                  /* "lie" command handler                     */
{
     mspstg("...Okay, you're now lying down %s.\r",pyrptr->sttptr->sobjlc);
     gibber();
     infoth("lying down to rest a while");
     return(0);
}

STATIC int
stnrtn(void)                  /* "stand" command handler                   */
{
     btuxmt(pyrctr,"...Okay, you're standing up.\r");
     infoth("standing up");
     return(0);
}

STATIC int
lghrtn(void)                  /* "laugh" command handler                   */
{
     btuxmt(pyrctr,"...Har, har, har!!\r");
     infoth("laughing %s fool head off");
     return(0);
}

STATIC int
shfrtn(void)                  /* "shuffle" command handler                 */
{
     int i;

     if ((i=pyrptr->nobjs-1) < 0) {
          btuxmt(pyrctr,"...Why shuffle nothing?\r");
          infoth("shuffling about aimlessly");
     }
     else if (i == 0) {
          mspstg("...Your %s appreciates that.\r",pyrptr->pyrobj[0]->name);
          gibber();
          infoth("having a wonderful time");
     }
     else {
          while (1) {
               zbjptr=pyrptr->pyrobj[i-1];
               intmp1=pyrptr->pobjct[i-1];
               pyrptr->pyrobj[i-1]=pyrptr->pyrobj[i];
               pyrptr->pobjct[i-1]=pyrptr->pobjct[i];
               pyrptr->pyrobj[i]=zbjptr;
               pyrptr->pobjct[i]=intmp1;
               if (--i == 0) {
                    break;
               }
          }
          btuxmt(pyrctr,"...Consider it done.\r");
     }
     infoth("shuffling %s goodies around");
     return(0);
}

STATIC int
pshrtn(void)                  /* "push" command handler                    */
{
     if (urgc >= 4
          && stgcmp(urgv[2],"on") == 0
          && (nmatch(urgv[1],"button") || nmatch(urgv[1],"switch")
                    || nmatch(urgv[1],"pushbutton"))) {
          if ((zbjptr=fnobjp(urgv[3],pyrptr)) != NULL) {
               if (zbjptr->flags&ACTBUT) {
                    mspstg("***\r%s is pushing the button on ",pyrptr->auxhdl);
                    addmbf(zhisher(pyrptr));
                    mspstg(" %s!\r",zbjptr->name);
                    fazoth();
                    if (pyrptr->pobjct[objidx] == 0) {
                         (*(zbjptr->actvec))();
                    }
                    else if (pyrptr->pyrobj[objidx] == &objcts[62]) {
                         pyrptr->pobjct[objidx]=0;
                         fashoo(pyrptr);
                    }
                    else {
                         btuxmt(pyrctr,"...Nothing happens.\r");
                    }
               }
               else {
                    btuxmt(pyrctr,"...It doesn't have one!\r");
                    infoth("getting a little crazy here");
               }
          }
          else {
               donthv();
          }
          return(0);
     }
     if (urgc == 2 && nmatch(urgv[1],"button")) {
          btuxmt(pyrctr,"...On what? (for example, \"PUSH THE BUTTON ON THE GWINGUS\")\r");
          return(0);
     }
     else if (stgcmp(urgv[0],"hit") == 0) {
          return(ntnice());
     }
     else if (stgcmp(urgv[0],"push") == 0) {
          return(shvrtn());
     }
     return(1);
}

STATIC int
aimrtn(void)                  /* "aim" and "point" command handler         */
{
     struct object *objtmp;

     if (urgc >= 3) {
          if ((zbjptr=fnobjp(urgv[1],pyrptr)) != NULL) {
               pfish();
               if ((zbjptr->flags&ACTPNT) == 0 || pyrptr->pobjct[objidx] != 0) {
               }
               else if (urgc >= 4
                    && (stgcmp(urgv[2],"at") == 0
                    || nmatch("to",urgv[2]))) {
                    if ((objtmp=fnobjs(urgv[3])) != NULL) {
                         (*(zbjptr->actvec))(objtmp,0);
                    }
                    else if ((othpyr=fndhdl(urgv[3])) != NULL) {
                         (*(zbjptr->actvec))(othpyr,1);
                    }
                    else {
                         *urgv[3]=tolower(*urgv[3]);
                         (*(zbjptr->actvec))(NULL,3);
                    }
               }
               else {
                    (*(zbjptr->actvec))(NULL,2);
               }
          }
          else {
               donthv();
          }
          return(0);
     }
     return(1);
}

STATIC void
pfish(void)                   /* aim/point command utility                 */
{
     mspstg("...Okay, it's %sed in that direction.\r",urgv[0]);
     gibber();
     mspstg("***\r%s is doing something fishy with ",pyrptr->auxhdl);
     addmbf(zhisher(pyrptr));
     mspstg(" %s.\r",zbjptr->name);
     fazoth();
}

STATIC int
kckrtn(void)                  /* "kick" command handler                    */
{
     if (urgc >= 2) {
          if ((zbjptr=fnobjp(urgv[1],pyrptr)) != NULL) {
               if (zbjptr->flags&ACTKCK) {
                    mspstg("***\r%s is kicking ",pyrptr->auxhdl);
                    addmbf(zhisher(pyrptr));
                    mspstg(" %s!\r",zbjptr->name);
                    fazoth();
                    if (pyrptr->pobjct[objidx] == 0) {
                         (*(zbjptr->actvec))();
                    }
                    else {
                         btuxmt(pyrctr,"...The poor thing!\r");
                    }
               }
               else {
                    ntnice();
               }
          }
          else {
               ntnice();
          }
          return(0);
     }
     return(1);
}

STATIC int
tnkrtn(void)                  /* "think" command handler                   */
{
     struct state *pyrstp;

     if (urgc >= 3
          && (stgcmp(urgv[1],"about") == 0 ||
              stgcmp(urgv[1],"at") == 0 || stgcmp(urgv[1],"of") == 0)) {
          infoth("suddenly deep in thought");
          if ((zbjptr=fnobjp(urgv[2],pyrptr)) != NULL) {
               if (zbjptr->flags&ACTTNK) {
                    (*(zbjptr->actvec))();
               }
               else {
                    mspstg("...The %s appreciates your thoughtfulness...\r",
                         zbjptr->name);
                    gibber();
               }
          }
          else if (hold(&objcts[58]) && (pyrstp=fndpyr(urgv[2])) != NULL) {
               prfmsg(FAZ1240);
               outare(pyrstp);
               prfmsg(FAZ1241);
               prfmsg(pyrstp->sttmsg);
               prfmsg(FAZ1242);
               gibber();
          }
          else {
               btuxmt(pyrctr,"...Ah yes, that does bear consideration!\r");
          }
          return(0);
     }
     return(1);
}

STATIC int
reartn(void)                  /* "read" command handler                    */
{
     if (urgc >= 2) {
          if ((zbjptr=fnobjp(urgv[1],pyrptr)) != NULL
               || (zbjptr=fnobjs(urgv[1])) != NULL) {
               if (zbjptr->flags&OBJRDA) {
                    looker();
               }
               else {
                    btuxmt(pyrctr,"...There isn't any writing on it.\r");
               }
          }
          else {
               donthv();
          }
          return(0);
     }
     return(1);
}

STATIC int
opnrtn(void)                  /* "open" command handler                    */
{
     return(nocndo(FAZ1825));
}

STATIC int
clsrtn(void)                  /* "close" command handler                   */
{
     return(nocndo(FAZ1826));
}

STATIC int
digrtn(void)                  /* "dig" command handler                     */
{
     jabber(FAZ1827);
     infoth("really getting into this");
     return(0);
}

STATIC int
usertn(void)                  /* "use" command handler                     */
{
     return(nocndo(FAZ1828));
}

STATIC int
sqzrtn(void)                  /* "squeeze" command handler                 */
{
     return(nocndo(FAZ1829));
}

STATIC int
jmprtn(void)                  /* "jump" command handler                    */
{
     jabber(FAZ1830);
     infoth("getting a little jumpy here");
     return(0);
}

STATIC int
clbrtn(void)                  /* "climb" command handler                   */
{
     jabber(FAZ1831);
     infoth("looking upset about something");
     return(0);
}

STATIC int
upyrtn(void)                  /* "up yours" command handler                */
{
     if (urgc >= 2 && stgcmp(urgv[1],"yours") == 0) {
          jabber(FAZ1832);
          infoth("contemplating corrective surgery");
          return(0);
     }
     return(1);
}

STATIC int
fckrtn(void)                  /* "fuck you" command handler                */
{
     if (urgc >= 2 && stgcmp(urgv[1],"you") == 0) {
          jabber(FAZ1833);
          infoth("telepathically beaming foul imprecations at the world");
          return(0);
     }
     return(1);
}

STATIC int
swgrtn(void)                  /* "swing" command handler                   */
{
     return(nocndo(FAZ1834));
}

STATIC int
wrtrtn(void)                  /* "write" command handler                   */
{
     jabber(FAZ1835);
     infoth("checking %s pockets for something");
     return(0);
}

STATIC int
smkrtn(void)                  /* "smoke" command handler                   */
{
     jabber(FAZ1836);
     infoth("fumbling around for something");
     return(0);
}

STATIC int
nocndo(msgno)                 /* utility for no-can-do situations          */
int msgno;
{
     if (urgc >= 2) {
          if ((zbjptr=fnobjp(urgv[1],pyrptr)) != NULL
            || (zbjptr=fnobjs(urgv[1])) != NULL) {
               jabber(msgno);
               infoth("trying something sneaky");
          }
          else {
               donthv();
          }
          return(0);
     }
     return(1);
}

STATIC int
clprtn(void)                  /* "clap" and "applaud" command handler      */
{
     btuxmt(pyrctr,"...Clap, clap, clap!\r");
     infoth("applauding");
     return(0);
}

STATIC int
snkrtn(void)                  /* "snicker" and "chuckle" command handler   */
{
     btuxmt(pyrctr,"...Heh, heh, heh!\r");
     infoth("chuckling under %s breath");
     return(0);
}

STATIC int
grnrtn(void)                  /* "grin" command handler                    */
{
     btuxmt(pyrctr,"...Such a wicked-looking grin you have!\r");
     infoth("grinning from ear to ear");
     return(0);
}

STATIC int
smlrtn(void)                  /* "smile" command handler                   */
{
     btuxmt(pyrctr,"...Such a nice smile you have!\r");
     infoth("smiling agreeably");
     return(0);
}

STATIC int
nodrtn(void)                  /* "nod" command handler                     */
{
     btuxmt(pyrctr,"...Yes, that's so!\r");
     infoth("nodding in agreement");
     return(0);
}

STATIC int
blhrtn(void)                  /* "blush" command handler                   */
{
     btuxmt(pyrctr,"...Oooh, your face is so red!\r");
     infoth("blushing");
     return(0);
}

STATIC int
pourtn(void)                  /* "pout" command handler                    */
{
     btuxmt(pyrctr,"...Now, now!\r");
     infoth("pouting");
     return(0);
}

STATIC int
frwrtn(void)                  /* "frown" command handler                   */
{
     btuxmt(pyrctr,"...Don't look so glum!\r");
     infoth("frowning");
     return(0);
}

STATIC int
ptwrtn(void)                  /* "whistle" command handler                 */
{
     btuxmt(pyrctr,"...Phoo-tee-weet?!\r");
     infoth("whistling");
     return(0);
}

STATIC int
smprtn(void)                  /* "stomp" command handler                   */
{
     if (iszleen(pyrptr)) {
          btuxmt(pyrctr,"...You can't, zleens don't have feet!\r");
          infoth("wiggling around awkwardly");
     }
     else {
          btuxmt(pyrctr,"...Stomp, stomp, stomp!\r");
          infoth("stomping %s feet");
     }
     return(0);
}

STATIC int
snrrtn(void)                  /* "sneer" command handler                   */
{
     btuxmt(pyrctr,"...You look awfully disdainful!\r");
     infoth("sneering disdainfully");
     return(0);
}

STATIC int
snortn(void)                  /* "snort" command handler                   */
{
     btuxmt(pyrctr,"...Snort!\r");
     mspstg("***\r%s just snorted!\r",pyrptr->auxhdl);
     fazoth();
     return(0);
}

STATIC int
gwlrtn(void)                  /* "growl" command handler                   */
{
     btuxmt(pyrctr,"...Grrrrrr!\r");
     infoth("growling ominously");
     return(0);
}

STATIC int
wnkrtn(void)                  /* "wink" command handler                    */
{
     btuxmt(pyrctr,"...Wink, wink!\r");
     zapwrd("at");
     if (urgc >= 2 && (othpyr=fndhdl(urgv[1])) != NULL) {
          mspstg("***\r%s just winked at you surreptitiously!\r",
               pyrptr->auxhdl);
          outpyr(othpyr);
     }
     else {
          infoth("apparently having problems with %s eyes");
     }
     return(0);
}

STATIC int
grirtn(void)                  /* "grimace" command handler                 */
{
     btuxmt(pyrctr,"...Such a perplexed look you have on your face there!\r");
     infoth("grimacing perplexedly");
     return(0);
}

STATIC int
grortn(void)                  /* "groan" command handler                   */
{
     btuxmt(pyrctr,"...Groan!\r");
     infoth("groaning piteously");
     return(0);
}

STATIC int
gntrtn(void)                  /* "grunt" command handler                   */
{
     btuxmt(pyrctr,"...Grunt!\r");
     infoth("grunting indifferently");
     return(0);
}

STATIC int
hssrtn(void)                  /* "hiss" command handler                    */
{
     btuxmt(pyrctr,"...SSSsssss!\r");
     infoth("hissing");
     return(0);
}

STATIC int
boortn(void)                  /* "boo" command handler                     */
{
     btuxmt(pyrctr,"...BOOOO!\r");
     infoth("booing loudly");
     return(0);
}

STATIC int
scwrtn(void)                  /* "scowl" command handler                   */
{
     btuxmt(pyrctr,"...Such a look you have!\r");
     infoth("scowling threateningly");
     return(0);
}

STATIC int
bnkrtn(void)                  /* "blink" command handler                   */
{
     btuxmt(pyrctr,"...Blink, blink!\r");
     infoth("blinking his eyes in disbelief");
     return(0);
}

STATIC int
gigrtn(void)                  /* "giggle" command handler                  */
{
     btuxmt(pyrctr,"...Hee hee hee!\r");
     infoth("giggling uncontrollably");
     return(0);
}

STATIC int
clkrtn(void)                  /* "cluck" command handler                   */
{
     btuxmt(pyrctr,"...Tsk, tsk!\r");
     infoth("clucking reproachfully");
     return(0);
}

STATIC int
glrrtn(void)                  /* "glare" command handler                   */
{
     btuxmt(pyrctr,"...Don't look so outraged!\r");
     zapwrd("at");
     if (urgc >= 2 && (othpyr=fndhdl(urgv[1])) != NULL) {
          mspstg("***\r%s is glaring at you as though outraged!\r",
               pyrptr->auxhdl);
          outpyr(othpyr);
          mspstg("***\r%s is glaring at ",pyrptr->auxhdl);
          mspstg("%s as though outraged!\r",othpyr->auxhdl);
          outexc(othpyr);
     }
     else {
          infoth("glaring about in outrage");
     }
     return(0);
}

STATIC int
ywnrtn(void)                  /* "yawn" command handler                    */
{
     btuxmt(pyrctr,"...Aaa-hhhhhr.\r");
     infoth("yawning openly");
     return(0);
}

STATIC int
trdrtn(void)                  /* "trade" command handler                   */
{
     jabber(FAZ1824);
     infoth("looking very businesslike all of a sudden");
     return(0);
}

STATIC int
bowrtn(void)                  /* "bow" command handler                     */
{
     btuxmt(pyrctr,"...Your nose is almost touching the ground!\r");
     infoth("bowing in all directions");
     return(0);
}

STATIC int
snzrtn(void)                  /* "sneeze" command handler                  */
{
     jabber(FAZ1837);
     infoth("making strange ah-ing noises");
     return(0);
}

STATIC int
cryrtn(void)                  /* "cry" command handler                     */
{
     if (urgc > 1) {
          yelrtn();
     }
     else {
          btuxmt(pyrctr,"...Boo, hoo, hoo!\r");
          infoth("crying %s poor heart out");
     }
     return(0);
}

STATIC int
sihrtn(void)                  /* "sigh" command handler                    */
{
     btuxmt(pyrctr,"...Sigh!\r");
     infoth("sighing wistfully");
     return(0);
}

STATIC int
srgrtn(void)                  /* "shrug" command handler                   */
{
     btuxmt(pyrctr,"...Hmmph!\r");
     infoth("shrugging %s shoulders");
     return(0);
}

STATIC int
drlrtn(void)                  /* "drool" command handler                   */
{
     btuxmt(pyrctr,"...Drool, drool!\r");
     infoth("drooling obscenely");
     return(0);
}

STATIC int
pntrtn(void)                  /* "pant" command handler                    */
{
     btuxmt(pyrctr,"...Huh uh-huh uh-huh!\r");
     infoth("panting heavily all of a sudden");
     return(0);
}

STATIC int
fdgrtn(void)                  /* "fidget" command handler                  */
{
     btuxmt(pyrctr,"...Can't you keep your hands still?\r");
     infoth("fidgeting nervously");
     return(0);
}

STATIC int
gsprtn(void)                  /* "gasp" command handler                    */
{
     btuxmt(pyrctr,"...Gasp!\r");
     infoth("gasping for breath");
     return(0);
}

STATIC int
whzrtn(void)                  /* "wheeze" command handler                  */
{
     btuxmt(pyrctr,"...Wheeze!\r");
     infoth("having trouble with %s breathing");
     return(0);
}

STATIC int
gglrtn(void)                  /* "gurgle" command handler                  */
{
     btuxmt(pyrctr,"...G-gGg-gG-Gggg-g!\r");
     infoth("gurgling noisily for some reason");
     return(0);
}

STATIC int
humrtn(void)                  /* "hum" command handler                     */
{
     btuxmt(pyrctr,"...Hm hmmm hm hmm!\r");
     infoth("humming a little tune");
     return(0);
}

STATIC int
brprtn(void)                  /* "burp" command handler                    */
{
     btuxmt(pyrctr,"...Uu-rrrrp!\r");
     infoth("giving vent to %s feelings");
     return(0);
}

STATIC int
frtrtn(void)                  /* "fart" command handler                    */
{
     btuxmt(pyrctr,"...If you say so!\r");
     addmbf("***\rYou suddenly smell a foul odor in the air!\r");
     fazoth();
     return(0);
}

STATIC int
tlprtn(void)                  /* "teleport" command handler                */
{
     int dststt;

     if (urgc >= 3
       && stgcmp(urgv[1],"to") == 0
       && sscanf(urgv[2],"%d",&dststt) == 1
       && holdng(&objcts[61])
       && dststt >= 0 && dststt < TOTSTT-1) {
          if (dststt < 313 || dststt > 319) {
               rmvobp(pyrptr,objidx);
               jabber(FAZ1230);
               prfmsg(FAZ1231);
               mspstg("%s!\r",pyrptr->auxhdl);
               fazoth();
               prfmsg(FAZ1232);
               outner();
               lvstt("turned to red fire and jumped into the column");
               prfmsg(FAZ1233);
               fazoth();
               prfmsg(FAZ1234);
               outare(&states[dststt]);
               ntrstt(&states[dststt],"appeared out of the column");
               prfmsg(FAZ1232);
               outner();
               prfmsg(FAZ1235);
               fazoth();
          }
          else {
               jabber(FAZ1237);
               infoth("looking pained and holding %s baffle very gingerly");
          }
     }
     else {
          spctch();
     }
     return(0);
}

STATIC int
dncrtn(void)                  /* "dance" command handler                   */
{
     btuxmt(pyrctr,"...You seem to dance very gracefully!\r");
     infoth("dancing about in glee");
     return(0);
}

STATIC int
inject(void)                  /* Sysop-privileged "inject:" command handler */
{
     if ((usrptr->flags&MASTER) && urgc > 1) {
          *urgv[1]=toupper(*urgv[1]);
          recomb();
          mspstg("***\r%s\r",urgv[1]);
          gibber();
          fazoth();
          return(0);
     }
     return(1);
}

struct kwtab *
fazbin(stgptr,table,length)   /* binary search keyword lookup routine      */
char *stgptr;
struct kwtab table[];
int length;
{
     int cond;
     struct kwtab *low,*mid,*high;

     low=&table[0];
     high=&table[length-1];
     while (low <= high) {
          mid=low+(int)((high-low))/2;
          if ((cond=stgcmp(stgptr,mid->kyword)) < 0) {
               if (mid == low) {
                    break;
               }
               high=mid-1;
          }
          else if (cond > 0) {
               if (mid == high) {
                    break;
               }
               low=mid+1;
          }
          else {
               return(mid);
          }
     }
     return(NULL);
}

STATIC int
shvrtn(void)                  /* "shove" command handler                   */
{
     int argno;
     static struct kwtab shvset[]={
          {"e",      shovee},
          {"east",   shovee},
          {"n",      shoven},
          {"north",  shoven},
          {"s",      shoves},
          {"south",  shoves},
          {"w",      shovew},
          {"west",   shovew}
     };

     if (urgc >= 2) {
          if ((othpyr=fndhdl(urgv[1])) == NULL) {
               ainthr(1);
          }
          else if (urgc == 2) {
               btuxmt(pyrctr,"...Which direction?\r");
               zntifo();
          }
          else {
               if (urgc > 3
                 && (stgcmp(urgv[2],"at") == 0 || nmatch("to",urgv[2]))) {
                    argno=3;
               }
               else {
                    argno=2;
               }
               if ((kwtptr=fazbin(urgv[argno],shvset,8)) != NULL) {
                    return((*(kwtptr->subadr))());
               }
               else {
                    btuxmt(pyrctr,"...Which direction is that?\r");
                    zntifo();
               }
          }
          return(0);
     }
     return(1);
}

STATIC int
mvgowk(void)                  /* "move", "go" and "walk" command handler   */
{
     static struct kwtab mgwset[]={
          {"e",      movee},
          {"east",   movee},
          {"n",      moven},
          {"north",  moven},
          {"s",      moves},
          {"south",  moves},
          {"w",      movew},
          {"west",   movew}
     };

     if (urgc == 1) {
          btuxmt(pyrctr,"...Which way?\r");
          infoth("looking around uncertainly");
     }
     else if (urgc > 2) {
          spctch();
     }
     else if ((kwtptr=fazbin(urgv[1],mgwset,8)) != NULL) {
          --urgc;
          return((*(kwtptr->subadr))());
     }
     else {
          return(1);
     }
     return(0);
}

STATIC int
spctch(void)                  /* weird or special action rejector          */
{
     btuxmt(pyrctr,"...You might need special technology to do that.\r");
     infoth("trying to do something strange");
     return(0);
}

STATIC int
helper(void)                  /* "help" command handler                    */
{
#define FHLPLEN (sizeof(hlpset)/sizeof(struct kwntab))

     static struct kwntab hlpset[]={
          {"fazuul",FAZ51},
          {"moving",FAZ54},
          {"quitting",FAZ58},
          {"strategy",FAZ56},
          {"talking",FAZ53},
          {"trading",FAZ55}
     };

     infoth("getting help");
     if (urgc == 1) {
          jabber(FAZ50);
     }
     else {
          for (kwnptr=hlpset ; kwnptr-hlpset < FHLPLEN ; kwnptr++) {
               if (nmatch(urgv[1],kwnptr->kyword)) {
                    jabber(kwnptr->number);
                    return(0);
               }
          }
          btuxmt(pyrctr,"...Help is not available on that subject.\r");
     }
     return(0);
}

STATIC
struct kwctab *
binkwc(stgptr,table,length)   /* binary search for kwctab structure        */
char *stgptr;
struct kwctab table[];
int length;
{
     int cond;
     struct kwctab *low,*mid,*high;

     low=&table[0];
     high=&table[length-1];
     while (low <= high) {
          mid=low+(int)((high-low))/2;
          if ((cond=stgcmp(stgptr,mid->kyword)) < 0) {
               if (mid == low) {
                    break;
               }
               high=mid-1;
          }
          else if (cond > 0) {
               if (mid == high) {
                    break;
               }
               low=mid+1;
          }
          else {
               return(mid);
          }
     }
     return(NULL);
}

int
stdcmd(void)                  /* standard command master handler           */
{
#define SSTLEN (sizeof(stdset)/sizeof(struct kwctab))

     static struct kwctab stdset[]={
          {"?",helper,0},
          {"admit",sayrtn,0},
          {"advise",sayrtn,0},
          {"agree",sayrtn,0},
          {"aim",aimrtn,1},
          {"allege",sayrtn,0},
          {"annihilate",ntnice,1},
          {"announce",sayrtn,0},
          {"applaud",clprtn,0},
          {"argue",sayrtn,0},
          {"ask",sayrtn,0},
          {"assemble",assemb,1},
          {"assert",sayrtn,0},
          {"attach",assemb,1},
          {"attack",ntnice,1},
          {"attest",sayrtn,0},
          {"aver",sayrtn,0},
          {"avow",sayrtn,0},
          {"babble",sayrtn,0},
          {"bawl",yelrtn,1},
          {"bellow",yelrtn,1},
          {"bite",ntnice,1},
          {"bless",ntnice,1},
          {"blink",bnkrtn,0},
          {"blubber",sayrtn,0},
          {"blurt",sayrtn,0},
          {"blush",blhrtn,0},
          {"boo",boortn,0},
          {"bow",bowrtn,0},
          {"break",zdsass,1},
          {"brief",brfrtn,0},
          {"burp",brprtn,0},
          {"cackle",sayrtn,0},
          {"catch",takrtn,1},
          {"chant",yelrtn,1},
          {"chat",sayrtn,0},
          {"chatter",sayrtn,0},
          {"cheer",clprtn,0},
          {"chirp",sayrtn,0},
          {"chortle",snkrtn,0},
          {"chuck",throwr,1},
          {"chuckle",snkrtn,0},
          {"claim",sayrtn,0},
          {"clap",clprtn,0},
          {"climb",clbrtn,1},
          {"clobber",ntnice,1},
          {"close",clsrtn,1},
          {"cluck",clkrtn,0},
          {"combine",assemb,1},
          {"comfort",ntnice,0},
          {"command",sayrtn,0},
          {"comment",sayrtn,0},
          {"concentrate",tnkrtn,1},
          {"confide",sayrtn,0},
          {"connect",assemb,1},
          {"cough",whzrtn,0},
          {"crack",crflun,1},
          {"cracker",crkrtn,0},
          {"crackers",crkrtn,0},
          {"crackers?",crkrtn,0},
          {"cry",cryrtn,0},
          {"dance",dncrtn,0},
          {"debrief",unbrtn,0},
          {"decapitate",ntnice,1},
          {"declare",sayrtn,0},
          {"demand",sayrtn,0},
          {"describe",looker,0},
          {"destroy",ntnice,1},
          {"die",diertn,1},
          {"dig",digrtn,1},
          {"direct",aimrtn,1},
          {"disassemble",zdsass,1},
          {"discard",drprtn,1},
          {"disclose",sayrtn,0},
          {"disintegrate",diertn,1},
          {"drawl",sayrtn,0},
          {"drool",drlrtn,0},
          {"drop",drprtn,1},
          {"e",movee,0},
          {"east",movee,0},
          {"eat",ntnice,1},
          {"emphasize",sayrtn,0},
          {"enquire",sayrtn,0},
          {"examine",looker,0},
          {"exclaim",sayrtn,0},
          {"explain",sayrtn,0},
          {"expostulate",sayrtn,0},
          {"exult",yelrtn,1},
          {"eye",looker,0},
          {"fart",frtrtn,1},
          {"feel",looker,0},
          {"fern,",jckpls,0},
          {"fidget",fdgrtn,0},
          {"fit",assemb,1},
          {"fling",throwr,1},
          {"flip",pshrtn,1},
          {"frown",frwrtn,0},
          {"fuck",fckrtn,1},
          {"gasp",gsprtn,0},
          {"get",takrtn,1},
          {"giggle",gigrtn,0},
          {"give",givrtn,1},
          {"glare",glrrtn,0},
          {"go",mvgowk,0},
          {"grab",takrtn,1},
          {"grasp",takrtn,1},
          {"grimace",grirtn,0},
          {"grin",grnrtn,0},
          {"groan",grortn,0},
          {"growl",gwlrtn,0},
          {"grumble",sayrtn,0},
          {"grunt",gntrtn,0},
          {"gurgle",gglrtn,0},
          {"hand",givrtn,1},
          {"harrass",ntnice,1},
          {"heh",snkrtn,0},
          {"help",helper,0},
          {"hint",sayrtn,0},
          {"hiss",hssrtn,0},
          {"hit",pshrtn,1},
          {"holler",yelrtn,1},
          {"hoot",yelrtn,1},
          {"how",whortn,0},
          {"howl",yelrtn,1},
          {"hug",ntnice,0},
          {"hum",humrtn,0},
          {"hurl",throwr,1},
          {"inject:",inject,0},
          {"inquire",sayrtn,0},
          {"insist",sayrtn,0},
          {"inspect",looker,0},
          {"interject",sayrtn,0},
          {"inv",invcmd,0},
          {"inven",invcmd,0},
          {"inventory",invcmd,0},
          {"jabber",sayrtn,0},
          {"jam",assemb,1},
          {"join",assemb,1},
          {"jump",jmprtn,0},
          {"kick",kckrtn,1},
          {"kill",ntnice,1},
          {"kiss",ntnice,1},
          {"laugh",lghrtn,0},
          {"lie",liertn,0},
          {"listen",looker,0},
          {"long",unbrtn,0},
          {"look",looker,0},
          {"maim",ntnice,1},
          {"maintain",sayrtn,0},
          {"mention",sayrtn,0},
          {"moan",yelrtn,1},
          {"move",mvgowk,0},
          {"mumble",sayrtn,0},
          {"munch",ntnice,1},
          {"murder",ntnice,1},
          {"murmur",whsrtn,0},
          {"mutter",whsrtn,0},
          {"n",moven,0},
          {"nail",ntnice,1},
          {"nod",nodrtn,0},
          {"nonbrief",unbrtn,0},
          {"north",moven,0},
          {"nudge",ntnice,1},
          {"object",sayrtn,0},
          {"observe",sayrtn,0},
          {"open",opnrtn,1},
          {"opine",sayrtn,0},
          {"pant",pntrtn,0},
          {"pass",givrtn,1},
          {"pick",takrtn,1},
          {"pinch",ntnice,1},
          {"plead",sayrtn,0},
          {"point",aimrtn,1},
          {"poke",ntnice,1},
          {"pout",pourtn,0},
          {"prattle",sayrtn,0},
          {"predict",sayrtn,0},
          {"press",pshrtn,1},
          {"promise",sayrtn,0},
          {"propose",sayrtn,0},
          {"protest",sayrtn,0},
          {"pull",zdsass,1},
          {"punch",ntnice,1},
          {"push",pshrtn,1},
          {"put",assemb,1},
          {"rant",sayrtn,0},
          {"rave",sayrtn,0},
          {"read",reartn,0},
          {"release",drprtn,1},
          {"remark",sayrtn,0},
          {"report",sayrtn,0},
          {"reset",diertn,1},
          {"restart",diertn,1},
          {"run",mvgowk,0},
          {"s",moves,0},
          {"say",sayrtn,0},
          {"scowl",scwrtn,0},
          {"scream",yelrtn,1},
          {"screech",yelrtn,1},
          {"screw",fckrtn,1},
          {"see",looker,0},
          {"shake",ntnice,1},
          {"shoot",ntnice,1},
          {"shout",yelrtn,1},
          {"shove",shvrtn,1},
          {"shrug",srgrtn,0},
          {"shuffle",shfrtn,0},
          {"sigh",sihrtn,0},
          {"sing",yelrtn,1},
          {"sit",sitrtn,0},
          {"slap",ntnice,1},
          {"smack",ntnice,1},
          {"smash",ntnice,1},
          {"smell",looker,0},
          {"smile",smlrtn,0},
          {"smoke",smkrtn,1},
          {"snap",sayrtn,0},
          {"snarl",sayrtn,0},
          {"snatch",takrtn,1},
          {"sneer",snrrtn,0},
          {"sneeze",snzrtn,0},
          {"snicker",snkrtn,0},
          {"sniff",sayrtn,0},
          {"snort",snortn,0},
          {"sob",sayrtn,0},
          {"sock",ntnice,1},
          {"south",moves,0},
          {"speak",sayrtn,0},
          {"split",zdsass,1},
          {"splutter",sayrtn,0},
          {"sputter",sayrtn,0},
          {"squash",ntnice,1},
          {"squawk",yelrtn,1},
          {"squeak",sayrtn,0},
          {"squeal",sayrtn,0},
          {"squeeze",sqzrtn,1},
          {"stab",ntnice,1},
          {"stammer",sayrtn,0},
          {"stand",stnrtn,0},
          {"start",diertn,1},
          {"state",sayrtn,0},
          {"steal",takrtn,1},
          {"stick",assemb,1},
          {"stomp",smprtn,0},
          {"strangle",ntnice,1},
          {"stutter",sayrtn,0},
          {"suggest",sayrtn,0},
          {"surmise",sayrtn,0},
          {"swing",swgrtn,1},
          {"take",takrtn,1},
          {"talk",sayrtn,0},
          {"teleport",tlprtn,1},
          {"tell",sayrtn,0},
          {"think",tnkrtn,1},
          {"threaten",sayrtn,0},
          {"throw",throwr,1},
          {"tickle",ntnice,1},
          {"toss",throwr,1},
          {"torture",ntnice,1},
          {"touch",looker,0},
          {"trade",trdrtn,1},
          {"turn",pshrtn,1},
          {"unbrief",unbrtn,0},
          {"undo",zdsass,1},
          {"up",upyrtn,1},
          {"urge",sayrtn,0},
          {"use",usertn,1},
          {"w",movew,0},
          {"wail",yelrtn,1},
          {"walk",mvgowk,0},
          {"warn",sayrtn,0},
          {"west",movew,0},
          {"what",whortn,0},
          {"wheeze",whzrtn,0},
          {"when",whortn,0},
          {"where",whortn,0},
          {"whine",sayrtn,0},
          {"whisper",whsrtn,0},
          {"whistle",ptwrtn,0},
          {"who",whortn,0},
          {"whoop",yelrtn,1},
          {"why",whortn,0},
          {"wiggle",mvgowk,0},
          {"wink",wnkrtn,0},
          {"write",wrtrtn,1},
          {"yawn",ywnrtn,0},
          {"yell",yelrtn,1},
          {"yelp",yelrtn,1},
          {"yowl",yelrtn,1},
          {"zap",ntnice,1}
     };

     if ((kwcptr=binkwc(urgv[0],stdset,SSTLEN)) != NULL) {
          if (kwcptr->payonl && !hasmkey(FAZKEY)) {
               btuxmt(pyrctr,fazcant);
               return(0);
          }
          return((*(kwcptr->subadr))());
     }
     else {
          return(1);
     }
}

