/***************************************************************************
 *                                                                         *
 *   ETLFSD.C                                                              *
 *                                                                         *
 *   Copyright (C) 1993-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   These are the handler routines for all FSD calls in ENTTLC.C          *
 *                                                                         *
 *                                            - J. Moriarty 11/93          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galetl.h"
#include "plstuff.h"
#include "fsdbbs.h"
#include "flash.h"
#include "etlact.h"
#include "etlfsd.h"

struct cedctrl cedctrl;       /* Channel editor control block              */
struct chanls cedtemp;        /* Temp channel for channel editor           */

struct aedctrl aedctrl;       /* List/action editor control block          */
struct actlst ledtemp;        /* Temp list for list editor                 */
struct action aedtemp;        /* Temp action for action editor             */

char *cedarea;                /* FSD scratch pad for channel editor        */
int cedsiz;                   /* Size of FSD scratch pad                   */

char *ledarea;                /* FSD scratch pad for list/action edt       */
int ledsiz;                   /* Size of FSD scratch pad                   */

char cedfsp[] =               /* Format specs for channel FSD              */
     "NAME "
     "TOPIC "
     "AXSKEY(NOSPACES) "
     "MODKEY(NOSPACES) "
     "ACTLST1(NOSPACES) "
     "ACTLST2(NOSPACES) "
     "CPROFAN(ALT=NO ALT=YES MULTICHOICE) "
     "CENTERX(ALT=NO ALT=YES MULTICHOICE) "
     "COPENCL(ALT=NO ALT=YES MULTICHOICE) "
     "DONE(ALT=SAVE ALT=QUIT MULTICHOICE)";

char cedfmt[] =               /* Return format for channel FSD             */
     "NAME=%s%c"
     "TOPIC=%s%c"
     "AXSKEY=%s%c"
     "MODKEY=%s%c"
     "ACTLST1=%s%c"
     "ACTLST2=%s%c"
     "CPROFAN=%s%c"
     "CENTERX=%s%c"
     "COPENCL=%s%c";

char ledfsp[] =               /* Format specs for list FSD                 */
     "NAME(NOSPACES) "
     "SEEKEY(NOSPACES) "
     "USEKEY(NOSPACES) "
     "DONE(ALT=SAVE ALT=QUIT MULTICHOICE)";

char ledfmt[] =               /* Return format for list FSD                */
     "NAME=%s%c"
     "SEEKEY=%s%c"
     "USEKEY=%s%c";

char aedfsp[] =               /* Format specs for action FSD               */
     "NAME(NOSPACES) "
     "SIMPLE1 "
     "SIMPLE2 "
     "SIMPLE3 "
     "SIMPLE4 "
     "COMPLEX1 "
     "COMPLEX2 "
     "COMPLEX3 "
     "COMPLEX4 "
     "RESPONSE1 "
     "RESPONSE2 "
     "RESPONSE3 "
     "RESPONSE4 "
     "AKEY(NOSPACES) "
     "DONE(ALT=SAVE ALT=QUIT MULTICHOICE)";

char aedfmt[] =               /* Return format for action FSD              */
     "NAME=%s%c"
     "SIMPLE1=%s%c"
     "SIMPLE2=%s%c"
     "SIMPLE3=%s%c"
     "SIMPLE4=%s%c"
     "COMPLEX1=%s%c"
     "COMPLEX2=%s%c"
     "COMPLEX3=%s%c"
     "COMPLEX4=%s%c"
     "RESPONSE1=%s%c"
     "RESPONSE2=%s%c"
     "RESPONSE3=%s%c"
     "RESPONSE4=%s%c"
     "AKEY=%s%c";

void EXPORT __tlcfsd(void)    /* GP Marker                                 */
{
}

void
initfsd(void)                 /* Initialize FSD buffers                    */
{
     cedsiz=fsdroom(CEDFSANS,cedfsp,0);
     cedsiz=max(cedsiz,fsdroom(CEDFSINF,cedfsp,-1));
     cedsiz=max(cedsiz,fsdroom(CEDFSNAN,cedfsp,0));
     cedarea=alcmem(cedsiz);
     ledsiz=fsdroom(LEDFSANS,ledfsp,0);
     ledsiz=max(ledsiz,fsdroom(LEDFSINF,ledfsp,-1));
     ledsiz=max(ledsiz,fsdroom(LEDFSNAN,ledfsp,0));
     ledsiz=max(ledsiz,fsdroom(AEDFSAN2,aedfsp,0));
     ledsiz=max(ledsiz,fsdroom(AEDFSIN2,aedfsp,-1));
     ledsiz=max(ledsiz,fsdroom(AEDFSNA2,aedfsp,0));
     ledarea=alcmem(ledsiz);
}

char *
tfsdpft(void)                 /* Get message for FSD use                   */
{
     switch(fsdusr->amode) {
     case 1:
          return(getasc(fsdusr->tmpmsg));
     case 0:
          return(rawmsg(fsdusr->tmpmsg));
     case -1:
          return(getmsg(fsdusr->tmpmsg));
     }
     return(NULL);
}

/********************** CHANNEL EDITOR ROUTINES ****************************/

void
cedprp(int msgno,int mode)    /* Prepare channel editor                    */
{
     int tmpflg;

     setmem(prfbuf,PFBSIZ,0);           /* to get around FSD bug in 6.21f  */
     fsdroom(msgno,cedfsp,mode);
     if (sameas(cedtemp.name,MNNAME)) {
          tmpflg=0;
     }
     else {
          tmpflg=(cedtemp.flags&COPENCL) ? 1 : 0;
     }
     sprintf(vdatmp,cedfmt,
               cedtemp.name,'\0',
               cedtemp.topic,'\0',
               cedtemp.axskey,'\0',
               cedtemp.modkey,'\0',
               cedtemp.actlst1,'\0',
               cedtemp.actlst2,'\0',
               (cedtemp.flags&CPROFAN) ? "YES" : "NO", '\0',
               (cedtemp.flags&CENTERX) ? "YES" : "NO", '\0',
               (tmpflg) ? "YES" : "NO", '\0');
     fsdapr(cedarea,cedsiz,vdatmp);
}

void
cedptc(int issysop)           /* Protect channel fields                    */
{
     fsdscb->flddat[CEDNAME].flags|=FFFAVD;
     if (sameas(cedtemp.name,MNNAME)) {
          fsdscb->flddat[CEDCOPE].flags|=FFFAVD;
     }
     if (issysop == FALSE) {
          fsdscb->flddat[CEDMODK].flags|=FFFAVD;  /* Don't let moderator   */
          fsdscb->flddat[CEDAXSK].flags|=FFFAVD;  /*  change this info     */
          fsdscb->flddat[CEDACT1].flags|=FFFAVD;
          fsdscb->flddat[CEDACT2].flags|=FFFAVD;
     }
}

void
ceddun(int save)              /* Done editing channel                      */
{
     int retval;

     setmbk(tlcmb);
     if (save) {
          fsdfxt(CEDNAME,cedtemp.name,CHNSIZ);
          fsdfxt(CEDTOPI,cedtemp.topic,TPCSIZ);
          fsdfxt(CEDAXSK,cedtemp.axskey,KEYSIZ);
          fsdfxt(CEDMODK,cedtemp.modkey,KEYSIZ);
          fsdfxt(CEDACT1,cedtemp.actlst1,LSTSIZ);
          fsdfxt(CEDACT2,cedtemp.actlst2,LSTSIZ);
          if (fsdord(CEDCPRO)) {
               cedtemp.flags|=CPROFAN;
          }
          else {
               cedtemp.flags&=~CPROFAN;
          }
          if (fsdord(CEDCENT)) {
               cedtemp.flags|=CENTERX;
          }
          else {
               cedtemp.flags&=~CENTERX;
          }
          if (fsdord(CEDCOPE)) {
               cedtemp.flags|=COPENCL;
          }
          else {
               cedtemp.flags&=~COPENCL;
          }
          retval=edtchn(&cedtemp,1);
          if (retval == 0) {
               uactupd();
               prfmsg(CEDSAV);
          }
          else {
               prfmsg(CEDSVER);
          }
     }
     else {
          prfmsg(CEDQIT);
     }
     usrptr->state=tlcstt;
     if (cedctrl.sysop) {
          usrptr->substt=EDTCHAN;
          cedctrl.state=CEDEDP;
     }
     else {
          cedctrl.user=-1;         /* Return moderator directly to TLC     */
          cedctrl.channel=BADCHAN;
          usrptr->substt=TLKING;
          swtchn(usrnum,tlcoff(usrnum)->channel);
          if (!(usrptr->flags&INVISB)) {
               tlcptr=tlcoff(usrnum);
               tl2ptr=&tl2lst[usrnum];
               entrmsg();
               outtlc();
          }
          prfmsg(ED2TLC);
     }
     btuinj(usrnum,CRSTG);
}

void
cedcdun(int save)             /* Finished creating channel                 */
{
     int retval;

     setmbk(tlcmb);
     if (save) {
          memset(&cedtemp,'\0',sizeof(struct chanls));
          fsdfxt(CEDNAME,cedtemp.name,CHNSIZ);
          fsdfxt(CEDTOPI,cedtemp.topic,TPCSIZ);
          fsdfxt(CEDAXSK,cedtemp.axskey,KEYSIZ);
          fsdfxt(CEDMODK,cedtemp.modkey,KEYSIZ);
          fsdfxt(CEDACT1,cedtemp.actlst1,LSTSIZ);
          fsdfxt(CEDACT2,cedtemp.actlst2,LSTSIZ);
          if (fsdord(CEDCPRO)) {
               cedtemp.flags|=CPROFAN;
          }
          else {
               cedtemp.flags&=~CPROFAN;
          }
          if (fsdord(CEDCENT)) {
               cedtemp.flags|=CENTERX;
          }
          else {
               cedtemp.flags&=~CENTERX;
          }
          if (fsdord(CEDCOPE)) {
               cedtemp.flags|=COPENCL;
          }
          else {
               cedtemp.flags&=~COPENCL;
          }
          retval=addchn(&cedtemp,1);
          if (retval == 0) {
               prfmsg(CEDSAV);
          }
          else {
               prfmsg(CEDSVER);
          }
     }
     else {
          prfmsg(CEDQIT);
     }
     usrptr->state=tlcstt;
     usrptr->substt=EDTCHAN;
     cedctrl.state=CEDCRP;
     btuinj(usrnum,CRSTG);
}

int
cedvfy(int fldno,char *answer)     /* Verify channel info                  */
{
     switch (fldno) {
     case CEDAXSK:
     case CEDMODK:
          if (strlen(answer) == 0 || keynam(answer)) {
               strupr(answer);
               return(VFYOK);
          }
          prf("\7");
          outprf(usrnum);
          return(VFYREJ);
     case CEDACT1:
     case CEDACT2:
          if (chkalph(answer) || answer[0] == '\0') {
               strupr(answer);
               return(VFYOK);
          }
          prf("\7");
          outprf(usrnum);
          return(VFYREJ);
     }
     return(vfyadn(fldno,answer));
}

/************************ ACTION LIST EDITOR *******************************/

void
ledprp(int msgno,int mode)    /* Prepare action list editor                */
{
     setmem(prfbuf,PFBSIZ,0);           /* to get around FSD bug in 6.21f  */
     fsdroom(msgno,ledfsp,mode);
     sprintf(vdatmp,ledfmt,
               ledtemp.name,'\0',
               ledtemp.seekey,'\0',
               ledtemp.usekey,'\0');
     fsdapr(ledarea,ledsiz,vdatmp);
}

void
ledptc(void)                  /* Protect action list fields                */
{
     fsdscb->flddat[LEDNAME].flags|=FFFAVD;
}

void
leddun(int save)              /* Done editing action list                  */
{
     int retval;

     setmbk(tlcmb);
     if (save) {
          strcpy(ledtemp.list,LSTNAM);
          fsdfxt(LEDNAME,ledtemp.name,ACTSIZ);
          fsdfxt(LEDSEEK,ledtemp.seekey,KEYSIZ);
          fsdfxt(LEDUSEK,ledtemp.usekey,KEYSIZ);
          retval=chglst(&ledtemp);
          if (retval == 0) {
               uactupd();
               prfmsg(LEDSAV);
          }
          else {
               prfmsg(LEDSVER);
          }
     }
     else {
          prfmsg(LEDQIT);
     }
     usrptr->state=tlcstt;
     usrptr->substt=EDTLIST;
     btuinj(usrnum,CRSTG);
}

void
ledcdun(int save)             /* Done creating action list                 */
{
     int retval;

     setmbk(tlcmb);
     if (save) {
          memset(&ledtemp,'\0',sizeof(actlst));
          strcpy(ledtemp.list,LSTNAM);
          fsdfxt(LEDNAME,ledtemp.name,ACTSIZ);
          fsdfxt(LEDSEEK,ledtemp.seekey,KEYSIZ);
          fsdfxt(LEDUSEK,ledtemp.usekey,KEYSIZ);
          retval=addlst(&ledtemp);
          if (retval == 0) {
               prfmsg(LEDSAV);
          }
          else {
               prfmsg(LEDSVER);
          }
     }
     else {
          prfmsg(LEDQIT);
     }
     usrptr->state=tlcstt;
     usrptr->substt=EDTLIST;
     btuinj(usrnum,CRSTG);
}

int
ledvfy(int fldno,char *answer)     /* Verify action list info              */
{
     switch (fldno) {
     case LEDSEEK:
     case LEDUSEK:
          if (strlen(answer) == 0 || keynam(answer)) {
               strupr(answer);
               return(VFYOK);
          }
          prf("\7");
          outprf(usrnum);
          return(VFYREJ);
     }
     return(vfyadn(fldno,answer));
}

/************************** ACTION WORD EDITOR *****************************/

void
aedprp(int msgno,int mode)    /* Prepare action word editor                */
{
     char *sp1,*sp2,*sp3,*sp4;
     char *cp1,*cp2,*cp3,*cp4;
     char *rp1,*rp2,*rp3,*rp4;

     if (strchr(aedtemp.simple,'\1') != NULL) {
          sp1=aedtemp.simple;
          sp2=strchr(sp1,'\1')+1;
          sp3=strchr(sp2,'\1')+1;
          sp4=strchr(sp3,'\1')+1;
          rplchr(aedtemp.simple,'\1','\0');
          cp1=aedtemp.complx;
          cp2=strchr(cp1,'\1')+1;
          cp3=strchr(cp2,'\1')+1;
          cp4=strchr(cp3,'\1')+1;
          rplchr(aedtemp.complx,'\1','\0');
          rp1=aedtemp.resp;
          rp2=strchr(rp1,'\1')+1;
          rp3=strchr(rp2,'\1')+1;
          rp4=strchr(rp3,'\1')+1;
          rplchr(aedtemp.resp,'\1','\0');
          setmem(prfbuf,PFBSIZ,0);      /* to get around FSD bug in 6.21f  */
          fsdroom(msgno,aedfsp,mode);
          sprintf(vdatmp,aedfmt,
                    aedtemp.name,'\0',
                    sp1,'\0',sp2,'\0',sp3,'\0',sp4,'\0',
                    cp1,'\0',cp2,'\0',cp3,'\0',cp4,'\0',
                    rp1,'\0',rp2,'\0',rp3,'\0',rp4,'\0',
                    aedtemp.actkey,'\0');
     }
     else {
          setmem(prfbuf,PFBSIZ,0);      /* to get around FSD bug in 6.21f  */
          fsdroom(msgno,aedfsp,mode);
          sprintf(vdatmp,aedfmt,
                    aedtemp.name,'\0',
                    "",'\0',"",'\0',"",'\0',"",'\0',
                    "",'\0',"",'\0',"",'\0',"",'\0',
                    "",'\0',"",'\0',"",'\0',"",'\0',"",'\0');
     }
     fsdapr(ledarea,ledsiz,vdatmp);
}

void
rplchr(char *target,char in,char out)   /* replace in with out in target   */
{
     int i;

     i=0;
     while (target[i] != '\0') {
          if (target[i] == in) {
               target[i]=out;
          }
          i++;
     }
}

void
aedptc(void)                  /* Protect action word fields                */
{
     fsdscb->flddat[AEDNAME].flags|=FFFAVD;
}

void
aeddun(int save)              /* Done editing action word                  */
{
     int retval;
     static char tmpres[RESSIZ];

     setmbk(tlcmb);
     if (save) {
          memset(&aedtemp,'\0',sizeof(struct action));
          fsdfxt(AEDKEY,aedtemp.actkey,KEYSIZ);
          strcpy(aedtemp.list,ledtemp.name);
          fsdfxt(AEDNAME,aedtemp.name,ACTSIZ);
          fsdfxt(AEDSIMP1,tmpres,RESSIZ);
          stzcpy(aedtemp.simple,tmpres,RESSIZ);
          stzcat(aedtemp.simple,"\1",RESSIZ);
          fsdfxt(AEDSIMP2,tmpres,RESSIZ);
          stzcat(aedtemp.simple,tmpres,RESSIZ);
          stzcat(aedtemp.simple,"\1",RESSIZ);
          fsdfxt(AEDSIMP3,tmpres,RESSIZ);
          stzcat(aedtemp.simple,tmpres,RESSIZ);
          stzcat(aedtemp.simple,"\1",RESSIZ);
          fsdfxt(AEDSIMP4,tmpres,RESSIZ);
          stzcat(aedtemp.simple,tmpres,RESSIZ);

          fsdfxt(AEDCOMP1,tmpres,RESSIZ);
          stzcpy(aedtemp.complx,tmpres,RESSIZ);
          stzcat(aedtemp.complx,"\1",RESSIZ);
          fsdfxt(AEDCOMP2,tmpres,RESSIZ);
          stzcat(aedtemp.complx,tmpres,RESSIZ);
          stzcat(aedtemp.complx,"\1",RESSIZ);
          fsdfxt(AEDCOMP3,tmpres,RESSIZ);
          stzcat(aedtemp.complx,tmpres,RESSIZ);
          stzcat(aedtemp.complx,"\1",RESSIZ);
          fsdfxt(AEDCOMP4,tmpres,RESSIZ);
          stzcat(aedtemp.complx,tmpres,RESSIZ);

          fsdfxt(AEDRESP1,tmpres,RESSIZ);
          stzcpy(aedtemp.resp,tmpres,RESSIZ);
          stzcat(aedtemp.resp,"\1",RESSIZ);
          fsdfxt(AEDRESP2,tmpres,RESSIZ);
          stzcat(aedtemp.resp,tmpres,RESSIZ);
          stzcat(aedtemp.resp,"\1",RESSIZ);
          fsdfxt(AEDRESP3,tmpres,RESSIZ);
          stzcat(aedtemp.resp,tmpres,RESSIZ);
          stzcat(aedtemp.resp,"\1",RESSIZ);
          fsdfxt(AEDRESP4,tmpres,RESSIZ);
          stzcat(aedtemp.resp,tmpres,RESSIZ);

          retval=chgact(&aedtemp);
          if (retval == 0) {
               uactupd();
               prfmsg(AEDSAV);
          }
          else {
               prfmsg(AEDSVER);
          }
     }
     else {
          prfmsg(AEDQIT);
     }
     usrptr->state=tlcstt;
     usrptr->substt=EDTACTN;
     btuinj(usrnum,CRSTG);
}

void
aedcdun(int save)             /* Done creating action word                 */
{
     int retval;
     static char tmpres[RESSIZ];

     setmbk(tlcmb);
     if (save) {
          memset(&aedtemp,'\0',sizeof(struct action));
          fsdfxt(AEDKEY,aedtemp.actkey,KEYSIZ);
          strcpy(aedtemp.list,ledtemp.name);
          fsdfxt(AEDNAME,aedtemp.name,ACTSIZ);
          fsdfxt(AEDSIMP1,tmpres,RESSIZ);
          stzcpy(aedtemp.simple,tmpres,RESSIZ);
          stzcat(aedtemp.simple,"\1",RESSIZ);
          fsdfxt(AEDSIMP2,tmpres,RESSIZ);
          stzcat(aedtemp.simple,tmpres,RESSIZ);
          stzcat(aedtemp.simple,"\1",RESSIZ);
          fsdfxt(AEDSIMP3,tmpres,RESSIZ);
          stzcat(aedtemp.simple,tmpres,RESSIZ);
          stzcat(aedtemp.simple,"\1",RESSIZ);
          fsdfxt(AEDSIMP4,tmpres,RESSIZ);
          stzcat(aedtemp.simple,tmpres,RESSIZ);

          fsdfxt(AEDCOMP1,tmpres,RESSIZ);
          stzcpy(aedtemp.complx,tmpres,RESSIZ);
          stzcat(aedtemp.complx,"\1",RESSIZ);
          fsdfxt(AEDCOMP2,tmpres,RESSIZ);
          stzcat(aedtemp.complx,tmpres,RESSIZ);
          stzcat(aedtemp.complx,"\1",RESSIZ);
          fsdfxt(AEDCOMP3,tmpres,RESSIZ);
          stzcat(aedtemp.complx,tmpres,RESSIZ);
          stzcat(aedtemp.complx,"\1",RESSIZ);
          fsdfxt(AEDCOMP4,tmpres,RESSIZ);
          stzcat(aedtemp.complx,tmpres,RESSIZ);

          fsdfxt(AEDRESP1,tmpres,RESSIZ);
          stzcpy(aedtemp.resp,tmpres,RESSIZ);
          stzcat(aedtemp.resp,"\1",RESSIZ);
          fsdfxt(AEDRESP2,tmpres,RESSIZ);
          stzcat(aedtemp.resp,tmpres,RESSIZ);
          stzcat(aedtemp.resp,"\1",RESSIZ);
          fsdfxt(AEDRESP3,tmpres,RESSIZ);
          stzcat(aedtemp.resp,tmpres,RESSIZ);
          stzcat(aedtemp.resp,"\1",RESSIZ);
          fsdfxt(AEDRESP4,tmpres,RESSIZ);
          stzcat(aedtemp.resp,tmpres,RESSIZ);

          retval=addact(&aedtemp);
          if (retval == 0) {
               prfmsg(AEDSAV);
          }
          else {
               prfmsg(AEDSVER);
          }
     }
     else {
          prfmsg(AEDQIT);
     }
     usrptr->state=tlcstt;
     usrptr->substt=EDTACTN;
     btuinj(usrnum,CRSTG);
}

int
aedvfy(int fldno,char *answer)     /* Verify action word info              */
{
     switch (fldno) {
     case AEDKEY:
          if (strlen(answer) == 0 || keynam(answer)) {
               strupr(answer);
               return(VFYOK);
          }
          prf("\7");
          outprf(usrnum);
          return(VFYREJ);
     }
     return(vfyadn(fldno,answer));
}
