/***************************************************************************
 *                                                                         *
 *   ETLACT.H                                                              *
 *                                                                         *
 *   Copyright (C) 1987-1994 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Structures and prototypes needed for the new action routines.         *
 *                                                                         *
 *                                            - M. Donnelly 11/3/93        *
 *                                                                         *
 ***************************************************************************/

/* ACTSIZ is used both for the max name of an action AND an action list.   */

#define ACTSIZ       16       /* Size of an action (list) name             */
#define RESSIZ      300       /* Size of an action response                */

#define NLISTS       32       /* How many action lists can exist at all    */
#define NACTS      1024       /* Number of actions allowable in one list   */
#define LSTNAM  "!List"       /* Key indicating this action is list header */

#define ABFSIZ     outbsz     /* Buffer size for action word expansion     */

#define KILCOLR    "[0m"     /* ANSI kill current color command           */
#define UNKMAC     "(Unknown macro)"    /* Unknown macro expansion text    */

#if ACTSIZ != 16
#error ACTSIZ is no longer 16!  Update IDXACT macro to not left shift!
#endif

#define IDXACT(p,n)  (p+(n<<4))

/* Do not use these buffers in external programs!  These buffers are used
   internally by the action routines when updating/adding/deleting stuff.
   Anything you put here will be destroyed, so don't do it.                */

#define tmpact       ((struct action *)actbb->data)
#define tmplst       ((struct actlst *)actbb->data)

extern
struct actlst {
     char list[ACTSIZ];       /* Name of this action list (must be LSTNAM) */
     char name[ACTSIZ];       /* Name of this action list                  */
     char seekey[KEYSIZ];     /* Key req'd to see other users using list   */
     char usekey[KEYSIZ];     /* Key req'd to use this list                */
     char spare[886];         /* spare space                               */
} *actlst;

struct action {
     char list[ACTSIZ];       /* Action list (btv key)                     */
     char name[ACTSIZ];       /* Name of action word                       */
     char simple[RESSIZ];     /* Output for action w/no more input         */
     char complx[RESSIZ];     /* Output for action w/extra input           */
     char resp[RESSIZ];       /* Output to user doing action               */
     int  isyell;             /* Does action expect text?  (userid if not) */
     char actkey[KEYSIZ];     /* Key required to use this action           */
};

#if sizeof(struct action) != 950
#error struct action has changed size.  Update .BCR file!
#endif

/* An array of actctl's is allocated at startup.  The array corresponds
   with an array of actlst's that is allocated, also.

   The list pointer is a pointer to a sorted list of action names.  Each
   one is simply 16 characters and they're all stuck together.  When a
   new action is inserted, everything is shifted around to insert the new
   action in order.  The list is binary-searched when users enter input.   */

typedef char KEYNAME[KEYSIZ];

extern
struct actctl {
     int count;               /* Number of actions in this list            */
     int deltag;              /* Tagged for deletion                       */
     char *list;              /* Pointer to dynamic list                   */
     int numxky;              /* Number of actions with an xkey defined    */
     int *xkylst;             /* Pointer to dynamic list of xkey indexes   */
     KEYNAME *xkynam;         /* Pointer to dynamic list of xkeys          */
} *actctl;

extern BTVFILE *actbb;

/* chklst will return 1 if it's a list that already exists, but it will
   return -1 if it's a list that exists and has been tagged for deletion.

   Note that both of the chkXXX functions will fill in the structure if the
   action/list in question is there.  When calling in, you only need to set
   the list/name fields (or name only in the case of chklst) and the functions
   will fill in the rest for you.  (chklst will fill in the list structure
   even if it has been tagged for deletion)                                */

void iniact(void);                      /* Initialize the action handler   */
void clsact(void);                      /* Shut down the action handler    */

int chkact(struct action *chkact);      /* Is this an action?              */
int addact(struct action *newact);      /* Add a new action                */
int delact(struct action *oldact);      /* Delete an action                */
int chgact(struct action *newact);      /* Change an action                */

int chklst(struct actlst *chklst);      /* Is this an action list?         */
int addlst(struct actlst *newlst);      /* Add a new action list           */
int dellst(struct actlst *oldlst);      /* Delete an action list. (tag)    */
int chglst(struct actlst *newlst);      /* Change an action list           */

/* setusr() sets up a user's flags when he enters a channel.  This looks
   up the index (for speed), visibility, and usability of the two action
   lists specified.  NULL can be passed for either or both action list to
   indicate no first or second list.  If a string is passed, but there is
   no list of that name, it is treated as if NULL was passed.              */

void setusr(int unum,unsigned tlcchn,char *act1,char *act2);

/* hdlact() is the master routine for action handling.  This routine should
   NOT be called when usrnum is equal to a channel that hasn't been set via
   the setusr() call.  Implicit inputs: usrnum (and pointers) and input.
   Input should be in the parsed state when this is invoked.

   hdlact() returns 0 if the input was not processed by this routine (no
   actions, etc invoked).  hdlact() returns 1 when it has consumed the
   input and no further processing should take place.  Also, output will
   be waiting in prfbuf for the current user when it returns 1.

   Note: this routine will ALWAYS destroy the contents of othusn.          */

int hdlact(void);
int netchkact(void);
void action(void);
void actlist(void);
void lstlst(void);
void lstact(char *lstnam,int ignkey);
void cpyausr(int dstusr,int srcusr);
