/***************************************************************************
 *                                                                         *
 *   CHATLINK.H Version 4.23                                               *
 *                                                                         *
 *   Copyright (C) 1992 Steve Neal              All Rights Reserved.       *
 *   Copyright (C) 1993-1994 GALACTICOMM, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   ChatLink Spoke software                  - S. Neal 8/5/93             *
 *   ETLC Integration                         - J. Moriarty 11/1/93        *
 *                                                                         *
 ***************************************************************************/

#define MAXCHAIN 8      /* ChatLink will support MAXCHAIN * NETBLOCK users */

#define NETBLOCK 128

#define NETCHNOFF 11000            /* channel offset for chatlink channels */

#define TERMCHAR 127               /* Packet terminator character          */
#define STARTCHAR 255              /* Packet start character               */

#define WHISPER30        1
#define ADDUSER30        2
#define DELUSER30        3
#define MODUSER30        4
#define INVITE30         5
#define UNINVITE30       6
#define JOINREQ30        7
#define CHANGECHN30      8
#define USERDONE30       9
#define WHOREQ30        10
#define WHO30           11
#define NEWSYSTEM30     12
#define WHISPERACK30    13
#define WHISPERNAK30    14
#define SHUTDOWN30      15
#define DELSYSTEM30     16
#define WHONAK30        17
#define INVNAK30        18
#define JOINNAK30       19
#define PUBLIC30        20
#define SYSNO30         21
#define ASKUSER30       22
#define ASKSYS30        23
#define ACTRSV30        24
#define ACTMSG30        25
#define TOPIC30         26
#define ADDUSERI30      27
#define EJECTC30        28
#define ALLOWC30        29
#define SCHED30         30
#define REQSCHED30      31
#define SYSMSG30        31
#define LASTCODE        32

#define ISVALIDPACKET(c) ((c) < LASTCODE)

extern struct paq1 {
     char type;
     char userid[UIDSIZ];
     int sysno;
     int usrnum;
     long vc;
};

extern struct paq2 {
     char type;
     char userid[UIDSIZ];
     int sysno;
     int usrnum;
     char userid2[UIDSIZ];
     int sysno2;
     int usrnum2;
};

extern struct paq3 {  /* Whisper packet */
     char type;
     char userid[UIDSIZ];
     int sysno;
     int usrnum;
     char userid2[UIDSIZ];
     int sysno2;
     int usrnum2;
     long vc;
     char msg;
};

extern struct paq4 {
     char type;
     char userid[UIDSIZ];
     int sysno;
     int usrnum;
     long vc;
     char msg;
};

extern struct netreg {
     char userid[UIDSIZ];
     char name[15];
     char sex;
     char age[4];
     char desc1[81];
     char desc2[81];
};

struct usrlist {
     int netstate;
     int chain;
     int entry;
     int sysn;
     int count;
     long vrec;
     long vc;
};

struct netuser {
     char userid[UIDSIZ];
     int sysno;
     int usrnum;
     char sex;
     long vc;
     char where1[NADSIZ];
     char countr;
};

extern char *chatlkey;
extern char tempname[40],tempname2[40];
extern char *nnstg;

#define NETREGPTR ((struct netreg *)(vdaptr+sizeof(struct esgusr)))
#define SPMENU (haskey(syskey) ? SPOKEMEN : SPOKEUSR)
#define NEMENU ((haskey(syskey)) ? NETMEN : SPOKEUSR)
#define ISSYS (haskey(syskey))
#define ENQSTR "chatlink"
#define UNKSTR " Unknown"

#ifndef NOGLOB
     #define NOGLOB 0x0000
#endif

#ifndef GACSTG
     #define GACSTG GASTRING
#endif

#define INVFLAG(x) (tlcoff(x)->flags&INVALL)

extern char netchar;
extern int netactive;
extern int netmain;
