# BFCDLL.MAK - Borland makefile for BFC40*.DLL
#
# BFC40[D].DLL is a DLL
#  which exports all the MFC classes
#

!ifndef LIBNAME
LIBNAME=BFC40
!endif

!if "$(DEBUG)" != "0"
CRTDLL=CW32MTI.lib
!else
CRTDLL=CW32MTI.lib
!endif

TARGET=w
DLL=2
TARGDEFS=/D_AFX_CORE_IMPL
LFLAGS=/n /m /s
RCFLAGS=@brcc32.cfg

!if "$(DEBUG)" != "0"
# Debug DLL build
TARGTYPE=$(TARGTYPE)D
RCDEFINES=$(RCDEFINES) /D_DEBUG
LFLAGS=$(LFLAGS) /v
!ifndef MONOLITHIC
MONOLITHIC=0
!endif
!ELSE
# Release DLL build
RCDEFINES=$(RCDEFINES)
LFLAGS=$(LFLAGS)
!ifndef MONOLITHIC
MONOLITHIC=1
!endif
!ENDIF

DEFFILE=$(PLATFORM)\$(TARG).DEF

!if "$(MONOLITHIC)" == "1"
TARGDEFS=$(TARGDEFS) /D_AFX_OLE_IMPL /D_AFX_DB_IMPL /D_AFX_NET_IMPL 
RCDEFINES=$(RCDEFINES) /D_AFX_MONOLITHIC
!endif

CFNAME=$(LIBNAME)$(TARGTYPE)
TARG=$(LIBNAME)$(PF)$(TARGTYPE)
TARG_STATIC=BFCS40$(PF)$(TARGTYPE)


!ifdef RELEASE # Release VERSION info
RCDEFINES=$(RCDEFINES) /DRELEASE
LFLAGS=$(LFLAGS) /release
!endif

LFLAGS=$(LFLAGS) /Tpd

bfcdll_goal: dll_goal

#############################################################################
# import most rules and library files from normal makefile

!include borland.mak

dll_goal: create.dir create.rsp \
	$(TARG).dll $(LIBDIR)\$(TARG).lib $(LIBDIR)\$(TARG_STATIC).lib

#############################################################################
# more flags and switches

LFLAGS=$(LFLAGS) 
LIBS=$(CRTDLL)+import32.lib+ole2w32.lib

#############################################################################

STATICLINK_OBJS=stdafx.obj nolib.obj \
	appmodul.obj dllmodul.obj oleexp.obj

CPPFLAGS_STATIC=\
	$(CL_MODEL) $(CL_OPT) $(DEFS) $(OPT) $(EH) -H

PCH_TARGET=stdafx.obj

stdafx.obj $D\stdafxs.pch: stdafx.cpp stdafx.h
	$(CPP) /H\"stdafx.h\" @&&!
/c $(CPPFLAGS_STATIC) /H=$D\stdafxs.csm stdafx.cpp
!

appmodul.obj: stdafx.obj appmodul.cpp
	$(CPP) @&&!
/c $(CPPFLAGS_STATIC) /H=$D\stdafxs.csm appmodul.cpp
!

dllmodul.obj: stdafx.obj dllmodul.cpp
	$(CPP) @&&!
/c $(CPPFLAGS_STATIC) /H=$D\stdafxs.csm dllmodul.cpp
!

oleexp.obj: stdafx.obj oleexp.cpp
	$(CPP) @&&!
/c $(CPPFLAGS_STATIC) /H=$D\stdafxs.csm oleexp.cpp
!

nolib.obj: stdafx.obj nolib.cpp
	$(CPP) @&&!
/c $(CPPFLAGS_STATIC) /H=$D\stdafxs.csm nolib.cpp
!

#############################################################################
# Build target

$D\$(TARG).res: mfcdll.rc build_.h
	brcc32 -v $(RCFLAGS) $(RCDEFINES) /fo $D\$(TARG).res mfcdll.rc

DLL_OBJS=$(OBJECT) $(OBJDIAG) $(INLINES) $(FILES) $(COLL1) $(COLL2) $(MISC) \
	$(WINDOWS) $(DIALOG) $(WINMISC) $(DOCVIEW) $(APPLICATION) $(OLEREQ)

!if "$(MONOLITHIC)" == "1"
DLL_OBJS=$(DLL_OBJS) $(SOCKETS) $(OLEDLL) $(DAO) $(DB)
!endif

DLL_OBJS=$(DLL_OBJS) dllinit.obj

DLL_RESOURCES=$D\$(TARG).res

$(TARG).dll:: $(DEFFILE) $(DLL_RESOURCES)

$(TARG).dll:: $(DLL_OBJS) 
	$(LINK32) @&&!
$(LFLAGS) +
C0D32.OBJ +
$(**: = +^
)
$(TARG).DLL
$(TARG).MAP
$(LIBS)
$(DEFFILE)
$(DLL_RESOURCES)
!

$(LIBDIR)\$(TARG).lib: $(TARG).dll
    implib  $(LIBDIR)\$(TARG).lib $(TARG).DLL

$(LIBDIR)\$(TARG_STATIC).lib: $(STATICLINK_OBJS)
	$(LIB32) $@ /P2048 @&&!
+$(**: = &^
+)
!

#############################################################################
