;[]-----------------------------------------------------------------[]
;|      H_SPUSH.ASM -- struct argument routine                       |
;[]-----------------------------------------------------------------[]

;
;       C/C++ Run Time Library - Version 7.0
; 
;       Copyright (c) 1987, 1996 by Borland International
;       All Rights Reserved.
; 

                INCLUDE RULES.ASI

; calls to this routine are generated by the compiler to copy
; a "struct" argument to the stack
;
; DX:AX = address of struct to copy to stack
; CX    = size of struct, in bytes
;

_TEXT           SEGMENT BYTE PUBLIC 'CODE'
                ASSUME  CS:_TEXT

                PUBLIC  SPUSH@
                PUBLIC  F_SPUSH@
                PUBLIC  N_SPUSH@

N_SPUSH@:
                pop     bx              ;fetch return address off stack
                sub     sp,cx           ;make room on stack for struct
                push    cs              ;save return address back on stack
                jmp     short PUSHIT
SPUSH@:
F_SPUSH@:
                pop     bx              ;fetch return address off stack
                pop     es
                sub     sp,cx           ;make room on stack for struct
                push    es              ;save return address back on stack
PUSHIT:
                push    bx

                push    di              ;save regs
                push    ds

                mov     di,sp           ;set up di for move
                add     di,8
                mov     bx,ss           ;es = ss for move
                mov     es,bx
                mov     ds,dx           ;set up ds for move
                xchg    ax,si           ;set up si for move (also saves si)

                cld
                shr     cx,1
                rep     movsw
                adc     cx,cx
                rep     movsb

                xchg    si,ax           ;restore si
                pop     ds
                pop     di
                retf
_TEXT           ENDS
                END

