//----------------------------------------------------------------------------
// Borland Services Library
// Copyright (c) 1993, 1996 by Borland International, All Rights Reserved
//
//$Revision:   5.6  $
//
//----------------------------------------------------------------------------
#if !defined(SERVICES_DEFS_H)
#define SERVICES_DEFS_H

#if !defined(__cplusplus)
# error Must compile Borland Services Library as C++
#endif

//----------------------------------------------------------------------------
// We must use all libraries in DLLs if we are using SVCS in a DLL
//
// Define _SVCSDLL with -WSE (-WE for 32bit) to use SVCS & RTL in dlls.
//
// Be sure _BUILDSVCSDLL is defined when building an actual SVCS dll
//
#if defined(_SVCSDLL) || defined(_BUILDSVCSDLL)
# if !defined(_SVCSDLL)
#   define _SVCSDLL
# endif
# if !defined(_RTLDLL)
#   define _RTLDLL
# endif
#endif

//
// Include the appropriate compiler-specific header based on known compiler
// defined preprocessor constants
//
#if defined(__BORLANDC__)
# include <services/borlandc.h>

#elif defined(_MSC_VER)
# include <services/msc.h>

#else
# error Unknown compiler
#endif

//
// Get core RTL definitions
//
#if defined(BI_COMP_BORLANDC)
# include <_defs.h>                   // Borland RTL core definitions
#else
# include <services/private/defs.h>   // General purpose definitions
#endif

//----------------------------------------------------------------------------
// OS-specific flags.
//

//
//  Need to do some special stuff when the OS doesn't support
//  per-instance data in DLLs.
//
#if defined(BI_PLAT_WIN16)
# define BI_NO_PER_INSTANCE_DATA
#endif

//
//  Sometimes we need to know if we're building for Windows 3.0.
//
#if defined(BI_PLAT_WIN16) && defined(WINVER) && WINVER < 0x030A
# define BI_IS_WIN30
#endif

//
//  Windows 3.1 provides functions to read and write huge buffers.
//
#if defined(BI_PTR_16_16) && !defined(BI_IS_WIN30)
# define BI_HAS_HREADWRITE
#endif

//
//  Under Windows 3.0 WEPs are seriously broken.
//
#if defined(BI_IS_WIN30)
# define BI_WINDOWS_WEP_BUG
#endif

//----------------------------------------------------------------------------
// _RTTI provides a convenient macro for switching on Borland's __rtti
// keyword for finer grained control over generation of runtime type
// information.
//

#if defined(BI_NO_RTTI)
# define _RTTI
#else
# define _RTTI __rtti
#endif

//----------------------------------------------------------------------------
//  These CAST macros encapsulate the new cast syntax in the ANSI/ISO
//  working paper. Note that TYPESAFE_DOWNCAST isn't as general as
//  dynamic_cast -- it only works on pointers.
//
//  Usage:
//
//  TYPESAFE_DOWNCAST(object,toClass)
//      Converts the pointer referred to by 'object' into a pointer to
//      an object of type 'toClass'. Note that the macro parameters to
//      TYPESAFE_DOWNCAST are in the opposite order from the rest of
//      the macros here. When using a compiler that supports new style
//      casts and runtime type information this is done with
//      dynamic_cast<> and will return 0 if the cast cannot be done.
//      When using a compiler that does not support new style casts and
//      runtime type information this is done with fake runtime type
//      information generated by the IMPLEMENT_CASTABLE macro.
//
//  STATIC_CAST(targetType,object)
//      Converts the data object referred to by 'object' into the type
//      referred to by 'targetType'. When using a compiler that supports
//      new style casts, this is done with static_cast<> and will fail
//      if the cast cannot be done without runtime type information.
//      When using a compiler that does not support new style casts, this
//      is done with an old style dangerous cast.
//
//  CONST_CAST(targetType,object)
//      Converts the data object referred to by 'object' into the type
//      referred to by 'targetType'. When using a compiler that supports
//      new style casts, this is done with const_cast<> and will fail
//      if the cast changes the type of the object in any way other than
//      adding or removing const and volatile qualifiers.
//      When using a compiler that does not support new style casts, this
//      is done with an old style dangerous cast.
//
//  REINTERPRET_CAST(targetType,object)
//      Converts the data object referred to by 'object' into the type
//      referred to by 'targetType'. When using a compiler that supports
//      new style casts, this is done with reinterpret_cast<>.
//      When using a compiler that does not support new style casts, this
//      is done with an old style dangerous cast.
//

#if defined( BI_NO_NEW_CASTS )
# define TYPESAFE_DOWNCAST(object,toClass)\
        (object ?(toClass *)(object)->FindBase(#toClass) : 0)
# define STATIC_CAST(targetType,object)   \
        ((targetType)(object))
# define CONST_CAST(targetType,object)    \
        ((targetType)(object))
# define REINTERPRET_CAST(targetType,object) \
        (*(targetType*)(void *)&(object))
#else
# define TYPESAFE_DOWNCAST(object,toClass)\
        dynamic_cast<toClass * >(object)
# define STATIC_CAST(targetType,object)   \
        static_cast<targetType >(object)
# define CONST_CAST(targetType,object)    \
        const_cast<targetType >(object)
# define REINTERPRET_CAST(targetType,object) \
        reinterpret_cast<targetType >(object)
#endif

//----------------------------------------------------------------------------
// Provide expansions for mutable and bool when appropriate.
//

#if defined(BI_NO_MUTABLE)
# define mutable
#endif

#if defined(BI_NO_BOOL)
enum TBool {
  false,
  true
};
# if defined(EMULATE_BOOL)
    typedef TBool bool;
#   define BI_UNIQUE_BOOL
# else
    typedef int bool;
#   undef BI_UNIQUE_BOOL
# endif

#else
  typedef bool TBool;
# define BI_UNIQUE_BOOL
#endif

#if defined(BI_NO_BOOL) && defined(EMULATE_BOOL)
  template<class T> inline bool ToBool(const T& t) {
    return STATIC_CAST(bool,(t!=0));
  }
#else
  template<class T> inline bool ToBool(const T& t) {
    return STATIC_CAST(bool,t);
  }
#endif

//
// Shorthand 'far' keyword evaluates to __far when needed & supported, else
// nothing. Same with 'huge' and 'HUGE'
//
#if !defined(far)
# if defined(BI_PTR_0_32)
#   define far
# else
#   define far __far
# endif
#endif
#if !defined(huge)
# if defined(BI_PTR_0_32)
#   define huge
# else
#   define huge __huge
# endif
#endif
#if !defined(HUGE)
# if defined(BI_PTR_0_32)
#   define HUGE
# else
#   define HUGE __huge
# endif
#endif

//
// Commonly used fixed-size integer types
//
#if defined(BI_COMP_BORLANDC)
# include <systypes.h>
#else
  typedef signed char    int8;
  typedef signed short   int16;
  typedef signed long    int32;

  typedef unsigned char  uint8;
  typedef unsigned short uint16;
  typedef unsigned long  uint32;
#endif

//
// Some nonfixed-size types defined similar to the fixedsize in systypes.h
//
typedef unsigned long  ulong;
typedef unsigned int   uint;
typedef unsigned short ushort;
typedef unsigned char  uchar;

//
// Integer byte, word and long word manipulation
//
inline uint16 MkUint16(uint8 lo, uint8 hi) {
  return uint16(lo | (uint16(hi) << 8));
}
inline uint32 MkUint32(uint16 lo, uint16 hi) {
  return lo | (uint32(hi) << 16);
}
inline uint16 LoUint16(uint32 u32) {
  return uint16(u32);
}
inline int16 LoInt16(uint32 u32) {
  return int16(u32);
}
inline uint16 HiUint16(uint32 u32) {
  return uint16(u32 >> 16);
}
inline int16 HiInt16(uint32 u32) {
  return int16(u32 >> 16);
}
inline uint8 LoUint8(uint16 u16) {
  return uint8(u16);
}
inline int8 LoInt8(uint16 u16) {
  return int8(u16);
}
inline uint8 HiUint8(uint16 u16) {
  return uint8(u16 >> 8);
}
inline int8 HiInt8(uint16 u16) {
  return int8(u16 >> 8);
}

//----------------------------------------------------------------------------

//
// Define library-wide function calling conventions. Must rebuild everything
// if changed, and must use appropriate modifier on derived classes.
//
#if !defined(_CALLCNVN)
# if defined(BI_PLAT_OS2) || defined(BI_PLAT_WIN32) 
#   define _CALLCNVN   //__stdcall
# else
#   if defined(_FASTTHIS)
#     define _CALLCNVN __fastthis
#   else
#     define _CALLCNVN //__pascal
#   endif
# endif
#endif

//
// MSVC uses __declspecs, so just turn import/export into those
//
#if defined(BI_COMP_MSC)
# define __export    __declspec(dllexport)
# define __import    __declspec(dllimport)
#endif

//----------------------------------------------------------------------------
// Setup class, function and data modifier macros for Services
//
#if defined(_BUILDSVCSDLL)
# define _SVCSCLASS     __export _CALLCNVN
# define _SVCSCLASS_RTL __export
# define _SVCSDATA      __export
# define _SVCSFUNC      __export
#elif defined(_SVCSDLL) && !defined(BI_PLAT_OS2)
# define _SVCSCLASS     __import _CALLCNVN
# define _SVCSCLASS_RTL __import
# if defined(BI_PTR_0_32)
#   define _SVCSDATA    __import
#   define _SVCSFUNC    __import
# else
#   define _SVCSDATA    __far
#   define _SVCSFUNC
# endif
#else
# if defined(_SVCSFARVTABLE)
#   define _SVCSCLASS   __huge _CALLCNVN
# else
#   define _SVCSCLASS   _CALLCNVN
# endif
# define _SVCSCLASS_RTL _EXPCLASS
# define _SVCSDATA
# define _SVCSFUNC
#endif

#endif  // SERVICES_DEFS_H
