# borland.mak : Builds a Microsoft Foundation Class library variant.
#
# Usage: MAKE -F BORLAND.MAK CLEAN        (removes all intermediary files)
#    or: MAKE -F BORLAND.MAK options      (builds a library variant (see below))
# Note that an MAKE CLEAN should be performed before building a new variant.
#
# 'Options' are one of each of:
#   "DLL"              (defaults to 0)
#           If this item is 0, then a normal library is generated.
#           If this item is 1, a DLL version of the library is generated.
#           If this item is 2, objects suitable for the shared DLL version
#           of MFC are created.  Note: DLL=2 is to be used only from
#           MFCDLL.MAK, MFCOLE.MAK, or MFCDB.MAK
#
#   "DEBUG"             (defaults to 1)
#           If this item is 1, debugging support is compiled into
#           the library.  If this item is 0, then debugging support
#           is disabled.  Debug support does not include CodeView information.
#
#   "OBJ=.\obj"         (defaults to '$$(MODEL)$(BASE)$(DEBUG)')
#           This optional specification specifies where temporary OBJ files
#           are stored during the build process.  The directory is created or
#           removed as necessary.
#
#   "OPT="              (no default value)
#           This allows additional compiler options to be added to the build.
#           If more than one switch is desired, put double-quotes around the
#           whole OPT= argument, e.g., "OPT=/J /W3".
#
#   "NO_PCH=0"
#           Set this item to override the default use of precompiled headers.
#
#
#   "BROWSE=1"          (defaults to 0)
#           Set this option to include browse information
#
#   "MT=0"              (defaults to 1)
#           To build a non-multithreaded library instead of the default
#           (which enables multitheading and uses the multithread
#           C-runtimes) you can use MT=0.
#
#	"LIBDIR=..\lib\borland"
#			Define path for generated libraries
#
#############################################################################
# Define defaults if not defined

# Default to DEBUG mode
!ifndef DEBUG
DEBUG=1
!endif

# Default to NOT DLL
!ifndef DLL
DLL=0
!endif

# Default to no BROWSE info
!ifndef BROWSE
BROWSE=0
!endif

# Default to no NO_PCH info
!ifndef NO_PCH
NO_PCH=1
!endif

# No MBCS
MBCS=0

# Default to multithreading support
!ifndef MT
MT=1
!endif

# Default to no warnings
!ifndef WARN
WARN=0
!endif

# Lib directory
!ifndef LIBDIR
LIBDIR=..\LIB\BORLAND
!endif

BASE=W
MODEL=N
PLATFORM=INTEL

#
# DEBUG OPTIONS
#
!if "$(DEBUG)" != "0"
DEBUGSUF=D
DEBDEFS=/D_DEBUG
DEBOPTS=-v
!else
#
# NON-DEBUG OPTIONS
#
DEBUGSUF=
DEBDEFS=
DEBOPTS=/O1
!endif

CPP=bcc32
LIB32=Tlib
LINK32=tlink32

CL_MODEL=/D_X86_


# TYPE = Library Type Designator
#       c = normal C library
#       d = DLL library
TYPE=c

#
# _USRDLL DLL Variant
#
!if "$(DLL)" == "1"
# _USRDLL library
TYPE=d
DEXT=.dll
TARGDEFS=$(TARGDEFS) /D_WINDLL /D_USRDLL
!else
DEXT=
!endif

#
# Object File Directory
#
!if "$(OBJ)" == ""
D=$$$(MODEL)$(BASE)$(DEBUGSUF)$(DEXT)    # subdirectory specific to variant
!else
D=$(OBJ)                                 # User specified directory
!endif

#
# _AFXDLL DLL Variant
#

!if "$(DLL)" == "2"
# _AFXDLL library
TYPE=e
!if "$(OBJ)" == ""
!if "$(AFXCTL)" == "1"
D=CTL$(DEBUGSUF)32.$(BASE)
!else
D=DLL$(DEBUGSUF).$(BASE)
!endif
D=$$$D
!endif

TARGOPTS=$(TARGOPTS) /WM
TARGDEFS=$(TARGDEFS) /D_WINDLL /D_AFXDLL /D_MT=1
!else
# not _AFXDLL library
!if "$(MT)" != "0"
TARGOPTS=$(TARGOPTS) /WM
TARGDEFS=$(TARGDEFS) /D_MT=1
!endif
!endif

!if "$(DLL)" == "2"
!if "$(TARG)" == ""
!error DLL=2 is used only from BFCDLL.MAK, BFCOLE.MAK, or BFCDB.MAK
!endif
GOAL=$(TARG)
!else
GOAL=$(MODEL)afx$(TYPE)$(BASE)$(DEBUGSUF)
!endif

#
# COMPILER OPTIONS
#
DEFS=$(DEFS) /D_AFX_PORTABLE /D_ANONYMOUS_STRUCT /D_WCHAR_T_DEFINED /D__MSC /D_RTLDLL
CL_OPT= $(DEBOPTS) $(CVOPTS) $(TARGOPTS) -n$D -WM -VF3

!if "$(WARN)" == "0"
CL_OPT=$(CL_OPT) -w-
!endif

!if "$(BROWSE)" != "0"
CL_OPT=-R $(CL_OPT)
!endif

DEFS=$(DEFS) $(DEBDEFS) $(TARGDEFS)


#############################################################################
# Library Components

OBJECT=objcore.obj except.obj afxver.obj \
	validadd.obj dumpcont.obj dumpflt.obj \
	arccore.obj arcobj.obj arcex.obj

# non-shared diagnostics
OBJDIAG=dumpinit.obj dumpout.obj \
	afxasert.obj afxmem.obj afxabort.obj

FILES=filecore.obj filetxt.obj filemem.obj fileshrd.obj \
	filex.obj filest.obj

COLL1=array_b.obj array_d.obj array_p.obj array_o.obj \
	array_s.obj array_u.obj array_w.obj \
	list_o.obj list_p.obj list_s.obj

COLL2=map_pp.obj map_pw.obj map_so.obj \
	map_sp.obj map_ss.obj map_wo.obj map_wp.obj plex.obj

MISC=strcore.obj strex.obj timecore.obj afxdbcs.obj afxstate.obj

WINDOWS=\
	wincore.obj winfrm.obj winfrm2.obj winfrmx.obj winmdi.obj \
	winmini.obj winhand.obj winmain.obj \
	barcore.obj bartool.obj bardlg.obj barstat.obj bardock.obj \
	dockcont.obj dockstat.obj \
	dcprev.obj dcmeta.obj trckrect.obj \

DIALOG=\
	winctrl1.obj winbtn.obj \
	dlgcore.obj dlgdata.obj dlgfloat.obj dlgprop.obj \
	dlgcomm.obj \
	dlgfile.obj dlgprnt.obj dlgclr.obj dlgfnt.obj dlgfr.obj

WINMISC=\
	wingdi.obj wingdix.obj winstr.obj winmenu.obj \
	auxdata.obj afxtrace.obj winutil.obj

DOCVIEW=\
	cmdtarg.obj doccore.obj doctempl.obj \
	docsingl.obj docmulti.obj \
	viewcore.obj viewprnt.obj winsplit.obj viewscrl.obj \
	viewform.obj viewedit.obj viewprev.obj
DOCVIEW=$(DOCVIEW) docmapi.obj

APPLICATION=\
	thrdcore.obj appcore.obj appinit.obj appterm.obj \
	appui.obj appui2.obj appui3.obj appgray.obj appdlg.obj \
	app3d.obj appprnt.obj apphelp.obj apphelpx.obj \
	appdata.obj filelist.obj dbdata.obj

DB=dbcore.obj dbrfx.obj dbview.obj dbflt.obj

SOCKETS=sockcore.obj

OLEREQ=olelock.obj oledata.obj

OLE=\
	oleinit.obj olebar.obj olecli1.obj olecli2.obj \
	olecli3.obj oledobj1.obj oledobj2.obj oledisp1.obj \
	oledisp2.obj oledlgs1.obj oledlgs2.obj oledoc1.obj \
	oledoc2.obj oledrop1.obj oledrop2.obj olemsgf.obj \
	oleenum.obj olefact.obj oleipfrm.obj olelink.obj \
	olemisc.obj olestrm.obj olesvr1.obj olesvr2.obj \
	olereg.obj oletsvr.obj oleui1.obj oleui2.obj \
	oleunk.obj olecall.obj
!if "$(DLL)" == "1"
OLE=$(OLE) oledll.obj
!endif

OLEDLL=$(OLE) $(OLEASM)

!if "$(DEBUG)" == "1"
INLINES = afxinl1.obj afxinl2.obj afxinl3.obj
!else
INLINES =
!endif

CPP_OBJS=$(OBJECT) $(OBJDIAG) $(INLINES) $(FILES) $(COLL1) $(COLL2) $(MISC) \
	$(WINDOWS) $(DIALOG) $(WINMISC) $(DOCVIEW) $(APPLICATION) \
	$(SOCKETS) $(OLEREQ) $(OLE)
OBJS=$(CPP_OBJS) $(OLEASM)


#############################################################################
# Standard tools

#############################################################################
# Set CPPFLAGS for use with .cpp.obj and .c.obj rules
# Define rule for use with OBJ directory
# C++ uses a PCH file

CPPFLAGS=$(CPPFLAGS) $(CL_MODEL) $(CL_OPT) $(DEFS) $(OPT)

!ifndef NO_PCH
!ifndef PCH_FILE
PCH_FILE=$D\stdafx
PCH_FILE=$(PCH_FILE).csm
!endif
!ifndef PCH_CPP
PCH_CPP=objcore
!endif

CPPFLAGS=$(CPPFLAGS) -Hu -H=$(PCH_FILE)
!else
CPPFLAGS=$(CPPFLAGS) -H-
PCH_FILE=
!endif

.SUFFIXES: .cpp

.path.obj = $D

.cpp.obj:
	$(CPP) @&&!
$(CPPFLAGS) /c 
! { $< }

!ifndef NO_PCH
PCH_TARGETS=$(PCH_FILE) $D\$(PCH_CPP).obj
!endif # NO_PCH

#############################################################################
# Goals to build

GOALS=create.dir
!ifndef NO_PCH
GOALS=$(GOALS) $(PCH_FILE) $D\$(PCH_CPP).obj
!endif # NO_PCH
GOALS=$(GOALS) $(LIBDIR)\$(GOAL).lib

goal: $(GOALS)

create.dir:
	@-if not exist $D\*.* mkdir $D
	@-if not exist $(LIBDIR) mkdir $(LIBDIR)

clean:
	-if exist $D\*.obj erase $D\*.obj
	-if exist $D\*.csm erase $D\*.csm
	-if exist $D\*.res erase $D\*.res
	-if exist $D\*.rsc erase $D\*.rsc
	-if exist $D\*.map erase $D\*.map
	-if exist $D\*.* rmdir $D

#############################################################################
# Precompiled header file

!ifndef NO_PCH

!if "$(DEBUG)" == "1"
HDRS =..\include\*.h
!else
HDRS =..\include\*.h ..\include\*.inl
!endif

#	$(CPP) -H\"stdafx.h\" @&&!
PCH_TARGETS=$(PCH_FILE) $D\$(PCH_CPP).obj

$(PCH_TARGETS): $(PCH_CPP).cpp $(HDRS)
	$(CPP) @&&!
-H -H=$(PCH_FILE) $(CL_MODEL) $(CL_OPT) $(DEFS) $(OPT) /c $(PCH_CPP).cpp
!

!endif # NO_PCH


#############################################################################
# Build the library from the up-to-date objs

!if "$(DLL)" != "2"

# Build final library
$(LIBDIR)\$(GOAL).lib: $(OBJS)
	-if exist $@ erase $@
#	&$(LIB32) $@ /P2048 -+ $**
	$(LIB32) $@ /P2048 @ &&!
+$(**: = &^
+)
!

!endif #DLL!=2

#############################################################################
