# BFCOLE.MAK - makefile for BFCO30*.DLL
#
# BFCO30[D].DLL is a DLL
#  which exports all the MFC/OLE classes
#

!ifndef LIBNAME
#!error LIBNAME is not defined. LIBNAME=BFCO30 builds the prebuilt DLL.
LIBNAME=BFCO30
!endif

TARGET=w
DLL=2
TARG=$(LIBNAME)
TARGDEFS=/D_AFX_OLE_IMPL
MFCDLL=BFC30
LFLAGS=/n /m /s
RCFLAGS=@brcc32.cfg
RCFLAGS=$(RCFLAGS) /r

!if "$(DEBUG)" != "0"
# Debug DLL build
RCDEFINES=/D_DEBUG
LFLAGS=$(LFLAGS) /v
PCH_FILE=$D\stdafxo.pch
PCH_CPP=dllole
TARG=$(TARG)D
MFCDLL=$(MFCDLL)D

!ELSE
# Release DLL build
RCDEFINES=
LFLAGS=$(LFLAGS)
PCH_FILE=$D\stdafxo.pch
PCH_CPP=dllole
!ENDIF

DEFFILE=$(PLATFORM)\$(TARG).DEF


!ifdef RELEASE # Release VERSION info
RCDEFINES=$(RCDEFINES) /DRELEASE
LFLAGS=$(LFLAGS) /release
!endif

LFLAGS=$(LFLAGS) /Tpd

olegoal: dll_goal

#############################################################################
# import most rules and library files from normal makefile

!include borland.mak

MFCDLL=$(LIBDIR)\$(MFCDLL).lib
LIBS=$(MFCDLL) $(CRTDLL) ole2w32.lib+import32.lib+cw32mti.lib
LIBS=mfcans32.lib msextra.lib $(LIBS)

dll_goal: create.dir $(TARG).dll $(LIBDIR)\$(TARG).lib

create2.dir:
	@-if not exist $D\*.* mkdir $D
	@-if not exist $(LIBDIR) mkdir $(LIBDIR)

#############################################################################
# Build target

$D\$(TARG).res: mfcole.rc
	brcc32 $(RCFLAGS) $(RCDEFINES) /fo $D\$(TARG).res mfcole.rc

DLL_OBJS=$(OLEDLL)

$(TARG).dll:: $(DEFFILE) $D\$(TARG).res

$(TARG).dll:: $(PCH_CPP).obj $(DLL_OBJS)
	$(LINK32) @&&!
$(LFLAGS) +
C0D32.OBJ +
$(**: = +^
)
$(TARG).DLL
$D\$(TARG).MAP
$(LIBS)
$(DEFFILE)
$D\$(TARG).res
!

$(LIBDIR)\$(TARG).lib: $(TARG).dll
    implib  $(LIBDIR)\$(TARG).lib $(TARG).DLL
	if exist $(LIBDIR)\$(TARG).exp del $(LIBDIR)\$(TARG).exp

#############################################################################
