# BFCDLL.MAK - Makefile for BFC30*.DLL
#              Includes BORLAND.MAK
#
# BFC30[D].DLL is a DLL
#  which exports all the MFC classes
#
# Note: LIBNAME must be 6 characters or less.

!ifndef LIBNAME
#!error LIBNAME is not defined. LIBNAME=BFC30 builds the Borland DLL.
LIBNAME=BFC30
!endif

!if "$(NTSDK)" == "1"
CRTDLL=crtdll.lib
!else
CRTDLL=msvcrt.lib
!endif

RCFLAGS=@brcc32.cfg
TARGET=w
DLL=2
TARG=$(LIBNAME)
TARGDEFS=/D_AFX_CORE_IMPL
LFLAGS=/n /m /s
RCFLAGS=$(RCFLAGS) /r

!if "$(DEBUG)" != "0"
# Debug DLL build
TARG=$(TARG)D
RCDEFINES=/D_DEBUG
LFLAGS=$(LFLAGS) /v
!ELSE
# Release DLL build
RCDEFINES=
LFLAGS=$(LFLAGS)
!ENDIF

DEFFILE=$(PLATFORM)\$(TARG).DEF

!ifdef RELEASE # Release VERSION info
RCDEFINES=$(RCDEFINES) /DRELEASE
LFLAGS=$(LFLAGS) 
!endif

LFLAGS=$(LFLAGS) /Tpd

bfc_dll: dll_goal

#############################################################################
# import most rules and library files from normal makefile

!include borland.mak

dll_goal: create.dir $(TARG).dll $(LIBDIR)\$(TARG).lib

#############################################################################
# more flags and switches

LFLAGS=$(LFLAGS) 

LIBS=import32.lib+cw32mti.lib

#############################################################################
# Build target

$D\$(TARG).res: mfcdll.rc
	brcc32 $(RCFLAGS) $(RCDEFINES) /fo $D\$(TARG).res mfcdll.rc

DLL_OBJS= \
	$(OBJECT) $(OBJDIAG) $(INLINES) $(FILES) $(COLL1) $(COLL2) $(MISC) \
	$(WINDOWS) $(DIALOG) $(WINMISC) $(DOCVIEW) $(APPLICATION) $(OLEREQ) \
	dllinit.obj

DLL_RESOURCES=$D\$(TARG).res

$(TARG).dll:: $(DLL_RESOURCES) $(DEFFILE)

$(TARG).dll:: $(DLL_OBJS)
	$(LINK32) @&&!
$(LFLAGS) +
C0D32.OBJ +
$(**: = +^
)
$(TARG).DLL
$(TARG).MAP
$(LIBS)
$(DEFFILE)
$(DLL_RESOURCES)
!

$(LIBDIR)\$(TARG).lib: $(TARG).dll
	implib  $(LIBDIR)\$(TARG).lib $(TARG).DLL
	if exist $(LIBDIR)\$(TARG).exp del $(LIBDIR)\$(TARG).exp

#############################################################################
