# BFCD30.MAK - Borland makefile for BFC30*.DLL
#
# BFCD30[D].DLL is a DLL
#  which exports all the MFC/DB classes
#

!ifndef LIBNAME
#!error LIBNAME is not defined. LIBNAME=MFCD30 builds the prebuilt DLL.
LIBNAME=BFCD30
!endif

CRTDLL=

TARGET=w
DLL=2
TARG=$(LIBNAME)
TARGDEFS=/D_AFX_DB_IMPL
MFCDLL=BFC30
LFLAGS=/n /m /s
RCFLAGS=@brcc32.cfg
RCFLAGS=$(RCFLAGS) /r

!if "$(DEBUG)" != "0"
# Debug DLL build
RCDEFINES=/D_DEBUG
LFLAGS=$(LFLAGS) /v
PCH_FILE=$D\stdafxd.pch
PCH_CPP=dlldb
TARG=$(TARG)D
MFCDLL=$(MFCDLL)D

!ELSE
# Release DLL build
RCDEFINES=
LFLAGS=$(LFLAGS)
PCH_FILE=$D\stdafxd.pch
PCH_CPP=dlldb
!ENDIF

DEFFILE=$(PLATFORM)\$(TARG).DEF

MFCDLL=$(LIBDIR)\$(MFCDLL).lib

!ifdef RELEASE # Release VERSION info
RCDEFINES=$(RCDEFINES) /DRELEASE
LFLAGS=$(LFLAGS) /release
!endif

LFLAGS=$(LFLAGS) /Tpd

LIBS=$(MFCDLL) $(CRTDLL) ole2w32.lib+import32.lib+cw32mti.lib

bfcdb_goal: dll_goal

#############################################################################
# import most rules and library files from normal makefile

!include borland.mak

dll_goal: create.dir $(TARG).dll $(LIBDIR)\$(TARG).lib

#############################################################################
# Build target

$D\$(TARG).res: mfcdb.rc
	brcc32 $(RCFLAGS) $(RCDEFINES) /fo $D\$(TARG).res mfcdb.rc

DLL_OBJS=$(DB)

$(TARG).dll:: $(DEFFILE) $D\$(TARG).res

$(TARG).dll:: $(PCH_CPP).obj $(DLL_OBJS)
	tlink32 @&&!
$(LFLAGS) +
C0D32.OBJ +
$(**: = +^
)
$(TARG).DLL
$D\$(TARG).MAP
$(LIBS)
$(DEFFILE)
$D\$(TARG).res
!

$(LIBDIR)\$(TARG).lib: $(TARG).dll
    implib  $(LIBDIR)\$(TARG).lib $(TARG).DLL
	if exist $(LIBDIR)\$(TARG).exp del $(LIBDIR)\$(TARG).exp

#############################################################################
