/***************************************************************************
*    OPMIMP.C                                                              *
*                                                                          *
*        Shopping Mall Version 6 Import Utility.  Please see the end       *
*    of code for instructions on how to run.                               *
*                                                                          *
*    Copyright 1993 Galacticomm, Inc.                                      *
*                                                 - C. Kotacka 04/22/93    *
***************************************************************************/

#include "gcomm.h"
#include "usracc.h"

/* OPMIMP.C 22/04/93 20.19.18 */
int is_there (void);
int do_import (void);
int nextln (void);
int trimit (void);
int get_merchant (void);
int get_dpt (void);
int get_prodid (void);
int get_brfdsc (void);
int get_weight (void);
int get_price (void);
int get_flags (void);
int get_verbose (void);
int reject (void);

#define PIDSIZ (12+1)         /* Max size of product number                */
#define BRDSIZ (30+1)         /* Max size of brief product description     */
#define DKYSIZ (6+1)          /* Department key size                  SE   */
#undef KEYSIZ
#define KEYSIZ (6+1)          /* Department key size                  SE   */
#define TXBSIZ (1920+1)          /* Maximum size of text buffer               */

#define DDSSIZ (30+1)         /* Max size of dept. description field       */
#define CSZSIZ (15+1)         /* Max field size of color and size entry    */
#define SIFNSZ (8+1)          /* Max size of .SIF file name (no ext)       */
#define SVDSIZ (40+1)         /* Max size of services description field    */
#define STTSIZ (2+1)          /* Max size of state field                   */
#define SPMSIZ (20+1)         /* Max size of pay/ship method desc. string  */
#define NSPMTH 6              /* Max number of shipping/payment methods    */

struct invtmp {               /* Temp inventory data buffer                */
     char macuid[UIDSIZ];     /* Merchants User-ID                         */
     char dptkey[KEYSIZ];     /* Department key                       SE   */
     char prodid[PIDSIZ];     /* Product or catalog number                 */
     char brfdsc[BRDSIZ];     /* Brief description of this item            */
     int weight;              /* Weight in ounces                          */
     long price;              /* Price of this item                        */
     int flags;               /* Misc. flags                               */
     char vrbdsc[TXBSIZ];     /* Long description                          */
     char spare[2018-2010];   /* spare decrement as needed                 */
};                            /* GALIVC.DAT file                           */

#define UPDINV 1              /* Made changes to inventory, update!        */
#define SIZES  2              /* Inventory item has sizes                  */
#define COLORS 4              /* Inventory item has colors                 */
#define DISCNT 8              /* Item qualifies for discount               */

/*             Import File Offsets                                         */

#define OFFDPT  (UIDSIZ-1)
#define OFFPROD (OFFDPT+KEYSIZ-1)
#define OFFBRF  (OFFPROD+PIDSIZ-1)
#define OFFWT   (OFFBRF+BRDSIZ-1)
#define OFFPRC  (OFFWT+5)
#define OFFFLG  (OFFPRC+12)
#define OFFVRB  (OFFFLG+2)

struct depxrf {               /* Department/Merchant cross-ref file        */
     char depkey[DKYSIZ];     /* Department key                            */
     char macuid[UIDSIZ];     /* Merchants User-ID                         */
};

#define MAXLINE 4096                              /* Maximum input length  */

BTVFILE *ord;                                     /* Btrieve File Pointer  */
BTVFILE *usr;                                     /* Btrieve File Pointer  */
BTVFILE *dxfbb;                                   /* Btrieve File Pointer  */
FILE    *inf;                                     /* Import file pointer   */

char infile[256];                                 /* Input file name       */
char whyrej[256];                                 /* Why Rejected          */
char tmp[MAXLINE];                                /* current line          */
char tmp2[MAXLINE];                               /* global holder         */


struct invtmp inv;                                /* Inventory pointer     */
struct depxrf dxf;                                /* Inventory pointer     */
struct usracc acc;                                /* User Account Pointer  */

int nosave=0;                                     /* global OK flag        */
long cnt=0L;                                      /* Records imported      */
long line=0L;                                     /* line being processed  */
int allok=1;                                      /* ok to import this rec?*/

main(
int argc,
char *argv[])
{
     if (argc != 2) {
          printf("Usage=  OPMIMP \"filename\" \n");
          return(0);
     }
     stzcpy(infile,argv[1],sizeof(infile));
     if (is_there()) {
          ord=opnbtv("GALIVC.DAT",sizeof(struct invtmp));
          usr=opnbtv("BBSUSR.DAT",sizeof(struct usracc));
          dxfbb=opnbtv("galdxf.dat",sizeof(struct depxrf));
          do_import();
     }
     clsbtv(ord);
     clsbtv(usr);
     clsbtv(dxfbb);
     fclose(inf);
     return(1);
}

is_there()
{
     if ((inf=fopen(infile,FOPRA)) != NULL) {
          return(1);
     }
     return(0);
}

do_import()
{
     nextln();
     do {
          line++;
          setmem(&inv,sizeof(struct invtmp),0);
          if (get_merchant()) {
               if (get_dpt()) {
                    if (get_prodid()) {
                         if (get_brfdsc()) {
                              if (get_weight()) {
                                   if (get_price()) {
                                        if (get_flags()) {
                                             get_verbose();
                                        }
                                   }
                              }
                         }
                    }
               }
          }
          if (allok) {
               setbtv(ord);
               if (dinsbtv(&inv)) {
                    printf("Good Record # %s\n",l2as(line));
               }
               else {
                    stzcpy(whyrej,"Duplicate Insert!",sizeof(whyrej));
                    reject();
               }
          }
          allok=1;
     } while (nextln());
     return(1);
}

nextln(void)                                 /* get the next line :>       */
{
     setmem(tmp,sizeof(tmp),0);
     setmem(tmp2,sizeof(tmp2),0);
     if (fgets(tmp,MAXLINE,inf) != NULL) {
          return(1);
     }
     allok=0;
     return(0);
}

get_merchant()                          /* dip into bbsusr.dat and see :>  */
{
     int i;

     for (i=0; i < (UIDSIZ-1) ; i++) {
          tmp2[i]=tmp[i];
     }
     trimit();
     stzcpy(inv.macuid,tmp2,UIDSIZ);
     setbtv(usr);
     if (qeqbtv(inv.macuid,0)) {
          return(1);
     }
     stzcpy(whyrej,"Merchant Not on file!",sizeof(whyrej));
     reject();
     allok=0;
     return(0);
}

get_dpt()                               /* check galdpt.dat for department */
{
     int i;
     char thingy[BRDSIZ];
     char *ptr;

     setmem(thingy,BRDSIZ,0);
     for (i=0; i < (KEYSIZ-1) ; i++) {
          tmp2[i]=tmp[i+(OFFDPT)];
     }
     trimit();
     stzcpy(thingy,tmp2,BRDSIZ);
     ptr=tmp2;
     ptr++;
     ptr++;
     ptr++;
     ptr++;
     ptr++;
     ptr++;
     ptr++;
     stzcpy(ptr,inv.macuid,UIDSIZ);
     stzcpy(inv.dptkey,tmp2,KEYSIZ);
     strupr(inv.dptkey);
     return(1);
}

get_prodid()                                         /* extract product ID */
{
     int i;

     for (i=0; i < (PIDSIZ-1) ; i++) {
          tmp2[i]=tmp[i+OFFPROD];
     }
     trimit();
     stzcpy(inv.prodid,tmp2,PIDSIZ);
     return(1);
}

trimit()
{
     char *ptr;

     ptr=strchr(tmp2,'\0');
     if (ptr != NULL) {
          ptr--;
          do {
               *ptr='\0';
               ptr--;
          } while (*ptr==' ');
     }
     return(1);
}


get_brfdsc()                                         /* extract brief dsc  */
{
     int i;

     for (i=0; i < 30 ; i++) {
          tmp2[i]=tmp[i+OFFBRF];
     }
     trimit();
     stzcpy(inv.brfdsc,tmp2,BRDSIZ);
     return(1);
}

get_weight()                                         /* extract prd weight */
{
     int i;

     for (i=0; i < 5 ; i++) {
          tmp2[i]=tmp[i+OFFWT];
     }
     trimit();
     inv.weight=atoi(tmp2);
     return(1);
}

get_price()                                         /* extract prd price   */
{
     int i;

     for (i=0; i < 12; i++) {
          tmp2[i]=tmp[i+OFFPRC];
     }
     trimit();
     inv.price=atol(tmp2);
     return(1);
}

get_flags()                                         /* extract flags      */
{
     int i;

     for (i=0; i < 2; i++) {
          tmp2[i]=tmp[i+OFFFLG];
     }
     trimit();
     inv.flags=atoi(tmp2);
     return(1);
}

get_verbose()                                       /* get verbose desc.  */
{
     int i;

     for (i=0; i < 1920; i++) {
          tmp2[i]=tmp[i+OFFVRB];
          if (tmp2[i]=='\x01') {
               tmp2[i]='\n';
          }
     }
     tmp2[i]='\0';
     stzcpy(inv.vrbdsc,tmp2,TXBSIZ);
     return(1);
}

reject()
{
     printf("Rejected Line # %s [%s]\n",l2as(line),whyrej);
     return(0);
}

/*   D O C U M E N T A T I O N

Shopping Mall Import Program
----------------------------


Running:

1)  Load Btrieve by going to the BBSV6 directory, and type:
    BBSBTR

2)  Run the program, specifying the import file in the command line.
    Example:  OPMIMP MALL.IMP

    < The file name can include drive letter and directory path specs >

3)  That's it...  If any problem is encountered along the way, a report
    will be generated to the screen.  You may wish to "pipe" this to
    a text file for later review...  For example:

    OPMIMP MALL.IMP >OPMIMP.LOG

--------------------------------------------------------------------------
Input file format specifications
--------------------------------------------------------------------------

The import file is a combination Fixed-Lenght ASCII for all fields
except the product description.  One record per line.

The format is as follows:

1-29  Merchant User-Id   (Case Sensitive...enter exactly as BBS Userid)

30-35 Department to place product into  (Case Sensitive)

36-47 Product Name

48-77 Brief description of the product

78-82 Weight of product (in ounces).  If no weight, you can leave this
      area padded with spaces.


83-94 Price of product (in pennies), meaning:
          If your product is $199.99 specify as 19999

      ***IMPORTANT***
      Please do not include $'s or decimals here... nasty stuff may result.
      You have been told....

95-96 Related Flags about the product.
           Flag values are:

               2 = product has different sizes
               4 = Product has different colors
               8 = Product is discountable

      For example, if your product comes in one size, has different colors
      and is discountable...simply add 4+8 and specify 12.

      If nothing is applicable, fill with 00.

97-(up to 2017) Verbose Description.

          The Verbose description does not need to be fixed length.
          Simply end the description with a carriage return.

          If you need CR's in there, simply put a hex-01 character
          where you'd like one, and it will be converted for you.

*** All fields should be left justified in the import file ***


-Enjoy....

-Clk


             E N D    O F    D O C U M E N T A T I O N                     */
