/***************************************************************************
 *                                                                         *
 *   GALUPX.C                                                              *
 *                                                                         *
 *   Copyright (C) 1994 GALACTICOMM, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   Uploading example.                                                    *
 *                                                                         *
 *                                              - R. Stein  12/6/93        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "filexfer.h"

STATIC int uplinp(void);
STATIC int fupupl(int fupcod);

int uplstt;                             /* Uploading module state number   */
struct module uplmodule={"",NULL,uplinp,dfsthn};

void EXPORT
init__uploader(void)                    /* Uploader initialization         */
{
     stzcpy(uplmodule.descrp,gmdnam("GALUPX.MDF"),MNMSIZ);
     uplstt=register_module(&uplmodule);
     mkdir("UPLDIR");
}

STATIC int
uplinp(void)                            /* Uploader input handler          */
{
     switch (usrptr->substt) {
     case 0:
          prf("Name of file to upload: ");
          usrptr->substt=1;
          break;
     case 1:
          if (margc == 0) {
               return(0);
          }
          fileup(strcpy(vdaptr,margv[0]),"?",fupupl);
     }
     outprf(usrnum);
     return(1);
}

int
fupupl(                                 /* Handle the application-specific */
int fupcod)                             /* aspects of the upload example   */
{                                       /* (fupcod=code for each aspect)   */
     int rc=0;

     switch(fupcod) {
     case FUPBEG:                       /* Begin uploading this file       */
     case FUPEND:                       /* This file uploaded successfully */
          sprintf(ftfbuf,"UPLDIR\\%s",vdaptr);
          rc=1;
          break;
     case FUPFIN:                       /* End of uploading session        */
          usrptr->state=uplstt;
     }
     return(rc);
}
