/* patchit.h */

typedef struct patchinfo {         /* info about patch                     */
     void *oldrout;                /*   pointer to old routine             */
     void *newrout;                /*   pointer to new routine             */
     char oldhead[5];              /*   first 5 bytes of virgin old routine*/
     char newhead[5];              /*   5 bytes patched into old routine   */
     char *oldroutw;               /*   writeable pointer to old routine   */
     SEL memsel;                   /*   selector of writeable pointer      */
} patchinfo;

void
patchinit(                         /* initialze patch capability           */
patchinfo *pinf,                   /*   info structure                     */
void *oldrout,                     /*   pointer to old routine             */
void *newrout);                    /*   pointer to new routine             */

void
patchnew(                          /* install patch to new routine         */
patchinfo *pinf);                  /*   patch info structure               */

void
patchold(                          /* restore old routine (make callable)  */
patchinfo *pinf);                  /*   patch info structure               */

void
patchfin(                          /* relinquish ability to patch new/old  */
patchinfo *pinf);                  /*   patch info structure               */

