unit Verobj;

interface

{Copyright Argon Helm: argonh@k2nesoft.com
 Used in PlugDLLVerify for an excalibur plugin.
 You may use this information as you wish so long as
 you hold me harmless for anything you do with it.}

uses WinTypes,
     WinProcs,
     Ver,
     SysUtils,
     Alchemw;


type PFileVersionInfor = ^TFileVersionInfo;
     TFileVersionInfo = record
      Version: Array[0..250] of Char;
      Description: Array[0..250] of Char;
      Company: Array[0..250] of Char;
      InternalName: Array[0..250] of Char;
      Size: LongInt;
      dwFileVersionMS: LongInt;
      dwFileVersionLS: LongInt;
end;

type
  PLongInt = ^Longint;

type TVersions = class
     private
      VSize, VHandle: Longint;
      Buffer: PChar;
      Length, LangID, CharSetID: Word;
      TranslationInfo, Result: Pointer;
      StringFileInfo: Array[0..49] of Char;
      LangCharSetIDArray: Array[1..2] of Word;
      FVerInfo: TFileVersionInfo;
      FileName: Array[0..79] of Char;
      procedure GetInfo;
     public
      constructor Create( AFileName: TFileName );
      function GetVerInfo: TFileVersionInfo;
      function  DLLVerify(curOS: LongInt; var info: Pointer;
          var company: PChar; var intern: PChar; var ver: PChar;
          var descript: PChar ): Word;
end;

implementation


constructor TVersions.Create( AFileName: TFileName );
 begin
  inherited Create;
  if not FileExists( AFileName ) then
   begin
    MessageBox(0, 'The Dll refered to dosn''t exist!', 'Problem', mb_ok);
   end
  else
   begin
    StrPCopy(FileName, AFileName);
    GetInfo;
   end;
 end;



procedure TVersions.GetInfo;
 var VersionInts: Pointer;
     Len: Word;
 begin
  { Get size of version info }
  VSize := GetFileVersionInfoSize(FileName, VHandle);

  { Allocate version info buffer }
  GetMem(Buffer, VSize + 1);

  { START GET VERSION INFO... }
 try
  if GetFileVersionInfo(FileName, VHandle, VSize, Buffer) then
    { Get translation info for Language / CharSet IDs }


    if VerQueryValue(Buffer, '\VarFileInfo\Translation',
                                       TranslationInfo, Length) then
     begin
      LangCharSetIDArray[1] := LoWord(PLongint(TranslationInfo)^);
      LangCharSetIDArray[2] := HiWord(PLongint(TranslationInfo)^);

      { Get company name }
      wvsPrintf(StringFileInfo,
                           '\StringFileInfo\%04x%04x\CompanyName',
                          LangCharSetIDArray);
      VerQueryValue(Buffer, StringFileInfo, Result, Length);
       StrCopy(FVerInfo.Company, PChar(Result) ) ;

      { Get file description }
      wvsPrintf(StringFileInfo,
                          '\StringFileInfo\%04x%04x\FileDescription',
                          LangCharSetIDArray);
      VerQueryValue(Buffer, StringFileInfo, Result, Length);
       StrCopy(FVerInfo.Description , PChar(Result)) ;

      { Get file version }
      wvsPrintf(StringFileInfo,
                          '\StringFileInfo\%04x%04x\FileVersion',
                          LangCharSetIDArray);
      VerQueryValue(Buffer, StringFileInfo, Result, Length);
       StrCopy(FVerInfo.Version, PChar(Result));

      { Get internal name}
      wvsPrintf(StringFileInfo,
                          '\StringFileInfo\%04x%04x\InternalName',
                          LangCharSetIDArray);
      VerQueryValue(Buffer, StringFileInfo, Result, Length);
       StrCopy(FVerInfo.InternalName, PChar(Result));

     GetMem( VersionInts, SizeOf( Tvs_FixedFileInfo ) + 100);
      try
       VerQueryValue(Buffer,'\', VersionInts,Len);
        FVerInfo.dwFileVersionMS := Pvs_FixedFileInfo(VersionInts)^.dwFileVersionMS;
        FVerInfo.dwFileVersionLS := Pvs_FixedFileInfo(VersionInts)^.dwFileVersionLS;
      finally
       FreeMem( VersionInts, SizeOf( Tvs_FixedFileInfo ) + 100 );
      end;

   end;
 finally
  FreeMem(Buffer, VSize + 1);
 end;
end;


function TVersions.GetVerInfo: TFileVersionInfo;
 begin
   Result := FVerInfo;
 end;


function  TVersions.DLLVerify(curOS: LongInt; var info: Pointer;
          var company: PChar; var intern: PChar; var ver: PChar;
          var descript: PChar ): Word;
const IsEmpty: PChar = '';
var VerInfo: TFileVersionInfo;
    AVerInfo: TFileVersionInfo;
    UserMS: LongInt;
    SysMS: LongInt;
    UserLS: LongInt;
    SysLS: LongInt;
    pchTrans: PChar;
begin
 {Zero out locals...}
 with VerInfo do
  begin
   FillChar(Version, 250, #0);
   FillChar(Description, 250, #0);
   FillChar(Company, 250, #0);
   FillChar(InternalName, 250, #0);
   Size := 0;
   dwFileVersionMS := 0;
   dwFileVersionLS := 0;
 end;

 VerInfo := GetVerInfo;

 Result := NODLL_OK;

 if (curOS <> VOS__WINDOWS16) then
    Result := NODLL_OVERWRITE
 else if ( lstrcmpi( VerInfo.Company, company ) <> 0 ) then
    Result := NODLL_OVERWRITE
 else if ( (Pvs_FixedFileInfo(info)^.dwFileVersionMS) < VerInfo.dwFileVersionMS ) then
    Result := NODLL_MAJOR
 else if ( (Pvs_FixedFileInfo(info)^.dwFileVersionMS shr 16) >
           (Pvs_FixedFileInfo(info)^.dwFileVersionMS shr 16) ) then
       begin
        UserMS := (Pvs_FixedFileInfo(info)^.dwFileVersionMS shr 16);
	SysMS :=  (VerInfo.dwFileVersionMS shr 16 );
	if ( UserMS > SysMS ) then
	 Result := NODLL_NEWER;
       end
 else if ( Pvs_FixedFileInfo(info)^.dwFileVersionLS < VerInfo.dwFileVersionLS ) then
          Result := NODLL_MINOR;

 if (StrComp( IsEmpty, Company ) = 0 ) or
    (StrComp( IsEmpty, Intern ) = 0 ) or
    (StrComp( IsEmpty, Ver ) = 0 ) or
    (StrComp( IsEmpty, Descript ) = 0 ) then
  Result := NODLL_NONE;

  StrCopy( Company, VerInfo.Company );
  StrCopy( Intern, VerInfo.InternalName );
  StrCopy( Descript, VerInfo.Description );
  StrCopy( Ver, VerInfo.Version );
end;

end.



