unit Verobj;

interface

{Modified from a Borland TI
 by Argon Helm: argonh@ix.netcom.com
 Used in PlugVerify for an excalibur plugin}

uses WinTypes,
     WinProcs,
     Ver,
     SysUtils;

type PFileVersionInfor = ^TFileVersionInfo;
     TFileVersionInfo = record
      Version: string;
      Description: string;
      Company: string;
      InternalName: string;
      Size: LongInt;
end;

type
  PLongInt = ^Longint;

type TVersions = class
     private
      VSize, VHandle: Longint;
      Buffer: PChar;
      Length, LangID, CharSetID: Word;
      TranslationInfo, Result: Pointer;
      StringFileInfo: Array[0..49] of Char;
      LangCharSetIDArray: Array[1..2] of Word;
      FVerInfo: TFileVersionInfo;
      FileName: Array[0..79] of Char;
      procedure GetInfo;
     public
      constructor Create( AFileName: TFileName );
      function GetVerInfo: TFileVersionInfo;
end;

implementation

{-------------------------------------------------------------------}
constructor TVersions.Create( AFileName: TFileName );
 begin
  inherited Create;
  if not FileExists( AFileName ) then
   begin
    MessageBox(0, 'The Dll refered to dosn''t exist!', 'Problem', mb_ok);
   end
  else
   begin
    StrPCopy(FileName, AFileName);
    GetInfo;
   end;
 end;


{-------------------------------------------------------------------}
procedure TVersions.GetInfo;
 begin
  { Get size of version info }
  VSize := GetFileVersionInfoSize(FileName, VHandle);

  { Allocate version info buffer }
  GetMem(Buffer, VSize + 1);

  { START GET VERSION INFO... }
 try
  if GetFileVersionInfo(FileName, VHandle, VSize, Buffer) then
    { Get translation info for Language / CharSet IDs }
    if VerQueryValue(Buffer, '\VarFileInfo\Translation',
                                       TranslationInfo, Length) then
     begin
      LangCharSetIDArray[1] := LoWord(PLongint(TranslationInfo)^);
      LangCharSetIDArray[2] := HiWord(PLongint(TranslationInfo)^);

      { Get company name }
      wvsPrintf(StringFileInfo,
                           '\StringFileInfo\%04x%04x\CompanyName',
                          LangCharSetIDArray);
      VerQueryValue(Buffer, StringFileInfo, Result, Length);
      FVerInfo.Company := StrPas( PChar(Result)) ;

      { Get file description }
      wvsPrintf(StringFileInfo,
                          '\StringFileInfo\%04x%04x\FileDescription',
                          LangCharSetIDArray);
      VerQueryValue(Buffer, StringFileInfo, Result, Length);
      FVerInfo.Description := StrPas( PChar(Result)) ;

      { Get file version }
      wvsPrintf(StringFileInfo,
                          '\StringFileInfo\%04x%04x\FileVersion',
                          LangCharSetIDArray);
      VerQueryValue(Buffer, StringFileInfo, Result, Length);
      FVerInfo.Version := StrPas( PChar(Result)) ;

      { Get internal name}
      wvsPrintf(StringFileInfo,
                          '\StringFileInfo\%04x%04x\InternalName',
                          LangCharSetIDArray);
      VerQueryValue(Buffer, StringFileInfo, Result, Length);
      FVerInfo.InternalName := StrPas( PChar(Result)) ;
   end;
 finally
  FreeMem(Buffer, VSize + 1);
 end;
end;

{-------------------------------------------------------------------}
function TVersions.GetVerInfo: TFileVersionInfo;
 begin
   Result := FVerInfo;
 end;

end.


{DISCLAIMER: You have the right to use this technical information
subject to the terms of the No-Nonsense License Statement that
you received with the Borland product to which this information
pertains.}

