unit Hostobj;
{This project is distributed as FreeWare.
 That means I retain full Copyright and
 can do with it as I please in the future.
 I you use this please drop me a line so
 I'll know how much it is used.

 Copyright 1995 Argon D. Helm

 argonh@ix.netcom.com
 HomeQuest BBS: 609-893-4031
 Argon Helm on the Excalibur HQ Board
 Handle: Watcher}
interface

uses WinTypes,
     WinProcs,
     SysUtils,
     Alchemw,
     Common,
     Conf,
     VerObj;


type THost = class(TObject)
     private
      FSlot: LPVOID;
      FDllName: string;
      FDllSize: LongInt;
      FPCommandData: PCommandRec;
      FTCommandData: TCommandRec;
      FConfItems: TGrailConfrence;
     protected
      procedure DoDone; virtual;
      procedure DoIdle; virtual;
      procedure SendConf( ToSend: TConferenceRec ); virtual;
     public
      FileSent: Bool;
      {Temporary until FixedFileVersion info is implemented}
      constructor Create( DllName: string; Slot: Lpvoid );

      destructor Destroy;

      {Equates to PlugDllVerify}
      function  Verify(var curOS: LongInt; var info: Pointer;
                              var company: PChar; var intern: PChar;
                              var ver: PChar; var descript: PChar): Word;

       {Equates to PlugDllSize}
      function  Size: LongInt;

      {Equates to PlugNextDll}
      function  NextFile(var name: PChar; var limit: WORD;
                                var dest: PChar; var dlim: WORD): Bool;

      {Equates to PlugCommmand}
      function  Command(SlotH: LPSLOT; cCMD: Pointer; cLen: WORD): Word;

      {Equates to PlugProcess}
      function  Process(SlotH: LPSLOT):Word;

      {PlugRecieve}
      function  Receive( SlotH: LPSLOT; data: Pointer; len: Word; sender: LongInt ): Word;

      {PlugBroadcast}
      function  Broadcast( SlotH: LPSLOT; data: Pointer; len: Word ): Word;

      {PlugData}
      function  Data(SlotH: LPSLOT; more: BOOL; data: LPVOID):BOOL;


end;

implementation

uses Geservr;


{---------------------------------------------------------------------}
{THost}
{---------------------------------------------------------------------}
constructor THost.Create( DllName: string; Slot: Lpvoid );
begin
  inherited Create;
  FDllName := DllName;
  FileSent := False;
  FSlot := Slot;
  FConfItems := TGrailConfrence.Create;
end;

{---------------------------------------------------------------------}
destructor THost.Destroy;
begin
 if assigned( FConfItems ) then FConfItems.Free;
 inherited Destroy;
end;

{---------------------------------------------------------------------}
function    THost.Verify(var curOS: LongInt; var info: Pointer;
                              var company: PChar; var intern: PChar;
                              var ver: PChar; var descript: PChar): Word;
const IsEmpty = '';
var FSend: Bool;
    Vers: TVersions;
    FileInfo: TFileVersionInfo;
begin

     FSend := False;

     if (StrComp(company, IsEmpty) = 0)  or
        (StrComp(intern, IsEmpty) = 0)   or
        (StrComp(ver, IsEmpty) = 0)      or
        (StrComp(descript, IsEmpty) = 0) then FSend := True;

     if FSend = True then
        begin
         Vers := TVersions.Create( FDllName );
          try
           FileInfo := Vers.GetVerInfo;
           StrPCopy( company, FileInfo.Company );
           StrPCopy( intern, FileInfo.InternalName );
           StrPCopy( ver, FileInfo.Version );
           StrPCopy( descript, FileInfo.Description );
          finally
           Vers.Free;
          end;
         Result := NODLL_NONE;
        end
     else
        begin
         Result := NODLL_OK;
        end;
end;


{---------------------------------------------------------------------}
function    THost.Size: LongInt;
var f: file of Byte;
begin
  if FileExists(FDllName) then
   begin
    {$I-}
     System.Assign(f, FDllName);
     Reset(f);
    {$I+}
      if IOResult <> 0 then
       begin
        Result := 0;
        Exit;
       end
      else
       begin
        FDllSize := FileSize(f);
        Result := FDllSize;
        System.Close(f);
       end;
  end;
end;


{---------------------------------------------------------------------}
function    THost.NextFile(var name: PChar; var limit: WORD;
                                var dest: PChar; var dlim: WORD): Bool;
begin
   if FileSent = False then
        begin
          StrPCopy( name, FDllName );
          StrPCopy( dest, FDllName );
          FileSent := True;
          Result   := True;
        end
        else
            begin
              StrPCopy( name, '' );
              StrPCopy( dest, '' );
              Result := FALSE;
            end;
end;

{---------------------------------------------------------------------}
function  THost.Command(SlotH: LPSLOT; cCMD: Pointer; cLen: WORD): Word;
const AllRecs = 'id==' + #0;
var i: Integer;
    GetPtr: Pointer;
    ChatAnchor: PChatCommandRec;
    UserHand: array[0..MaxHandleLen] of Char;
begin
    FPCommandData := nil;
    FSlot := SlotH;
    Result := AL_OK;
    FPCommandData := cCMD;

     case FPCommandData^.State of
          CA_IDLE:   begin
                      DoIdle;
                     end;

          CA_DONE:   begin
                      DoDone;
                     end;

          CA_CONF:   begin
                      AlGrailRequest( SlotH, 'conference','id,description',nil);
                      AlSetState( SlotH, DO_PROCESS );
                     end;

      CA_SENDCONF:   begin
                      with FConfItems do
                       begin
                        for i := 0 to Count - 1 do
                            SendConf( PConferenceRec( Items[i] )^ );
                       end;
                       AlSetState( SlotH, CA_IDLE );
                     end;

     CA_CHAT:        begin
                      {It's their conversation just pass it thru}
                      AlCreateMultiAll( SlotH, SizeOf( TChatCommandRec ) );
                      AlGetUserHandle( SlotH, UserHand, MaxHandleLen - 1);
                      Move(UserHand, PChatCommandRec( cCmd )^.Chat.From, MaxHandleLen - 1);
                      Move( cCmd^, AlMultiLock( SlotH )^, SizeOf( TChatCommandRec ));
                      AlMultiUnlock( SlotH );
                     end;
    end;
end;


{----------------------------------------------------------------}
function  THost.Process(SlotH: LPSLOT):Word;
var pState: Word;
begin

    FSlot := SlotH;
    pState := AlGetState(SlotH);
    Result := AL_OK;

     case pState of
       CA_IDLE: begin
                 Result := AL_IDLE;
                 Exit;
                end;
       CA_DONE: begin
                 Result := AL_DIE;
                 Exit;
                end;

       DO_PROCESS: begin
                     if FConfItems.IsReady then
                      begin
                       FTCommandData.ControlByte := 1;
                       FTCommandData.State := EX_CONFREADY;
                       AlAddBlock( SlotH, @FTCommandData, 3);
                       AlSetState( SlotH, CA_IDLE );
                     end;
                   end;
   end;


end;

{----------------------------------------------------------------}
function  THost.Receive( SlotH: LPSLOT; data: Pointer; len: Word; sender: LongInt ): Word;
var ChatRec: TChatCommandRec;
begin
 Move( data^, ChatRec, SizeOf( TChatCommandRec ));
 ChatRec.ControlByte := 1;
 ChatRec.State := EX_CHAT;
 AlAddBlock( SlotH, @ChatRec, SizeOf( TChatCommandRec ));
 AlSetState( SlotH, CA_IDLE );
end;

{----------------------------------------------------------------}
{This is all just a Quick Hack to show how to pick up info from
 PlugBroadcast. AL_BROAD_LEAVE  not included. And you should
 probably make a list object to contain these in case of
 transmisson problems.}
function  THost.Broadcast( SlotH: LPSLOT; data: Pointer; len: Word ): Word;
var DummyPtr: PByte;
    Ident: PByte;
    Counter: PInteger;
    i: Integer;
    tagUser: PtagAlBroadEnter;
    Users: TUserCommandRec;
begin
  DummyPtr := PByte( data );
  Ident := PByte( DummyPtr );
   case Ident^ of
    AL_BROAD_ALLHERE: begin
                       {Get Count of users here}
                       Inc(DummyPtr, SizeOf( Byte ));
                       Counter := PInteger( DummyPtr );
                       Inc( DummyPtr, SizeOf( Integer ));

                       {Loop through them and send to client}
                        for i := 0 to Counter^ - 1 do
                         begin
                          {Setup transmittal record}
                          Users.ControlByte := 1;
                          Users.State := EX_USER;

                          {Aquire users id,handle and put in tx rec}
                          tagUser := PtagAlBroadEnter( DummyPtr );
                            Users.User.Id := tagUser^.UserId;
                            StrPCopy(Users.User.Handle, tagUser^.Handle);

                           {Send to client}
                           AlAddBlock( SlotH, @Users, SizeOf( TUserCommandRec ) );

                          {Increment to next user here}
                          Inc (DummyPtr, SizeOf( tagAlBroadEnter ));
                         end;
                       end;

    AL_BROAD_ENTER:   begin
                       {Setup Transmittal record}
                       Users.ControlByte := 1;
                       Users.State := EX_USER;
                       {Get rid of the state variable}
                       Inc(DummyPtr, SizeOf( Byte ));
                       {If it isn't this slots user}
                       if PtagAlBroadEnter( DummyPtr )^.UserId <>
                          AlGetUserId( SlotH ) then
                         begin
                          Users.User.Id := PtagAlBroadEnter( DummyPtr )^.UserId;
                          StrPCopy(Users.User.Handle , PtagAlBroadEnter( DummyPtr )^.Handle);
                          AlAddBlock( SlotH, @Users, SizeOf( TUserCommandRec ));
                         end;
                      end;
   end;
   Result := AL_IDLE;

end;

{----------------------------------------------------------------}
{Incorporates a TList desendant to store the data.
 ..... another quick hack but should get the point across.}
function  THost.Data(SlotH: LPSLOT; more: BOOL; data: LPVOID):BOOL;
begin
 with FConfItems do
  begin
   Clear;
   Pack;
   DumpAllConfrencesToList( data );
   Result := False;
  end;
end;

{Plug Command Creators}
{These make the code in Command & Process more readable for me.
 That's important to me because I spend a lot of my time tweaking
 those functions.}
{---------------------------------------------------------------------}
procedure THost.DoDone;
begin
 FTCommandData.ControlByte := 1;
 FTCommandData.State := EX_DONE;
 AlAddBlock(FSlot,@FTCommandData,3);
 AlSetState(FSlot,CA_DONE);
end;

{---------------------------------------------------------------------}
procedure THost.DoIdle;
begin
  FTCommandData.ControlByte := 1;
  FTCommandData.State := EX_START;
  AlAddBlock(FSlot, @FTCommandData,3);
  AlSetState(FSlot,CA_IDLE);
end;

{---------------------------------------------------------------------}
procedure THost.SendConf( ToSend: TConferenceRec );
var ConfSend: TConferenceCommandRec;
begin
 ConfSend.Conference := ToSend;
 ConfSend.ControlByte := 1;
 ConfSend.State := EX_CONF;
 AlAddBlock(FSlot, @ConfSend, SizeOf( TConferenceCommandRec ));
end;


end.
