unit Geservr;

Interface

uses
  WinTypes,
  SysUtils,
  Alchemw,
  common,
  HostObj;

function  PlugDialog(SlotH: LPSLOT; uResult: WORD):WORD; export;
function  PlugUnique(SlotH: LPSLOT; args, cMessage: PChar):BOOL; export;
procedure PlugDestroy(SlotH: LPSLOT); export;
function  PlugType(SlotH: LPSLOT; title: PChar):WORD; export;
function  PlugProcess(SlotH: LPSLOT):WORD; export;
function  PlugDLLSize(SlotH: LPSLOT):LongInt; export;
function  PlugNextDLL(SlotH: LPSLOT; name: PChar; limit: WORD; dest: PChar;
          dlim: WORD):BOOL; export;
function  PlugDLLVerify(SlotH: LPSLOT; curOS: LongInt; info: Pointer;
          company, intern, ver, descript: PChar ):WORD; export;
function  PlugCommand(SlotH: LPSLOT; cCMD: Pointer; cLen: WORD):WORD; export;
function  PlugReceive( SlotH: LPSLOT; data: Pointer; len: Word; sender: LongInt ): Word; export;
function  PlugBroadcast( SlotH: LPSLOT; data: Pointer; len: Word ): Word; export;
function  PlugData(SlotH: LPSLOT; more: BOOL; data: LPVOID):BOOL; export;

implementation

{-----------------------------------------------------------------------}
function  PlugDialog(SlotH: LPSLOT; uResult: WORD):WORD;
begin
 Result := AL_OK;
end;

{-----------------------------------------------------------------------}
function  PlugUnique(SlotH: LPSLOT; args, cMessage: PChar):BOOL;
var HostObj: THost;
begin
 Result := False;
end;

{-----------------------------------------------------------------------}
procedure PlugDestroy(SlotH: LPSLOT);
var HostObj: THost;
begin
 HostObj := AlGetPointer(SlotH);
 HostObj.Free;
end;

{-----------------------------------------------------------------------}
function  PlugType(SlotH: LPSLOT; title: PChar):WORD;
var HostObj: THost;
begin
 HostObj := THost.Create( 'EX_EX.DLL', SlotH );
 AlSetPointer(SlotH, HostObj);
 strpcopy( title, 'EX_EX.DLL' );
 Result := AL_WIN_PLUGIN or AL_WIN_MULTI;
end;

{-----------------------------------------------------------------------}
function  PlugDLLSize(SlotH: LPSLOT):LongInt;
var HostObj: THost;
begin
 HostObj := AlGetPointer(SlotH);
 Result := HostObj.Size;
end;

{-----------------------------------------------------------------------}
function  PlugNextDLL(SlotH: LPSLOT; name: PChar; limit: WORD; dest: PChar;
          dlim: WORD):BOOL;
var HostObj: THost;
begin
 HostObj := AlGetPointer(SlotH);
 Result := HostObj.NextFile(name, limit, dest, dlim);
end;

{-----------------------------------------------------------------------}
function  PlugDLLVerify(SlotH: LPSLOT; curOS: LongInt; info: Pointer;
          company, intern, ver, descript: PChar ):WORD;
var HostObj: THost;
begin
 HostObj := AlGetPointer(SlotH);
 Result := HostObj.Verify(CurOS, info, company, intern, ver, descript);
end;

{-----------------------------------------------------------------------}
function  PlugCommand(SlotH: LPSLOT; cCMD: Pointer; cLen: WORD):WORD;
var HostObj: THost;
begin
 HostObj := AlGetPointer(SlotH);
 Result := HostObj.Command(SlotH, cCMD, cLen);
end;


{-----------------------------------------------------------------------}
function  PlugProcess(SlotH: LPSLOT):WORD;
var HostObj: THost;
begin
 HostObj := AlGetPointer(SlotH);
 Result := HostObj.Process(SlotH);
end;

{-----------------------------------------------------------------------}
function  PlugReceive( SlotH: LPSLOT; data: Pointer; len: Word; sender: LongInt ): Word;
var HostObj: THost;
begin
 HostObj := AlGetPointer(SlotH);
 Result := HostObj.Receive( SlotH, data, len, sender );
end;

{-----------------------------------------------------------------------}
function  PlugBroadcast( SlotH: LPSLOT; data: Pointer; len: Word ): Word;
var HostObj: THost;
begin
 HostObj := AlGetPointer(SlotH);
 Result := HostObj.Broadcast( SlotH, data, len );
end;

{-----------------------------------------------------------------------}
function  PlugData(SlotH: LPSLOT; more: BOOL; data: LPVOID):BOOL;
var HostObj: THost;
begin
 HostObj := AlGetPointer(SlotH);
 Result := HostObj.Data( SlotH, more, data );
end;

end.
