library Ex_ex;

{FreeWare. Copyright Argon D. Helm
 See cam_db.dpr for conditions of use.}

uses
  Forms,
  WinTypes,
  WinProcs,
  Exmain in 'EXMAIN.PAS' {frmExample},
  Common in 'COMMON.PAS',
  Exlib in 'EXLIB.PAS';

{$R *.RES}


{Plug Entry Points, Required by Excalibur for the Plug to work.
 I create the form in PlugInit then pass the rest of the plug entry
 points to the corresponding Methods in the form object. However,
 you do not have to do this.}

{-----------}
function  PlugInit(LibH: Lpvoid; Args: PChar): Word; export;
var frmExample: TfrmExample;
begin
   try
    Application.Handle := ExMdiClient( LibH );
    Application.CreateForm(TfrmExample, frmExample);
  frmExample.Show;
    frmExample.FPlugLibH := LibH;
    frmExample.FPlugIsDownloaded := True;
    frmExample.FPlugState := EX_INIT;
    ExSetPtr( LibH, frmExample );
    Result := AL_OK;
   except
    {In case of trouble.}
    MessageBox(0, 'Couldn''t start plug...sorry.', 'PlugInit', mb_ok);
    Result := AL_DIE;
    Exit;
   end;
  Result := AL_OK;
end;

{-----------}
procedure PlugDestroy( LibH: Lpvoid ); export;
begin
 {I use this to clean up if I use non-excalibur memory
  allocations (eg. a custom call to GlobalAlloc)
   ..otherwize I put items to be cleaned
  in the TForm and clean'em up in the forms destructor.
  Is this the best way? Beats the hell out of me...but it
  seems right since  ExSetPtr is just keeping track of
  my object pointer for me as opposed to doing the actual
  heap allocations.}
end;

{-----------}
function  PlugCommand( LibH: Lpvoid; CommandPtr: Pointer; PtrLen: Word): Word; export;
var frmExample: TfrmExample;
begin
 frmExample := ExGetPtr( LibH );
 Result := frmExample.Command( LibH, CommandPtr, PtrLen );
end;

{-----------}
function  PlugProcess( LibH: Lpvoid ): Word; export;
var frmExample: TfrmExample;
begin
 frmExample := ExGetPtr( LibH );
 Result := frmExample.Process( LibH );
end;

exports
  PlugInit Index 3,
  PlugDestroy Index 4,
  PlugCommand Index 5,
  PlugProcess Index 6;

begin
end.
