unit Exmain;
{This project is distributed as FreeWare.
 That means I retain full Copyright and
 can do with it as I please in the future.
 I you use this please drop me a line so
 I'll know how much it is used.

 Copyright 1995 Argon D. Helm

 argonh@ix.netcom.com
 HomeQuest BBS: 609-893-4031
 Argon Helm on the Excalibur HQ Board
 Handle: Watcher}

 {Just a quick note:
   If your plug has to do internal processing always return AL_OK;
   If your plug is to wait for user input before doing anything
      useful return AL_IDLE.
   When you put your plug in AL_IDLE it will do nothing until
   a new command is recieved Via PlugCommand or other applicable
   entry points. It will not even think about looking in PlugProcess
   until it has a state of AL_OK. ( Or it seems that way to me..)}

interface

uses
  SysUtils,
  WinTypes,
  WinProcs,
  Messages,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  Buttons,
  ExtCtrls,
  Common,
  ExLib;

type
  TfrmExample = class(TForm)
    lblCapChatResults: TLabel;
    bevDetailBox: TBevel;
    bevBasicBox: TBevel;
    bevButtonBox: TBevel;
    spdExit: TSpeedButton;
    lblConnect: TLabel;
    mmoChatResults: TMemo;
    spdConferences: TSpeedButton;
    edtChat: TEdit;
    lblCapChatTo: TLabel;
    lstConference: TListBox;
    lstUser: TListBox;
    lblCaplstConference: TLabel;
    lblCaplstUser: TLabel;
    Bevel1: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure spdExitClick(Sender: TObject);
    procedure spdConferencesClick(Sender: TObject);
    procedure edtChatKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    procedure Request( What: Word );
    procedure LoadConference( var ConferenceCommand: Pointer );
    procedure LoadUser( var UserCommand: Pointer );
    procedure PostChat( var ChatCommand: Pointer );
  public
    {Plug Control and Data Variables}
    FPlugState: Word;
    FCommandData: TCommandRec;
    FPlugLibH: Lpvoid;
    FPlugIsDownloaded: Bool;
    {Methods Corresponding to PlugCommand and PlugProcess resp.}
    function  Command( LibH: Lpvoid; CommandPtr: Pointer; PtrLen: Word): Word;
    function  Process( LibH: Lpvoid ): Word;
  end;

implementation
const
  ScreenWidth: LongInt = 640; {I designed my form in 640 X 480 mode.}
  ScreenHeight: LongInt = 480;

   {$R *.DFM}

{Begin Generic Form Routines}

{------------}
{Extracts conference info and puts it in a list box}
procedure TfrmExample.LoadConference( var ConferenceCommand: Pointer );
var ConfStr: string;
    Conference: TConferenceRec;
begin
 Conference := PConferenceCommandRec( ConferenceCommand )^.Conference;
 with Conference do
  begin
   ConfStr := IntToStr( ConfId ) + ': ';
   ConfStr := ConfStr + StrPas( Description );
  end;
 lstConference.Items.Add( ConfStr );
end;

{------------}
{Extracts user info and puts it in a list box}
procedure TfrmExample.LoadUser( var UserCommand: Pointer );
var UserStr: string;
    User: TUserRec;
begin
 User := PUserCommandRec( UserCommand )^.User;
 with User do
  begin
   UserStr := IntToStr( Id ) + ': ';
   UserStr := UserStr + StrPas( Handle );
  end;
 lstUser.Items.Add( UserStr );
end;

{------------}
{Extracts chat info and puts it in a memo box}
procedure TfrmExample.PostChat( var ChatCommand: Pointer );
var ChatStr: string;
    Chat: TChatRec;
begin
 Chat := PChatCommandRec( ChatCommand )^.Chat;
 with Chat do
  begin
   ChatStr := StrPas( From ) + ': ';
   ChatStr := ChatStr + Chatter;
  end;
 mmoChatResults.Lines.Add( ChatStr );
end;

{--------}
(* Try to do a little something about different screen resoulutions
   adapted from a Borland TI*)
procedure TfrmExample.FormCreate(Sender: TObject);
begin
   scaled := true;
  if (screen.width <> ScreenWidth) then
  begin
    height := longint(height) * longint(screen.height) div ScreenHeight;
    width := longint(width) * longint(screen.width) div ScreenWidth;
    scaleBy(screen.width, ScreenWidth);
  end;
end;

{-------}
{For non information bearing requests}
procedure TfrmExample.Request ( What: Word );
begin
 FCommandData.ControlByte := 1;
 FCommandData.State := What;
 ExAddBlock( FPlugLibH, @FCommandData, SizeOf( TCommandRec ) );
 lblConnect.Caption := 'Requesting...';
end;

{-----------}
procedure TfrmExample.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 {Let the plug be closed via process ... not here
  cleanup will occur when excalibur sends a window kill}
 FPlugState := EX_CLOSE;
 Action := caNone;
end;


{------------}
procedure TfrmExample.spdExitClick(Sender: TObject);
begin
 FPlugState := EX_CLOSE;
end;

{------------}
procedure TfrmExample.spdConferencesClick(Sender: TObject);
begin
 Request( CA_CONF );
end;

{------------}
procedure TfrmExample.edtChatKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var ChatRec: TChatCommandRec;
begin
 if Key = vk_return then
  begin
   ChatRec.Chat.Chatter := edtChat.Text;
   ChatRec.ControlByte := 1;
   ChatRec.State := CA_CHAT;
   ExAddBlock( FPlugLibH, @ChatRec, SizeOf( TChatCommandRec ));
   FPlugState := EX_IDLE;
  end;
end;

{Begin Form to Plug Methods}

{--------}
function  TfrmExample.Command( LibH: Lpvoid; CommandPtr: Pointer; PtrLen: Word): Word;
var frmDataView: TfrmExample;
    CData: PCommandRec;
begin
  frmDataView := ExGetPtr( LibH );
  frmDataView.FCommandData.ControlByte := 1;
  CData := CommandPtr;

  with frmDataView do
   begin
    case CData^.State of
     {See Common.pas for explantions of these constants}
     EX_START:  begin
                 lblConnect.Caption := 'Connected...';
                 FPlugState := EX_START;
                 Result := AL_OK;
                end;

     EX_DONE:   begin
                 lblConnect.Caption := 'Closing...';
                 Result := AL_DIE;
                end;

     EX_CONF:   begin
                 lblConnect.Caption := 'Conferences...';
                 LoadConference( CommandPtr );
                 FPlugState := EX_IDLE;
                 Result := AL_IDLE;
                end;

    EX_USER:    begin
                 lblConnect.Caption := 'Users...';
                 LoadUser( CommandPtr );
                 FPlugState := EX_IDLE;
                 Result := AL_IDLE;
                end;

    EX_CHAT:    begin
                 lblConnect.Caption := 'Chats...';
                 PostChat( CommandPtr );
                 FPlugState := EX_IDLE;
                 Result := AL_IDLE;
                end;

   EX_CONFREADY: begin
                  Request( CA_SENDCONF );
                  lblConnect.Caption := 'Conferences Ready...';
                  FPlugState := EX_IDLE;
                  Result := AL_IDLE;
                 end;

     else
      Result := AL_OK;
    end;
   end;

end;


{--------}
function  TfrmExample.Process( LibH: Lpvoid ): Word;
var frmDataView: TfrmExample;
begin
 frmDataView := ExGetPtr( LibH );
 frmDataView.FCommandData.ControlByte := 1;
 Result := AL_OK;

 with frmDataView do
  begin
   case FPlugState of
     {When the FPlugState variable is set it is captured here ....
      Use Process for internal processing and command to
      interface with the host.}
     EX_INIT:   begin
                 FCommandData.State := CA_IDLE;
                 ExAddBlock(LibH, @FCommandData, 3);
                 FPlugState := EX_IDLE;
                 Result := AL_IDLE;
                end;

      EX_START: begin
                 lblConnect.Caption  := 'Awaiting Requests...';
                 FPlugState := EX_IDLE;
                 Result := AL_OK;
                end;

      EX_IDLE:  begin
                 Result := AL_IDLE;
                end;

      EX_CLOSE: begin
                 lblConnect.Caption := 'Leaving, Please Wait...';
                 FCommandData.State := CA_DONE;
                 ExAddBlock(LibH, @FCommandData, 3);
                 FPlugState := EX_IDLE;
                 Result := AL_IDLE;
                end;
   end;
 end;

end;

end.
