unit Common;

{ Contants and Types Usefull in both the
  Camelot and Excalibur Ends of the plug-in. }


interface

{ A Reflection of array Lengths - 1 for the
  Zero based array max index values. }
const
  MaxDescriptionLen =  60; {Max len of a description field in conf.gdb}
  MaxHandleLen      =  40;

const
  MaxDataBlockSize = 248;  {This could be longer but I wan't
                            to reserve some space in case I wish to
                            add another state variable or two to the end
                            of my Command Records.}

{Camelot Commands}
const
  CA_IDLE            = 5000;  {Tells host to enter idle state}
  CA_DONE            = 5001;  {Tells host to kill the plug}
  CA_CONF            = 5002;  {Tells host to AQUIRE conferences}
  CA_SENDCONF        = 5003;  {Client tells host to SEND conferences}
  CA_CHAT            = 5004;  {Tell host to post the chat to all users}
  DO_PROCESS         = 5005;  {General state constant for processing internal data}

{Excalibur Commands... to a large degree correspond to the camalot cmds..}
const
  EX_START           = 6000; {Everythings Ok client goes to idle}
  EX_DONE            = 6001; {Tells client to die}
  EX_INIT            = 6002; {Effectively put's both plug ends in Idle mode}
  EX_IDLE            = 6003; {Tells client to go to idle}
  EX_CLOSE           = 6004; {Tells client plug to send close command to host}
  EX_CONF            = 6005; {Tells plug that a conference item is HERE}
  EX_CONFREADY       = 6006; {Host sends to notify conferences are READY}
  EX_USER            = 6007; {Incoming user rec}
  EX_CHAT            = 6009; {Incoming chat rec}

 {Holds conference info}
type PConferenceRec = ^TConferenceRec;
     TConferenceRec = record
      ConfId: LongInt;                                   {4 Bytes}
      Description: array[0..MaxDescriptionLen] of Char;  {61 Bytes}
end;                                                     {65 Bytes total}

 {Holds some user info. For total user info available
  see tagAlBroadEnter in alchemw.pas/h. Procs for this
  implement the AL_BROAD_ALLHERE flag only!}
type PUserRec = ^TUserRec;
     TUserRec = record
       Id: LongInt;                                   {4 Bytes}
       Handle: array[0..MaxHandleLen] of Char;        {41 Bytes}
end;                                                   {45 Bytes total}

 {For Chat Messages}
type PChatRec = ^TChatRec;
     TChatRec = record
       From: array[0..MaxHandleLen] of Char;              {41 Bytes}
       Chatter: string[203];                              {204 Bytes}
end;                                                      {245 Bytes total}

{I split up the format data is sent depending on what I wan't
 to do. I do this, not because I have to, because I like to
 minimize confusion for myself. Also, I use the "Rec" suffix
 to denote that the record is not an object type.}

{Generic Command Record}
type  PCommandRec = ^TCommandRec;
      TCommandRec = Record
        ControlByte:    Byte;                       {1 Byte}
        State:          Word;                       {2 Bytes}
end;                                                {3 Bytes total}

{Conference Command Record}
type PConferenceCommandRec = ^TConferenceCommandRec;
     TConferenceCommandRec = record
       ControlByte:   Byte;                        {1 Byte}
       State:         Word;                        {2 Bytes}
       Conference:    TConferenceRec               {65 Bytes}
end;                                               {68 Bytes total}

{User Command Record, I only wan't the handle/id. If you wan't more
 see tagAlBroadEnter record/structure in alchemw.pas/h}
type PUserCommandRec = ^TUserCommandRec;
     TUserCommandRec = record
      ControlByte:     Byte;                       {1 Byte}
      State:           Word;                       {2 Bytes}
      User:            TUserRec;                   {45 Bytes}
end;                                               {48 Bytes total}

 {Chat Command Record}
type PChatCommandRec = ^TChatCommandRec;
     TChatCommandRec = record
      ControlByte:   Byte;                         {1 Byte}
      State:         Word;                         {2 Bytes}
      Chat:          TChatRec;                     {245 Bytes}
end;                                               {248 Bytes total}

{Please note, you can use the ControlByte like I am using
 the State but it may not be 0 and must always be no larger
 than 1 byte in length. }

implementation
end.
