unit Alchemw;

{Translated by Seraj at PC Net Com. Thanks Seraj!
 If you want the original version of this file
 see trktoon.zip on the Excal HQ Board. This one
 contains minor modifications.}

interface
uses WinTypes, WinProcs;

{ -- assorted identifiers for generic DLL functions }
const AL_PLUGTYPE 	=   3;
const AL_PLUGPROCESS	=   4;
const AL_PLUGDESTROY	=   5;
const AL_PLUGUNIQUE	=   6;
const AL_PLUGDIALOG	=   7;
const AL_PLUGBUTTON	=   8;
const AL_PLUGDATA	=   9;
const AL_PLUGMOUSE	=   10;
const AL_PLUGDLLSIZE	=   11;
const AL_PLUGNEXTDLL	=   12;
const AL_PLUGDLLVERIFY	=   13;
const AL_PLUGCOMMAND	=   14;
const AL_PLUGBROADCAST	=   15;
const AL_PLUGACTIVATE	=   16;
const AL_PLUGPAINT	=   17;
const AL_PLUGRESIZE	=   18;
const AL_PLUGRECEIVE	=   19;

{ -- assorted identifiers for screen DLL functions }
const AL_PLUGSTARTSCREEN =  3;
const AL_PLUGSCREENBLOCK =  4;
const AL_PLUGENDSCREEN	 =  5;

{ -- assorted identifiers for string substitution DLL's}
const AL_PLUGTEXT	 =  1;

{ -- window types }
const AL_WIN_NONE	=   0;
const AL_WIN_HIDDEN	=   1;
const AL_WIN_GRAPHIC	=   2;
const AL_WIN_PLUGIN	=   3;
const AL_WIN_MULTI      =   $1000;

{ -- Returns from PlugProcess }
const AL_IDLE		=  0;
const AL_OK		=  1;
const AL_DIE		=  2;
const AL_HANGUP	        =  3;

{ -- Returns from PlugCheckDLL }
const NODLL_OK		=   0;	{ -- DLL is just fine... use it. }
const NODLL_NONE	=   1;	{ -- no copy of the DLL }
const NODLL_MINOR	=   2;	{ -- minor revision... error corrections only }
const NODLL_MAJOR	=   3;	{ -- major revision... definitely incompatable }
const NODLL_NEWER	=   4;	{ -- too new major revision... maybe incompatable }
const NODLL_BADOS	=   5;	{ -- DLL not available for your particular OS }
const NODLL_LANGUAGE	=   6;	{ -- DLL not available for particular language }
const NODLL_OVERWRITE	=   7;	{ -- will over-write something by other mfgr }

{ -- Standard colors }
const AL_BLACK		 =  0;
const AL_RED	         =  1;
const AL_GREEN		 =  2;
const AL_BROWN		 =  3;
const AL_BLUE	         =  4;
const AL_MAGENTA         =  5;
const AL_CYAN	         =  6;
const AL_GRAY		 =  7;
const AL_LTGRAY		 =  8;
const AL_LTRED		 =  9;
const AL_LTGREEN	 =  10;
const AL_YELLOW		 =  11;
const AL_LTBLUE		 =  12;
const AL_LTMAGENTA	 =  13;
const AL_LTCYAN		 =  14;
const AL_WHITE		 =  15;

const AL_BLANK_LONG	 =  $80000000;
const AL_BLANK_WORD	 =  $8000;
const AL_BLANK_BYTE	 =  $80;


{ -- broadcast codes from Grail }
const AL_BROAD_ALLHERE	 =   1;	{ -- short count followed by structure below }
const AL_BROAD_ENTER	 =   2;	{ -- see structure below }
const AL_BROAD_LEAVE	 =   3;	{ -- LONG follows that is the ID }

type  PtagAlBroadEnter = ^tagAlBroadEnter;
      tagAlBroadEnter = Record
	MultiID:     Longint;	{ -- ID of registered dll }
	UserID:      Longint;	{ -- ID of person entering }
	Slot:        BYTE;	{ -- the slot the person entered on. }
	First:       array[0..20] of Char;
        Middle:      array[0..20] of Char;
        Last:        array[0..20] of Char;
	Handle:      array[0..40] of Char;
end;

type _OFSTRUCT = Record
        cBytes:        BYTE;
        fFixedDisk:    BYTE;
        nErrCode:      WORD;
        Reserved1:     WORD;
        Reserved2:     WORD;
        szPathName:    array[0..80] of Char;
     end;

type LPSLOT = LPVOID;
     AlBroadEnter = tagAlBroadEnter;
     OFSTRUCT = _OFSTRUCT;

{ -- API function declarations }
{ -- miscellaneous functions }
function  AlSlot( SlotH: LPSLOT ):WORD;
function  AlArgs( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
procedure AlCaption( SlotH: LPSLOT; title: PChar );
procedure AlLogWrite( SlotH: LPSLOT; text: PChar );
function  AlAlloc( SlotH: LPSLOT; size: LongInt ):HWND;
procedure AlFree( SlotH: LPSLOT );
function  AlLock( SlotH: LPSLOT ):LPVOID;
procedure AlUnlock( SlotH: LPSLOT );
function  AlReAlloc( SlotH: LPSLOT; size: LongInt ):HWND;
function  AlGetHandle( SlotH: LPSLOT ):HWND;
procedure AlSetHandle( SlotH: LPSLOT; dHandle: HWND );
function  AlGetPointer( SlotH: LPSLOT ):LPVOID;
procedure AlSetPointer( SlotH: LPSLOT; userPtr: LPVOID );
procedure AlAddBlock( SlotH: LPSLOT; data: LPVOID; len: WORD );
function  AlMainWindow( SlotH: LPSLOT ):HWND;
procedure AlSetWindowOrg( SlotH: LPSLOT; hdc: HDC );
function  AlSetState( SlotH: LPSLOT; value: WORD ):WORD;
function  AlGetState( SlotH: LPSLOT ):WORD;
procedure AlPushState( SlotH: LPSLOT; value: WORD );
function  AlPopState( SlotH: LPSLOT ):WORD;

{ -- screen handling routines }
function  AlOpenScreen( SlotH: LPSLOT; name: PChar; ofs: OFSTRUCT; mode: WORD ):
          Integer;
function  AlOpenScratch( SlotH: LPSLOT; name: PChar; ofs: OFSTRUCT;
          mode: WORD ):Integer;
function  AlOpenUserFile( SlotH: LPSLOT; name: PChar; ofs: OFSTRUCT;
          mode: WORD ):Integer;
function  AlOpenGlobalFile( SlotH: LPSLOT; name: PChar; ofs: OFSTRUCT;
          mode: WORD ):Integer;

function  AlDateTimeNow:LongInt;
procedure AlDateDecode( date: LongInt; var year, month, day: WORD );
function  AlDateEncode( year, month, day: WORD ):LongInt;
procedure AlReleaseButton( SlotH: LPSLOT );
procedure AlSound( SlotH: LPSLOT; sound: PChar );
procedure AlMessageBox( SlotH: LPSLOT; message: PChar; title: PChar;
          code: WORD );
procedure AlMouseDisable( SlotH: LPSLOT );
procedure AlMouseEnable( SlotH: LPSLOT );
procedure AlMouseRelease( SlotH: LPSLOT );

{ -- Dialog processing functions }
procedure AlExecDialog( SlotH: LPSLOT );
function  AlLoadDialog( SlotH: LPSLOT; resourceID: PChar; module: HWND ):BOOL;
procedure AlNewDialog( SlotH: LPSLOT; caption: PChar; x, y, w, h: WORD );
procedure AlDialogPress( SlotH: LPSLOT; id: WORD );
procedure AlSetString( SlotH: LPSLOT; id: WORD; data: PChar );
procedure AlSetCheck( SlotH: LPSLOT; id: WORD );
procedure AlLbAddString( SlotH: LPSLOT; id: WORD; data: PChar );
procedure AlCbAddString( SlotH: LPSLOT; id: WORD; data: PChar );
procedure AlLimitText( SlotH: LPSLOT; id, len: WORD );
procedure AlItemEdit( SlotH: LPSLOT; id, x, y, w, h: WORD; style: LongInt );
procedure AlItemStatic( SlotH: LPSLOT; id, x, y, w, h: WORD; style: LongInt;
          text: PChar );
procedure AlItemButton( SlotH: LPSLOT; id, x, y, w, h: WORD; style: LongInt;
          text: PChar );
procedure AlItemListBox( SlotH: LPSLOT; id, x, y, w, h: WORD;
          style: LongInt );
procedure AlItemComboBox( SlotH: LPSLOT; id, x, y, w, h: WORD;
          style: LongInt );
procedure AlItemScrollBar( SlotH: LPSLOT; id, x, y, w, h: WORD;
          style: LongInt );
procedure AlItemBorShade( SlotH: LPSLOT; id, x, y, w, h: WORD;
          style: LongInt;
          text: PChar );
procedure AlItemBorCheck( SlotH: LPSLOT; id, x, y, w, h: WORD;
          style: LongInt; text: PChar );
procedure AlItemBorRadio( SlotH: LPSLOT; id, x, y, w, h: WORD;
          style: LongInt; text: PChar );
procedure AlItemBorButton( SlotH: LPSLOT; id, x, y, w, h: WORD;
          style: LongInt );
function  AlDialogReturn( SlotH: LPSLOT ):WORD;
function  AlGetText( SlotH: LPSLOT; id: WORD; dest: PChar; len: WORD ):PChar;
function  AlGetTextLen( SlotH: LPSLOT; id: WORD ):Integer;
function  AlGetCheck( SlotH: LPSLOT; id: WORD ):BOOL;
function  AlGetSelected( SlotH: LPSLOT; id: WORD ):WORD;
function  AlGetSelList( SlotH: LPSLOT; id: WORD; var dest: WORD;
          limit: Integer ):WORD;
function  AlGetSelCount( SlotH: LPSLOT; id: WORD ):WORD;
function  AlGetScrollPos( SlotH: LPSLOT; id: WORD ):WORD;
procedure AlSetScrollPos( SlotH: LPSLOT; id, pos: WORD );
procedure AlSetScrollRange( SlotH: LPSLOT; id, lower, upper: WORD );
procedure AlLbSelect( SlotH: LPSLOT; id, pick: WORD );
procedure AlLbSelectItem( SlotH: LPSLOT; id, pick: WORD );
procedure AlLbSelectRange( SlotH: LPSLOT; id, lower, upper: WORD );
procedure AlCbSelect( SlotH: LPSLOT; id, pick: WORD );

{ -- general Grail database access }
function  AlGrailRequest( SlotH: LPSLOT; table, fields, filter: PChar ):BOOL;
function  AlGrailExecute( SlotH: LPSLOT; command: PChar ):BOOL;
function  AlCreateGrailInsert( SlotH: LPSLOT; table: PChar; size: WORD;
          needID: BOOL ):BOOL;
function  AlCreateGrailUpdate( SlotH: LPSLOT; table: PChar; size: WORD;
          id: LongInt ):BOOL;
function  AlGrailLock( SlotH: LPSLOT ):LPVOID;
procedure AlGrailUnlock( SlotH: LPSLOT );
function  AlGrailLastInsert( SlotH: LPSLOT ):LongInt;

{ -- Current User Information }
function  AlGetUserID( SlotH: LPSLOT ):LongInt;
function  AlGetUserULBytes( SlotH: LPSLOT ):LongInt;
function  AlGetUserDLBytes( SlotH: LPSLOT ):LongInt;
function  AlGetUserBalance( SlotH: LPSLOT ):LongInt;
function  AlGetUserRevenue( SlotH: LPSLOT ):LongInt;
function  AlGetUserLastCall( SlotH: LPSLOT ):LongInt;
function  AlGetUserDayByteLeft( SlotH: LPSLOT ):LongInt;
function  AlGetUserWeekByteLeft( SlotH: LPSLOT ):LongInt;
function  AlGetUserMonthByteLeft( SlotH: LPSLOT ):LongInt;
function  AlGetUserPermByte( SlotH: LPSLOT ):LongInt;
function  AlGetUserPermTime( SlotH: LPSLOT ):LongInt;
function  AlGetUserFirstCall( SlotH: LPSLOT ):LongInt;
function  AlGetUserExpiration( SlotH: LPSLOT ):LongInt;
function  AlGetUserCallByte( SlotH: LPSLOT ):LongInt;
function  AlGetUserDayByte( SlotH: LPSLOT ):LongInt;
function  AlGetUserWeekByte( SlotH: LPSLOT ):LongInt;
function  AlGetUserMonthByte( SlotH: LPSLOT ):LongInt;
function  AlGetUserBirth( SlotH: LPSLOT ):LongInt;
function  AlGetUserOtherMail( SlotH: LPSLOT ):LongInt;
function  AlGetUserULFiles( SlotH: LPSLOT ):WORD;
function  AlGetUserDLFiles( SlotH: LPSLOT ):WORD;
function  AlGetUserTotalCall( SlotH: LPSLOT ):WORD;
function  AlGetUserDayTimeLeft( SlotH: LPSLOT ):WORD;
function  AlGetUserWeekTimeLeft( SlotH: LPSLOT ):WORD;
function  AlGetUserMonthTimeLeft( SlotH: LPSLOT ):WORD;
function  AlGetUserByteRatio( SlotH: LPSLOT ):WORD;
function  AlGetUserFileRatio( SlotH: LPSLOT ):WORD;
function  AlGetUserCallTime( SlotH: LPSLOT ):WORD;
function  AlGetUserDayTime( SlotH: LPSLOT ):WORD;
function  AlGetUserWeekTime( SlotH: LPSLOT ):WORD;
function  AlGetUserMonthTime( SlotH: LPSLOT ):WORD;
function  AlGetUserLanguage( SlotH: LPSLOT ):WORD;
function  AlGetUserFirst( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserMiddle( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserLast( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserHandle( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserPassword( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserTitle( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserPosition( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserCompany( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserAddress1( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserAddress2( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserCity( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserState( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserCountry( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserPostal( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserPhoneHome( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserPhoneWork( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserPhoneFax( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserPhoneBBS( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserFirstVerify( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserLastVerify( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserLocalNet( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetUserNetID( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
{
function  AlGetUserComment( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;}
function  AlGetUserFlag( SlotH: LPSLOT; dest: PChar; index: WORD ):BOOL;
function  AlGetUserFlagCount( SlotH: LPSLOT ):WORD;
function  AlIsUserFlag( SlotH: LPSLOT; flag: PChar ):BOOL;
procedure AlSetUserFlag( SlotH: LPSLOT; name: PChar );
procedure AlClearUserFlag( SlotH: LPSLOT; name: PChar );
procedure AlSetUserULBytes( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserDLBytes( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserBalance( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserRevenue( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserLastCall( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserDayByteLeft( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserWeekByteLeft( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserMonthByteLeft( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserPermByte( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserPermTime( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserFirstCall( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserExpiration( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserCallByte( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserDayByte( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserWeekByte( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserMonthByte( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserBirth( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserOtherMail( SlotH: LPSLOT; value: LongInt );
procedure AlSetUserULFiles( SlotH: LPSLOT; value: WORD );
procedure AlSetUserDLFiles( SlotH: LPSLOT; value: WORD );
procedure AlSetUserTotalCall( SlotH: LPSLOT; value: WORD );
procedure AlSetUserDayTimeLeft( SlotH: LPSLOT; value: WORD );
procedure AlSetUserWeekTimeLeft( SlotH: LPSLOT; value: WORD );
procedure AlSetUserMonthTimeLeft( SlotH: LPSLOT; value: WORD );
procedure AlSetUserByteRatio( SlotH: LPSLOT; value: WORD );
procedure AlSetUserFileRatio( SlotH: LPSLOT; value: WORD );
procedure AlSetUserCallTime( SlotH: LPSLOT; value: WORD );
procedure AlSetUserDayTime( SlotH: LPSLOT; value: WORD );
procedure AlSetUserWeekTime( SlotH: LPSLOT; value: WORD );
procedure AlSetUserMonthTime( SlotH: LPSLOT; value: WORD );
procedure AlSetUserLanguage( SlotH: LPSLOT; value: WORD );
function  AlSetUserFirst( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserMiddle( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserLast( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserHandle( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserPassword( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserTitle( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserPosition( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserCompany( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserAddress1( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserAddress2( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserCity( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserState( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserCountry( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserPostal( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserPhoneHome( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserPhoneWork( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserPhoneFax( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserPhoneBBS( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserFirstVerify( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserLastVerify( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserLocalNet( SlotH: LPSLOT; data: PChar ):PChar;
function  AlSetUserNetID( SlotH: LPSLOT; data: PChar ):PChar;
{
function  AlSetUserComment( SlotH: LPSLOT; data: PChar ):PChar;}

{ -- Current Port Information }
function  AlGetPortID( SlotH: LPSLOT ):LongInt;
function  AlGetPortLastUser( SlotH: LPSLOT ):LongInt;
function  AlGetPortCalls( SlotH: LPSLOT ):LongInt;
function  AlGetPortBaud( SlotH: LPSLOT ):LongInt;
function  AlGetPortTemplate( SlotH: LPSLOT ):LongInt;
function  AlGetPortGuest( SlotH: LPSLOT ):LongInt;
function  AlGetPortWinStyle( SlotH: LPSLOT ):WORD;
function  AlGetPortWinX( SlotH: LPSLOT ):WORD;
function  AlGetPortWinY( SlotH: LPSLOT ):WORD;
function  AlGetPortWinW( SlotH: LPSLOT ):WORD;
function  AlGetPortWinH( SlotH: LPSLOT ):WORD;
function  AlGetPortBeepRepeat( SlotH: LPSLOT ):WORD;
function  AlGetPortBeepInterval( SlotH: LPSLOT ):WORD;
function  AlGetPortPort( SlotH: LPSLOT ):BYTE;
function  AlGetPortRingDetect( SlotH: LPSLOT ):BOOL;
function  AlGetPortUseHangup( SlotH: LPSLOT ):BOOL;
function  AlGetPortRingCount( SlotH: LPSLOT ):BYTE;
function  AlGetPortTimeout( SlotH: LPSLOT ):BYTE;
function  AlGetPortLockRate( SlotH: LPSLOT ):BOOL;
procedure AlGetPortDriveMap( SlotH: LPSLOT; dest: PChar );
function  AlGetPortNetName( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortSendExcal( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortLogin( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortNewUser( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortModemName( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortReset( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortInit( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortOffHook( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortOnHook( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortAnswer( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortRing( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortCIDPrefix( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortCIDPrivate( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortCIDNone( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortHangup( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortConnect( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortConnect1200( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortConnect2400( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortConnect4800( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortConnect9600( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortConnect19k( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortConnect38k( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortConnect57k( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortErrorCorrect( SlotH: LPSLOT; index: WORD; dest: PChar;
          len: WORD ):PChar;
function  AlGetPortEffBaud( SlotH: LPSLOT; index: WORD; dest: PChar;
          len: WORD ):PChar;
function  AlGetPortWaitMessage( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortScratch( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortSoundName( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortFirst( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortMiddle( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortLast( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetPortHandle( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;

{ -- system settings }
function  AlGetSysMajorRev( SlotH: LPSLOT ):WORD;
function  AlGetSysMinorRev( SlotH: LPSLOT ):WORD;
function  AlGetSysPageFrom( SlotH: LPSLOT ):WORD;
function  AlGetSysPageTo( SlotH: LPSLOT ):WORD;
function  AlGetSysByteCreditPct( SlotH: LPSLOT ):WORD;
function  AlGetSysDayCarryPct( SlotH: LPSLOT ):WORD;
function  AlGetSysWeekCarryPct( SlotH: LPSLOT ):WORD;
function  AlGetSysMonthCarryPct( SlotH: LPSLOT ):WORD;
function  AlGetSysDayCarryLimit( SlotH: LPSLOT ):LongInt;
function  AlGetSysWeekCarryLimit( SlotH: LPSLOT ):LongInt;
function  AlGetSysMonthCarryLimit( SlotH: LPSLOT ):LongInt;
function  AlGetSysCanPage( SlotH: LPSLOT ):BOOL;
function  AlGetSysAdultAge( SlotH: LPSLOT ):BYTE;
function  AlGetSysLogClear( SlotH: LPSLOT ):BOOL;
function  AlGetSysPageClear( SlotH: LPSLOT ):BOOL;
function  AlGetSysMinimumTime( SlotH: LPSLOT ):BYTE;
function  AlGetSysChargePartial( SlotH: LPSLOT ):BOOL;
function  AlGetSysNoULClock( SlotH: LPSLOT ):BOOL;
function  AlGetSysCreditNow( SlotH: LPSLOT ):BOOL;
function  AlGetSysSystemName( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetSysSerial( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetSysCreditCard( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetSysDefTopic( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetSysTimeZone( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetSysChat( SlotH: LPSLOT; index: WORD; dest: PChar; len: WORD ):
          PChar;
function  AlGetSysScreenDir( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
procedure AlGetSysLogFlags( SlotH: LPSLOT; dest: PChar );
function  AlGetSysUserDir( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetSysPreviewDir( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
function  AlGetSysNoAttachments( SlotH: LPSLOT ):BOOL;
function  AlGetSysPreviewCharge( SlotH: LPSLOT ):WORD;
function  AlGetSysHandles( SlotH: LPSLOT ):BOOL;

{ -- Graphic commands }
procedure AlScreenStart( SlotH: LPSLOT; color: BYTE );
procedure AlScreenEnd( SlotH: LPSLOT );
procedure AlLine( SlotH: LPSLOT; x1, y1, x2, y2: WORD; color, mode: BYTE;
          width: WORD );
procedure AlRectangle( SlotH: LPSLOT; x1, y1, x2, y2: WORD; color, mode: BYTE;
          width: WORD );
procedure AlEllipse( SlotH: LPSLOT; x1, y1, x2, y2: WORD; color, mode: BYTE;
          width: WORD );
procedure AlFRectangle( SlotH: LPSLOT; x1, y1, x2, y2: WORD; color, mode: BYTE;
          width: WORD; fg, bg, fill: BYTE; transparent: BOOL );
procedure AlFEllipse( SlotH: LPSLOT; x1, y1, x2, y2: WORD; color, mode: BYTE;
          width: WORD; fg, bg, fill: BYTE; transparent: BOOL );
procedure AlRoundRect( SlotH: LPSLOT; x1, y1, x2, y2: WORD; xe, ye: WORD;
          color, mode: BYTE; width: WORD );
procedure AlFRoundRect( SlotH: LPSLOT; x1, y1, x2, y2: WORD; xe, ye: WORD;
          color, mode: BYTE; width: WORD; fg, bg, fill: BYTE;
          transparent: BOOL );
procedure AlArc( SlotH: LPSLOT; x1, y1, x2, y2, x3, y3, x4, y4: WORD;
          color, mode: BYTE; width: WORD );
procedure AlPie( SlotH: LPSLOT; x1, y1, x2, y2, x3, y3, x4, y4: WORD;
          color, mode: BYTE;
          width: WORD; fg, bg, fill: BYTE; transparent: BOOL );
procedure AlChord( SlotH: LPSLOT; x1, y1, x2, y2, x3, y3, x4, y4: WORD;
          color, mode: BYTE; width: WORD; fg, bg, fill: BYTE;
          transparent: BOOL );
procedure AlHit( SlotH: LPSLOT; x1, y1, x2, y2: WORD; id, key: BYTE  );
procedure AlButton( SlotH: LPSLOT; x1, y1, x2, y2: WORD;
          id, key, font, width, height, style, color: BYTE; caption: PChar );
procedure AlPolygon( SlotH: LPSLOT; count: WORD; var point: WORD;
          color, mode: BYTE; width: WORD );
procedure AlFPolygon( SlotH: LPSLOT; count: WORD; var point: WORD;
          color, mode: BYTE; width: WORD;
          fg, bg, fill: BYTE; transparent: BOOL );
procedure AlText( SlotH: LPSLOT; x1, y1, x2, y2: WORD;
          font, width, height, style, position, color: BYTE; text: PChar );
procedure AlCard( SlotH: LPSLOT; card: BYTE; x1, y1, x2, y2: WORD );

{ -- International conversions }
function  AlUserMoneyFormat( SlotH: LPSLOT; dest: PChar; amt: LongInt ):PChar;
function  AlSysMoneyFormat( SlotH: LPSLOT; dest: PChar; amt: LongInt ):PChar;
function  AlSysShortDate( SlotH: LPSLOT; date: LongInt; dest: PChar;
          len: Integer ):PChar;
function  AlSysLongDate( SlotH: LPSLOT; date: LongInt; dest: PChar;
          len: Integer ):PChar;
function  AlUserShortDate( SlotH: LPSLOT; date: LongInt; dest: PChar;
          len: Integer ):PChar;
function  AlUserLongDate( SlotH: LPSLOT; date: LongInt; dest: PChar;
          len: Integer ):PChar;
function  AlSysTime( SlotH: LPSLOT; date: LongInt; dest: PChar; len: Integer ):
          PChar;
{
function  AlUserTime( SlotH: LPSLOT; date: LongInt; dest: PChar; len: Integer ):
           PChar;
function  AlSysDateScan( SlotH: LPSLOT; var dest: LongInt; date: PChar ):BOOL;
function  AlUserDateScan( SlotH: LPSLOT; var dest: LongInt; date: PChar ):BOOL;
function  AlSysTimeScan( SlotH: LPSLOT; var dest: LongInt; time: PChar ):BOOL;
function  AlUserTimeScan( SlotH: LPSLOT; var dest: LongInt; time: PChar ):BOOL;
procedure AlUserInternational( SlotH: LPSLOT;
          sShortDate, sLongDate, s1159, s2359, sTime: PChar;
          var iTime, iTLZero: BOOL; sThousand, sDecimal, sList, sDate: PChar );

{ -- slot controls }
procedure AlChainScreen( SlotH: LPSLOT; name: PChar );
procedure AlSlotDownload( SlotH: LPSLOT; id: LongInt );
procedure AlSlotMail( SlotH: LPSLOT );
procedure AlSlotPlugIn( SlotH: LPSLOT; name: PChar; cmd: PChar );
procedure AlSlotPreview( SlotH: LPSLOT; id: LongInt);
procedure AlSlotLibrary( SlotH: LPSLOT; id: LongInt );
procedure AlSlotConference( SlotH: LPSLOT; id: LongInt);
procedure AlSlotBulletin( SlotH: LPSLOT; name: PChar; title: PChar );

{ -- language independence routines }
function  AlLoadLangDialog( SlotH: LPSLOT; resourceID: PChar ):BOOL;
function  AlLoadLangLibrary( SlotH: LPSLOT ):HWND;
procedure AlFreeLangLibrary( SlotH: LPSLOT );
function  AlLangLibrary( SlotH: LPSLOT ):HWND;
function  AlLangString( SlotH: LPSLOT; id: WORD; dest: PChar; len: WORD ):PChar;

{ -- multi-user routines }
function  AlCreateMulti( SlotH: LPSLOT; count: WORD; var dest: LongInt;
          size: WORD ):BOOL;
function  AlCreateMultiAll( SlotH: LPSLOT; size: WORD ):BOOL;
function  AlCreateMultiSingle( SlotH: LPSLOT; dest: LongInt; size: WORD ):BOOL;
function  AlMultiLock( SlotH: LPSLOT ):LPVOID;
procedure AlMultiUnlock( SlotH: LPSLOT );
function  AlMultiSelf( SlotH: LPSLOT ):LongInt;

{ -- Direct COMM support (won't work with excalibur connections) }
function  AlCommHandle( SlotH: LPSLOT ):Integer;
procedure AlSwitchDLL( SlotH: LPSLOT; name: PChar; args: PChar );
procedure AlRunDLL( SlotH: LPSLOT; name: PChar; args: PChar );
function  AlCarrier( SlotH: LPSLOT ):BOOL;
function  AlSetNoHangup( SlotH: LPSLOT; flag: BOOL ):BOOL;

implementation
{ -- API function declarations }
{ -- miscellaneous functions }
function  AlSlot( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 233; {WORD}
function  AlArgs( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 234; {LPSTR}
procedure AlCaption( SlotH: LPSLOT; title: PChar );
                                           external 'ALCHEMW' Index 235; {void}
procedure AlLogWrite( SlotH: LPSLOT; text: PChar );
                                           external 'ALCHEMW' Index 236; {void}
function  AlAlloc( SlotH: LPSLOT; size: LongInt ):HWND;
                                           external 'ALCHEMW' Index 237; {HGLOBAL}
procedure AlFree( SlotH: LPSLOT );
                                           external 'ALCHEMW' Index 238; {void}
function  AlLock( SlotH: LPSLOT ):LPVOID;
                                           external 'ALCHEMW' Index 239; {void *}
procedure AlUnlock( SlotH: LPSLOT );
                                           external 'ALCHEMW' Index 240; {void}
function  AlReAlloc( SlotH: LPSLOT; size: LongInt ):HWND;
                                           external 'ALCHEMW' Index 241; {HGLOBAL}
function  AlGetHandle( SlotH: LPSLOT ):HWND;
                                           external 'ALCHEMW' Index 242; {HGLOBAL}
procedure AlSetHandle( SlotH: LPSLOT; dHandle: HWND );
                                           external 'ALCHEMW' Index 243; {void}
function  AlGetPointer( SlotH: LPSLOT ):LPVOID;
                                           external 'ALCHEMW' Index 303; {LPVOID}
procedure AlSetPointer( SlotH: LPSLOT; userPtr: LPVOID );
                                           external 'ALCHEMW' Index 304; {void}
procedure AlAddBlock( SlotH: LPSLOT; data: LPVOID; len: WORD );
                                           external 'ALCHEMW' Index 305; {void}
function  AlMainWindow( SlotH: LPSLOT ):HWND;
                                           external 'ALCHEMW' Index 306; {HWND}
procedure AlSetWindowOrg( SlotH: LPSLOT; hdc: HDC );
                                           external 'ALCHEMW' Index 307; {void}
function  AlSetState( SlotH: LPSLOT; value: WORD ):WORD;
                                           external 'ALCHEMW' Index 250; {WORD}
function  AlGetState( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 251; {WORD}
procedure AlPushState( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 252; {void}
function  AlPopState( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 253; {WORD}

{ -- screen handling routines }
function  AlOpenScreen( SlotH: LPSLOT; name: PChar; ofs: OFSTRUCT;
          mode: WORD ):Integer;
                                           external 'ALCHEMW' Index 244; {HFILE}
function  AlOpenScratch( SlotH: LPSLOT; name: PChar; ofs: OFSTRUCT;
          mode: WORD ):Integer;
                                           external 'ALCHEMW' Index 245; {HFILE}
function  AlOpenUserFile( SlotH: LPSLOT; name: PChar; ofs: OFSTRUCT;
          mode: WORD ):Integer;
                                           external 'ALCHEMW' Index 246; {HFILE}
function  AlOpenGlobalFile( SlotH: LPSLOT; name: PChar; ofs: OFSTRUCT;
          mode: WORD ):Integer;
                                           external 'ALCHEMW' Index 247; {HFILE}
function  AlDateTimeNow:LongInt;
                                           external 'ALCHEMW' Index 56; {LongInt}
procedure AlDateDecode( date: LongInt; var year, month, day: WORD );
                                           external 'ALCHEMW' Index 57; {void}
function  AlDateEncode( year, month, day: WORD ):LongInt;
                                           external 'ALCHEMW' Index 58; {LongInt}
procedure AlReleaseButton( SlotH: LPSLOT );
                                           external 'ALCHEMW' Index 248; {void}
procedure AlSound( SlotH: LPSLOT; sound: PChar );
                                           external 'ALCHEMW' Index 249; {void}
procedure AlMessageBox( SlotH: LPSLOT; message: PChar; title: PChar;
          code: WORD );
                                           external 'ALCHEMW' Index 254; {void}
procedure AlMouseDisable( SlotH: LPSLOT );
                                           external 'ALCHEMW' Index 35; {void}
procedure AlMouseEnable( SlotH: LPSLOT );
                                           external 'ALCHEMW' Index 36; {void}
procedure AlMouseRelease( SlotH: LPSLOT );
                                           external 'ALCHEMW' Index 37; {void}

{ -- Dialog processing functions }
procedure AlExecDialog( SlotH: LPSLOT );
                                           external 'ALCHEMW' Index 2; {void}
function  AlLoadDialog( SlotH: LPSLOT; resourceID: PChar; module: HWND ):BOOL;
                                           external 'ALCHEMW' Index 3; {BOOL}
procedure AlNewDialog( SlotH: LPSLOT; caption: PChar; x, y, w, h: WORD );
                                           external 'ALCHEMW' Index 4; {void}
procedure AlDialogPress( SlotH: LPSLOT; id: WORD );
                                           external 'ALCHEMW' Index 5; {void}
procedure AlSetString( SlotH: LPSLOT; id: WORD; data: PChar );
                                           external 'ALCHEMW' Index 6; {void}
procedure AlSetCheck( SlotH: LPSLOT; id: WORD );
                                           external 'ALCHEMW' Index 7; {void}
procedure AlLbAddString( SlotH: LPSLOT; id: WORD; data: PChar );
                                           external 'ALCHEMW' Index 8; {void}
procedure AlCbAddString( SlotH: LPSLOT; id: WORD; data: PChar );
                                           external 'ALCHEMW' Index 9; {void}
procedure AlLimitText( SlotH: LPSLOT; id, len: WORD );
                                           external 'ALCHEMW' Index 10; {void}
procedure AlItemEdit( SlotH: LPSLOT; id, x, y, w, h: WORD; style: LongInt );
                                           external 'ALCHEMW' Index 11; {void}
procedure AlItemStatic( SlotH: LPSLOT; id, x, y, w, h: WORD;
          style: LongInt; text: PChar );
                                           external 'ALCHEMW' Index 12; {void}
procedure AlItemButton( SlotH: LPSLOT; id, x, y, w, h: WORD; style: LongInt;
          text: PChar );
                                           external 'ALCHEMW' Index 13; {void}
procedure AlItemListBox( SlotH: LPSLOT; id, x, y, w, h: WORD; style: LongInt );
                                           external 'ALCHEMW' Index 14; {void}
procedure AlItemComboBox( SlotH: LPSLOT; id, x, y, w, h: WORD; style: LongInt );
                                           external 'ALCHEMW' Index 15; {void}
procedure AlItemScrollBar( SlotH: LPSLOT; id, x, y, w, h: WORD;
          style: LongInt );
                                           external 'ALCHEMW' Index 16; {void}
procedure AlItemBorShade( SlotH: LPSLOT; id, x, y, w, h: WORD; style: LongInt;
          text: PChar );
                                           external 'ALCHEMW' Index 17; {void}
procedure AlItemBorCheck( SlotH: LPSLOT; id, x, y, w, h: WORD; style: LongInt;
          text: PChar );
                                           external 'ALCHEMW' Index 18; {void}
procedure AlItemBorRadio( SlotH: LPSLOT; id, x, y, w, h: WORD; style: LongInt;
          text: PChar );
                                           external 'ALCHEMW' Index 19; {void}
procedure AlItemBorButton( SlotH: LPSLOT; id, x, y, w, h: WORD; style: LongInt );
                                           external 'ALCHEMW' Index 20; {void}
function  AlDialogReturn( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 21; {WORD}
function  AlGetText( SlotH: LPSLOT; id: WORD; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 22; {LPSTR}
function  AlGetTextLen( SlotH: LPSLOT; id: WORD ):Integer;
                                           external 'ALCHEMW' Index 23; {int}
function  AlGetCheck( SlotH: LPSLOT; id: WORD ):BOOL;
                                           external 'ALCHEMW' Index 24; {BOOL}
function  AlGetSelected( SlotH: LPSLOT; id: WORD ):WORD;
                                           external 'ALCHEMW' Index 25; {WORD}
function  AlGetSelList( SlotH: LPSLOT; id: WORD; var dest: WORD;
          limit: Integer ):WORD;
                                           external 'ALCHEMW' Index 26; {WORD}
function  AlGetSelCount( SlotH: LPSLOT; id: WORD ):WORD;
                                           external 'ALCHEMW' Index 27; {WORD}
function  AlGetScrollPos( SlotH: LPSLOT; id: WORD ):WORD;
                                           external 'ALCHEMW' Index 28; {WORD}
procedure AlSetScrollPos( SlotH: LPSLOT; id, pos: WORD );
                                           external 'ALCHEMW' Index 29; {void}
procedure AlSetScrollRange( SlotH: LPSLOT; id, lower, upper: WORD );
                                           external 'ALCHEMW' Index 30; {void}
procedure AlLbSelect( SlotH: LPSLOT; id, pick: WORD );
                                           external 'ALCHEMW' Index 31; {void}
procedure AlLbSelectItem( SlotH: LPSLOT; id, pick: WORD );
                                           external 'ALCHEMW' Index 32; {void}
procedure AlLbSelectRange( SlotH: LPSLOT; id, lower, upper: WORD );
                                           external 'ALCHEMW' Index 33; {void}
procedure AlCbSelect( SlotH: LPSLOT; id, pick: WORD );
                                           external 'ALCHEMW' Index 34; {void}

{ -- general Grail database access }
function  AlGrailRequest( SlotH: LPSLOT; table, fields, filter: PChar ):BOOL;
                                           external 'ALCHEMW' Index 255; {BOOL}
function  AlGrailExecute( SlotH: LPSLOT; command: PChar ):BOOL;
                                           external 'ALCHEMW' Index 256; {BOOL}
function  AlCreateGrailInsert( SlotH: LPSLOT; table: PChar; size: WORD;
          needID: BOOL ):BOOL;
                                           external 'ALCHEMW' Index 257; {BOOL}
function  AlCreateGrailUpdate( SlotH: LPSLOT; table: PChar; size: WORD;
          id: LongInt ):BOOL;
                                           external 'ALCHEMW' Index 258; {BOOL}
function  AlGrailLock( SlotH: LPSLOT ):LPVOID;
                                           external 'ALCHEMW' Index 259; {void *}
procedure AlGrailUnlock( SlotH: LPSLOT );
                                           external 'ALCHEMW' Index 260; {void}
function  AlGrailLastInsert( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 289; {LongInt}

{ -- Current User Information }
function  AlGetUserID( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 123; {LongInt}
function  AlGetUserULBytes( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 124; {LongInt}
function  AlGetUserDLBytes( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 125; {LongInt}
function  AlGetUserBalance( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 126; {LongInt}
function  AlGetUserRevenue( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 127; {LongInt}
function  AlGetUserLastCall( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 128; {LongInt}
function  AlGetUserDayByteLeft( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 129; {LongInt}
function  AlGetUserWeekByteLeft( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 130; {LongInt}
function  AlGetUserMonthByteLeft( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 131; {LongInt}
function  AlGetUserPermByte( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 132; {LongInt}
function  AlGetUserPermTime( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 133; {LongInt}
function  AlGetUserFirstCall( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 134; {LongInt}
function  AlGetUserExpiration( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 135; {LongInt}
function  AlGetUserCallByte( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 136; {LongInt}
function  AlGetUserDayByte( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 137; {LongInt}
function  AlGetUserWeekByte( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 312; {LongInt}
function  AlGetUserMonthByte( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 138; {LongInt}
function  AlGetUserBirth( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 139; {LongInt}
function  AlGetUserOtherMail( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 140; {LongInt}
function  AlGetUserULFiles( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 141; {WORD}
function  AlGetUserDLFiles( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 142; {WORD}
function  AlGetUserTotalCall( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 143; {WORD}
function  AlGetUserDayTimeLeft( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 144; {WORD}
function  AlGetUserWeekTimeLeft( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 145; {WORD}
function  AlGetUserMonthTimeLeft( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 146; {WORD}
function  AlGetUserByteRatio( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 147; {WORD}
function  AlGetUserFileRatio( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 148; {WORD}
function  AlGetUserCallTime( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 149; {WORD}
function  AlGetUserDayTime( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 150; {WORD}
function  AlGetUserWeekTime( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 151; {WORD}
function  AlGetUserMonthTime( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 152; {WORD}
function  AlGetUserLanguage( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 153; {WORD}
function  AlGetUserFirst( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 154; {LPSTR}
function  AlGetUserMiddle( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 155; {LPSTR}
function  AlGetUserLast( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 156; {LPSTR}
function  AlGetUserHandle( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 157; {LPSTR}
function  AlGetUserPassword( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 158; {LPSTR}
function  AlGetUserTitle( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 159; {LPSTR}
function  AlGetUserPosition( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 160; {LPSTR}
function  AlGetUserCompany( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 161; {LPSTR}
function  AlGetUserAddress1( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 162; {LPSTR}
function  AlGetUserAddress2( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 163; {LPSTR}
function  AlGetUserCity( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 164; {LPSTR}
function  AlGetUserState( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 165; {LPSTR}
function  AlGetUserCountry( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 166; {LPSTR}
function  AlGetUserPostal( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 167; {LPSTR}
function  AlGetUserPhoneHome( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 168; {LPSTR}
function  AlGetUserPhoneWork( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 169; {LPSTR}
function  AlGetUserPhoneFax( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 170; {LPSTR}
function  AlGetUserPhoneBBS( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 171; {LPSTR}
function  AlGetUserFirstVerify( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 172; {LPSTR}
function  AlGetUserLastVerify( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 173; {LPSTR}
function  AlGetUserLocalNet( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 174; {LPSTR}
function  AlGetUserNetID( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 175; {LPSTR}
{
function  AlGetUserComment( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index ..;} {LPSTR}
function  AlGetUserFlag( SlotH: LPSLOT; dest: PChar; index: WORD ):BOOL;
                                           external 'ALCHEMW' Index 176; {BOOL}
function  AlGetUserFlagCount( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 177; {WORD}
function  AlIsUserFlag( SlotH: LPSLOT; flag: PChar ):BOOL;
                                           external 'ALCHEMW' Index 178; {BOOL}
procedure AlSetUserFlag( SlotH: LPSLOT; name: PChar );
                                           external 'ALCHEMW' Index 179; {void}
procedure AlClearUserFlag( SlotH: LPSLOT; name: PChar );
                                           external 'ALCHEMW' Index 180; {void}

procedure AlSetUserULBytes( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 181; {void}
procedure AlSetUserDLBytes( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 182; {void}
procedure AlSetUserBalance( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 183; {void}
procedure AlSetUserRevenue( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 184; {void}
procedure AlSetUserLastCall( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 185; {void}
procedure AlSetUserDayByteLeft( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 186; {void}
procedure AlSetUserWeekByteLeft( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 187; {void}
procedure AlSetUserMonthByteLeft( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 188; {void}
procedure AlSetUserPermByte( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 189; {void}
procedure AlSetUserPermTime( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 190; {void}
procedure AlSetUserFirstCall( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 191; {void}
procedure AlSetUserExpiration( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 192; {void}
procedure AlSetUserCallByte( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 193; {void}
procedure AlSetUserDayByte( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 194; {void}
procedure AlSetUserWeekByte( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 311; {void}
procedure AlSetUserMonthByte( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 195; {void}
procedure AlSetUserBirth( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 196; {void}
procedure AlSetUserOtherMail( SlotH: LPSLOT; value: LongInt );
                                           external 'ALCHEMW' Index 197; {void}
procedure AlSetUserULFiles( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 198; {void}
procedure AlSetUserDLFiles( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 199; {void}
procedure AlSetUserTotalCall( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 200; {void}
procedure AlSetUserDayTimeLeft( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 201; {void}
procedure AlSetUserWeekTimeLeft( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 202; {void}
procedure AlSetUserMonthTimeLeft( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 203; {void}
procedure AlSetUserByteRatio( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 204; {void}
procedure AlSetUserFileRatio( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 205; {void}
procedure AlSetUserCallTime( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 206; {void}
procedure AlSetUserDayTime( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 207; {void}
procedure AlSetUserWeekTime( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 208; {void}
procedure AlSetUserMonthTime( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 209; {void}
procedure AlSetUserLanguage( SlotH: LPSLOT; value: WORD );
                                           external 'ALCHEMW' Index 210; {void}
function  AlSetUserFirst( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 211; {LPSTR}
function  AlSetUserMiddle( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 212; {LPSTR}
function  AlSetUserLast( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 213; {LPSTR}
function  AlSetUserHandle( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 214; {LPSTR}
function  AlSetUserPassword( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 215; {LPSTR}
function  AlSetUserTitle( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 216; {LPSTR}
function  AlSetUserPosition( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 217; {LPSTR}
function  AlSetUserCompany( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 218; {LPSTR}
function  AlSetUserAddress1( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 219; {LPSTR}
function  AlSetUserAddress2( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 220; {LPSTR}
function  AlSetUserCity( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 221; {LPSTR}
function  AlSetUserState( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 222; {LPSTR}
function  AlSetUserCountry( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 223; {LPSTR}
function  AlSetUserPostal( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 224; {LPSTR}
function  AlSetUserPhoneHome( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 225; {LPSTR}
function  AlSetUserPhoneWork( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 226; {LPSTR}
function  AlSetUserPhoneFax( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 227; {LPSTR}
function  AlSetUserPhoneBBS( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 228; {LPSTR}
function  AlSetUserFirstVerify( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 229; {LPSTR}
function  AlSetUserLastVerify( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 230; {LPSTR}
function  AlSetUserLocalNet( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 231; {LPSTR}
function  AlSetUserNetID( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index 232; {LPSTR}
{
function AlSetUserComment( SlotH: LPSLOT; data: PChar ):PChar;
                                           external 'ALCHEMW' Index ..;} {LPSTR}

{ -- Current Port Information }
function  AlGetPortID( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 71; {LongInt}
function  AlGetPortLastUser( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 72; {LongInt}
function  AlGetPortCalls( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 73; {LongInt}
function  AlGetPortBaud( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 74; {LongInt}
function  AlGetPortTemplate( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 75; {LongInt}
function  AlGetPortGuest( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 76; {LongInt}
function  AlGetPortWinStyle( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 77; {WORD}
function  AlGetPortWinX( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 78; {WORD}
function  AlGetPortWinY( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 79; {WORD}
function  AlGetPortWinW( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 80; {WORD}
function  AlGetPortWinH( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 81; {WORD}
function  AlGetPortBeepRepeat( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 82; {WORD}
function  AlGetPortBeepInterval( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 83; {WORD}
function  AlGetPortPort( SlotH: LPSLOT ):BYTE;
                                           external 'ALCHEMW' Index 84; {BYTE}
function  AlGetPortRingDetect( SlotH: LPSLOT ):BOOL;
                                           external 'ALCHEMW' Index 85; {BOOL}
function  AlGetPortUseHangup( SlotH: LPSLOT ):BOOL;
                                           external 'ALCHEMW' Index 86; {BOOL}
function  AlGetPortRingCount( SlotH: LPSLOT ):BYTE;
                                           external 'ALCHEMW' Index 87; {BYTE}
function  AlGetPortTimeout( SlotH: LPSLOT ):BYTE;
                                           external 'ALCHEMW' Index 88; {BYTE}
function  AlGetPortLockRate( SlotH: LPSLOT ):BOOL;
                                           external 'ALCHEMW' Index 89; {BOOL}
procedure AlGetPortDriveMap( SlotH: LPSLOT; dest: PChar );
                                           external 'ALCHEMW' Index 90; {void}
function  AlGetPortNetName( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 91; {LPSTR}
function  AlGetPortSendExcal( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 92; {LPSTR}
function  AlGetPortLogin( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 93; {LPSTR}
function  AlGetPortNewUser( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 94; {LPSTR}
function  AlGetPortModemName( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 95; {LPSTR}
function  AlGetPortReset( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 96; {LPSTR}
function  AlGetPortInit( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 97; {LPSTR}
function  AlGetPortOffHook( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 98; {LPSTR}
function  AlGetPortOnHook( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 99; {LPSTR}
function  AlGetPortAnswer( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 100; {LPSTR}
function  AlGetPortRing( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 101; {LPSTR}
function  AlGetPortCIDPrefix( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 102; {LPSTR}
function  AlGetPortCIDPrivate( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 103; {LPSTR}
function  AlGetPortCIDNone( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 104; {LPSTR}
function  AlGetPortHangup( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 105; {LPSTR}
function  AlGetPortConnect( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 106; {LPSTR}
function  AlGetPortConnect1200( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 107; {LPSTR}
function  AlGetPortConnect2400( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 108; {LPSTR}
function  AlGetPortConnect4800( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 109; {LPSTR}
function  AlGetPortConnect9600( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 110; {LPSTR}
function  AlGetPortConnect19k( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 111; {LPSTR}
function  AlGetPortConnect38k( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 112; {LPSTR}
function  AlGetPortConnect57k( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 113; {LPSTR}
function  AlGetPortErrorCorrect( SlotH: LPSLOT; index: WORD; dest: PChar;
          len: WORD ):PChar;
                                           external 'ALCHEMW' Index 114; {LPSTR}
function  AlGetPortEffBaud( SlotH: LPSLOT; index: WORD; dest: PChar;
          len: WORD ):PChar;
                                           external 'ALCHEMW' Index 115; {LPSTR}
function  AlGetPortWaitMessage( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 116; {LPSTR}
function  AlGetPortScratch( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 117; {LPSTR}
function  AlGetPortSoundName( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 118; {LPSTR}
function  AlGetPortFirst( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 119; {LPSTR}
function  AlGetPortMiddle( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 120; {LPSTR}
function  AlGetPortLast( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 121; {LPSTR}
function  AlGetPortHandle( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 122; {LPSTR}

{ -- system settings }
function  AlGetSysMajorRev( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 261; {WORD}
function  AlGetSysMinorRev( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 262; {WORD}
function  AlGetSysPageFrom( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 263; {WORD}
function  AlGetSysPageTo( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 264; {WORD}
function  AlGetSysByteCreditPct( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 265; {WORD}
function  AlGetSysDayCarryPct( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 266; {WORD}
function  AlGetSysWeekCarryPct( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 267; {WORD}
function  AlGetSysMonthCarryPct( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 268; {WORD}
function  AlGetSysDayCarryLimit( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 269; {LongInt}
function  AlGetSysWeekCarryLimit( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 270; {LongInt}
function  AlGetSysMonthCarryLimit( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 271; {LongInt}
function  AlGetSysCanPage( SlotH: LPSLOT ):BOOL;
                                           external 'ALCHEMW' Index 272; {BOOL}
function  AlGetSysAdultAge( SlotH: LPSLOT ):BYTE;
                                           external 'ALCHEMW' Index 273; {BYTE}
function  AlGetSysLogClear( SlotH: LPSLOT ):BOOL;
                                           external 'ALCHEMW' Index 274; {BOOL}
function  AlGetSysPageClear( SlotH: LPSLOT ):BOOL;
                                           external 'ALCHEMW' Index 275; {BOOL}
function  AlGetSysMinimumTime( SlotH: LPSLOT ):BYTE;
                                           external 'ALCHEMW' Index 276; {BYTE}
function  AlGetSysChargePartial( SlotH: LPSLOT ):BOOL;
                                           external 'ALCHEMW' Index 277; {BOOL}
function  AlGetSysNoULClock( SlotH: LPSLOT ):BOOL;
                                           external 'ALCHEMW' Index 278; {BOOL}
function  AlGetSysCreditNow( SlotH: LPSLOT ):BOOL;
                                           external 'ALCHEMW' Index 279; {BOOL}
function  AlGetSysSystemName( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 280; {LPSTR}
function  AlGetSysSerial( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 281; {LPSTR}
function  AlGetSysCreditCard( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 282; {LPSTR}
function  AlGetSysDefTopic( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 283; {LPSTR}
function  AlGetSysTimeZone( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 284; {LPSTR}
function  AlGetSysChat( SlotH: LPSLOT; index: WORD; dest: PChar;
          len: WORD ):PChar;
                                           external 'ALCHEMW' Index 285; {LPSTR}
function  AlGetSysScreenDir( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 286; {LPSTR}
procedure AlGetSysLogFlags( SlotH: LPSLOT; dest: PChar );
                                           external 'ALCHEMW' Index 287; {void}
function  AlGetSysUserDir( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 288; {LPSTR}
function  AlGetSysPreviewDir( SlotH: LPSLOT; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 315; {LPSTR}
function  AlGetSysNoAttachments( SlotH: LPSLOT ):BOOL;
                                           external 'ALCHEMW' Index 317; {BOOL}
function  AlGetSysPreviewCharge( SlotH: LPSLOT ):WORD;
                                           external 'ALCHEMW' Index 316; {WORD}
function  AlGetSysHandles( SlotH: LPSLOT ):BOOL;
                                           external 'ALCHEMW' Index 318; {BOOL}

{ -- Graphic commands }
procedure AlScreenStart( SlotH: LPSLOT; color: BYTE );
                                           external 'ALCHEMW' Index 38; {void}
procedure AlScreenEnd( SlotH: LPSLOT );
                                           external 'ALCHEMW' Index 39; {void}
procedure AlLine( SlotH: LPSLOT; x1, y1, x2, y2: WORD; color, mode: BYTE;
          width: WORD );
                                           external 'ALCHEMW' Index 40; {void}
procedure AlRectangle( SlotH: LPSLOT; x1, y1, x2, y2: WORD; color, mode: BYTE;
          width: WORD );
                                           external 'ALCHEMW' Index 41; {void}
procedure AlEllipse( SlotH: LPSLOT; x1, y1, x2, y2: WORD; color, mode: BYTE;
          width: WORD );
                                           external 'ALCHEMW' Index 42; {void}
procedure AlFRectangle( SlotH: LPSLOT; x1, y1, x2, y2: WORD; color, mode: BYTE;
          width: WORD; fg, bg, fill: BYTE; transparent: BOOL );
                                           external 'ALCHEMW' Index 43; {void}
procedure AlFEllipse( SlotH: LPSLOT; x1, y1, x2, y2: WORD; color, mode: BYTE;
          width: WORD; fg, bg, fill: BYTE; transparent: BOOL );
                                           external 'ALCHEMW' Index 44; {void}
procedure AlRoundRect( SlotH: LPSLOT; x1, y1, x2, y2: WORD; xe, ye: WORD;
          color, mode: BYTE; width: WORD );
                                           external 'ALCHEMW' Index 45; {void}
procedure AlFRoundRect( SlotH: LPSLOT; x1, y1, x2, y2: WORD; xe, ye: WORD;
          color, mode: BYTE; width: WORD; fg, bg, fill: BYTE;
          transparent: BOOL );
                                           external 'ALCHEMW' Index 46; {void}
procedure AlArc( SlotH: LPSLOT; x1, y1, x2, y2, x3, y3, x4, y4: WORD;
          color, mode: BYTE; width: WORD );
                                           external 'ALCHEMW' Index 47; {void}
procedure AlPie( SlotH: LPSLOT; x1, y1, x2, y2, x3, y3, x4, y4: WORD;
          color, mode: BYTE; width: WORD; fg, bg, fill: BYTE;
          transparent: BOOL );
                                           external 'ALCHEMW' Index 48; {void}
procedure AlChord( SlotH: LPSLOT; x1, y1, x2, y2, x3, y3, x4, y4: WORD;
          color, mode: BYTE; width: WORD; fg, bg, fill: BYTE;
          transparent: BOOL );
                                           external 'ALCHEMW' Index 49; {void}
procedure AlHit( SlotH: LPSLOT; x1, y1, x2, y2: WORD; id, key: BYTE  );
                                           external 'ALCHEMW' Index 50; {void}
procedure AlButton( SlotH: LPSLOT; x1, y1, x2, y2: WORD;
          id, key, font, width, height, style, color: BYTE; caption: PChar );
                                           external 'ALCHEMW' Index 51; {void}
procedure AlPolygon( SlotH: LPSLOT; count: WORD; var point: WORD;
          color, mode: BYTE; width: WORD );
                                           external 'ALCHEMW' Index 52; {void}
procedure AlFPolygon( SlotH: LPSLOT; count: WORD; var point: WORD;
          color, mode: BYTE; width: WORD; fg, bg, fill: BYTE;
          transparent: BOOL );
                                           external 'ALCHEMW' Index 53; {void}
procedure AlText( SlotH: LPSLOT; x1, y1, x2, y2: WORD;
          font, width, height, style, position, color: BYTE; text: PChar );
                                           external 'ALCHEMW' Index 54; {void}
procedure AlCard( SlotH: LPSLOT; card: BYTE; x1, y1, x2, y2: WORD );
                                           external 'ALCHEMW' Index 55; {void}

{ -- International conversions }
function  AlUserMoneyFormat( SlotH: LPSLOT; dest: PChar; amt: LongInt ):PChar;
                                           external 'ALCHEMW' Index 59; {LPSTR}
function  AlSysMoneyFormat( SlotH: LPSLOT; dest: PChar; amt: LongInt ):PChar;
                                           external 'ALCHEMW' Index 60; {LPSTR}
function  AlSysShortDate( SlotH: LPSLOT; date: LongInt; dest: PChar;
          len: Integer ):PChar;
                                           external 'ALCHEMW' Index 61; {LPSTR}
function  AlSysLongDate( SlotH: LPSLOT; date: LongInt; dest: PChar;
          len: Integer ):PChar;
                                           external 'ALCHEMW' Index 62; {LPSTR}
function  AlUserShortDate( SlotH: LPSLOT; date: LongInt; dest: PChar;
          len: Integer ):PChar;
                                           external 'ALCHEMW' Index 63; {LPSTR}
function  AlUserLongDate( SlotH: LPSLOT; date: LongInt; dest: PChar;
          len: Integer ):PChar;
                                           external 'ALCHEMW' Index 64; {LPSTR}
function  AlSysTime( SlotH: LPSLOT; date: LongInt; dest: PChar;
          len: Integer ):PChar;
                                           external 'ALCHEMW' Index 65; {LPSTR}
{
function  AlUserTime( SlotH: LPSLOT; date: LongInt; dest: PChar;
          len: Integer ):PChar;
                                          external 'ALCHEMW' Index ..;} {LPSTR}
{$F+}
function  AlSysDateScan( SlotH: LPSLOT; var dest: LongInt; date: PChar ):BOOL;
                                           external 'ALCHEMW' Index 66; {BOOL}
function  AlUserDateScan( SlotH: LPSLOT; var dest: LongInt; date: PChar ):BOOL;
                                           external 'ALCHEMW' Index 67; {BOOL}
function  AlSysTimeScan( SlotH: LPSLOT; var dest: LongInt; time: PChar ):BOOL;
                                           external 'ALCHEMW' Index 68; {BOOL}
function  AlUserTimeScan( SlotH: LPSLOT; var dest: LongInt; time: PChar ):BOOL;
                                           external 'ALCHEMW' Index 69; {BOOL}
procedure AlUserInternational( SlotH: LPSLOT;
          sShortDate, sLongDate, s1159, s2359, sTime: PChar;
          var iTime, iTLZero: BOOL; sThousand, sDecimal, sList, sDate: PChar );
                                           external 'ALCHEMW' Index 70; {void}

{ -- slot controls }
procedure AlChainScreen( SlotH: LPSLOT; name: PChar );
                                           external 'ALCHEMW' Index 290; {void}
procedure AlSlotDownload( SlotH: LPSLOT; id: LongInt );
                                           external 'ALCHEMW' Index 291; {void}
procedure AlSlotMail( SlotH: LPSLOT );
                                           external 'ALCHEMW' Index 292; {void}
procedure AlSlotPlugIn( SlotH: LPSLOT; name: PChar; cmd: PChar );
                                           external 'ALCHEMW' Index 293; {void}
procedure AlSlotPreview( SlotH: LPSLOT; id: LongInt);
                                           external 'ALCHEMW' Index 294; {void}
procedure AlSlotLibrary( SlotH: LPSLOT; id: LongInt );
                                           external 'ALCHEMW' Index 295; {void}
procedure AlSlotConference( SlotH: LPSLOT; id: LongInt);
                                           external 'ALCHEMW' Index 296; {void}
procedure AlSlotBulletin( SlotH: LPSLOT; name: PChar; title: PChar );
                                           external 'ALCHEMW' Index 297; {void}

{ -- language independence routines }
function  AlLoadLangDialog( SlotH: LPSLOT; resourceID: PChar ):BOOL;
                                           external 'ALCHEMW' Index 298; {BOOL}
function  AlLoadLangLibrary( SlotH: LPSLOT ):HWND;
                                           external 'ALCHEMW' Index 299; {HINSTANCE}
procedure AlFreeLangLibrary( SlotH: LPSLOT );
                                           external 'ALCHEMW' Index 300; {void}
function  AlLangLibrary( SlotH: LPSLOT ):HWND;
                                           external 'ALCHEMW' Index 301; {HINSTANCE}
function  AlLangString( SlotH: LPSLOT; id: WORD; dest: PChar; len: WORD ):PChar;
                                           external 'ALCHEMW' Index 302; {LPCSTR}

{ -- multi-user routines }
function  AlCreateMulti( SlotH: LPSLOT; count: WORD; var dest: LongInt;
          size: WORD ):BOOL;
                                           external 'ALCHEMW' Index 308; {BOOL}
function  AlCreateMultiAll( SlotH: LPSLOT; size: WORD ):BOOL;
                                           external 'ALCHEMW' Index 314; {BOOL}
function  AlCreateMultiSingle( SlotH: LPSLOT; dest: LongInt; size: WORD ):BOOL;
                                           external 'ALCHEMW' Index 313; {BOOL}
function  AlMultiLock( SlotH: LPSLOT ):LPVOID;
                                           external 'ALCHEMW' Index 309; {void *}
procedure AlMultiUnlock( SlotH: LPSLOT );
                                           external 'ALCHEMW' Index 310; {void}
function  AlMultiSelf( SlotH: LPSLOT ):LongInt;
                                           external 'ALCHEMW' Index 319; {long}

{ -- Direct COMM support (won't work with excalibur connections) }
function  AlCommHandle( SlotH: LPSLOT ):Integer;
                                           external 'ALCHEMW' Index 320; {int}
procedure AlSwitchDLL( SlotH: LPSLOT; name: PChar; args: PChar );
                                           external 'ALCHEMW' Index 321; {void}
procedure AlRunDLL( SlotH: LPSLOT; name: PChar; args: PChar );
                                           external 'ALCHEMW' Index 322; {void}
function  AlCarrier( SlotH: LPSLOT ):BOOL;
                                           external 'ALCHEMW' Index 323; {BOOL}
function  AlSetNoHangup( SlotH: LPSLOT; flag: BOOL ):BOOL;
                                           external 'ALCHEMW' Index 324; {BOOL}

end.
