#include <classlib\listimp.h>
#include <owl\layoutwi.h>
#include <owl\owlpch.h>
#include <owl\dc.h>
#include <mmsystem.h>
#include <exlib.h>
#include "s_sample.h"
#include <bwcc.h>
#include <string.h>
#include "stdlib.h"
#include "stdio.h"
#include <ctype.h>
//end of includes

static Bye = FALSE;
//============================================================================/
// Some DLL overhead                                                          /
//============================================================================/

extern "C" {
	int FAR PASCAL _export LibMain( HINSTANCE, WORD, WORD, LPSTR );
	int FAR PASCAL _export WEP(int);
	WORD FAR PASCAL _export PlugInit( EXLIBH handle, LPCSTR args );
	void FAR PASCAL _export PlugDestroy( EXLIBH handle );
	WORD FAR PASCAL _export PlugCommand( EXLIBH handle, LPBYTE cmd, WORD len );
	WORD FAR PASCAL _export PlugProcess( EXLIBH handle );
	};

extern HINSTANCE _hInstance;
TModule *module;
int FAR PASCAL
  LibMain( HINSTANCE /* hInstance */, WORD, WORD, LPSTR lpCmdLine )
	{
	module = new TModule("module", _hInstance, lpCmdLine );

	if((module == NULL) || (module->Status != 0))
	  {
		delete module;
		module = NULL;
		return FALSE;
	  }
	else return TRUE;
	}

int FAR PASCAL
WEP(int /*bSystemExit*/)
	{
	return 1;
	}
//============================================================================/
// The game window class header                                               /
//============================================================================/
class GameWindow : public TWindow {

	//Excalibur library import
	EXLIBH          LibH;                                           // handle to library information

public:
	GameWindow( EXLIBH lib );
	~GameWindow()
		{
		ExSetToDie(LibH);
		ExSetPtr( LibH, 0 );
		}
	//Standard windows functions
	void SetupWindow();
	//routines to handle data from camelot
	WORD Command( BYTE *cmd, WORD len );
	//response table
	DECLARE_RESPONSE_TABLE( GameWindow );
	};


DEFINE_RESPONSE_TABLE1( GameWindow, TWindow )
END_RESPONSE_TABLE;


GameWindow::GameWindow( EXLIBH lib )
	: LibH(lib), TWindow( 0, "" )
	{
	Attr.H=250;
	Attr.W=350;
	}

void _FAR setfont( TWindow *w, void *f )
	{
	w->SendMessage( WM_SETFONT, (WPARAM)(*(HFONT*)f), FALSE );
	}

void GameWindow::SetupWindow()
	{
	TWindow::SetupWindow();
	TRect r;
	Parent->Attr.Style &= ~( WS_MINIMIZEBOX );
	Parent->SetWindowLong( GWL_STYLE, Parent->Attr.Style );
	HFONT font = ExDlgFont( LibH );
	ForEach( setfont, &font );
	}
//=====================
//Messages from Camelot
//=====================
WORD GameWindow::Command( BYTE */*cmd*/, WORD /*len*/ )
	{
	/*switch( *cmd++ ) {
		}*/
	return AL_OK;
	}

//===================
//Excalibur interface
//===================

void _export SetupTools( EXLIBH /*handle*/, EXCHILD /*vchild*/ )
	{
	/*EXTOOLBAR cb = ExCreateToolbar( handle, vchild, 1 );
	ExInsertToolbar( vchild, cb );*/
	}

WORD FAR PASCAL _export PlugInit( EXLIBH handle, LPCSTR /* args */ )
	{
	ExcalWindow win;
	win.DLLInstance = _hInstance;
	win.OwlWindow = new GameWindow( handle );
	win.Title = "C_CLIENT";
	win.Class = "OwlWindow";
	win.Menu = NULL;
	win.Icon = NULL;
	win.KBHandling = FALSE;
	win.ShowMethod = SW_SHOW;
	win.ToolbarSetup = NULL;
	ExCreateTool( handle, &win );
	ExSetPtr( handle, win.OwlWindow );
	return AL_OK;
	}

void FAR PASCAL _export PlugDestroy( EXLIBH handle )
	{
	GameWindow *win = (GameWindow*)ExGetPtr( handle );
	if ( win )
		win->CloseWindow();
	while ( ! Bye )
		ExPumpMessages( handle );
	}

#pragma argsused
WORD FAR PASCAL _export PlugCommand( EXLIBH handle, LPBYTE cmd, WORD len )
	{
	GameWindow *win = (GameWindow*)ExGetPtr( handle );
	return win->Command( cmd, len );
	}

WORD FAR PASCAL _export PlugProcess( EXLIBH /* handle */ )
	{
	return AL_OK;
	}


