/*
@Goto NoRexx
*/

/*
   

   REXX-Script to create a TERMINATOR 2
   OS/2 Presentation Manager Folder

   Run this command file at the OS/2 command prompt

   
     REXX script for TERMINATOR 2 by SAM Dmitriev
*/

Say "Creating PM-folder for TERMINATOR 2. Please wait..."

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

IF Arg(1)<>''
   THEN
   DO
   Call directory Arg(1)
   END

TeDir=Directory()
TeDir=SubStr(TeDir,1,LastPos('\',TeDir))

Say "TERMINATOR 2 should now have been installed in "TeDir"."
Say "If it wasn't, then drag the new folder to trash... ;)"
ObjMode="Replace"
rc=0


say 'Creating a TERMINATOR 2 folder...'

/* The Folder */
Class = "WPFolder"
Location = "<WP_DESKTOP>"
Title = "TERMINATOR 2"
SetupString = "OBJECTID=<TE>;ICONFILE="TeDir"OS2\TE_PMF.ICO;BACKGROUND="TeDir"OS2\TE.BMP;"
rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

/*  REG Info  */


say "Creating 'Registration Info' folder..."

/* The Folder */
Class = "WPFolder"
Location = "<TE>"
Title = "Register"
SetupString = "OBJECTID=<TEREG>;ICONFILE="TeDir"OS2\TE_DOC.ICO;BACKGROUND="TeDir"OS2\TE.BMP;"
rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

/* Doc's in folder */
Location = "<TEREG>"
ObjMode="UpDate"
Class = "WPProgram"

 CALL AddReg "ReadMe"
 CALL AddReg "BBS"
 CALL AddReg "CD-ROM"
 CALL AddReg "Hardware"
 CALL AddReg "Library"
 CALL AddReg "Magazine"

/*  REG  */

say "Creating 'Ripley' folder..."

/* The Folder */
Class = "WPFolder"
Location = "<TE>"
Title = "Ripley"
SetupString = "OBJECTID=<TEBKG>;ICONFILE="TeDir"OS2\TE_DOC.ICO;BACKGROUND="TeDir"OS2\TEBKG.BMP;"
rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

/* Doc's in folder */
Location = "<TEBKG>"
ObjMode="UpDate"
Class = "WPProgram"

Title = "Bo$Welch"
SetupString = "OBJECTID=<TEBKBO>;ICONFILE="TeDir"OS2\TE_TXT.ICO;EXENAME=E.EXE;PARAMETERS="TeDir"DOCUMENT\BO$WELCH.TXT;"
rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)
Title = "Liar_Woods"
SetupString = "OBJECTID=<TEBKWO>;ICONFILE="TeDir"OS2\TE_TXT.ICO;EXENAME=E.EXE;PARAMETERS="TeDir"DOCUMENT\LIAR_WOO.DS;"
rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

/*  OVERVIEW  */


say "Creating  Rexx , History , Licence   objects..."

/* Doc's in folder */

Location = "<TE>"
ObjMode="UpDate"
Class = "WPProgram"

Title = "T-REXX"
SetupString = "OBJECTID=<TEREXX>;ICONFILE="TeDir"OS2\TE_TXT.ICO;EXENAME=E.EXE;PARAMETERS="TeDir"DOCUMENT\REXX.DOC;"
rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

Title = "History"
SetupString = "OBJECTID=<TEHIST>;ICONFILE="TeDir"OS2\TE_TXT.ICO;EXENAME=E.EXE;PARAMETERS="TeDir"DOCUMENT\HISTORY.DOC;"
rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

Title = "Problems?"
SetupString = "OBJECTID=<TEPROBL>;ICONFILE="TeDir"OS2\TE_TXT.ICO;EXENAME=E.EXE;PARAMETERS="TeDir"DOCUMENT\PROBLEMS.TXT;"
rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

Title = "Licence"
SetupString = "OBJECTID=<TELIC>;ICONFILE="TeDir"OS2\LICENCE.ICO;EXENAME=E.EXE;PARAMETERS="TeDir"DOCUMENT\LICENCE.DOC;"
rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)


/*  TERMINATOR 2 EXECUTABLE  */

say 'Creating TERMINATOR 2 objects...'

/*  TERMINATOR 2 EXECUTABLE SETTINGS  */
/*
   NOTE!!!
   I'm not sure , that everything will be correct for you, so
   you can modify any settings (and even add new ones) that you
   understand
   It's highly recommended to use a FIFO chip and a SIO driver by Ray
   Gwinn instead of the standard COMM drivers coming with OS/2
*/

TermSetup ='SET DOS_BACKGROUND_EXECUTION=1;'||,
           'SET DOS_FILES=80;'||,
           'SET DOS_HIGH=1;'||,
           'SET DOS_UMB=1;'||,
           'SET DPMI_DOS_API=DISABLED;'||,
           'SET DPMI_MEMORY_LIMIT=0;'||,
           'SET EMS_MEMORY_LIMIT=2048;'||,
           'SET IDLE_SECONDS=10;'||,
           'SET IDLE_SENSITIVITY=75;'||,
           'SET SESSION_PRIORITY=1;'

/* The Programs in the folder */

ObjMode="UpDate"
Class = "WPProgram"
Location = "<TE>"

Title = "T2"

SetupString='OBJECTID=<TEEXE>;'||,
            'ICONFILE='TeDir'OS2\TE_PM.ICO;'||,
            'PROGTYPE=VDM;'||,
            'EXENAME='TeDir'T2.EXE;'||,
            'STARTUPDIR='TeDir';'TermSetup


rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

 verG = Left(SysOS2Ver(),3);
 verL = Substr(verG,Pos('.',verG,1)+1,1);
 verG = Left(SysOS2Ver(),1);

/* Say 'OS/2 Version 'verG'.'verL     */
/* SysCreateShadow available in Warp  */

 if ( ( VerG = '2' ) & ( VerL > '2' ) ) then
 rc = rc + (SysCreateShadow('<TEEXE>','<WP_DESKTOP>')<>1)

Title = "File Navigator"

SetupString =   'OBJECTID=<TEFM>;'||,
                'ICONFILE='TeDir'OS2\TEFM_PM.ICO;'||,
                'PROGTYPE=VDM;'||,
                 'EXENAME='TeDir'T2.EXE;'||,
              'PARAMETERS=/FN;'||,
              'STARTUPDIR='TeDir';'TermSetup

rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

Title = "Fax Manager"

SetupString =   'OBJECTID=<TEFAX>;'||,
                'ICONFILE='TeDir'OS2\TEFAX_PM.ICO;'||,
                'PROGTYPE=VDM;'||,
                 'EXENAME='TeDir'T2.EXE;'||,
              'PARAMETERS=/FAX;'||,
              'STARTUPDIR='TeDir';'TermSetup

rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

Title = "QWK'em"

SetupString =   'OBJECTID=<TEQWK>;'||,
                'ICONFILE='TeDir'OS2\TEQWK_PM.ICO;'||,
                'PROGTYPE=VDM;'||,
                 'EXENAME='TeDir'T2.EXE;'||,
              'PARAMETERS=/QWK;'||,
              'STARTUPDIR='TeDir';'TermSetup

rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

Title = "Host"

SetupString =   'OBJECTID=<TEHST>;'||,
                'ICONFILE='TeDir'OS2\TEHST_PM.ICO;'||,
                'PROGTYPE=VDM;'||,
                 'EXENAME='TeDir'T2.EXE;'||,
              'PARAMETERS=/HOST;'||,
              'STARTUPDIR='TeDir';'TermSetup

rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

Title = "SAM'ed"

SetupString =   'OBJECTID=<TESE>;'||,
                'ICONFILE='TeDir'OS2\TESE_PM.ICO;'||,
                'PROGTYPE=VDM;'||,
                 'EXENAME='TeDir'SAM''ED\SAMED.EXE;'||,
               'PARAMETERS=/TOSS /SCAN /EDIT;'||,
               'STARTUPDIR='TeDir'SAM''ED\;'||,
               'SET EMS_MEMORY_LIMIT=2048;'

rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)


/*  OPEN TERMINATOR 2 FOLDER  */

/* Open folder */
Class = "WPFolder"
Location = "<WP_DESKTOP>"
Title = "TERMINATOR 2"
SetupString = "OBJECTID=<TE>;OPEN=Default;"
rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)

/*  END  */

  Say
  If (rc='0') Then
   Do
     say 'Install successful'
     say 'TERMINATOR 2 folder created. '
   End
  Else
     say 'Install failed'
Exit;

/*  Adding Text file objects */
AddReg:
Title = Arg(1)
SetupString = "OBJECTID=<TER"Arg(1)">;ICONFILE="TeDir"OS2\TE_TXT.ICO;EXENAME=E.EXE;PARAMETERS="TeDir"REGISTER\"ARG(1)".REG;"
rc = rc + (SysCreateObject(Class,Title,Location,SetupString,ObjMode)<>1)
Return

/* No REXX found */

:NoRexx
@Echo Off
Ansi On
Echo [2J[30m[47m
Echo ͸
Echo                       No REXX support found in your system                   
Echo ;
Echo [37m[40m
Echo If you plan to install OS/2 REXX support, then
Echo Please open object "Selective Install" from OS/2 System folder
Echo and install REXX in your OS/2 system.

