/***
 *
 * ANXGLOBF.C - Register global command and specify priority for it
 *
 * by Randall R. Spangler
 *
 * $Revision: 1.0 $ $Date: 1996/05/07 04:50:24 $
 *
 ***/

#include "gcomm.h"
#include "majorbbs.h"
#include "anxglobf.h"

/***************************************************************************/
/*** VARIABLES *************************************************************/
/***************************************************************************/

static char glfixdll[] = "ANXGLFIX";    /* Name of our DLL */

/***************************************************************************/
/*** FUNCTIONS *************************************************************/
/***************************************************************************/

int         GlobalFixRegister(int (*glofunc) (), int priority)
{
    /* Registers a global command with the specified priority.  Returns zero
     * if successful or non-zero if error (in which case you can compare the
     * return code to the GLFIX_ return codes in ANXGLOBF.H). */

    USHORT      m;
    int         (*fp) (int (*glofunc) (), int prio);

    /*** Find our DLL ***/
    if (DosGetModHandle(glfixdll, &m)) {
        /* DLL not present - so pass through to globalcmd() so that the
         * global command still gets registered. */
        globalcmd(glofunc);
        return GLFIX_PASSTHRU;
    }
    /*** Find our function ***/
    if (DosGetProcAddr(m, "_GLOBALFIXCMD", (PPFN) & fp)) {
        /* Couldn't find our global command registerer, so pass through. */
        globalcmd(glofunc);
        return GLFIX_PASSTHRU;
    }
    /*** Call our function ***/
    return fp(glofunc, priority);
}

/***************************************************************************/
