/*
*********************************************************************
* hwmas.inc
* constants, structures, function prototypes for HWMAS "AccountSave"
* Copyright (c) 1993 by Frank LaPiana, HighWater Mark, All Rights Reserved
*********************************************************************
*/
#ifndef hwmas_inc
	#define hwmas_inc

	/*
	*****************************************************************
	* function prototypes
	*****************************************************************
	*/
	void EXPORT 	init__AccountSave (void);
	void EXPORT 	as_UserSave (void);
	void EXPORT 	as_AcctDel (char *UserID);

	/*
	*****************************************************************
	* GLOBAL data allocations
	*****************************************************************
	*/
	#ifdef HWMAS_GLOBAL
		int                 as_ModuleNumber;
		struct module 		as_Module =
		{
			"",							/* char *descrp */
										/*    description for main menu         */
			NULLPTR,					/* int (*lonrou)() */
										/*    user logon supplemental routine   */
			NULLPTR,					/* int (*sttrou)() */
										/*    input routine if selected         */
			NULLPTR,					/* int (*stsrou)()
										/*    status-input routine if selected  */
			NULLPTR,					/* int (*injrou)() */
										/*    "inject other" channel routine" */
			NULLPTR,					/* int (*lofrou)() */
										/*    log-off routine     */
			NULLPTR,					/* int (*huprou)() */
										/*    hangup (lost carrier) routine     */
			NULLPTR,					/* int (*mcurou)() */
										/*    midnight cleanup routine          */
			as_AcctDel,					/* int (*dlarou)() */
										/*    delete-account routine            */
			NULLPTR						/* int (*finrou)() */
										/*    finish-up (sys shutdown) routine  */
		};

		int					as_CycleTime = 61;
								// this is how often ct "cycles"
								// and checks the lines
		char				as_CycleShow = FALSE;
								// TRUE to show the start of each cyclic save
		char				as_AcctDeleteSave = FALSE;
								// TRUE to save deleted account user-id's
								// to an MS-DOS file 
	#endif

	/*
	*****************************************************************
	* EXTERNAL data declarations
	*****************************************************************
	*/

#endif
