/*
*********************************************************************
* hwmas.c
* "AccountSave"
* Saves the account records on a timed basis, to disk, in case of
* random BBS crash.
* Freeware. Distribute and use freely. Please accredit all derivations.
*
* copyright (c) 1993, Frank LaPiana, HighWater Mark, all rights reserved
*********************************************************************
*/

#define HWMAS_GLOBAL

#include "hwmcomp.h"
#include "gcomm.h"
#include "majorbbs.h"

#include "hwmas.inc"
#include "hwmas.h"

/*
*********************************************************************
* init__AccountSave
* Initialize for processing at BBS startup time.
*********************************************************************
*/
void EXPORT init__AccountSave (void)
{
	FILE		*as_MsgFile = NULLPTR;		// MSG file structure

	// module description/name and number
	stzcpy (as_Module.descrp, gmdnam("HWMAS.MDF"), MNMSIZ);
	as_ModuleNumber = register_module (&as_Module);

	// get any run-time options from the config/msg file
	as_MsgFile = opnmsg ("hwmas.mcv");
	setmbk (as_MsgFile);

	as_CycleTime	       		= numopt (ASCYCLE, 0, 9999);
	as_CycleShow				= ynopt (ASCYCSH);
	as_AcctDeleteSave			= ynopt (ASDELSV);

	clsmsg (as_MsgFile);
	as_MsgFile = NULLPTR;

	// our version information, displayed in the "general info" banner
	shocst ("HWMAS Account Save", __DATE__);
	/*
	*******************************************************
	* initialize the user and event control arrays.
	*******************************************************
	*/

	/*
	*******************************************************
	* start any cycle processes
	*******************************************************
	*/
	if (as_CycleTime > 0)
		rtkick (as_CycleTime, as_UserSave);
	rstmbk();
}
/*
*********************************************************************
* as_UserSave
* save user records back to the account file.
*********************************************************************
*/
void EXPORT as_UserSave (void)
{
	static int						iTemp1 = 0;
	static struct user				*UserPtr;
	static int						InLoop = FALSE;

	// if we are in a loop, then keep on checking for records to
	// save. Else, restart the loop again.
	if (InLoop == FALSE)
	{
		if (as_CycleShow == TRUE)
		{
			iTemp1 = usrnum;
			usrnum = 0;
			shocst ("HWMAS new save sequence", "");
			usrnum = iTemp1;
		}
		iTemp1 = 0;
	}
	InLoop = TRUE;
	for (UserPtr = &user[iTemp1]; iTemp1 < nterms; iTemp1++, UserPtr++)
	{
		switch (UserPtr->class)
		{
			case ACTUSR:
			case SUPLON:
			case SUPLOF:
				if (UserPtr->flags BITAND NOHDWE)
					// this is not a real channel
					break;
				usaptr = uacoff(iTemp1);
				updacc();
				rtkick (30, as_UserSave);	// cycle to save another record
				iTemp1++;					// make sure we check the next user
				return;
		}
	}
	// set up for next cycle-check
	InLoop = FALSE;
	rtkick (as_CycleTime, as_UserSave);
	return;
}
/*
*********************************************************************
* as_AcctDel
* Save the User-ID to an MS-DOS file when accounts are deleted.
* The format is one per line, pure text.
*********************************************************************
*/
void EXPORT as_AcctDel (char *UserID)
{
	static FILE 			*DelFile;
	static int				DelFileOpen = FALSE;	// only report the error once

	if (!as_AcctDeleteSave)
		return;

	DelFile = fopen ("HWMAS.DEL", "a+t");
	if (DelFile == NULLPTR)
	{
		if (DelFileOpen == FALSE)
		{
			shocst ("HWMAS Account Delete Save ERROR", "cannot open HWMAS.DEL");
			DelFileOpen = TRUE;
		}
		return;
	}
	fprintf (DelFile, "%s\n", UserID);
	fclose (DelFile);
	DelFile = NULLPTR;
	return;
}
