/***************************************************************************
 *                                                                         *
 *   GALCONDL.C                                                            *
 *                                                                         *
 *   Copyright (C) 1993-1995 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Connect-time delay / sample interception of (*hdlcon)() vector        *
 *                                                                         *
 *                                                   - R. Stein 7/30/93    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galcondl.h"

static long *orgcnt;                    /* array of time samples, per user */
static long condelay;                   /* delay time in 1/65536 sec units */

void (*oldhcn)();                       /* saved hdlcon value              */

int ctdstt;                             /* Connect Time Delay state number */

char *onemom;                           /* "One moment please" message     */

STATIC void condlay(void);
STATIC int ctdinp(void);
STATIC void ctdsth(void);

struct module ctdmodule={          /* module interface block               */
     "",                           /*    name used to refer to this module */
     NULL,                         /*    user logon supplemental routine   */
     ctdinp,                       /*    input routine if selected         */
     ctdsth,                       /*    status-input routine if selected  */
     NULL,                         /*    "injoth" routine for this module  */
     NULL,                         /*    user logoff supplemental routine  */
     NULL,                         /*    hangup (lost carrier) routine     */
     NULL,                         /*    midnight cleanup routine          */
     NULL,                         /*    delete-account routine            */
     NULL,                         /*    finish-up (sys shutdown) routine  */
};

void EXPORT
init__galcondl(void)                    /* initialize connect-time delay   */
{
     FILE *ctdmb;
     char *msg;

     oldhcn=hdlcon;
     hdlcon=condlay;
     stzcpy(ctdmodule.descrp,gmdnam("GALCONDL.MDF"),MNMSIZ);
     ctdstt=register_module(&ctdmodule);
     orgcnt=(long *)alcmem(nterms*sizeof(long));
     ctdmb=opnmsg("galcondl.mcv");
     condelay=0x10000L*numopt(CONDELAY,0,32767);
     msg=getmsg(ONEMOM);
     onemom=alcmem(strlen(msg)+1);
     strcpy(onemom,msg);
     clsmsg(ctdmb);
}

STATIC void
condlay(void)                           /* begin the delay                   */
{
     orgcnt[usrnum]=hrtval();
     usrptr->class=BBSPRV;
     usrptr->state=ctdstt;
     usrptr->substt=0;
     usrptr->flags|=NOGLOB;
     if (condelay > 0L) {
          prf("%s",onemom);
          outprf(usrnum);
     }
     btuinj(usrnum,CYCLE);
}

STATIC int
ctdinp(void)                            /* re-reminder input handling      */
{
     prf("%s",onemom);
     outprf(usrnum);
     return(1);
}

STATIC void
ctdsth(void)                            /* status handler, delay over yet? */
{
     static int indfs=0;   /* avoids infinite loop via dfsthn-loscar-stsrou */

     if (indfs) {
          rstchn();
          return;
     }
     switch (status) {
     case CYCLE:
          if (hrtval()-orgcnt[usrnum] < condelay) {
               btuinj(usrnum,CYCLE);
          }
          else {
               usrptr->class=VACANT;
               usrptr->flags&=~NOGLOB;
               (*oldhcn)();
          }
          break;
     default:
          indfs=1;
          dfsthn();
          indfs=0;
          break;
     }
}
