/* patchit.c */

#include "gcomm.h"
#include "patchit.h"

#define JMPFAR '\xEA'              /* FAR JUMP opcode                      */

void
patchinit(                         /* initialze patch capability           */
patchinfo *pinf,                   /*   info structure                     */
void *oldrout,                     /*   pointer to old routine             */
void *newrout)                     /*   pointer to new routine             */
{

     pinf->oldrout=oldrout;
     pinf->newrout=newrout;
     if (DosCreateDSAlias(FP_SEG(oldrout),&pinf->memsel) != 0) {
          catastro("GALHPAC: Cannot patch!");
     }
     pinf->oldroutw=(char *)MK_FP(pinf->memsel,FP_OFF(oldrout));
     dsairp();
     pinf->oldhead[0]=((char *)pinf->oldrout)[0];
     pinf->oldhead[1]=((char *)pinf->oldrout)[1];
     pinf->oldhead[2]=((char *)pinf->oldrout)[2];
     pinf->oldhead[3]=((char *)pinf->oldrout)[3];
     pinf->oldhead[4]=((char *)pinf->oldrout)[4];
     pinf->newhead[0]=JMPFAR;
     *((void **)&(pinf->newhead[1]))=newrout;
     enairp();
}

void
patchnew(                          /* install patch to new routine         */
patchinfo *pinf)                   /*   patch info structure               */
{
     dsairp();
     pinf->oldroutw[0]=pinf->newhead[0];
     pinf->oldroutw[1]=pinf->newhead[1];
     pinf->oldroutw[2]=pinf->newhead[2];
     pinf->oldroutw[3]=pinf->newhead[3];
     pinf->oldroutw[4]=pinf->newhead[4];
     enairp();
}

void
patchold(                          /* restore old routine (make callable)  */
patchinfo *pinf)                   /*   patch info structure               */
{
     dsairp();
     pinf->oldroutw[0]=pinf->oldhead[0];
     pinf->oldroutw[1]=pinf->oldhead[1];
     pinf->oldroutw[2]=pinf->oldhead[2];
     pinf->oldroutw[3]=pinf->oldhead[3];
     pinf->oldroutw[4]=pinf->oldhead[4];
     enairp();
}

void
patchfin(                          /* relinquish ability to patch new/old  */
patchinfo *pinf)                   /*   patch info structure               */
{
     if (DosFreeSeg(pinf->memsel) != 0) {
          catastro("GALHPAC: Cannot clean up after patch!");
     }
}

