/***************************************************************************
*    OPMEXP.C                                                              *
*                                                                          *
*        Shopping Mall Version 6 Export Utility.  Please see the end       *
*    of code for instructions on how to run.                               *
*                                                                          *
*    Copyright 1993 Galacticomm, Inc.                                      *
*                                                 - C. Kotacka 04/22/93    *
***************************************************************************/

#include "gcomm.h"
#include "usracc.h"

/* OPMEXP.C 26/04/93 11.31.54 */
int can_open (void);
int do_export (void);
int formvbr (void);
int print_it (void);

#define PIDSIZ (12+1)         /* Max size of product number                */
#define BRDSIZ (30+1)         /* Max size of brief product description     */
#define DKYSIZ (6+1)          /* Department key size                  SE   */
#undef KEYSIZ
#define KEYSIZ (6+1)          /* Department key size                  SE   */
#define TXBSIZ (1920+1)          /* Maximum size of text buffer               */

#define DDSSIZ (30+1)         /* Max size of dept. description field       */
#define CSZSIZ (15+1)         /* Max field size of color and size entry    */
#define SIFNSZ (8+1)          /* Max size of .SIF file name (no ext)       */
#define SVDSIZ (40+1)         /* Max size of services description field    */
#define STTSIZ (2+1)          /* Max size of state field                   */
#define SPMSIZ (20+1)         /* Max size of pay/ship method desc. string  */
#define NSPMTH 6              /* Max number of shipping/payment methods    */

struct invtmp {               /* Temp inventory data buffer                */
     char macuid[UIDSIZ];     /* Merchants User-ID                         */
     char dptkey[KEYSIZ];     /* Department key                       SE   */
     char prodid[PIDSIZ];     /* Product or catalog number                 */
     char brfdsc[BRDSIZ];     /* Brief description of this item            */
     int weight;              /* Weight in ounces                          */
     long price;              /* Price of this item                        */
     int flags;               /* Misc. flags                               */
     char vrbdsc[TXBSIZ];     /* Long description                          */
     char spare[2018-2010];   /* spare decrement as needed                 */
};                            /* GALIVC.DAT file                           */

#define UPDINV 1              /* Made changes to inventory, update!        */
#define SIZES  2              /* Inventory item has sizes                  */
#define COLORS 4              /* Inventory item has colors                 */
#define DISCNT 8              /* Item qualifies for discount               */

#define GENLEN   128                              /* Generic length        */

BTVFILE *ord;                                     /* Btrieve File Pointer  */
FILE    *inf;                                     /* Import file pointer   */

char  ofile[256];                                 /* Input file name       */
char macid[UIDSIZ];

struct invtmp inv;                                /* Inventory pointer     */

main(
int argc,
char *argv[])
{
     if (argc != 3) {
          printf("Usage=  OPMEXP \"merchant-Id\" \"filename\" \n");
          return(0);
     }
     stzcpy(macid,argv[1],UIDSIZ);
     stzcpy(ofile,argv[2],sizeof(ofile));
     ord=opnbtv("GALIVC.DAT",sizeof(struct invtmp));
     if (can_open()) {
          do_export();
     }
     clsbtv(ord);
     fclose(inf);
     return(1);
}

can_open()
{
     if ((inf=fopen(ofile,FOPWA)) != NULL) {
          return(1);
     }
     return(0);
}

do_export()
{
     if (slobtv(&inv)) {
          do {
               if (sameas(inv.macuid,macid)) {
                    printf("+");
                    formvbr();
                    print_it();
               }
               else {
                    printf("-");
               }
          } while (snxbtv(&inv));
     }
     return(1);
}

formvbr()
{
     int i;

     for (i=0 ; i < TXBSIZ ; i++) {
          if (inv.vrbdsc[i]=='\n') {
               inv.vrbdsc[i]='\x01';
          }
          if (inv.vrbdsc[i]=='\r') {
               inv.vrbdsc[i]='\x01';
          }
     }
     return(1);
}

print_it()
{
     char wt[GENLEN],flg[GENLEN];

     itoa(inv.weight,wt,10);
     itoa(inv.flags,flg,10);
     fprintf(inf,"%-29.29s%-6.6s%-12.12s%-30.30s%-5.5s%-12.12s%-2.2s%s\n",
          inv.macuid,inv.dptkey,inv.prodid,inv.brfdsc,wt,l2as(inv.price),
          flg,inv.vrbdsc);
     return(1);
}
