{
  "TRANSSYS.PAS"  ( UNIT : TRANSYS )  t@C]vgR

  '91.06.11 XMODEM(SUM/CRC/CRC1024) , YMODEM(g/batch/g-batch) ,
            ZMODEM(batch) , M-LINK(batch) , and Console supported.
}

unit transsys;

{----------------------------------------------------------------------}
interface

Uses Dos, JmpCall,
     header, kernel, rsdriver, timer, filmangr, monitor, io;

procedure clearline;

procedure Downloadselect(var successful: boolean);
procedure Uploadselect(filename: string; var successful: boolean);

procedure Xdownload(var successful: boolean);
procedure Ydownload(var successful: boolean);
procedure Zdownload(var successful: boolean);
procedure Mdownload(var successful: boolean);
procedure CONdownload(var successful: boolean);

procedure Xupload(filename: string; var successful: boolean);
procedure Yupload(filename: string; var successful: boolean);
procedure Zupload(filename: string; var successful: boolean);
procedure Mupload(filename: string; var successful: boolean);
procedure CONupload(filename: string; var successful: boolean);

{----------------------------------------------------------------------}
implementation

const
  crcstr:array[crctype] of string[7]=('SUM','CRC16','CRC32');
  gstr  :array[boolean] of string[2]=('','-g');
  SOH        = 1; (* ʕ *)
  STX        = 2;
  EOT        = 4;
  ACK        = 6;
  NAK        = $15;
  CAN        = $18;
  C          = $43;
  G          = $47;
  _PAD       = 42; (* ZMODEM ` *)
  _DLE       = 24;
  _DLEE      = 88;
  _BIN       = 65;
  _HEX       = 66;
  _BIN32     = 67;
  _RQINIT    = 0;
  _RINIT     = 1;
  _SINIT     = 2;
  _ACK       = 3;
  _FILE      = 4;
  _SKIP      = 5;
  _NAK       = 6;
  _ABORT     = 7;
  _FIN       = 8;
  _RPOS      = 9;
  _DATA      = 10;
  _EOF       = 11;
  _FERR      = 12;
  _CRC       = 13;
  _CHALLENGE = 14;
  _COMPL     = 15;
  _CAN       = 16;
  _FREECNT   = 17;
  _COMMAND   = 18;
  _STDERR    = 19;
  _CRCE      = 104;
  _CRCG      = 105;
  _CRCQ      = 106;
  _CRCW      = 107;
  CANFDX     = $01;
  CANOVIO    = $02;
  CANBRK     = $04;
  CANCRY     = $08;
  CANLZW     = $10;
  CANFC32    = $20;
  _CBIN      = 1; { Use of ZF1 }
  _CNL       = 2;
  _CRESUM    = 3;
  _MNEW      = 1; { Use of ZF2 }
  _MCRC      = 2;
  _MAPND     = 3;
  _MCLOB     = 4;
  _MSPARS    = 5;
  _MDIFF     = 6;
  _MPROT     = 7;
  _TLZW      = 1; { Use of ZF3 , but not implemented. (compressions) }
  _TCRYPT    = 2;
  _TRLE      = 3;
  _CACK1     = 1; { Use of ZF4 , but don't know how to use it. }
  INI        = $4D; (* M-LINK ` *)
  ABT        = $41;
  ETR        = $45;
  EXT        = $1B;
  MED        = $0D;
  ACNT       = 10;
  C1970      = 2440588; (* Unix WԂ̌Œl used in jurian<->georgeian *)
  D0         = 1461;
  D1         = 146097;
  D2         = 1721119;

type
  headertype = array[0..4] of byte; { hdrtype & ZF3..ZF0 (ZP0..ZP3) }
  filbufptr  = ^filbuffer;

  function stri(x:word):string;
    var
      temp:string;
    begin
      str(x,temp);
      stri:=temp;
    end;

  procedure xmit(x:byte); assembler;
    asm
      mov al,x
      push ax
      call xmitchar
    end;

  function inbyte: byte; assembler;
    asm
      call recvchar
    end;

  function timedin: boolean; assembler;
    (* PbȓɎMf[^ΐ^ԂBused in X/Y/ZMODEM *)
    asm
      call gettcount
      mov cx,ax
   @1:push cx
      call inready
      pop cx
      cmp al,0
      jnz @2
      push cx
      push cx
      call calctcount
      pop cx
      cmp ax,word ptr seccnt
      jae @2
      push cx
      call cts
      pop cx
      cmp al,0
      jnz @1
   @2:call inready
    end;

  function Ztimedin:boolean; assembler;
    (* PUbȓɎMf[^ΐ^ԂBused in ZMODEM *)
    asm
      call gettcount
      mov cx,ax
   @1:push cx
      call inready
      pop cx
      cmp al,0
      jnz @2
      push cx
      push cx
      call calctcount
      mov bx,word ptr seccnt
      mov cl,4
      shl bx,cl
      pop cx
      cmp ax,bx
      jae @2
      push cx
      call cts
      pop cx
      cmp al,0
      jnz @1
   @2:call inready
    end;

  procedure calcCRC(data:byte); assembler;
  (*
    16bitcrc  vZ (XMODEM-crc) f=$1021
    32bitcrc  EvZ (CCITT-crc)  f=$edb88320
  *)
    asm
      xor ah,ah
      mov al,cn
      mov cl,2
      shl ax,cl
      mov bx,offset cnarg
      add bx,ax
      les bx,[bx]
      push es
      push bx
      mov cx,8
      mov dl,data
      mov al,crc16
      cmp header.cnargrec(es:[bx]).crcmode,al
      jz @16
      ja @32
   @s:add header.cnargrec(es:[bx]).chksum,dl   { checksum8 }
      pop bx
      pop es
      jmp @e
  @16:mov ax,header.cnargrec(es:[bx]).crc    { begin crc16 }
   @1:shl ax,1
      pushf
      shl dl,1
      jnc @2
      or ax,1
   @2:popf
      jnc @3
      xor ax,01021h
   @3:loop @1
      pop bx
      pop es
      mov header.cnargrec(es:[bx]).crc,ax
      jmp @e
  @32:les ax,header.cnargrec(es:[bx]).crc32    { begin crc32 }
      mov bx,es
      xor al,dl
   @5:shr bx,1
      rcr ax,1
      jnc @6
      xor bx,0edb8h
      xor ax,08320h
   @6:shl dl,1
      loop @5
      mov dx,bx
      pop bx
      pop es
      mov word ptr header.cnargrec(es:[bx]).crc32,ax
      mov word ptr header.cnargrec(es:[bx]).crc32+2,dx
   @e:
    end;

{  pascal ̃\[X }
{   var
      carry: boolean;
      i: byte;
    begin
      case cnarg[cn]^.crcmode of
        sum  : cnarg[cn]^.chksum := lo(cnarg[cn]^.chksum + data);
        crc16:with cnarg[cn]^ do begin
              for i := 0 to 7 do begin
                carry := (crc and $8000) <> 0;
                crc := crc shl 1;
                if (data and $80) <> 0 then crc := crc or $0001;
                if carry then crc := crc xor $1021;
                data := lo(data shl 1);
              end;
        end;
        crc32:with cnarg[cn]^ do begin
              crc32 := crc32 xor data;
              for i := 0 to 7 do begin
                carry := (crc32 and 1) <> 0;
                crc32 := crc32 shr 1;
                if carry then
                  crc32 := crc32 xor $edb88320;
                data := lo(data shl 1);
              end;
        end;
      end;
    end; }


  function takeCRC:longint;
    begin
      case cnarg[cn]^.crcmode of
        crc16:takeCRC:=cnarg[cn]^.crc;
        crc32:takeCRC:=cnarg[cn]^.crc32;
      end;
    end;

  function matchCRC:longint;
    begin
      case cnarg[cn]^.crcmode of
        crc16:matchCRC:=$0000;
        crc32:matchCRC:=$debb20e3;
      end;
    end;

  procedure clearCRC;
    begin
      case cnarg[cn]^.crcmode of
        sum  :cnarg[cn]^.chksum:=0;
        crc16:cnarg[cn]^.crc:=0;
        crc32:cnarg[cn]^.crc32:=$ffffffff;
      end;
    end;

  procedure sendcalc(ch : byte);
    begin
      xmit(ch);
      calcCRC(ch);
    end;

  procedure clearbuff;
    var i:integer;
    begin
      for i:=0 to 127 do cnarg[cn]^.filebuff[0,i]:=0;
    end;

  procedure clearline; assembler;
    asm
   @1:call timedin
      cmp al,0
      jz @e
      call inbyte
      jmp @1
   @e:
    end;

  function CheckTimeOver: boolean;
    var
      usehour, usemin, usesec, usetime  : integer;
    begin
      calcconnect(usehour, usemin, usesec);
      usetime := usehour*60 + usemin;
      if usetime>timelimit[cnarg[cn]^.access] then CheckTimeOver := true
      else CheckTimeOver := false;
    end;

  procedure acknak(var inch: byte; time: integer);
  (*timebȉ̃R[h҂B^CAEg or ؂ȂOԂB
@@ACK, NAK, CAN, C, G, INI, ABT, ETR, EXT, MED *)
    var loop, loopend, i: integer;
    begin
      loopend := ACNT * time;
      loop := 0;
      inch := 0;
      repeat
        waiting(seccnt div 10);   {wait 0.1sec}
        if inready then inch:=inbyte;
        inc(loop);
      until (inch in [ACK, NAK, CAN, C, G, INI, ABT, ETR, EXT, MED]) or
        (loop >= loopend) or not cts;
    end;

  function acknakout(ch : byte): boolean;
    var  times, loops: integer;
    begin
      times:=0;
      repeat
        loops:=0;
        xmit(ch);
        while (loops<10) and not timedin do inc(loops);
        inc(times);
      until inready or (times>9) or not cts;
      acknakout:=inready and cts;
    end;

{ ------------------- }

function send1block(blkunit:byte;blocknum:integer):shortint;
  (*PubN(=blkunit)AUgR[hmFANAKȂđB
  @0:ACK  9:CAN or PO񃊃gCĂ_ or ؂ *)
  var
    tries       : byte;
    wk          : byte;
    inch, loop  : byte;
  begin
    cnarg[cn]^.CnStat := zfileprotocol;
    if hoststat = 0 then dispstatus(cn);
    tries := 0;
    repeat
      inc(tries);
      if blkunit = 1 then xmit(SOH)
      else xmit(STX);
      xmit(lo(blocknum));
      xmit($FF-lo(blocknum));
      clearCRC;
      for wk := 1 to blkunit do begin
        for loop := 0 to 127 do begin
          sendcalc(cnarg[cn]^.filebuff[wk-1,loop]);
          TransferNext;
        end;
      end;
      calcCRC(0);
      calcCRC(0);
      if cnarg[cn]^.crcmode=crc16 then begin
        xmit(hi(cnarg[cn]^.crc));
        xmit(lo(cnarg[cn]^.crc));
      end
      else begin xmit(cnarg[cn]^.chksum);  end;
      if not cnarg[cn]^.g_option then acknak(inch, 10)
      else if inready then inch := inbyte
      else inch := ACK;
      if tries = 5 then cnarg[cn]^.crcmode := crc16;
    until (inch = ACK) or (inch = CAN) or (tries = 10) or not cts;
    if cts and (inch = ACK) then send1block := 0
    else send1block := 9;
    cnarg[cn]^.CnStat := zfile;
    if hoststat = 0 then dispstatus(cn);
  end;

  function recchar(var error: boolean): byte;
    (* error͂PbȓɃf[^΋U *)
    var temp: byte;
    begin
      if not cts then error := true
      else begin
        if not timedin then error:=true
        else begin
          temp:=inbyte;
          calcCRC(temp);
          recchar:=temp;
        end;
      end;
    end;

procedure Xdownload(var successful: boolean);
  var
      inch, loop: byte;
      blocknum  : integer;
      temp      : string;
      rslt      : shortint;
      wk        : byte;
      done      : boolean;
      tries     : byte;
      fnam      : string;
  begin
    assignM(cnarg[cn]^.dllist[0].fnam);
    {$I-} resetM {$I+};
    if IOresult = 0 then begin
      stringout('[32mXMODEM');
      if cnarg[cn]^.crcmode=crc16 then
        if cnarg[cn]^.blkunit=8 then stringout(' (CRC/1024)')
        else stringout(' (CRC/128)')
      else stringout(' (SUM/128)');
      lineout('[36m Ń_E[h܂B[m');
      lineout('[33mCTRL-X Œf[m');
      flowctrl(false);
      flushed;
      done   := false;
      rslt   := 0;
      blocknum := 0;
      cnarg[cn]^.crcmode:=sum;
      acknak(inch, 60);
      if inch=0 then inch:=CAN;
      if inch=C then cnarg[cn]^.crcmode:=crc16;  (* Ǒ葤ɍ킹*)
      repeat
        if rslt = 0 then begin
          if eofM then done := true
          else begin
            wk := 0;
            while (wk < cnarg[cn]^.blkunit) and not eofM do begin
              inc(wk);
              blockreadM(cnarg[cn]^.filebuff[wk-1], 1);
            end;
            if eofM and (wk=1) and (cnarg[cn]^.RecCount=0) then done:=true
            else begin
              if hoststat=cn then
                write(cr+'XMODEM '+crcstr[cnarg[cn]^.crcmode]+' (',
                cnarg[cn]^.blkunit*128,') Sent #',blocknum:4);
              inc(blocknum);
            end;
          end;
        end;
        if (inch <> CAN) and cts and not done then begin
          rslt := send1block(cnarg[cn]^.blkunit, blocknum);
        end;
        if done then rslt := 1;
      until (inch = CAN) or (rslt <> 0);
      successful := (rslt = 1);
      tries := 0;
      if successful and cts then repeat
        xmit(EOT);
        acknak(inch, 60);
        inc(tries);
      until (inch=ACK) or (tries > 10) or not cts;
      if cts and (inch <> CAN) and not successful then xmit(CAN);
      closeM;
      lineout('');
    end
    else begin
      lineout('[31mCan''t find '+cnarg[cn]^.filedat.title+' ![m');
      successful := false;
    end;
    flushed;
    flowctrl(true);
  end;

procedure Ydownload(var successful: boolean);
  procedure setYheader(ft:DLlistType);
    var
      i, p  : byte;
      c     : char;
      tmp   : string[64];
      D2    : dirstr;
      N2    : namestr;
      E2    : extstr;
  begin
    clearbuff;
    p := 0;
    tmp:=ft.fnam;
    FSplit(tmp,D2,N2,E2);
    tmp:=N2+E2;
    for i := 1 to length(tmp) do begin
      c := tmp[i];
      if c in ['A'..'Z'] then c := char(ord(c)+$20);
      cnarg[cn]^.filebuff[0,p] := ord(c);
      inc(p);
    end;
    inc(p);
    str(filesizeM shl 7, tmp);
    for i := 1 to length(tmp) do begin
      c := tmp[i];
      cnarg[cn]^.filebuff[0,p] := ord(c);
      inc(p);
    end;
  end;
  var
    inch, loop: byte;
    blocknum  : integer;
    temp      : string;
    rslt      : shortint;
    wk        : byte;
    done      : boolean;
    tries     : byte;
    g_work    : boolean;
    i         : byte;
    fnam      : string;
  begin
    i := 0;
    if cnarg[cn]^.batchmode then i:=1;
    stringout('[32mYMODEM');
    if cnarg[cn]^.g_option then stringout('-g');
    if cnarg[cn]^.batchmode then stringout(' (Batch)');
    lineout('[36m Ń_E[h܂B[m');
    lineout('[33mCTRL-X Œf[m');
    flowctrl(false);
    flushed;
    repeat
      assignM(cnarg[cn]^.dllist[i].fnam);
      {$I-} resetM {$I+};
      if IOresult = 0 then begin
        done   := false;
        rslt   := 0;
        blocknum := 0;
        acknak(inch, 60);
        if inch = 0 then inch := CAN;
        if      inch = G then cnarg[cn]^.g_option := true
        else if inch = C then cnarg[cn]^.g_option := false
        else                  rslt     := 9;
        repeat
          if rslt = 0 then begin
            if blocknum = 0 then setYheader(cnarg[cn]^.dllist[i])
            else if eofM then done := true
            else begin
              wk := 0;
              while (wk < 8) and not eofM do begin
                inc(wk);
                blockreadM(cnarg[cn]^.filebuff[wk-1], 1);
              end;
              if eofM and (wk = 1) and (cnarg[cn]^.RecCount = 0) then
                done := true;
            end;
          end;
          if (inch <> CAN) and cts and not done then begin
            if blocknum = 0 then begin
              rslt := send1block(1, blocknum);
              acknak(inch, 10);
            end
            else begin
              rslt := send1block(8, blocknum);
            end;
          end;
          if rslt = 0 then begin
            if hoststat = cn then write(cr+'YMODEM'+gstr[cnarg[cn]^.g_option]+
              ' Sent #', blocknum:4);
            inc(blocknum);
          end;
          if done then rslt := 1;
        until (inch = CAN) or (rslt <> 0) or not cts;
        successful := (rslt = 1);
        tries := 0;
        if successful and cts then repeat
          if not boolean(tries) and (hoststat=cn) then begin
            writeln;writeln(' EOT sent.');
          end;
          xmit(EOT);
          acknak(inch, 60);
          inc(tries);
        until (inch=ACK) or (tries > 10) or not cts;
        closeM;
        cnarg[cn]^.dllist[i].rslt := true;
        inc(i);
      end
      else begin
        if cts then xmit(CAN);
        flushed;
        flowctrl(true);
        waiting(seccnt);
        lineout('[31mCannot find: '+cnarg[cn]^.dllist[i].fnam+'[m');
        successful := false;
      end;
    until (i > cnarg[cn]^.dlnum) or not successful or
      not cnarg[cn]^.batchmode or CheckTimeOver or not cts;
    if cts and cnarg[cn]^.batchmode and successful then begin
      acknak(inch, 10);
      clearbuff;
      rslt := send1block(1, 0);
    end;
    if cts and (inch <> CAN) and not successful then xmit(CAN);
    flushed;
    flowctrl(true);
    waiting(seccnt);
  end;


{----------- zmodem support routine -------------}

  procedure gregoriantojulian(year,month,day:integer;var julian:longint);
    var
      century,Xyear : longint;
    begin
      If month<=2 then begin
        year:=pred(year);
        month:=month+12;
      end;
      month:=month-3;
      century:=year div 100;
      Xyear:=year mod 100;
      century:=(century*D1) shr 2;
      Xyear:=(Xyear*D0) shr 2;
      julian:=((((month*153)+2) div 5)+day)+D2+Xyear+century;
    end;

  procedure juliantogregorian(julian:longint;var year,month,day:integer);
    var
      temp,Xyear        : longint;
      Yyear,Ymonth,Yday : integer;
    begin
      temp:=(((julian-D2) shl 2)-1);
      Xyear:=(temp mod D1) or 3;
      julian:=temp div D1;
      Yyear:=(Xyear div D0);
      temp:=((((Xyear mod D0)+4) shr 2)*5)-3;
      Ymonth:=temp div 153;
      if Ymonth>=10 then begin
        Yyear:=Yyear+1;
        Ymonth:=Ymonth-12;
      end;
      month:=Ymonth+3;
      Yday:=temp mod 153;
      day:=(Yday+5) div 5;
      year:=Yyear+(julian*100);
    end;

  function Ztounixdate(fdate:longint):string;
    var
      dt : dos.datetime;
      secspast, datenum, dayspast : longint;
      s  : string;
    begin
      unpacktime(fdate,dt);
      gregoriantojulian(dt.year,dt.month,dt.day,datenum);
      dayspast:=datenum-c1970;
      secspast:=dayspast*86400;
      secspast:=secspast+dt.hour*3600+dt.min*60+dt.sec;
      s:='';
      while (secspast<>0) AND (length(s)<255) do begin
        s:=chr((secspast and 7)+$30)+s;
        secspast:=(secspast shr 3)
      end;
      s:='0'+s;
      Ztounixdate:=s
    end;

  function Zfromunixdate(s:string):longint;
    var
      dt : dos.datetime;
      secspast, datenum : longint;
      n  : word;
    begin
      secspast:=0;
      for n:=1 to length(s) do
        secspast:=(secspast shl 3)+ord(s[n])-$30;
      datenum:=(secspast div 86400)+c1970;
      juliantogregorian(datenum,integer(dt.year),
        integer(dt.month),integer(dt.day));
      secspast:=secspast mod 86400;
      dt.hour:=secspast div 3600;
      secspast:=secspast mod 3600;
      dt.min:=secspast div 60;
      dt.sec:=secspast mod 60;
      packtime(dt,secspast);
      Zfromunixdate:=secspast
   end;

  procedure Zmakepackedheader(htype:byte;datas:longint;var hdr:headertype);
    assembler;
    asm
      push ds
      lds bx,hdr
      mov al,htype
      mov [bx],al
      les ax,datas
      mov dx,es
      mov [bx+1],al
      mov [bx+2],ah
      mov [bx+3],dl
      mov [bx+4],dh
      pop ds
    end;

  function Zmakeunpackedheader(hdr:headertype):longint; assembler;
    asm
      les bx,hdr
      mov al,es:[bx+1]
      mov ah,es:[bx+2]
      mov dl,es:[bx+3]
      mov dh,es:[bx+4]
    end;

  function ZcheckfileCRC(crcreq:longint):longint;
    { C:Seishi      dlقȂĂ }
    var
      dumy:byte;
      loop:word;
      fbuf:filbuffer;
      len :integer;
      success:boolean;
    begin {$I-}
      clearCRC;
      seekM(0);
      dec(crcreq);
      repeat
        for loop:=0 to 9 do Transfernext;
        blockreadM(fbuf,1);
        len:=cnarg[cn]^.RecCount;
        if len>crcreq then len:=crcreq;
        for loop:=0 to len-1 do calcCRC(fbuf[loop]);
        dec(crcreq,len);
      until (crcreq=0) or (len=0);
      seekM(0);
      ZcheckfileCRC:=not takeCRC;
    end; {$I+}

  procedure Zcancel;
    var
      loop:byte;
    begin
      flushed;
      for loop:=0 to 7 do begin
        xmit(CAN);
        waiting(seccnt div 10);
      end;
      for loop:=0 to 7 do xmit(8); { backspaces }
    end;

  procedure Zsendstring(p:string);
    var
      loop:word;
    begin
      for loop:=1 to length(p) do begin
        case p[loop] of
          #221 : begin end; { Not support send break }
          #222 : waiting(seccnt*2);
          else   xmitchar(p[loop]);
        end;
      end;
    end;

  procedure Zsendhex(b:byte);
    const
      hex:array[0..15] of char='0123456789abcdef';
    begin
      xmitchar(hex[b shr 4]);   { ASCII hex code output }
      xmitchar(hex[b and $0F]);
    end;

  procedure Zsendhexheader(header:headertype);
    var
      loop:byte;
      bkup:crctype;
    begin
      bkup:=cnarg[cn]^.crcmode;
      cnarg[cn]^.crcmode:=crc16;
      xmit(_PAD);
      xmit(_PAD);
      xmit(_DLE);
      xmit(_HEX);
      clearCRC;
      for loop:=0 to 4 do begin
        Zsendhex(header[loop]);
        calcCRC(header[loop]);
      end;
      calcCRC(0);
      calcCRC(0);
      Zsendhex(lo(cnarg[cn]^.crc shr 8));
      Zsendhex(lo(cnarg[cn]^.crc));
      xmit(13); xmit(10);
      cnarg[cn]^.crcmode:=bkup;
    end;

  function ZcatchZDL(var err:boolean):word; assembler;
    asm
      les bx,err
      xor al,al
      cmp es:[bx],al
      jnz @x
      call Ztimedin
      cmp al,0
      jz @x
      call inbyte
      xor ah,ah
      cmp al,_DLE
      jnz @e
      call timedin
      cmp al,0
      jz @x
      call inbyte
      cmp al,CAN
      jz @2
      cmp al,_CRCE
      jb @3
      cmp al,_CRCW
      ja @3
   @2:mov ah,1
      jmp @e
   @3:mov bl,60h
      and bl,al
      cmp bl,40h
      jnz @x
      xor ah,ah
      xor al,40h
      jmp @e
   @x:or al,1
      les bx,err
      mov es:[bx],al
   @e:
    end;

 (* var
      temp:byte;
    begin
      if not err and Ztimedin then begin
        temp:=inbyte;
        if temp<>_DLE then begin
          ZcatchZDL:=temp;
          exit;
        end;
        if timedin then begin
          temp:=inbyte;
          case temp of
            CAN,_CRCE,_CRCG,_CRCQ,_CRCW :
              ZcatchZDL:=word(temp) or $0100; { sequense character }
            else if (temp and $60)=$40 then begin
              temp:=temp xor $40;   { decode }
              ZcatchZDL:=temp;
            end
            else err:=true;
          end;
        end
        else err:=true;
      end
      else err:=true;
    end; *)

  function Zgethex(var err:boolean):byte;
    var
      temp:byte;
      loop:byte;
      rx  :string;
      dumy:integer;
    begin
      if not err and timedin then begin
        rx:='$'+recvchar;
        if timedin then rx:=rx+recvchar else err:=true;
        val(rx,temp,dumy);
        err:=boolean(dumy);
      end
      else err:=true;
      Zgethex:=temp;
    end;

  procedure Zgethexheader(var header:headertype;var err:boolean);
    var
      loop:byte;
      temp:byte;
      dumy:char;
    begin
      clearCRC;
      for loop:=0 to 4 do begin        { Ztype and four Zflags }
        header[loop]:=Zgethex(err);
        calcCRC(header[loop]);
      end;
      for loop:=0 to 1 do begin
        temp:=Zgethex(err);
        calcCRC(temp); { CRC check }
      end;
      if takeCRC<>matchCRC then err:=true;
      for loop:=0 to 1 do
        if timedin then dumy:=recvchar { CR/LF receive }
    end;

  procedure Zgetbinheader(var header:headertype;var err:boolean);
    var
      loop:byte;
      temp:word;
      dumy:byte;
    begin
      clearCRC;
      loop:=0;
      repeat        { Ztype and four Zflags }
        temp:=ZcatchZDL(err);
        if temp<256 then begin
          header[loop]:=byte(temp);
          calcCRC(byte(temp));
        end
        else err:=true;
        inc(loop);
      until (loop=5) or err or not cts;
      loop:=0;
      if cnarg[cn]^.crcmode=crc16 then begin
        repeat
          temp:=ZcatchZDL(err);
          if temp<256 then calcCRC(byte(temp))
          else err:=true;
          inc(loop);
        until (loop=2) or err or not cts;
      end
      else begin
        repeat
          temp:=ZcatchZDL(err);
          if temp<256 then calcCRC(byte(temp))
          else err:=true;
          inc(loop);
        until (loop=4) or err or not cts;
      end;
      if takeCRC<>matchCRC then err:=true;
    end;

  function Zgetheader(var header:headertype;var num:longint;
    var err:boolean):byte;
    (* f܂ :-) *)
    var
      temp    :byte;
      loop    :byte;
      pass    :boolean;
      bkup    :crctype;
      cancount:byte;
    begin
      err:=false;
      pass:=false;
      bkup:=cnarg[cn]^.crcmode;
      cnarg[cn]^.crcmode:=crc16;
      cancount:=2;
      repeat
        if Ztimedin then temp:=inbyte else err:=true;
        case temp of
          _PAD : begin  (* n߂ɂPȏ ZPAD ('*') 󂯂 *)
                 pass:=true;
          end;
          _DLE : begin  (* ZPAD ̎ɗȂƖ *)
                 if pass then begin
                   if timedin then temp:=inbyte
                   else err:=true;  (* ^X ̒f͂ƌ (ZDLE=CAN) *)
                   case temp of
                     _BIN   : begin
                              Zgetbinheader(header,err);
                     end;
                     _BIN32 : begin  { use in CRC32bit mode }
                              cnarg[cn]^.crcmode:=crc32;
                              Zgetbinheader(header,err);
                     end;
                     _HEX   : begin
                              Zgethexheader(header,err);
                     end;
                     CAN    : header[0]:=CAN;  (* A ^X (Ų) *)
                     else     pass:=false;
                   end;
                 end
                 else begin
                   dec(cancount);
                   if cancount=0 then header[0]:=CAN
                   else temp:=$00;
                 end;
          end
          else begin
            cancount:=2;
            pass:=false;
          end;
        end;
      until (temp in [CAN,_BIN,_BIN32,_HEX]) or err or not cts;
      if err then header[0]:=_CAN
      else num:=Zmakeunpackedheader(header);
      cnarg[cn]^.crcmode:=bkup;
      Zgetheader:=temp;
    end;

  procedure Zsendbyte(b:byte);
    begin
      if ((b and $7F) in [16,17,19,24]) or
        (((b and $7F)=13) and ((cnarg[cn]^.lastsent and $7F)=$40)) then begin
        xmit(_DLE);         { pers character }
        cnarg[cn]^.lastsent:=b xor $40; { encode }
      end
      else cnarg[cn]^.lastsent:=b;
      xmit(cnarg[cn]^.lastsent);
    end;

  procedure Zsendbinheader(header:headertype);
    var
      loop:byte;
    begin
      clearCRC;
      xmit(_PAD);
      xmit(_DLE);
      if cnarg[cn]^.crcmode=crc16 then loop:=_BIN else loop:=_BIN32;
      xmit(loop);
      for loop:=0 to 4 do begin
        Zsendbyte(header[loop]);
        calcCRC(header[loop]);
      end;
      if cnarg[cn]^.crcmode=crc16 then begin
        calcCRC(0);
        calcCRC(0);
        Zsendbyte(byte(cnarg[cn]^.crc shr 8));
        Zsendbyte(byte(cnarg[cn]^.crc));
      end
      else begin
        cnarg[cn]^.crc32:=not cnarg[cn]^.crc32;
        for loop:=0 to 3 do begin
          Zsendbyte(byte(cnarg[cn]^.crc32));
          cnarg[cn]^.crc32:=cnarg[cn]^.crc32 shr 8;
        end;
      end;
    end;

(* AƂ.. *)
{----------- end of zmodem support -------------}


procedure Zdownload(var successful: boolean);
  var
    i        : byte;
    retry    : byte;
    blocknum : longint;  (* oCgP *)
    temp     : string;
    rslt     : byte;
    fnam     : string;
    pack     : headertype;
  procedure Zsenddata(p:filbufptr;count:word;frame:byte);
    var
      loop:word;
      blk :word;
    begin
      clearCRC;
      cnarg[cn]^.CnStat:=zfileprotocol;
      if hoststat = 0 then dispstatus(cn);
      blk:=0;
      while (blk<count) and cts do begin
        Zsendbyte(p^[blk]);
        calcCRC(p^[blk]);
        inc(blk);
      end;
      xmit(_DLE);   (* Zp[^ *)
      xmit(frame);  (* CRC    *)
      calcCRC(frame);
      if cnarg[cn]^.crcmode=crc16 then begin
        calcCRC(0);
        calcCRC(0);
        Zsendbyte(lo(cnarg[cn]^.crc shr 8));
        Zsendbyte(lo(cnarg[cn]^.crc));
      end
      else begin
        cnarg[cn]^.crc32:=not cnarg[cn]^.crc32;
        for loop:=0 to 3 do begin
          Zsendbyte(byte(cnarg[cn]^.crc32));
          cnarg[cn]^.crc32:=cnarg[cn]^.crc32 shr 8;
        end;
      end;
      cnarg[cn]^.CnStat:=zfile;
      if hoststat = 0 then dispstatus(cn);
      if frame=_CRCW then begin
        xmit(17);
        waiting(seccnt div 4);
      end;
    end;
  function Zendsend:boolean;
    var
      temp:headertype;
      test:boolean;
      dumy:longint;
    begin
      test:=false;
      dumy:=0;
      cnarg[cn]^.crcmode:=crc16;
      Zmakepackedheader(_FIN,dumy,temp);
      Zsendbinheader(temp);
      dumy:=Zgetheader(temp,dumy,test);
      if temp[0]<>_FIN then test:=true;
      Zendsend:=not test;
    end;
  function Zgetrecvinfo(var err:boolean):byte;
    var
      loop:byte;
      temp:headertype;
      test:boolean;
      dumy:longint;
      dumy2:byte;
    begin
      loop:=8;
      test:=false;
      repeat
        dumy2:=Zgetheader(temp,dumy,err);
        case temp[0] of
          _CHALLENGE:begin  (* ̃pPbgȂ *)
                     Zmakepackedheader(_ACK,blocknum,temp);
                     Zsendhexheader(temp);  (* ZACK Ԃ΂炵 *)
          end;
          _COMMAND  :begin  (* 悭Ȃ *)
                     Zmakepackedheader(_RQINIT,0,temp);
                     Zsendhexheader(temp);  (*  ZRQINIT  *)
          end;
          _RINIT    :begin  (* t@C] *)
                     Zgetrecvinfo:=_RINIT;
                     cnarg[cn]^.crcmode:=crc16;
                     if (temp[4] and CANFC32)>0 then
                       cnarg[cn]^.crcmode:=crc32;
                     test:=true;
          end;
          _RQINIT   :begin end; { pass it }
          CAN,_CAN  :begin
                     Zgetrecvinfo:=temp[0];
                     test:=true;
          end
          else begin  (* 󂯎pPbgs *)
                     Zmakepackedheader(_NAK,0,temp);  (* đv *)
                     Zsendhexheader(temp);
          end;
        end;
        dec(loop);
      until test or (loop=0) or err or not cts;
      err:=not test or err;
    end;
  function Zsyncrecv(var err:boolean):byte;
    var
      loop:byte;
      temp:headertype;
      test:boolean;
      error:boolean;
      dumy:byte;
    begin
      loop:=8;
      test:=false;
      if not err then repeat
        dumy:=Zgetheader(temp,blocknum,error);
        if error then dec(loop)
        else case temp[0] of
          _CAN,_ABORT,_FIN : err:=true; (* Ȃ̒m :-) *)
          _RPOS : begin  (* G[̂߁Aʒu␳ *)
                  {$I-} seekM(blocknum div 128); {$I+}
                  if ioresult>0 then begin
                    err:=true;
                    Zmakepackedheader(_FERR,0,temp);
                    Zsendhexheader(temp);
                  end
                  else begin
                    Zsyncrecv:=_RPOS;
                    test:=true;
                  end;
          end;
          CAN,_SKIP,_RINIT,_ACK : begin  (* CAN,ZSKIP,ZRINIT,ZACK ͑fʂ *)
                  Zsyncrecv:=temp[0];
                  test:=true;
          end;
          else begin  (* 󂯎pPbgs *)
                  Zmakepackedheader(_NAK,0,temp); (* đv *)
                  Zsendbinheader(temp);
          end;
        end;
        dec(loop);
      until test or (loop=0) or err or not cts;
      if loop=0 then err:=true;
    end;
  function Zsendfiledata(var err:boolean):byte;
    var
      loop:word;
      temp:byte;
      pack:headertype;
      test:boolean;
      frame:byte;
      retry:byte;
    begin
      flushed;
      clearline;
      retry:=10; (* đMPO *)
      if not err then repeat
        if eofM or inready then begin
          repeat
            temp:=Zsyncrecv(err);
            if temp=_RPOS then begin  (* G[fBeNgiʒu␳j*)
              dec(retry);
              if retry=0 then begin      (* PO̊ԂɐȂ *)
                err:=true;
              end
              else begin
                flushed;
              end;
            end
            else begin
              if temp<>CAN then retry:=10;
              case temp of
                _ACK  : begin end; { pass it }
                _SKIP : begin
                        Zsendfiledata:=_SKIP;
                        exit;
                end;
                _RINIT: begin
                        Zsendfiledata:=0;
                        exit;
                end
                else err:=true;
              end;
            end;
          until (temp in [_ACK,_RPOS]) or err or not cts;
        end;
        Zmakepackedheader(_DATA,blocknum,pack);
        Zsendbinheader(pack);
        if not err then repeat
          loop:=0;
          while not eofM and (loop<8) and not err and cts do begin
            {$I-} blockreadM(cnarg[cn]^.filebuff[loop],1); {$I+}
            err:=boolean(ioresult);
            inc(blocknum,128);
            inc(loop);
          end;
          if eofM then frame:=_CRCE
          else frame:=_CRCG;
          Zsenddata(filbufptr(@cnarg[cn]^.filebuff),loop*128,frame);
          if hoststat=cn then write(cr+'ZMODEM '+
            crcstr[cnarg[cn]^.crcmode]+' (1024) Sent #',(blocknum div 1024):4);
        until (frame<>_CRCG) or inready or err or not cts;
        if not err and (frame=_CRCE) then begin
          Zmakepackedheader(_EOF,blocknum,pack);
          Zsendbinheader(pack);
          if hoststat=cn then begin
            writeln;writeln(' EOF sent.');
          end;
        end;
      until err or not cts;
    end;
  function Zsendfile(var err:boolean):byte;
    var
      loop:byte;
      temp:headertype;
      test:boolean;
      dumy:byte;
    begin
      if not err then repeat
        dumy:=Zgetheader(temp,blocknum,err);
        case temp[0] of
          _CAN,_FIN,_ABORT : err:=true;
          _CRC  : begin    { C:Seishi     ZcheckfileCRC ύX̂ }
                  Zmakepackedheader(_CRC,ZcheckfileCRC(blocknum),temp);
                  Zsendhexheader(temp);
          end;
          _SKIP : begin
                  Zsendfile:=_SKIP;
                  exit
          end;
          _RPOS : begin  (* ߂̈ʒu (for ZMODEM resume) *)
                  {$I-} seekM(blocknum div 128); {$I+}
                  if ioresult>0 then begin
                    err:=true;
                    Zmakepackedheader(_FERR,0,temp);
                    Zsendhexheader(temp);
                  end
                  else begin
                    Zsendfile:=Zsendfiledata(err);  { main transfer }
                    exit
                  end;
          end;
        end;
      until (temp[0]<>_RINIT) or err or not cts;
    end;
  procedure setZheader(ft:DLlistType);
    var
      i, p : byte;
      c    : char;
      tmp  : string;
      sdek : string;
      D2   : dirstr;
      N2   : namestr;
      E2   : extstr;
    begin
      clearbuff;
      p:=0;
      FSplit(ft.fnam,D2,N2,E2);
      tmp:=N2+E2+#$00;
      str(longint(filesizeM) shl 7,sdek);
      tmp:=tmp+sdek+' '+Ztounixdate(dt2bin(ft.time));
      for i:=1 to length(tmp) do begin
        c:=tmp[i];
        if c in ['A'..'Z'] then c:=char(ord(c)+$20);
        cnarg[cn]^.filebuff[0,p]:=ord(c);
        inc(p);
      end;
    end;
  begin  { of Zdownload }
    (* ƁAG߂₵܂H Omen Technology inc. ....         *)
    (* ƂĂk܂ŃT|[goȂB܂ŗĂCĂ :-) *)
    i:=0;
    if cnarg[cn]^.batchmode then i:=1;
    stringout('[32mZMODEM');
    if cnarg[cn]^.batchmode then stringout(' (Batch)');
    lineout('[36m Ń_E[h܂B[m');
    lineout('[33mCTRL-X Œf[m');
    flowctrl(false);
    flushed;
    cnarg[cn]^.lastsent:=0;
    repeat
      assignM(cnarg[cn]^.dllist[i].fnam);
      {$I-} resetM {$I+};
      if ioresult=0 then begin
        blocknum:=0; { not resume }
        retry:=4;  (* ^CI[o[ׂ̈ɂS҂ *)
        repeat
          temp:='rz'+#13;
          Zsendstring(temp);
          Zmakepackedheader(_RQINIT,0,pack);
          Zsendhexheader(pack);
          rslt:=Zgetrecvinfo(successful);
          successful:=not successful;
          dec(retry);
        until (rslt=CAN) or (retry=0) or successful or not cts;
        if successful and (rslt=_RINIT) then begin
          successful:=false;
          setZheader(cnarg[cn]^.dllist[i]);
          Zmakepackedheader(_FILE,0,pack);
          pack[4]:=_CRESUM;
          Zsendbinheader(pack);
          Zsenddata(filbufptr(@cnarg[cn]^.filebuff),128,_CRCW);
          successful:=false;
          rslt:=Zsendfile(successful); { main }
          successful:=not successful; (* ݼ޹ װЂԂ *)
          if successful then begin
            cnarg[cn]^.dllist[i].rslt:=true;
            inc(i);
          end
          else Zcancel;
        end
        else begin  (* ѵްiZMODEM ̋Nxj ݾ *)
          successful:=false;
        end;
        closeM;
      end
      else begin
        Zcancel;
        flushed;
        flowctrl(true);
        waiting(seccnt);
        lineout('[31mCannot find: '+cnarg[cn]^.dllist[i].fnam+'[m');
        successful:=false;
      end;
    until (i>cnarg[cn]^.dlnum) or not successful or
      not cnarg[cn]^.batchmode or CheckTimeOver or not cts;
    if successful then begin
      successful:=Zendsend;
      temp:='OO';
      Zsendstring(temp);
    end;
    clearline;
    flowctrl(true);
    waiting(seccnt);
  end;

procedure Mdownload(var successful: boolean);
  procedure setMheader(ft:DLlistType);
    var
      i, p  : byte;
      c     : char;
      tmp   : string[64];
      dttm  : string[32];
      D2    : dirstr;
      N2    : namestr;
      E2    : extstr;
    begin
      tmp:=ft.fnam;
      FSplit(tmp,D2,N2,E2);
      tmp:=N2+E2;
      for i := 1 to length(tmp) do begin
        c := tmp[i];
        xmit(byte(c));
      end;
      xmit($20);
      str(filesizeM shl 7, tmp);
      for i := 1 to length(tmp) do xmit(byte(tmp[i]));
      xmit($20);
      dttm:='19'+ft.time;
      for i := 1 to length(dttm) do xmit(byte(dttm[i]));
      xmit($0D);
    end;
  var
    i         : byte;
    inch      : byte;
    blocknum  : integer;
    temp      : string;
    rslt      : shortint;
    wk        : byte;
    wk1       : byte;
    wk2       : byte;
    fs        : word;
    fnam      : string;
    error     : boolean;
  begin
    i:=0;
    if cnarg[cn]^.batchmode then i:=1;
    stringout('[32mM-LINK');
    if cnarg[cn]^.batchmode then stringout(' (Batch)');
    lineout('[36m Ń_E[h܂B[m');
    lineout('[33mCTRL-X Œf[m');
    flowctrl(false);
    flushed;
    repeat
      blocknum := 0;
      rslt:=0;
      assignM(cnarg[cn]^.dllist[i].fnam);
      {$I-} resetM {$I+};
      if ioresult>0 then rslt:=8;
      if (rslt=0) and not cnarg[cn]^.dllist[i].rslt then begin
        acknak(inch, 60);
        if cts and (inch =ord(INI)) then rslt:=0
        else rslt:= 9;
        if rslt = 0 then begin
          setMheader(cnarg[cn]^.dllist[i]);
          acknak(inch,10);
          wk:=0;
          fs:=filesizeM;
          if inch<>INI then rslt:=9
          else begin
            while cts and (fs>0) and (rslt=0) do begin
              cnarg[cn]^.CnStat:=zfileprotocol;
              if hoststat = 0 then dispstatus(cn);
              wk:=0;
              while (fs>0) and (wk<8) do begin
                blockreadM(cnarg[cn]^.filebuff[wk], 1);
                inc(wk);
                dec(fs);
              end;
              if wk>0 then
                for wk1:=0 to wk-1 do
                  for wk2:=0 to 127 do
                    xmit(cnarg[cn]^.filebuff[wk1,wk2]);
              cnarg[cn]^.CnStat:=zfile;
              if hoststat = 0 then dispstatus(cn);
              inc(blocknum);
              if hoststat = cn then
                write(cr + 'M-LINK Sent #', blocknum:4);
              if inready then begin
                inch:=inbyte;
                if (inch=ABT) or (inch=EXT) then rslt:=9;
              end;
            end;
            if cts and (rslt=0) then begin
              acknak(inch,10);
              if inch<>ETR then rslt:=9
              else begin
                if hoststat = cn then begin
                  writeln;writeln(' ETR received.');
                end;
                cnarg[cn]^.dllist[i].rslt:=true;
                inc(i);
              end;
            end;
          end;
        end;
        cnarg[cn]^.CnStat:=zfile;
        closeM;
      end;
      successful := (rslt = 0);
      if not successful then begin
        if cts then xmit(ABT);
        waiting(seccnt);
        flushed;
        flowctrl(true);
        if rslt=8 then
          lineout('[31mCannot find: '+cnarg[cn]^.dllist[i].fnam+'[m');
      end;
    until (i > cnarg[cn]^.dlnum) or not cnarg[cn]^.batchmode or
      CheckTimeOver or not successful or not cts;
    xmit(MED);
    acknak(inch, 60);
    waiting(seccnt);
    flushed;
    flowctrl(true);
    cnarg[cn]^.CnStat:=zfile;
    if hoststat = 0 then dispstatus(cn);
  end;

  procedure CONdownload(var successful:boolean);
    var
      temp:string;
      rslt:byte;
      i   :byte;
      fn  :string;
    begin
      lineoutifneed;
      cnarg[cn]^.prompt :=
        '[36m_E[h̃fBNg[m ([33m[RET]:quit[m) >';
      temp := allcaps(getinput(cnarg[cn]^.prompt,255,echo));
      rslt := 0;
      lineout('');
      i:=0;
      if not cnarg[cn]^.batchmode then with cnarg[cn]^.dllist[0] do begin
        fnam:=filedrive+'FILE'+stri(cnarg[cn]^.sect.number)+'\'+
              cnarg[cn]^.filedat.title;
        size:=cnarg[cn]^.filedat.size;
        time:=cnarg[cn]^.filedat.date;
        rslt:=false;
      end
      else i:=1;
      if temp<>'' then begin
        repeat
          stringout('[33m] [32m['+cnarg[cn]^.dllist[i].fnam+'] ...');
          cnarg[cn]^.cnstat := zfileprotocol;
          if hoststat = 0 then dispstatus(cn);
          FileCopy(cnarg[cn]^.dllist[i].fnam,temp,rslt);
          cnarg[cn]^.cnstat := zfile;
          if hoststat = 0 then dispstatus(cn);
          if rslt = 0 then begin
            cnarg[cn]^.dllist[i].rslt := true;
            lineout(' [33mI[m');
          end
          else lineout(' [31ms[m');
          inc(i);
        until (cnarg[cn]^.dlnum<i) or (rslt<>0) or not cnarg[cn]^.batchmode;
        successful := (rslt = 0);
      end
      else successful:=false;
    end;

function recv1block(var blkunit:byte; var blocknum:integer):shortint;
  (*PubNMBvgRG[ȂNAK𑗂ăgCB
    0:ok  1:EOF  (2:ERROR)  9:FATAL-ERROR *)
  var
    tries       : byte;
    locblock    : integer;
    rslt        : shortint;
    error       : boolean;
    opening     : byte;
    comp        : integer;
    wk          : byte;
    byteloc     : integer;
    crc2        : integer;
    hicrc, locrc: byte;
    csum2       : byte;
  begin
    cnarg[cn]^.CnStat := zfileprotocol;
    if hoststat = 0 then dispstatus(cn);
    locblock := blocknum;
    tries := 0;
    repeat
      inc(tries);
      rslt := 0;
      error := false;
      opening := recchar(error);
      if not error then case opening of
        CAN : rslt := 9;
        EOT : begin
              rslt := 1;
              if hoststat = cn then begin
                 writeln; writeln(' EOT received.');
              end;
              end;
        SOH, STX : begin
              if opening = SOH then blkunit := 1
              else if opening = STX then blkunit := 8;
              if cts then begin
                blocknum := recchar(error);
                comp := recchar(error);
                if (comp + blocknum = $FF) and not error then begin
                  clearCRC;
                  for wk := 1 to blkunit do begin
                    byteloc := 0;
                    while (byteloc < 128) and not error do begin
                      cnarg[cn]^.filebuff[wk-1,byteloc] := recchar(error);
                      inc(byteloc);
                    end;
                  end;
                  if cts and (rslt=0) and not error then begin
                    calcCRC(0); calcCRC(0);
                    crc2 := cnarg[cn]^.crc;
                    csum2 := cnarg[cn]^.chksum;
                    hicrc := recchar(error);
                    if cnarg[cn]^.crcmode=crc16 then begin
                      locrc := recchar(error);
                      if (lo(crc2) <> locrc) or (hi(crc2) <> hicrc) and
                        not error then rslt := 2;
                    end
                    else if csum2 <> hicrc then rslt := 2;
                    if (lo(locblock) <> blocknum) and
                      (lo(locblock) <> lo(blocknum+1)) then rslt := 9;
                  end;
                end
                else error := true;
              end; {if cts}
              end; {SOH,STX}
        else error := true;
      end; {case}
      if error then begin clearline; rslt := 2; end;
      if rslt = 2 then begin
        if (not cnarg[cn]^.g_option) and cts then begin
          if not acknakout(NAK) then rslt := 9;
        end
        else rslt := 9;
      end;
      if tries > 6 then cnarg[cn]^.crcmode := crc16;
    until (rslt=0) or (rslt=1) or (rslt=9);
    recv1block := rslt;
    cnarg[cn]^.CnStat := zfile;
    if hoststat = 0 then dispstatus(cn);
  end;

{$I-}
procedure Xupload(filename: string; var successful: boolean);
  var
    blocknum, byteloc : integer;
    locblock          : integer;
    opening           : byte;
    rslt, rslt1       : shortint;
    wk                : byte;
    temp              : string;
    fnam              : string;
  begin
    cnarg[cn]^.g_option := false;
    stringout('[32mXMODEM');
    if cnarg[cn]^.crcmode=crc16 then
      if cnarg[cn]^.blkunit=8 then stringout(' (CRC/1024)')
      else stringout(' (CRC/128)')
    else stringout(' (SUM/128)');
    lineout('[36m ŃAbv[h܂B[m');
    lineout('[33mCTRL-X Œf[m');
    flowctrl(false);
    flushed;
    locblock := 1;
    assignM(filename);
    rewriteM;
    rslt := ioresult; if rslt <> 0 then rslt := 9;
    if cnarg[cn]^.crcmode=crc16 then opening := C
    else opening := NAK;
    if cts and (rslt = 0) then begin
      if acknakout(opening) then rslt := 0
      else rslt := 9;
    end;
    while cts and (rslt <> 1) and (rslt <> 9) do begin
      blocknum := locblock;
      rslt := recv1block(cnarg[cn]^.blkunit, blocknum);
      if (lo(locblock) = blocknum) and (rslt <= 1) then begin
        for wk := 1 to cnarg[cn]^.blkunit do
          blockwriteM(cnarg[cn]^.filebuff[wk-1], 1);
        if hoststat = cn then
          write(cr+'XMODEM '+crcstr[cnarg[cn]^.crcmode]+' (',
          cnarg[cn]^.blkunit*128,') Received #',blocknum:4);
        rslt1 := ioresult; if rslt1 <> 0 then rslt := 9;
        inc(locblock);
      end;

{     if rslt = 9 then flushed    C:Seishi
      else clearline;                  ubNɑ҂邽߁B }
      if rslt = 9 then flushed;

      if rslt = 0 then begin
        if acknakout(ACK) then begin
          rslt := 0;
        end
        else rslt := 9;
      end;
    end; {while}
    case rslt of
      9:xmit(CAN);
      1:begin
        if hoststat = cn then begin
          writeln;writeln(' EOT received.');
        end;
        xmit(ACK);
      end;
    end;
    successful := (IOresult = 0) and (rslt <= 1) and exists(filename) and cts;
    closeM;
    if not successful then eraseM;
    flushed;
    flowctrl(true);
    lineout('');
  end;

procedure Yupload(filename: string; var successful: boolean);
  var
    blocknum, byteloc : integer;
    locblock          : integer;
    opening           : byte;
    rslt, rslt1       : shortint;
    wk                : byte;
    temp              : string;
    fnam              : string;
  begin
    cnarg[cn]^.crcmode := crc16;
    cnarg[cn]^.blkunit := 8;
    stringout('[32mYMODEM');
    if cnarg[cn]^.g_option then stringout('-g');
    lineout('[36m ŃAbv[h܂B[m');
    lineout('[33mCTRL-X Œf[m');
    flowctrl(false);
    flushed;
    locblock := 0;
    assignM(filename);
    rewriteM;
    rslt := ioresult; if rslt <> 0 then rslt := 9;
    if not cnarg[cn]^.g_option then opening := C
    else opening := G;
    if cts and (rslt = 0) then begin
      if acknakout(opening) then rslt := 0
      else rslt := 9;
    end;
    while cts and (rslt <> 1) and (rslt <> 9) do begin
      blocknum := locblock;
      rslt := recv1block(cnarg[cn]^.blkunit, blocknum);
      if (lo(locblock) = blocknum) and (rslt = 0) then begin
        if locblock > 0 then begin  (* ubNO͖ *)
          for wk := 1 to cnarg[cn]^.blkunit do
            blockwriteM(cnarg[cn]^.filebuff[wk-1], 1);
        end;
        if hoststat = cn then write(cr+'YMODEM'+gstr[cnarg[cn]^.g_option]+
          ' Received #',blocknum:4);
        rslt1 := ioresult; if rslt1 <> 0 then rslt := 9;
        inc(locblock);
      end;
      if rslt = 9 then flushed;
      if rslt = 0 then begin
        if blocknum = 0 then begin

{         xmit(ACK);    C:Seishi        YMODEM-g ł ACK ͑Ȃ }
          if not cnarg[cn]^.g_option then xmit(ACK);

          if acknakout(opening) then rslt := 0
          else rslt := 9;
        end
        else if not cnarg[cn]^.g_option then begin
          if acknakout(ACK) then begin
            rslt := 0;
          end
          else rslt := 9;
        end;
      end;
    end; {while}
    case rslt of
      9:xmit(CAN);
      1:begin
        if hoststat = cn then begin
          writeln;writeln(' EOT received.');
        end;
        xmit(ACK);
      end;
    end;
    if cnarg[cn]^.batchmode then begin
      blocknum := 0;
      if acknakout(opening) then
        rslt := recv1block(cnarg[cn]^.blkunit,blocknum);
      if not cnarg[cn]^.g_option then xmit(ACK);
      rslt := 1;
    end;
    successful := (IOresult = 0) and (rslt <= 1) and exists(filename) and cts;
    closeM;
    if not successful then eraseM;
    flushed;
    flowctrl(true);
  end;

procedure Zupload(filename: string; var successful: boolean);
  var
    blocknum : longint;  (* oCgP *)
    retry    : byte;
    recurs   : byte;
    error    : boolean;
    temp     : headertype;
  procedure Zreceivedata(p:filbufptr;var count:word;var frame:byte;
      var err:boolean);
    var
      temp  :word;
      loop  :byte;
      test  :boolean;
      recurs:boolean;
    begin
      clearCRC;
      clearbuff;
      count:=0;
      test:=false;
      cnarg[cn]^.CnStat:=zfileprotocol;
      if hoststat=0 then dispstatus(cn);
      repeat
        temp:=ZcatchZDL(err);
        if not err then repeat
          recurs:=false;
          if temp<256 then begin   (* ꃁbZ[Wł͂Ȃif[^j*)
            if count=1024 then err:=true  { overrun datas }
            else begin
              p^[count]:=byte(temp);
              calcCRC(byte(temp));
              inc(count);
            end;
          end
          else case byte(temp) of
            _CRCE,_CRCW,_CRCG,_CRCQ : begin
                frame:=byte(temp);
                calcCRC(frame);
                loop:=0;
                if cnarg[cn]^.crcmode=crc16 then begin
                  repeat
                    temp:=ZcatchZDL(err);
                    if temp<256 then calcCRC(byte(temp))
                    else recurs:=true;
                    inc(loop);
                  until (loop=2) or recurs or err or not cts;
                end
                else begin
                  repeat
                    temp:=ZcatchZDL(err);
                    if temp<256 then calcCRC(byte(temp))
                    else recurs:=true;
                    inc(loop);
                  until (loop=4) or recurs or err or not cts;
                end;
                if not recurs and not err then begin
                  if takeCRC<>matchCRC then begin
                    err:=true;  { CRC error }
                  end
                  else test:=true;
                end;
            end;
            CAN:begin
                frame:=_CAN;
                test:=true;
            end
            else err:=true;  (* 蓾Ȃif[^j*)
          end;
          if not cts then err:=true;
        until not recurs or err;
      until test or err;
      cnarg[cn]^.CnStat:=zfile;
      if hoststat=0 then dispstatus(cn);
    end;
  procedure Zendrecv;
    var
      loop:byte;
      temp:headertype;
      inret:byte;
    begin
      Zmakepackedheader(_FIN,blocknum,temp);
      loop:=4;
      repeat
        Zsendhexheader(temp);  (* Binary header ͂܂̂낤 *)
        if Ztimedin then begin
          inret:=inbyte;
          case inret of
            79:begin   (* Over and Out 'OO' receive *)
               if Ztimedin then inret:=inbyte;
               clearline;
               exit;
            end
            else begin
               clearline;
               dec(loop);
            end;
          end;
        end;
      until (loop=0) or not cts;   (* ZFIN ŏIoȂĂ悵Ƃ *)
    end;
  function Zinitreceiver(var err:boolean):byte;
    function getdrivename(s:string):char;
      begin
        if pos(':',s)>0 then getdrivename:=s[pos(':',s)-1]
        else getdrivename:='@';
      end;
    var
      temp:headertype;
      sufs:byte;
      blks:word;
      loop:byte;
      test:boolean;
      glbs:boolean;
      dumy:longint;
    begin
      test:=false;
      loop:=10;   { retry count at 10 }
      repeat
        Zmakepackedheader(_RINIT,0,temp);
        temp[4]:=
          CANFDX or CANOVIO or CANFC32;  { full duplex,overlay I/O,CRC32 }
        Zsendhexheader(temp);
        repeat
          glbs:=false;
          blks:=0;    { dumy }
          sufs:=Zgetheader(temp,dumy,err);
          if not err then begin
            if sufs=_BIN32 then cnarg[cn]^.crcmode:=crc32;
            case temp[0] of
              _FILE : begin
                      clearbuff;
                      Zreceivedata(filbufptr(@cnarg[cn]^.filebuff),blks,
                        sufs,err);
                      Zinitreceiver:=_FILE;
                      if sufs=_CRCW then test:=true { check ok }
                      else begin
                        Zmakepackedheader(_NAK,0,temp);
                        Zsendhexheader(temp);
                      end;
              end;
              _RQINIT : begin
                      glbs:=true;
              end;
              _RINIT : begin end;  { pass it }
              _SINIT : begin
                      Zreceivedata(filbufptr(@cnarg[cn]^.filebuff),blks,
                        sufs,err);
                      if sufs=_CRCW then begin
                        Zmakepackedheader(_ACK,0,temp);
                        Zsendhexheader(temp);
                      end
                      else begin
                        Zmakepackedheader(_NAK,0,temp);
                        Zsendhexheader(temp);
                      end;
              end;
           {  _FREECNT : begin
                      (* resume ̃hCu`FbNp            *)
                      (* ۰ނł resume ̂ŎgȂ *)
                      Zmakepackedheader(_ACK,
                        diskfree(byte(getdrivename(filedrive))-$40),temp);
                      Zsendhexheader(temp);
              end;  }
              _COMMAND : begin
                      Zreceivedata(filbufptr(@cnarg[cn]^.filebuff),blks,
                        sufs,err);
                      if sufs=_CRCW then begin
                        repeat
                          Zmakepackedheader(_COMPL,0,temp);
                          Zsendhexheader(temp);
                          blks:=0;    { dumy }
                          dumy:=Zgetheader(temp,dumy,err);
                          dec(retry);
                        until (temp[0]=_FIN) or (retry=0) or err or not cts;
                        Zinitreceiver:=_COMPL;
                        test:=true;
                      end
                      else begin
                        Zmakepackedheader(_NAK,0,temp);
                        Zsendhexheader(temp);
                      end;
              end;
              _COMPL,_FIN : begin
                      Zinitreceiver:=_COMPL;
                      test:=true;
              end;
              CAN,_CAN : begin
                      Zinitreceiver:=temp[0];
                      test:=true;
              end
              else begin
                      glbs:=true;
                      dec(loop);
                      if loop=0 then err:=true;
              end;
            end;
          end;
        until test or glbs or err or not cts;
      until test or err or not cts;
    end;
  procedure Zrecvwrite(p:filbufptr;count:word;num:longint;var err:boolean);
    begin
      if count>0 then begin
        {$I-} seekM(num div 128);
              blockwriteM(p^,((count-1) div 128)+1); {$I+}
        err:=boolean(ioresult);
      end;
    end;
  function Zreceivefile(var err:boolean):byte;
    (* ǂlAI ZEOF łAȂ *)
    var
      retry:byte;
      loop :byte;
      temp:headertype;
      sufs:byte;
      blks:word;
      reload:boolean;
      rehdr:boolean;
      complete:boolean;
      rslt:longint;
      error:boolean;
      dumy:byte;
      leng:word;
    begin
      retry:=10;
      blocknum:=0;
      leng:=0;
      complete:=false;
      repeat
        Zmakepackedheader(_RPOS,blocknum,temp);  (* X^[gC *)
        Zsendbinheader(temp);
        repeat
          rehdr:=false;
          error:=false;
          dumy:=Zgetheader(temp,rslt,error);
          if error then begin
            dec(retry);
            if retry=0 then err:=true;  { retry over }
          end
          else case temp[0] of
            _DATA : begin
                    if blocknum<>rslt then begin  (* ubN *)
                      dec(retry);
                      if retry=0 then err:=true;  { retry over }
                    end
                    else begin
                      repeat
                        reload:=false;
                        error:=false;
                        Zreceivedata(filbufptr(@cnarg[cn]^.filebuff),blks,
                          sufs,error);      (* f[^{ *)
                        if error
                          { {ɕKvǂ^킵B
                          or (sufs=_CAN) }
                          then begin
                          xmit(_PAD);
                          clearline;  (* ~܂܂ő҂ *)
                          dec(retry);
                          if retry=0 then err:=true;
                        end
                        else if sufs in [_CRCW,_CRCE,_CRCG,_CRCQ] then begin
                          if leng=0 then leng:=blks;
                          retry:=10;
                          Zrecvwrite(filbufptr(@cnarg[cn]^.filebuff),
                            blks,blocknum,err);
                          if not err then begin
                            inc(blocknum,blks);
                            if sufs in [_CRCW,_CRCQ] then begin
                              Zmakepackedheader(_ACK,blocknum,temp);
                              Zsendbinheader(temp);
                            end;
                            if sufs in [_CRCQ,_CRCG] then reload:=true
                            else rehdr:=true;
                            if hoststat=cn then write(cr+'ZMODEM '+
                              crcstr[cnarg[cn]^.crcmode],' (',blks:4,
                              ') Received #',(blocknum div leng):4);
                          end;
                        end
                        else if sufs=_CAN then err:=true;
                      until not reload or err or not cts;
                    end;
            end;
            _FILE : begin   (* ǂނǂŖ *)
                   Zreceivedata(filbufptr(@cnarg[cn]^.filebuff),
                     blks,sufs,err);
            end;
            _EOF : begin
                   if rslt=blocknum then begin
                     Zreceivefile:=_EOF;
                     complete:=true;
                   end;
            end
            else begin
                   xmit(_PAD);
                   clearline;  (* ~܂܂ő҂ *)
                   dec(retry);
                   if retry=0 then err:=true;  { retry over }
            end;
          end;
        until not rehdr or complete or err or not cts;
      until complete or err or not cts;
    end;
  begin { of Zupload }
    lineout('[32mZMODEM[36m ŃAbv[h܂B[m');
    lineout('[33mCTRL-X Œf[m');
    cnarg[cn]^.lastsent:=0;
    cnarg[cn]^.crcmode:=crc16;
    flowctrl(false);
    flushed;
    assignM(filename);
    {$I-} rewriteM; {$I+}
    if ioresult=0 then begin
      blocknum:=0; { cannot resume }
      retry:=8;  (* ^CI[o[ׂ̈ɂW҂ *)
      error:=false;
      repeat
        recurs:=Zinitreceiver(error);
        dec(retry);
      until (((recurs in [CAN,_CAN,_FILE,_COMPL]) or (retry=0)) and
        not error) or not cts;
      if not error then
        case recurs of
          _FILE : begin
                  recurs:=Zreceivefile(error);  { main }
          end;    (* ߂Ă ZEOF or error *)
          _COMPL : begin end
          else error:=true;
        end;
      retry:=4;
      if not error then repeat
        recurs:=Zinitreceiver(error);
        if recurs=_FILE then begin  (* ob`Abv[h͏oȂ *)
          Zmakepackedheader(_SKIP,0,temp);
          Zsendhexheader(temp);
        end
        else dec(retry);
      until (recurs=_COMPL) or (retry=0) or not error or not cts;
      if not error then Zendrecv
      else Zcancel;
    end
    else error:=true;
    successful := (IOresult = 0) and not error and exists(filename) and cts;
    closeM;
    if not successful then eraseM;
    clearline;  (* rŃG[ƃobt@ɗĂ̂ŃNA *)
    flushed;    (* Break check Ă *)
    flowctrl(true);
  end;

procedure Mupload(filename: string; var successful: boolean);
  var
    blocknum    : integer;
    opening     : byte;
    rslt        : shortint;
    wk          : byte;
    wk1         : byte;
    filebytes   : longint;
    bytes       : word;
    dumy        : word;
    inch        : byte;
    loop        : word;
    temp        : string;
    fnam        : string;
    canc        : boolean;
    loopi       : byte;
  function detecthb(time: integer):boolean;
  (*timeb͂҂B^CAEg or ؂ȂfalseԂB*)
    var loop, loopend: integer;
    begin
      loopend := ACNT * time;
      loop := 0;
      repeat
        waiting(seccnt div 10);   {wait 0.1sec}
        inc(loop);
      until not cts or inready or (loop >= loopend);
      if loop>=loopend then detecthb:=false else detecthb:=true;
    end;
  function recm:byte;  (* CRC vZȂ *)
    var
      times: word;
      test : boolean;
      err  : boolean;
    begin
      err  :=false;
      times:=gettcount;
      repeat
        test:=inready;
        if not cts then err:=true;
      until (calctcount(times)>seccnt*2) or test or err;
      if test then recm:=inbyte
      else canc:=true;
    end;

  begin
    lineout('[32mM-LINK[36m ŃAbv[h܂B[m');
    lineout('[33mCTRL-X Œf[m');
    canc:=false;
    loopi:=10;
    clearbuff;
    assignM(filename);
    rewriteM;
    rslt := IOresult; if cts and (rslt <> 0) then rslt := 9;
    if rslt=0 then begin
      flowctrl(false);
      flushed;
      wk:=8;  (* W҂܂ *)
      xmit(INI);
      while cts and not detecthb(15) and (wk>0) do begin
        xmit(INI);
        dec(wk);
      end;
      if wk=0 then rslt:=9;
      if cts and (rslt=0) then begin
        inch:=0;
        repeat    (* t@C΂ *)
          inch:=recm;
        until not cts or (inch=$20) or (inch=EXT) or canc;
        if (inch=EXT) or canc or not cts then rslt:=9
        else begin
          temp:='';
          dumy:=0;
          repeat  (* t@CTCY𓾂 *)
            dumy:=recm;
            temp:=temp+chr(dumy);
          until not cts or (dumy=$20) or cnarg[cn]^.cancelled;
          val(copy(temp,1,length(temp)-1),filebytes,dumy);
          if (dumy>0) or cnarg[cn]^.cancelled then rslt:=9
          else begin
            repeat  (* IB ̏I܂Ŕ΂ *)
            until not cts or (recm=$0D) or cnarg[cn]^.cancelled;
          end;
          if cnarg[cn]^.cancelled or (rslt=9) then xmit(ABT) else xmit(INI);
        end;
        wk:=0;
        blocknum:=0;
        if cts and (rslt=0) then begin
          repeat
            cnarg[cn]^.CnStat:=zfileprotocol;
            if hoststat = 0 then dispstatus(cn);
            wk1:=0;
            while not ((filebytes=0) or (wk1=8)) and not canc do begin
              wk:=0;
              if filebytes>127 then bytes:=128 else bytes:=filebytes;
              while (wk<bytes) and not canc do begin
                cnarg[cn]^.filebuff[wk1,wk]:=recm;
                inc(wk);
              end;
              filebytes:=filebytes-bytes;
              inc(wk1);
            end;
            cnarg[cn]^.CnStat:=zfile;
            if hoststat = 0 then dispstatus(cn);
            if canc then rslt:=9
            else begin
              for wk:=0 to wk1-1 do blockwriteM(cnarg[cn]^.filebuff[wk], 1);
              inc(blocknum);
              if hoststat = cn then
                write(cr + 'M-LINK Received #', blocknum:4);
            end;
          until not cts or (rslt=9) or (filebytes=0);
          if rslt=9 then xmit(ABT)
          else begin
            xmit(ETR);
            if hoststat = cn then begin
              writeln;writeln('ETR sent.');
            end;
          end;
        end;
      end;
    end;
    flushed;
    flowctrl(true);
    cnarg[cn]^.CnStat:=zfile;
    if hoststat = 0 then dispstatus(cn);
    successful := (IOresult = 0) and (rslt = 0) and exists(filename) and cts;
    closeM;
    if not successful then eraseM;
    lineout('');
  end;

  procedure CONupload(filename: string; var successful: boolean);
    var
      temp:string;
      D2  :dirstr;
      N2  :namestr;
      E2  :extstr;
      D3  :dirstr;
      N3  :namestr;
      E3  :extstr;
      fn  :string;
      rslt:byte;
    begin
      lineoutifneed;
      cnarg[cn]^.prompt:=
        '[36mt@C݂̑fBNg[m ([33m[RET]:quit[m) >';
      temp := allcaps(getinput(cnarg[cn]^.prompt,255,echo));
      if temp<>'' then begin
        lineout('');
        Fsplit(temp,D2,N2,E2);
        Fsplit(filename,D3,N3,E3);
        if (N2='') and (E2='') then fn:=D2+N3+E3
        else fn:=temp;
        stringout('[33m] [32m['+fn+'] ...');
        cnarg[cn]^.cnstat := zfileprotocol;
        if hoststat = 0 then dispstatus(cn);
        FileCopy(fn,filename, rslt);
        cnarg[cn]^.cnstat := zfile;
        if hoststat = 0 then dispstatus(cn);
        successful := (rslt = 0);
        if successful then lineout(' [33mI[m')
        else lineout(' [31ms[m');
      end
      else successful:=false;
    end;


  procedure Downloadselect(var successful: boolean);
    var
      inch:char;
    begin
      cnarg[cn]^.blkunit:=8;
      cnarg[cn]^.crcmode:=crc16;
      cnarg[cn]^.g_option:=false;
      repeat
        lineoutifneed;
        cnarg[cn]^.prompt:=
          '[36mDownload[m ([33mS,C,X,Y,G,Z,M,?,0[m) >';
        inch:=getcap(cnarg[cn]^.prompt);
        case inch of
          'S':begin
              cnarg[cn]^.blkunit:=1;
              cnarg[cn]^.crcmode:=sum;
              Xdownload(successful);
          end;
          'C':begin
              cnarg[cn]^.blkunit:=1;
              Xdownload(successful);
          end;
          'X':Xdownload(successful);
          'Y':Ydownload(successful);
          'G':begin
              cnarg[cn]^.g_option:=true;
              Ydownload(successful);
          end;
          'Z':Zdownload(successful);
          'M':Mdownload(successful);
          '?':begin
              lineout('');
              outfile(bmesdrive+j_downhelp);
          end;
        end;
      until (inch in ['S','C','X','Y','G','Z','M','0']) or not cts;
    end;

  procedure Uploadselect(filename: string; var successful: boolean);
    var
      inch:char;
    begin
      cnarg[cn]^.blkunit:=8;
      cnarg[cn]^.crcmode:=crc16;
      cnarg[cn]^.g_option:=false;
      repeat
        lineoutifneed;
        cnarg[cn]^.prompt:=
          '[36mUpload[m ([33mS,C,X,Y,G,Z,M,?,0[m) >';
        inch:=getcap(cnarg[cn]^.prompt);
        case inch of
          'S':begin
              cnarg[cn]^.blkunit:=1;
              cnarg[cn]^.crcmode:=sum;
              Xupload(filename,successful);
          end;
          'C':begin
              cnarg[cn]^.blkunit:=1;
              Xupload(filename,successful);
          end;
          'X':Xupload(filename,successful);
          'Y':Yupload(filename,successful);
          'G':begin
              cnarg[cn]^.g_option:=true;
              Yupload(filename,successful);
          end;
          'Z':Zupload(filename,successful);
          'M':Mupload(filename,successful);
          '?':begin
              lineout('');
              outfile(bmesdrive+j_uphelp);
          end;
        end;
      until (inch in ['S','C','X','Y','G','Z','M','0']) or not cts;
    end;


end.

