{
  "MONITOR.PAS"  ( UNIT : MONITOR )  j^

}

unit monitor;

{----------------------------------------------------------------------}
interface

uses
  header, kernel, rsdriver, filmangr;

procedure titlebbs;
procedure titleins(s:string);
procedure writeover(x:byte);
procedure writelogon;
function  whereisCn(cn: integer): string;
procedure dispstatus(cn: integer);
procedure writemonitorlock;
procedure initmonitor;
function  hex(i:word):string;

{----------------------------------------------------------------------}
implementation

const
  crlf:string[2]=#13+#10;

procedure titlebbs;
  begin
    titleins(cnarg[0]^.timeon);
  end;

procedure titleins(s:string);
  begin
    gotoxy(1,1);
    write('[36;7m   The resource edition  s|aar  '+
      copy(VERSION+'        ',1,9)+'    [33m '+s+
      ' [36;7m  [m'+crlf+crlf);
  end;

procedure writeover(x:byte);
  var
    temp:string[10];
    loop:byte;
  begin
    gotoxy(18,20);
    if overtest<>omain then begin
      write('[32mv[m');
      exit;
    end;
    if x in [0..54] then write('[36m')
    else if x in [55..84] then write('[33m')
    else write('[31m');
    str(x:3,temp);
    write(temp+'[32m%[m  ');
{$IFDEF PRIORITY}
    if priorityput then begin
      write('[31;7m');
      for loop:=0 to MaxCnNum do begin
        str(cnarg[loop]^.priority:3,temp);
        gotoxy(76,loop+7);
        write(temp);
      end;
    end;
{$ENDIF}
  end;

procedure writelogon;
  var temp:string;
  begin
    str(getsystemlogon,temp);
    gotoxy(56,3);
    write('[32m'+temp+'[m');
  end;

function hex(i:word):string;
  const
    hexi:array[0..15] of char=('0','1','2','3','4','5','6','7',
                               '8','9','A','B','C','D','E','F');
  var
    buf:string;
    x,j:word;
  begin
    buf:='';
    j:=i;
    x:=4096;
    repeat
      buf:=buf+hexi[j div x];
      j:=j mod x;
      x:=x div 16;
    until x=0;
    hex:=buf;
  end;

function whereisCn(cn: integer): string;
  var
    wk : string;
    tuser : string[10];
    thandle : name;
    temp  : string[4];
    temp2 : string[5];
  begin
    wk:='[mCh.'+chr($30+cn)+' ';
    if not (cnarg[cn]^.CnStat in [zoff,zawait,zclose,zewait]) then begin
      tuser := cnarg[cn]^.caller + ' ';
      thandle := cnarg[cn]^.handle_name + ' ';
      wk:=wk+'[36m'+copy(tuser+'         ',1,9)+
        '[33m'+copy(thandle+'         ',1,9);
      wk:=wk+'[m'+copy(whereis[cnarg[cn]^.CnStat]+'         ',1,9)+
        '[32m'+ratemess[cnarg[cn]^.baud]+'[m/[32m'+
        cnarg[cn]^.name_protocol[cnarg[cn]^.MNPflg]+' [m'+
        copy(cnarg[cn]^.memo+'                                                                        ',1,32);
    end
    else begin
      if cnarg[cn]^.cnstat=zewait then wk:=wk+'[32mexported'
      else if cnarg[cn]^.cnstat<>zclose then wk:=wk+'[36mwait_acc'
      else wk:=wk+'[34mclosed  ';
      wk:=wk+'[m                                                             ';
    end;
    WhereisCn := wk;
  end;


function whereisDisp(cn: integer): string;
  var
    wk : string;
    tuser : string[10];
    thandle : name;
    temp  : string[4];
    temp2 : string[5];
    temp3 : string;
  begin
    str(getsystemlogonline(cn):5,temp3);
    wk:='[7m '+chr($30+cn)+' [33;7m'+temp3+' ';
    if not (cnarg[cn]^.CnStat in [zoff,zawait,zclose,zewait]) then begin
      tuser := cnarg[cn]^.caller + ' ';
      thandle := cnarg[cn]^.handle_name + ' ';
      wk:=wk+'[36;7m'+copy(tuser+'         ',1,9)+
        '[33;7m'+copy(thandle+'         ',1,9);
      temp3:=cnarg[cn]^.memo;
      temp3:=temp3+'                                           ';
      wk:=wk+'[7m'+copy(whereis[cnarg[cn]^.CnStat]+'         ',1,9)+
        '[32;7m'+ratemess[cnarg[cn]^.baud]+'/'+
        cnarg[cn]^.name_protocol[cnarg[cn]^.MNPflg]+' [7m';
{$IFDEF PRIORITY}
      if priorityput then begin
        wk:=wk+dellastkanji(copy(temp3,1,29))+'[31;7m';
        str(cnarg[cn]^.priority:3,temp3);
        wk:=wk+temp3+' ';
      end
      else begin
        wk:=wk+dellastkanji(copy(temp3,1,33));
      end;
{$ELSE}
      wk:=wk+dellastkanji(copy(temp3,1,33));
{$ENDIF}
    end
    else begin
      if cnarg[cn]^.cnstat=zewait then wk:=wk+'[32;7mexported '
      else if cnarg[cn]^.cnstat<>zclose then wk:=wk+'[36;7mwait_acc '
      else wk:=wk+'[34;7mclosed   ';
      wk:=wk+'[33;7m         [7m         [32;7m          ';
{$IFDEF PRIORITY}
      if priorityput then begin
        str(cnarg[cn]^.priority:3,temp3);
        wk:=wk+'[7m                             [31;7m'+temp3+' ';
      end
      else wk:=wk+'[7m                                 ';
{$ELSE}
      wk:=wk+'[7m                                 ';
{$ENDIF}
    end;
    WhereisDisp := wk+'[m';
  end;

procedure dispstatus(cn: integer);
  begin
    gotoxy(1, cn+7);
    write(whereisDisp(cn));
  end;

procedure writemonitorlock;
  begin
    gotoxy(1, 21);
    write('      [33mf[[m :                         ');
    if getconsolelock then
      write('[31m*-*[m : [33mj^[bN[m'+crlf)
    else writeln('[32m1-',MaxCnNum,'[m : [33me`l̃j^[m');
  end;

procedure initmonitor;
  var i : integer;
  begin
    ClrScr;
    cursor(false);
    titlebbs;
    writeln('    [ [36m'+BBSNAME+'[m ]    [33mChannel[m:[32m ',
      MaxCnNum,' [m/[32m ',MaxCn,'    [33mTotal login[m:[32m ',
      getsystemlogon,'[m');
    write(crlf);
    write('[34;7m                                                                               [m'+crlf);
    write('[7mCh.[33;7mLogin [36;7mID       [33;7mHandle   [7mCommand  ');
{$IFDEF PRIORITY}
    if priorityput then
      write('[32;7mBaud/ptcl [7mMemo                         [31;7mPr  [m'+crlf)
    else write('[32;7mBaud/ptcl [7mMemo                             [m'+crlf);
{$ELSE}
    write('[32;7mBaud/ptcl [7mMemo                             [m'+crlf);
{$ENDIF}
    for i := 0 to MaxCnNum do dispstatus(i);
    gotoxy(1, MaxCnNum+8);
    write('[7m   [33;7m      [36;7m         [33;7m         [7m         [32;7m         ');
{$IFDEF PRIORITY}
    if priorityput then
      write(' [7m                             [31;7m    [m'+crlf)
    else write(' [7m                                 [m'+crlf);
{$ELSE}
    write(' [7m                                 [m'+crlf);
{$ENDIF}
    write('[34;7m                                                                               [m'+crlf);
    write(crlf);
    gotoxy(1, 20);
    write('      [33mח[m   :                         [32m0[m   : [33mgp[m'+crlf);
    writemonitorlock;
    write('                                         [35mESC[m : [33m[JOC[m'+crlf);
    write('                                         [35m^[mC  : [33mI[m'+crlf);
  end;


end.
