{
  "KERNEL.PAS"  ( UNIT : KERNEL )  S

}

unit kernel;

{----------------------------------------------------------------------}
interface

Uses JmpCall, Dos, header;

var
  daemonprocess: word;

procedure assignCRTansi;
procedure removeCRTansi;
function  keypressed:boolean;
function  readkey:char;
procedure clrscr;
procedure gotoxy(x,y:byte);
procedure checkbreak(ck:boolean);
procedure cursor(ck:boolean);
function  value(s1:string):longint;
procedure clock(var year, month, date, hour, min, sec: word);
function  dt2bin(s:datetime):longint;
function  time(year, month, date, hour, min, sec: word): DateTime;
function  getclock: datetime;
function  iskanji(w: char): boolean;
function  kpos(substr:char;str:string):byte;
function  iskbyte1(a:string; n:byte): boolean;
function  dellastkanji(s:string):string;

procedure writedaemon;
procedure raisedaemon;
procedure transfernext;

procedure requestmail;
procedure detailmail;
function  statusmail:boolean;

procedure changePSP(x:byte);
procedure restorePSP;

function  getcullentPSP:word;
procedure setcullentPSP(processID:word);
procedure buildPSP(newseg:word);
procedure dosflush;

{----------------------------------------------------------------------}
implementation

uses timer;

const
  conhd=0;

type
  reqtype=(noq,req,det);

var
  savecon   :word;
  requestm  :reqtype;
  statusm   :boolean;
  rank      :boolean;

procedure assignCRTansi; assembler;
  asm
    mov bx,conhd
    mov ax,4400h
    int 21h
    mov savecon,dx
    and dx,0020h
    jnz @e
    mov ax,4401h
    mov bx,conhd
    or dx,0020h
    and dx,00ffh
    int 21h
 @e:
  end;

procedure removeCRTansi; assembler;
  asm
    mov ax,4401h
    mov bx,conhd
    mov dx,savecon
    and dx,00dfh
    int 21h
  end;

function keypressed:boolean; assembler;
  asm
    mov ax,4406h
    mov bx,conhd
    int 21h
  end;

function readkey:char; assembler;
  asm
    mov ah,07h
    int 21h
  end;

procedure gotoxy(x,y:byte);
  var
    temp1:string;
    temp2:string;
  begin
    str(x,temp1);
    str(y,temp2);
    write(chr($1B)+'['+temp2+';'+temp1+'H');
  end;

procedure clrscr;
  var
    temp:string;
  begin
    write(' '+chr($1B)+'[2J');
  end;

procedure checkbreak(ck:boolean); assembler;
  asm
    mov al,ck
    push ax
    call dos.setcbreak
  end;

procedure cursor(ck:boolean); assembler;
  asm
    mov al,ck
    push ax
    call timer.dispcursor
  end;

procedure TransferNext; assembler;
{$IFDEF PRIORITY}
  asm
    cmp sysopflag,0
    jz @x
    dec calls1
    jnz @x
    mov calls1,1000
    mov ah,02h
    mov dl,7
    int 21h
    dec calls2
    jnz @x
    mov sysopflag,0
 @x:cmp transok,0
    jz @e
    mov al,cn
    xor ah,ah
    shl al,1
    shl al,1
    mov bx,offset cnarg
    add bx,ax
    les bx,[bx]

    dec es:cnargrec([bx]).incounts
    jnz @z
    mov ah,maxpriority
    sub ah,es:cnargrec([bx]).priority
    mov cl,4    { maxpriority=15 ̎ }
    shl ah,cl
    mov es:cnargrec([bx]).incounts,ah
    mov ah,underprio
    mov al,es:cnargrec([bx]).priority
    dec al
    cmp al,ah
    jnz @n
    inc ah
    mov al,ah
 @n:mov es:cnargrec([bx]).priority,al

 @z:dec es:cnargrec([bx]).rotates
    jnz @e
    mov al,es:cnargrec([bx]).priority
    mov es:cnargrec([bx]).rotates,al

    xor bh,bh
    mov bl,cn
    inc bl
    mov cl,2
    shl bx,cl
    mov dx,offset p
    add bx,dx
    push ds
    push bx
    inc cn
    mov al,MaxCnNum
    cmp cn,al
    jbe @1
    mov cn,-1
 @1:xor bh,bh
    mov bl,cn
    inc bl
    shl bx,cl
    add bx,dx
    les ax,[bx]
    push es
    push ax
    call jmpcall.transfer
 @e:
  end;
{$ELSE}
  asm
    cmp sysopflag,0
    jz @x
    dec calls1
    jnz @x
    mov calls1,1000
    mov ah,02h
    mov dl,7
    int 21h
    dec calls2
    jnz @x
    mov sysopflag,0
 @x:cmp transok,0
    jz @e
    xor bh,bh
    mov bl,cn
    inc bl
    mov cl,2
    shl bx,cl
    mov dx,offset p
    add bx,dx
    push ds
    push bx
    inc cn
    mov al,MaxCnNum
    cmp cn,al
    jbe @1
    mov cn,-1
 @1:xor bh,bh
    mov bl,cn
    inc bl
    shl bx,cl
    add bx,dx
    les ax,[bx]
    push es
    push ax
    call jmpcall.transfer
 @e:
  end;
{$ENDIF}

procedure clock(var year, month, date, hour, min, sec: word);
{Returns with month in range 1(Jan)..12(Dec),
 date in 1..length of month, hour in 0..23 (24-hr clock),
 minute and second in 0..59}
  var
    daywk : word;
    sec100  : word;
  begin
    GetDate(year, month, date, daywk);
    GetTime(hour, min, sec, sec100);
  end;

function value(s1:string):longint;
  var
    temp:integer;
    dumy:integer;
  begin
    val(s1,temp,dumy);
    value:=temp;
  end;

function dt2bin(s:datetime):longint;  (* time ̋t֐ *)
  var
    temp:dos.datetime;
    sdck:longint;
  begin
    with temp do begin
      year:=value('19'+copy(s,1,2));
      month:=value(copy(s,4,2));
      day:=value(copy(s,7,2));
      hour:=value(copy(s,10,2));
      min:=value(copy(s,13,2));
      sec:=value(copy(s,16,2));
    end;
    packtime(temp,sdck);
    dt2bin:=sdck;
  end;

function time(year, month, date, hour, min, sec: word): DateTime;
  var
    temps,tempm,tempd,temph,tempmo,tempy : string[2];
    wk : string[4];
  begin
    str(sec  :2, temps);
    str(min  :2, tempm);
    str(hour :2, temph);
    str(date :2, tempd);
    str(month:2, tempmo);
    str(year :4, wk);
    tempy := copy(wk, 3, 2);
    if sec   < 10 then temps[1]  := '0';
    if min   < 10 then tempm[1]  := '0';
    if date  < 10 then tempd[1]  := '0';
  if month < 10 then tempmo[1] := '0';
  time := tempy+'/'+tempmo+'/'+tempd+' '+temph+':'+tempm+':'+temps;
  end;

function getclock: datetime;
  var
    tempyear,tempmonth,tempdate,temphour,tempmin,tempsec : word;
  begin
    clock(tempyear,tempmonth,tempdate,temphour,tempmin,tempsec);
    getclock:=time(tempyear,tempmonth,tempdate,temphour,tempmin,tempsec);
  end;

function iskanji(w: char): boolean;
  begin
    iskanji:=w in kanji;
  end;

function kpos(substr:char;str:string):byte;
  var
    s:string;
    i:byte;
  begin
    i:=1;
    repeat
      if iskanji(str[i]) then inc(i);
      inc(i);
    until (i>length(str)) or (str[i]=substr);
    if str[i]=substr then kpos:=i else kpos:=0;
  end;

{ w肳ꂽ nbyte ڂ 1byte ڂ check :NOBUYA }
{ AZu ComServe }
function iskbyte1(a:string;n:byte): boolean; assembler;
  asm
    mov cl,n
    xor ch,ch
    les bx,a
    inc bx
    xor al,al
    and cl,cl
    jz @e
 @1:and al,al
    jnz @2
    mov dl,es:[bx]
    push es
    push bx
    push cx
    push dx
    call iskanji
    pop cx
    pop bx
    pop es
    jmp @3
 @2:xor al,al
 @3:inc bx
    loop @1
 @e:
  end;
(*
var
  i    : integer;
  kekka: boolean;
begin
  kekka:=false;
  for i:=1 to n do
    if kekka then kekka:=false          {  1byte ͖̎ false    }
    else          kekka:=iskanji(a[n]); {  1byte łȂȂ check    }
  iskbyte1:=kekka;
end;
*)


function dellastkanji(s:string):string;
  begin
    if iskbyte1(s,length(s)) then dellastkanji:=copy(s,1,length(s)-1)
    else dellastkanji:=s;
  end;

{-----------------------------}

procedure writedaemon;
const
  demonstr:array[0..2] of string[11]=
           ('[31m~','[32mx~','[36m');
begin
  if hoststat=0 then begin
    gotoxy(18,21);
    if statusm then
      if rank then write(demonstr[2]+'[m')
      else write(demonstr[0]+'[m')
    else write(demonstr[1]+'[m');
  end;
end;

procedure raisedaemon;
  (* Ђ烁[{bNX̍œKJԂf[B *)
  (* [̃ANZXvꂽꎞ~         *)
  function transferstart(x:byte):boolean;
    var loop:byte;
    begin
      loop:=x;
      repeat
        cn:=0;
        transfer(p[-1],p[0]);
        dec(loop);
      until (loop=0) or (exitchar=abort);
      if exitchar=abort then transferstart:=true
      else transferstart:=false;
    end;
  label exitdaemon;   (* A߂ȂI *)
  const
    deletedmess=-1;
  var
    f, g : file of messages;
    mess : messages;
    loop : word;
    wrts : word;
    test : byte;
    lastyear, nowyear, lastmonth , nowmonth, nowdate, dummy: word;
  begin
    loop:=0;
    wrts:=0;
    rank:=true;  (* œK`FbNi߂͍œKĂȂƂj*)
    statusm:=true;
    requestm:=noq;
    getdate(lastyear, lastmonth, dummy, dummy);
    while true do begin
      { RTC NύXȂꍇ̑Ώ }
      getdate(nowyear, nowmonth, nowdate, dummy);
      if (lastmonth=12) and (nowmonth=1) and (lastyear=nowyear) then begin
        setdate(nowyear+1, nowmonth, nowdate);
      end;
      if transferstart(49) then goto exitdaemon;
      case requestm of
        req:begin
            requestm:=noq;
            if statusm and (loop>0) then begin
              close(f);
              close(g);
            end;
            statusm:=false;
        end;
        noq:if statusm and rank and (loop=0) then begin
            assign(f,boarddrive+'MESSM0.BBS');
            {$I-} reset(f); {$I+}
            if ioresult=0 then begin
              if filesize(f)>0 then begin
                assign(g,boarddrive+'MESSM0.TMP');
                rewrite(g);
                loop:=1;
                wrts:=1;
              end
              else begin
                close(f);
                rank:=false;
              end;
            end
            else begin
              rank:=false;
            end;
        end;
        det:begin
            requestm:=noq;
            statusm:=true;
            rank:=true;   (* ANZXꂽ̂ōœK *)
            loop:=0;
            wrts:=0;
        end;
      end;
      if transferstart(49) then goto exitdaemon;
      if statusm and (loop>0) then begin
        seek(f,loop-1);
        read(f,mess);
        if (mess.recver<>deletedmess) and (mess.rec>0) then begin
          mess.number:=loop;
          mess.refwd:=0;
          if transferstart(24) then goto exitdaemon;
          seek(g,wrts-1);
          write(g,mess);
          inc(wrts);
        end;
        inc(loop);
        if transferstart(19) then goto exitdaemon;
        if eof(f) then begin
          close(f);
          if transferstart(19) then goto exitdaemon;
          close(g);
          if transferstart(19) then goto exitdaemon;
          erase(f);
          rename(g,boarddrive+'MESSM0.BBS');
          loop:=0;
          wrts:=0;
          rank:=false;
        end;
      end;
      dosflush;
    end;
exitdaemon:
    if statusm and (loop>0) then begin
      close(f);
      close(g);
    end;
    statusm:=false;
  end;

(* f[ʐMp *)

procedure requestmail;
  begin
    requestm:=req;
  end;

procedure detailmail;
  begin
    requestm:=det;
  end;

function statusmail:boolean;
  begin
    statusmail:=statusm or (requestm<>noq);
  end;


(*
    PSP 𑀍삷邱Ƃɂ
      MS-DOS ł́APvZXőQÕt@CI[voȂB
      ł͉ȂɃpNĂ܂̂ŁAvZXƂ
@@@݂āAt@C̃I[vU蕪B
      changePSP,restorePSP ͑΂ɂȂĂ鎖B܂A܂ꂽł͐΂
      transfernext Ă͂ȂB
@@@iƊmɃt@CԂ̂ŏdvj
*)

procedure changePSP(x:byte);
  var
    temp:word;
  begin
    temp:=seg(cnarg[x]^);
    asm
      mov ah,050h
      mov bx,temp
      int 21h
    end;
  end;

procedure restorePSP; assembler;
  asm
    mov ah,050h
    mov bx,daemonprocess
    int 21h
  end;

function getcullentPSP:word; assembler;
  asm
    mov ah,051h
    int 21h
    mov ax,bx    { ax ߂lɂȂ܂Bbyte Ȃ alA}
  end;           { pointer Ƃ longint  dx:ax ߂lł }

procedure setcullentPSP(processID:word); assembler;
  asm
    mov ah,050h
    mov bx,processID;
    int 21h
  end;

procedure buildPSP(newseg:word); assembler;
  asm
    mov ah,055h
    mov dx,newseg
    int 21h
  end;

procedure dosflush; assembler;
  asm
    cmp ignoreflush,0
    jz @e
    mov ah,0dh
    int 21h
 @e:
  end;

end.
