{
  "FILMANGR.PAS"  ( UNIT : FILMANGR )  t@CǗ
}

unit filmangr;

{----------------------------------------------------------------------}
interface

Uses
  Dos, JmpCall, header, kernel, timer;

 (* mt@Č^i^̓wb_Œ`jn

    Mׂ͂file^I

  FMT[].filtypB   var           ^
  ---------------------------------------------
  idfil    .....  idfile      : file of sysid
  logfil   .....  logfile     : file of log
  signfil  .....  signfile    : file of signuprec
  gathfil  .....  gathfile    : file of gatherrec
  arcfil   .....  arcfile     : file of filbuffer
  mbdfil   .....  mesbdfile   : file of secttype
  fbdfil   .....  filebdfile  : file of secttype
  mesfil   .....  messagefile : file of messages
  filfil   .....  filefile    : file of filerec
 *)


const
  SysFileName    = 'SYSTEM.BBS';   (* ver5.3 *)
  IdFileName     = 'IDM.BBS';      (* ver5.3 *)
  LogFileName    = 'LOG.BBS';      (**)
  SignupFileName = 'SIGN.BBS';     (* ver5.2 *)
  GatherFileName = 'GATHER.BBS';   (* ver5.2 *)
  MesbdFileName  = 'MESSBDM.BBS';  (* ver5.3 *)
  FilebdFileName = 'FILEBDM.BBS';  (* ver5.3 *)
  {ArchiveName   = 'ARCMx.BBS';    (* ver5.3 *)}
  {MesFileName   = 'MESSMx.BBS';   (* ver5.2 *)}
  {FileFileName  = 'FILEMx.BBS';   (* ver5.2 *)}
  {MesLogName    = 'MESSLx.BBS';   (* ver5.3 *)}
  {FileLogName   = 'FILELx.BBS';   (* ver5.3 *)}


procedure fsplit(s:string;var d:dirstr;var n:namestr;var e:extstr);
function  allcaps(letters:string):string;
procedure FileCopy(SourceName, DestName: string; var rslt:byte);
function  SearchSameFile(filename:string): shortint;
procedure InitCnM(c:shortint);
function  exists(filename: string): boolean;

function  getsystemexec:word;
function  getsystemlogon:longword;
function  getsystemlogonline(linen:byte):longword;
function  getconsolelock:boolean;
procedure incsystemexec;
procedure incsystemlogon;
procedure setconsolelock(lock:boolean);

procedure assignM(filename:string);
procedure resetM;
procedure rewriteM;
procedure appendM;
procedure seekM(n:longint);
procedure writelnM(var linedata:string);
procedure blockreadM(var filebrock:filbuffer; n:word);
procedure blockwriteM(var filebrock:filbuffer; n:word);
procedure closeM;
procedure eraseM;
procedure renameM(filename: string);
function  filesizeM: longint;
function  eofM: boolean;

procedure InitCnB(c:shortint);
function  SearchSameBoard(bd:integer):shortint;
procedure openBBSfiles;
procedure closeBBSfiles;
procedure openBoard(boardnum: integer);
procedure closeBoard;
procedure seekB(ftype:FileTypeB; n:longint);
function  islockB(ftype:FileTypeB; n:longint): boolean;
procedure lockB(ftype:FileTypeB; n:longint);
procedure unlockB(ftype:FileTypeB);
procedure readB(ftype:FileTypeB; recptr:pointer);
procedure writeB(ftype:FileTypeB; recptr:pointer);
function  eofB(ftype:FileTypeB): boolean;
procedure truncateB(ftype:FileTypeB);
function  filesizeB(ftype:FileTypeB): longint;

function  getrat(tw:word):word;
procedure setrat(tw:word;dat:word);
procedure replaceratend(link:word);
function  firstfreerec:word;
procedure nextfreerec(var link:word);
procedure endmark(link:word);

procedure clearB;

function  lookup(l:byte):string;

{----------------------------------------------------------------------}
implementation


var
  systemfile  : file of systemrec;
  idfile      : file of sysid;
  logfile     : file of log;
  signfile    : file of signuprec;
  gathfile    : file of gatherrec;
  arcfile     : file of filbuffer;
  mesbdfile   : file of secttype;
  filebdfile  : file of secttype;

    systemrecz  : systemrec;
    idrecz      : sysid;
    logrecz     : log;
    signrecz    : signuprec;
    gathrecz    : gatherrec;
    arcrecz     : filbuffer;
    mesbdrecz   : secttype;
    filebdrecz  : secttype;
    bdlogrecz   : boardlog;
    mesrecz     : messages;
    filrecz     : filerec;


procedure panic(mes:name);
  begin
    fmerror:=mes;
    runerror(252);
    halt;
  end;


procedure fsplit(s:string;var d:dirstr;var n:namestr;var e:extstr);
(* ǂĂ dos.fsplit oÔœȕ쐬 *)
  var
    buf :string;
    loop:byte;
  begin
    buf:=s;
    if pos('.',buf)>0 then e:=copy(buf,pos('.',buf),4)
    else begin
      e:='';
      buf:=buf+'.';
    end;
    loop:=length(buf);
    while (loop>0) and not (buf[loop] in ['\',':']) do dec(loop);
    if loop>0 then begin
      n:=copy(buf,loop+1,pos('.',buf)-loop-1);
      d:=copy(buf,1,loop);
    end
    else begin
      n:=copy(buf,1,pos('.',buf)-loop-1);
      d:='';
    end;
    { writeln('<'+buf+'> <'+d+'> <'+n+'> <'+e+'>'); }
  end;

function allcaps(letters:string):string;
(*̑啶ϊ*)
  var
    loop:byte;
    temp:string;
  begin
    temp:='';
    for loop:=1 to length(letters) do
      temp:=temp+upcase(letters[loop]);
    allcaps:=temp;
  end;


procedure FileCopy(SourceName, DestName: string; var rslt:byte);
(* "*.BBS"t@C͈ȂƂɒ(ɃI[vĂ邩)B*)
  var
    fnametmp: string;
    buf   : filbuffer;
    g     : file;
    D2    : DirStr;
    N2    : NameStr;
    E2    : ExtStr;
    D3    : DirStr;
    N3    : NameStr;
    E3    : ExtStr;
    NumWritten : word;
    loop    : byte;
  begin
    rslt:=0;
    if (SourceName<>'') and (DestName<>'') and (SourceName<>DestName) and
      (pos('.BBS', SourceName)=0) and (pos('.BBS', DestName)=0) then begin
      FSplit(DestName,D2,N2,E2);
      FSplit(SourceName,D3,N3,E3);
        (* DestName ȗ̑΍ *)
      if (N2='') and (E2='') then begin N2:=N3; E2:=E3; end;
      assignM(SourceName);
      {$I-} resetM {$I+};
      rslt:=ioresult;
      if rslt=0 then begin
        fnametmp:=D2+'temp'+chr($30+cn)+'.$$$';
        changePSP(cn);
        assign(g, fnametmp);
        {$I-} rewrite(g, 1) {$I+};
        restorePSP;
        rslt:=ioresult;
        if rslt=0 then begin
          repeat
            for loop:=0 to 23 do TransferNext;
            {$I-} blockreadM(buf, 1); {$I+}
            rslt:=IOresult;
            if rslt=0 then begin
              for loop:=0 to 23 do TransferNext;
              changePSP(cn);
              {$I-} blockwrite(g, buf, cnarg[cn]^.RecCount, NumWritten); {$I+}
              restorePSP;
              rslt:=IOresult;
            end;
          until (cnarg[cn]^.RecCount = 0) or
            (cnarg[cn]^.RecCount <> NumWritten) or (rslt>0);
          changePSP(cn);
          SetFTime(g, cnarg[cn]^.FileTime);
          close(g);
          restorePSP;
        end;
        closeM;
      end;
      if rslt=0 then begin
        while SearchSameFile(DestName)>=0 do TransferNext;
        changePSP(cn);
        assign(g, D2+N2+E2);
        {$I-} reset(g) {$I+};
        if IOresult=0 then begin
          close(g);
          erase(g);
        end;
        assign(g, fnametmp);
        {$I-} rename(g, D2+N2+E2); {$I+}
        rslt:=ioresult;
        restorePSP;
      end;
    end
    else rslt:=161;
  end;


procedure InitCnM(c:shortint);
(*elŝP`l̏ (file, text) *)
  begin
    with cnarg[c]^.FMT do begin
      stream  := 0;
      filnam  := '';
      skposM  := 0;
      rdposM  := -1;
      eofflgM := false;
      delflgM := false;
    end;
  end;


procedure ClearCnM(c:byte);
(*elŝP`l̏ (t@C͎c) *)
  begin
    with cnarg[c]^.FMT do begin
      stream  := 0;
      skposM  := 0;
      rdposM  := -1;
      eofflgM := false;
      delflgM := false;
    end;
  end;


function SearchSameFile(filename:string):shortint;
  (* ̃t@C΂̃`lԍAȂ΁|PԂ *)
  var i : integer;
  begin
    i:=-1;
    repeat
      inc(i);
      if i=cn then inc(i);
    until (i>MaxCnNum)
      or ((cnarg[i]^.FMT.filnam=filename) and (cnarg[i]^.FMT.stream>0));
    if not (i>MaxCnNum) then SearchSameFile:=i
    else SearchSameFile:=-1;
  end;

function GetStreamNum:byte;
  (* gpĂȂXg[̔ԍ^ *)
  var
    chks  : array[0..MaxCn+1] of boolean;
    i, wk : integer;
  begin
    for i:=1 to MaxCn+1 do chks[i]:=false;
    for i:=0 to MaxCnNum do chks[cnarg[i]^.FMT.stream]:=true;
    i:=1;
    while (i<=MaxCnNum+1) and chks[i] do inc(i);
    if i>MaxCnNum+1 then panic('GetStreamNum');
    GetStreamNum:=i;
  end;


function exists(filename: string): boolean;
  (* ̃t@Cɑ݂邩 *)
  (* changePSP gpĂ͂ȂȂBINITBBS Ă΂邽 *)
  var
    f0 : file;
  begin
    if SearchSameFile(filename)>0 then exists := true
    else begin
      assign(f0,filename);
      {$I-} reset(f0) {$I+};
      if IOresult=0 then begin
        close(f0);
        exists := true;
      end
      else exists := false;
    end;
  end;

{----------------------------------------}

function getsystemexec:word;
  begin
    getsystemexec:=systemrecz.execute;
  end;

function getsystemlogon:longword;
  begin
    getsystemlogon:=systemrecz.logons;
  end;

function getsystemlogonline(linen:byte):longword;
  begin
    getsystemlogonline:=systemrecz.logonln[linen];
  end;

function getconsolelock:boolean;
  begin
    getconsolelock:=systemrecz.conlock;
  end;

procedure incsystemexec;  (* P͕KĂяo *)
  begin
    assign(systemfile,SysFileName);
    reset(systemfile);
    read(systemfile,systemrecz);
    inc(systemrecz.execute);
    seek(systemfile,0);
    write(systemfile,systemrecz);
    close(systemfile);
  end;

procedure incsystemlogon;
  begin
    assign(systemfile,SysFileName);
    reset(systemfile);
    inc(systemrecz.logons);
    inc(systemrecz.logonln[cn]);
    write(systemfile,systemrecz);
    close(systemfile);
  end;

procedure setconsolelock(lock:boolean);
  begin
    assign(systemfile,SysFileName);
    reset(systemfile);
    systemrecz.conlock:=lock;
    write(systemfile,systemrecz);
    close(systemfile);
  end;

{----------------------------------------}
procedure assignM(filename:string);
  begin
    with cnarg[cn]^.FMT do begin
      filnam  := allcaps(filename);
      eofflgM := false;
    end;
  end;

procedure resetM;
  var
    wk, strm : integer;
  begin {$I-}
    wk:=SearchSameFile(cnarg[cn]^.FMT.filnam);
    if wk=-1 then begin
      strm:=GetStreamNum;
      with cnarg[cn]^.FMT do begin
        stream:=strm;
        changePSP(strm-1);
        assign(fl_blk[strm], filnam);
        reset(fl_blk[strm], 1);
        eofflgM:=eof(fl_blk[strm]);
        GetFTime(fl_blk[strm], cnarg[cn]^.FileTime);
        restorePSP;
        cnarg[cn]^.RecCount:=0;
      end;
    end
    else cnarg[cn]^.FMT.stream := cnarg[wk]^.FMT.stream;
  end; {$I+}

procedure rewriteM;
  var
    wk, strm:integer;
  begin {$I-}
    wk:=SearchSameFile(cnarg[cn]^.FMT.filnam);
    if wk=-1 then begin
      cnarg[cn]^.WriteMode:=true;
      strm:=GetStreamNum;
      with cnarg[cn]^.FMT do begin
        stream := strm;
        changePSP(strm-1);
        assign(fl_blk[strm], filnam);
        rewrite(fl_blk[strm], 1);
        restorePSP;
      end;
      cnarg[cn]^.textpos := 0;
    end
    else cnarg[cn]^.FMT.stream := cnarg[wk]^.FMT.stream;
  end; {$I+}

procedure appendM;
(*eLXgt@C̃Ayhfile^Ŏ*)
  var
  wk, strm  : integer;
  rslt    : integer;
  ch      : byte;
  begin {$I-}
    wk:=SearchSameFile(cnarg[cn]^.FMT.filnam);
    if wk=-1 then begin
      cnarg[cn]^.WriteMode := true;
      strm:=GetStreamNum;
      with cnarg[cn]^.FMT do begin
        stream:=strm;
        changePSP(strm-1);
        assign(fl_blk[strm], filnam);
        reset(fl_blk[strm], 1);
        seek(fl_blk[strm], FileSize(fl_blk[strm])-cnarg[cn]^.RecSize);
        blockread(fl_blk[strm], cnarg[cn]^.textbrock, cnarg[cn]^.RecSize, cnarg[cn]^.RecCount);
        restorePSP;
        cnarg[cn]^.textpos := 0;
        ch := cnarg[cn]^.textbrock[cnarg[cn]^.textpos];
        while (ch <> $00) and (ch <> $1A)
          and (cnarg[cn]^.textpos < cnarg[cn]^.RecSize) do begin
          inc(cnarg[cn]^.textpos);
          ch := cnarg[cn]^.textbrock[cnarg[cn]^.textpos];
        end;
        if cnarg[cn]^.textpos = cnarg[cn]^.RecSize then cnarg[cn]^.textpos := 0
        else begin
          changePSP(strm-1);
          seek(fl_blk[strm], filesize(fl_blk[strm])-cnarg[cn]^.RecSize);
          restorePSP;
        end;
      end;
    end
    else cnarg[cn]^.FMT.stream := cnarg[wk]^.FMT.stream;
  end; {$I+}

procedure seekM(n:longint);
  begin
    cnarg[cn]^.FMT.skposM := n;
  end;

procedure writelnM(var linedata:string);
(*eLXgt@Co͂file^Ŏ*)
  var
  i : integer;
{$I-}
  procedure inctextpos;
    begin
      inc(cnarg[cn]^.textpos);
      if cnarg[cn]^.textpos >= cnarg[cn]^.RecSize then begin
        blockwriteM(cnarg[cn]^.textbrock, 1);
        cnarg[cn]^.textpos := 0;
      end;
    end;
  begin {writelnM}
    if linedata[1] <> #$1A then begin
      for i := 1 to length(linedata) do begin
        cnarg[cn]^.textbrock[cnarg[cn]^.textpos] := ord(linedata[i]);
        inctextpos;
      end;
      cnarg[cn]^.textbrock[cnarg[cn]^.textpos] := $0D;
      inctextpos;
      cnarg[cn]^.textbrock[cnarg[cn]^.textpos] := $0A;
      inctextpos;
    end
    else begin
      for i := cnarg[cn]^.textpos to cnarg[cn]^.RecSize-1 do cnarg[cn]^.textbrock[i] := $00;
      blockwriteM(cnarg[cn]^.textbrock, 1);
      cnarg[cn]^.textpos := 0;
    end;
  end; {$I+}

procedure blockreadM(var filebrock:filbuffer; n:word);
  begin {$I-}
    with cnarg[cn]^.FMT do begin
      changePSP(stream-1);
      seek(fl_blk[stream], skposM*cnarg[cn]^.RecSize);
      blockread(fl_blk[stream], filebrock, n*cnarg[cn]^.RecSize, cnarg[cn]^.RecCount);
      restorePSP;
      rdposM := skposM;
      inc(skposM);
      if n*cnarg[cn]^.RecSize <> cnarg[cn]^.RecCount then eofflgM := true;
    end;
  end; {$I+}

procedure blockwriteM(var filebrock:filbuffer; n:word);
  begin {$I-}
    with cnarg[cn]^.FMT do begin
      changePSP(stream-1);
      seek(fl_blk[stream], skposM*cnarg[cn]^.RecSize);
      blockwrite(fl_blk[stream], filebrock, n*cnarg[cn]^.RecSize, cnarg[cn]^.RecCount);
      restorePSP;
      rdposM := skposM;
      inc(skposM);
      if n*cnarg[cn]^.RecSize <> cnarg[cn]^.RecCount then eofflgM := true;
    end;
  end; {$I+}

procedure closeM;
  var wk : integer;
  begin {$I-}
    wk:=SearchSameFile(cnarg[cn]^.FMT.filnam);
    if wk=-1 then begin
      if cnarg[cn]^.WriteMode then cnarg[cn]^.WriteMode:=false;
      with cnarg[cn]^.FMT do begin
        changePSP(stream-1);
        close(fl_blk[stream]);
        if delflgM then erase(fl_blk[stream]);
        restorePSP;
      end;
    end
    else if cnarg[cn]^.FMT.delflgM then cnarg[wk]^.FMT.delflgM := true;
    ClearCnM(cn);
  end; {$I+}

procedure eraseM;
  var
    wk : integer;
    f0 : file;
  begin {$I-}
    wk:=SearchSameFile(cnarg[cn]^.FMT.filnam);
    if wk=-1 then begin
    {$I-}
      changePSP(cn);
      assign(f0, cnarg[cn]^.FMT.filnam);
      reset(f0);
      {$I+}
      if IOresult=0 then begin
        close(f0);
        erase(f0);
      end;
      restorePSP;
    end
    else cnarg[wk]^.FMT.delflgM := true;
    ClearCnM(cn);
  end; {$I+}

procedure renameM(filename: string);
  var
    rslt:byte;
  begin
    FileCopy(cnarg[cn]^.FMT.filnam, filename, rslt);
    eraseM;
  end;

function filesizeM: longint;
  begin {$I-}
    with cnarg[cn]^.FMT do begin
      changePSP(stream-1);
      filesizeM := (filesize(fl_blk[stream])+cnarg[cn]^.RecSize-1) div cnarg[cn]^.RecSize;
      restorePSP;
    end;
  end; {$I+}

function eofM: boolean;
  begin
    eofM := cnarg[cn]^.FMT.eofflgM;
  end;

{----------------------------------------}

procedure InitCnB(c:shortint);
(*elŝP`l̏ (VXeǗt@C) *)
  begin
    with cnarg[c]^.FMT do begin
      dup      := 0;
      filtypB  := closed;
      locktypB := closed;
      boardB   := -1;
    end;
  end;

procedure openBBSfiles;
(*hct@CAOt@C͈ꊇĂnodm*)
  begin
    assign(idfile, IdFileName);
    {$I-} reset(idfile); {$I+}
    if IOresult<>0 then rewrite(idfile);
    if logsize>0 then begin
      assign(logfile, LogFileName);
      {$I-} reset(logfile); {$I+}
      if IOresult<>0 then rewrite(logfile);
    end;
    assign(signfile, SignupFileName);
    {$I-} reset(signfile); {$I+}
    if IOresult<>0 then rewrite(signfile);
    if gathersize>0 then begin
      assign(gathfile, GatherFileName);
      {$I-} reset(gathfile); {$I+}
      if IOresult<>0 then rewrite(gathfile);
    end;
    assign(mesbdfile, MesbdFileName);
    {$I-} reset(mesbdfile); {$I+}
    if IOresult<>0 then rewrite(mesbdfile);
    assign(filebdfile, FilebdFileName);
    {$I-} reset(filebdfile); {$I+}
    if IOresult<>0 then rewrite(filebdfile);
  end;

procedure closeBBSfiles;
(*hct@CAOt@C͈ꊇĂbknrd*)
  begin
    close(idfile);
    if logsize>0 then close(logfile);
    close(signfile);
    if gathersize>0 then close(gathfile);
    close(mesbdfile);
    close(filebdfile);
  end;

function SearchSameBoard(bd:integer):shortint;
  (*{[hANZXĂ΂̃`lԍAȂ΁|PԂ*)
  var i:shortint;
  begin
    i:=-1;
    repeat
      inc(i);
      if i=cn then inc(i);
    until (i>MaxCnNum) or
      ((cnarg[i]^.FMT.boardB=bd) and (cnarg[i]^.FMT.dup>0));
    if not (i>MaxCnNum) then SearchSameBoard:=i
    else SearchSameBoard:=-1;
  end;

function GetBoardNum:byte;
  (*gpĂȂ{[hXg[̔ԍ^*)
  var
    chks :array[0..MaxCn+1] of boolean;
    i, wk:integer;
  begin
    for i:=1 to MaxCn+1 do chks[i]:=false;
    for i:=0 to MaxCnNum do chks[cnarg[i]^.FMT.dup]:=true;
    i:=1;
    while (i<=MaxCnNum+1) and chks[i] do inc(i);
    if i>MaxCnNum+1 then panic('GetBoardNum');
    GetBoardNum:=i;
  end;

procedure openBoard(boardnum:integer);
  var
    i:byte;
    c:shortint;
    temp:string;
    buf :filbuffer;
  begin {$I-}
    if cnarg[cn]^.FMT.boardB<>-1 then panic('openBoard');
    if (boardnum=0) and statusmail then begin
      requestmail;   (* f[Ƀ[{bNX̖nv *)
      while statusmail do transfernext;    (* ܂ő҂ *)
    end;
    cnarg[cn]^.FMT.boardB:=boardnum;
    c:=SearchSameBoard(boardnum);
    if c=-1 then begin
      i:=GetBoardNum;
      cnarg[cn]^.FMT.dup:=i;
      if boardnum<1000 then begin
        str(boardnum,temp);
        changePSP(i-1);
        assign(mf_blk[i],boarddrive+'MESSM'+temp+'.BBS');
        reset(mf_blk[i]);
        if ioresult>0 then rewrite(mf_blk[i]);
        if boardnum>0 then begin   (* [{bNXł̓OȂ *)
          assign(log_blk[i],logdrive+'MESSL'+temp+'.BBS');
          reset(log_blk[i]);
          if ioresult>0 then rewrite(log_blk[i]);
        end;
        assign(arc_blk[i],arcvdrive+'ARCM'+temp+'.BBS');
        reset(arc_blk[i]);
        if ioresult>0 then panic('Destroy arc');
        seek(arc_blk[i],$0000);
        read(arc_blk[i],filbuffer(cnarg[i-1]^.ratbuf));
        with cnarg[i-1]^ do begin
          ratsize:=ratbuf[0];
          ratlast:=ratbuf[1];
          ratlastbak:=ratlast;
          ratrec:=$0000;
          ratwrite:=false;
        end;
        seek(arc_blk[i],$0001);
        read(arc_blk[i],filbuffer(cnarg[i-1]^.ratbuf));
        restorePSP;
      end
      else begin
        str(boardnum-1000,temp);
        changePSP(i-1);
        assign(ff_blk[i],boarddrive+'FILEM'+temp+'.BBS');
        reset(ff_blk[i]);
        if ioresult>0 then rewrite(ff_blk[i]);
        assign(log_blk[i],logdrive+'FILEL'+temp+'.BBS');
        reset(log_blk[i]);
        if ioresult>0 then rewrite(log_blk[i]);
        restorePSP;
      end;
    end
    else cnarg[cn]^.FMT.dup:=cnarg[c]^.FMT.dup;
  end; {$I+}

procedure closeBoard;
  var
    c    :shortint;
    bk   :string;
    i    :byte;
    o    :byte;
    temp :string;
    dumy1:file of messages;
    dumy2:file of filerec;
    dumy3:file of boardlog;
  begin {$I-}
    c:=SearchSameBoard(cnarg[cn]^.FMT.boardB);
    if c=-1 then begin
      i:=cnarg[cn]^.FMT.dup;
      if cnarg[cn]^.FMT.boardB<1000 then begin
        changePSP(i-1);
        close(mf_blk[i]);
        if cnarg[cn]^.FMT.boardB>0 then close(log_blk[i]);
        if cnarg[i-1]^.ratwrite then begin
          seek(arc_blk[i],cnarg[i-1]^.ratrec+1);
          write(arc_blk[i],filbuffer(cnarg[i-1]^.ratbuf));
        end;
        if cnarg[i-1]^.ratlast<>cnarg[i-1]^.ratlastbak then begin
          cnarg[i-1]^.ratbuf[0]:=cnarg[i-1]^.ratsize;
          cnarg[i-1]^.ratbuf[1]:=cnarg[i-1]^.ratlast;
          for o:=2 to 63 do cnarg[i-1]^.ratbuf[o]:=0;
          seek(arc_blk[i],$0000);
          write(arc_blk[i],filbuffer(cnarg[i-1]^.ratbuf));
        end;
        close(arc_blk[i]);
        restorePSP;
      end
      else begin
        changePSP(i-1);
        close(ff_blk[i]);
        close(log_blk[i]);
        restorePSP;
      end;
      (* f[Ƀ[{bNX𖾂n *)
      if cnarg[cn]^.FMT.boardB=0 then detailmail;
    end;
    InitCnB(cn);
  end; {$I+}

procedure seekB(ftype:FileTypeB; n:longint);
  var
    tempb:byte;
    tempp:pointer;
  begin {$I-}
  with cnarg[cn]^.FMT do begin
    filtypB := ftype;
    case filtypB of
      idfil  : begin
             skposB := n;
             seek(idfile, n);
             eofflgB := eof(idfile);
           end;
      logfil : begin
             skposB := n;
             seek(logfile, n);
             eofflgB := eof(logfile);
           end;
      signfil: begin
             skposB := n;
             seek(signfile, n);
             eofflgB := eof(signfile);
           end;
      gathfil: begin
             skposB := n;
             seek(gathfile, n);
             eofflgB := eof(gathfile);
           end;
      mbdfil : begin
             skposB := n;
             seek(mesbdfile, n);
             eofflgB := eof(mesbdfile);
           end;
      fbdfil : begin
             skposB := n;
             seek(filebdfile, n);
             eofflgB := eof(filebdfile);
           end;
      bdlog  : begin
             skposB := n;
             changePSP(dup-1);
             seek(log_blk[dup], n);
             eofflgB := eof(log_blk[dup]);
             restorePSP;
           end;
      arcfil : begin
             skposB:=n;
             changePSP(dup-1);
             seek(arc_blk[dup],n);
             eofflgB := eof(arc_blk[dup]);
             restorePSP;
           end;
      mesfil : begin
             skposB := n;
             changePSP(dup-1);
             seek(mf_blk[dup], n);
             eofflgB := eof(mf_blk[dup]);
             restorePSP;
           end;
      filfil : begin
             skposB := n;
             changePSP(dup-1);
             seek(ff_blk[dup], n);
             eofflgB := eof(ff_blk[dup]);
             restorePSP;
           end;
      end;
    end;
  end; {$I+}

function  islockB(ftype:FileTypeB; n:longint): boolean;
(*̃R[hbNĂ邩^*)
  var
    i      : integer;
    board  : integer;
  begin
    i := -1;
    board := cnarg[cn]^.FMT.boardB;
    repeat
      inc(i);
      if i = cn then inc(i);
    until (i > MaxCnNum)
      or ((cnarg[cn]^.FMT.locktypB = ftype) and
      (cnarg[cn]^.FMT.lockposB = n) and
      (cnarg[cn]^.FMT.boardB = board));
    if i <= MaxCnNum then islockB := true
    else islockB := false;
  end;

procedure lockB(ftype:FileTypeB; n:longint);
  begin
    with cnarg[cn]^.FMT do begin
      locktypB := ftype;
      lockposB := n;
    end;
  end;

procedure unlockB(ftype:FileTypeB);
  begin
    cnarg[cn]^.FMT.locktypB := closed;
  end;

procedure readB(ftype:FileTypeB; recptr:pointer);
  begin {$I-}
    with cnarg[cn]^.FMT do begin
    if filtypB <> ftype then panic('readB');
      case filtypB of
        idfil  : begin
               read(idfile, idrecz);
               eofflgB := eof(idfile);
               move(idrecz, recptr^, sizeof(idrecz));
             end;
        logfil : begin
               read(logfile, logrecz);
               eofflgB := eof(logfile);
               move(logrecz, recptr^, sizeof(logrecz));
             end;
        signfil: begin
               read(signfile, signrecz);
               eofflgB := eof(signfile);
               move(signrecz, recptr^, sizeof(signrecz));
             end;
        gathfil: begin
               read(gathfile, gathrecz);
               eofflgB := eof(gathfile);
               move(gathrecz, recptr^, sizeof(gathrecz));
             end;
        mbdfil : begin
               read(mesbdfile, mesbdrecz);
               eofflgB := eof(mesbdfile);
               move(mesbdrecz, recptr^, sizeof(mesbdrecz));
             end;
        fbdfil : begin
               read(filebdfile, filebdrecz);
               eofflgB := eof(filebdfile);
               move(filebdrecz, recptr^, sizeof(filebdrecz));
             end;
        bdlog  : begin
               changePSP(dup-1);
               read(log_blk[dup], bdlogrecz);
               eofflgB := eof(log_blk[dup]);
               move(bdlogrecz, recptr^, sizeof(bdlogrecz));
               restorePSP;
             end;
        arcfil : begin
               changePSP(dup-1);
               read(arc_blk[dup], arcrecz);
               eofflgB := eof(arc_blk[dup]);
               move(arcrecz, recptr^, sizeof(arcrecz));
               restorePSP;
             end;
        mesfil : begin
               changePSP(dup-1);
               read(mf_blk[dup], mesrecz);
               eofflgB := eof(mf_blk[dup]);
               move(mesrecz, recptr^, sizeof(mesrecz));
               restorePSP;
             end;
        filfil : begin
               changePSP(dup-1);
               read(ff_blk[dup], filrecz);
               eofflgB := eof(ff_blk[dup]);
               move(filrecz, recptr^, sizeof(filrecz));
               restorePSP;
             end;
      end;
    end;
  end;{$I+}

procedure writeB(ftype:FileTypeB; recptr:pointer);
  begin {$I-}
    with cnarg[cn]^.FMT do begin
    if filtypB <> ftype then panic('writeB');
      case filtypB of
        idfil  : begin
               move(recptr^, idrecz, sizeof(idrecz));
               write(idfile, idrecz);
             end;
        logfil : begin
               move(recptr^, logrecz, sizeof(logrecz));
               write(logfile, logrecz);
             end;
        signfil: begin
               move(recptr^, signrecz, sizeof(signrecz));
               write(signfile, signrecz);
             end;
        gathfil: begin
               move(recptr^, gathrecz, sizeof(gathrecz));
               write(gathfile, gathrecz);
             end;
        mbdfil : begin
               move(recptr^, mesbdrecz, sizeof(mesbdrecz));
               write(mesbdfile, mesbdrecz);
             end;
        fbdfil : begin
               move(recptr^, filebdrecz, sizeof(filebdrecz));
               write(filebdfile, filebdrecz);
             end;
        bdlog  : begin
               changePSP(dup-1);
               move(recptr^, bdlogrecz, sizeof(bdlogrecz));
               write(log_blk[dup], bdlogrecz);
               restorePSP;
             end;
        arcfil : begin
               changePSP(dup-1);
               move(recptr^, arcrecz, sizeof(arcrecz));
               write(arc_blk[dup], arcrecz);
               restorePSP;
             end;
        mesfil : begin
               changePSP(dup-1);
               move(recptr^, mesrecz, sizeof(mesrecz));
               write(mf_blk[dup], mesrecz);
               restorePSP;
             end;
        filfil : begin
               changePSP(dup-1);
               move(recptr^, filrecz, sizeof(filrecz));
               write(ff_blk[dup], filrecz);
               restorePSP;
             end;
      end;
    end;
  end; {$I+}

function eofB(ftype:FileTypeB): boolean;
  begin
    with cnarg[cn]^.FMT do begin
      if not (filtypB in [idfil,logfil,signfil,gathfil,mbdfil,fbdfil])
        and (filtypB <> ftype) then panic('eofB');
      eofB := eofflgB;
    end;
  end;

procedure truncateB(ftype:FileTypeB);
  begin {$I-}
    case ftype of
      idfil  : truncate(idfile);
      logfil : truncate(logfile);
      signfil: truncate(signfile);
      gathfil: truncate(gathfile);
      mbdfil : truncate(mesbdfile);
      fbdfil : truncate(filebdfile);
      bdlog  : begin
                 changePSP(cnarg[cn]^.FMT.dup-1);
                 truncate(log_blk[cnarg[cn]^.FMT.dup]);
                 restorePSP;
               end;
      arcfil : begin
                 changePSP(cnarg[cn]^.FMT.dup-1);
                 truncate(arc_blk[cnarg[cn]^.FMT.dup]);
                 restorePSP;
               end;
      mesfil : begin
                 changePSP(cnarg[cn]^.FMT.dup-1);
                 truncate(mf_blk[cnarg[cn]^.FMT.dup]);
                 restorePSP;
               end;
      filfil : begin
                 changePSP(cnarg[cn]^.FMT.dup-1);
                 truncate(ff_blk[cnarg[cn]^.FMT.dup]);
                 restorePSP;
               end;
    end;
    cnarg[cn]^.FMT.eofflgB:=true;
  end; {$I+}

function filesizeB(ftype:FileTypeB): longint;
  (* arcfil قȂiRAT TCY̎擾j*)
  begin {$I-}
    case ftype of
      idfil  : filesizeB := filesize(idfile);
      logfil : filesizeB := filesize(logfile);
      signfil: filesizeB := filesize(signfile);
      gathfil: filesizeB := filesize(gathfile);
      mbdfil : filesizeB := filesize(mesbdfile);
      fbdfil : filesizeB := filesize(filebdfile);
      bdlog  : begin
               changePSP(cnarg[cn]^.FMT.dup-1);
               filesizeB := filesize(log_blk[cnarg[cn]^.FMT.dup]);
               restorePSP;
               end;
      arcfil : begin
               filesizeB := cnarg[cnarg[cn]^.FMT.dup-1]^.ratsize;
               end;
      mesfil : begin
               changePSP(cnarg[cn]^.FMT.dup-1);
               filesizeB := filesize(mf_blk[cnarg[cn]^.FMT.dup]);
               restorePSP;
               end;
      filfil : begin
               changePSP(cnarg[cn]^.FMT.dup-1);
               filesizeB := filesize(ff_blk[cnarg[cn]^.FMT.dup]);
               restorePSP;
               end;
    end;
  end; {$I+}


(* A[JCut@CRg[  uses mailsys   ComServe

   RAT (Record Allocation Table)  16bit,R[h $0001`ratsize ܂ŋL^
   oBPR[h 128Byte.  (=filbuffer)
   RAT ̑F $0000   :gpigp\̃R[hj
                ratsize :`FC̏IB
                ̑  :̃`FCwB

   `FC͕K ratsize ŏIȂ΂ȂȂB
   bZ[W̓r $0000 Ă͂ȂȂB
     iƂ݂ΌxbZ[Wo܂j

   xbZ[WoȂ΁A߂ Archiver 蒼܂傤B
  iSĂƁA񂾃bZ[W߂߂ɂȂ\܂Bj
*)

(* RAT 擾Eݒ *)
(* 64words (=filbuffer) ̋^ cache ݂čB*)

function getrat(tw:word):word;
  var
    staticrec:word;
    dupx     :byte;
  begin
    dupx:=cnarg[cn]^.FMT.dup-1;
    staticrec:=tw div 64;
    if cnarg[dupx]^.ratrec<>staticrec then begin
      if cnarg[dupx]^.ratwrite then begin
        seekB(arcfil,cnarg[dupx]^.ratrec+1);
        writeB(arcfil,@cnarg[dupx]^.ratbuf);
      end;
      seekB(arcfil,staticrec+1);
      readB(arcfil,@cnarg[dupx]^.ratbuf);
      cnarg[dupx]^.ratrec:=staticrec;
      cnarg[dupx]^.ratwrite:=false;
    end;
    getrat:=cnarg[dupx]^.ratbuf[tw mod 64];
  end;

procedure setrat(tw:word;dat:word);
  var
    staticrec:word;
    dupx     :byte;
  begin
    dupx:=cnarg[cn]^.FMT.dup-1;
    staticrec:=tw div 64;
    if cnarg[dupx]^.ratrec<>staticrec then begin
      if cnarg[dupx]^.ratwrite then begin
        seekB(arcfil,cnarg[dupx]^.ratrec+1);
        writeB(arcfil,@cnarg[dupx]^.ratbuf);
      end;
      seekB(arcfil,staticrec+1);
      readB(arcfil,@cnarg[dupx]^.ratbuf);
      cnarg[dupx]^.ratrec:=staticrec;
    end;
    cnarg[dupx]^.ratbuf[tw mod 64]:=dat;
    cnarg[dupx]^.ratwrite:=true;
  end;

function findfreerec(recs:word):word;
  var
    temp:word;
  begin
    repeat
      inc(recs);
      temp:=getrat(recs);
    until (temp=$0000) or (recs=filesizeB(arcfil));
    if recs=filesizeB(arcfil) then begin
      recs:=0;     (* ČJn *)
      repeat
        inc(recs);
        temp:=getrat(recs);
      until (temp=$0000) or (recs=filesizeB(arcfil));
    end;
    if recs=filesizeB(arcfil) then findfreerec:=0
    else findfreerec:=recs;
  end;

function firstfreerec:word;
  begin
    firstfreerec:=findfreerec(cnarg[cnarg[cn]^.FMT.dup-1]^.ratlast);
  end;

procedure replaceratend(link:word);
  begin
    if cnarg[cnarg[cn]^.FMT.dup-1]^.ratlast>link-1 then
      cnarg[cnarg[cn]^.FMT.dup-1]^.ratlast:=link-1;
  end;

procedure nextfreerec(var link:word);
  (* 󂫃R[h{AÕ`FCɐVR[hԍ *)
  var
    temp:word;
  begin
    temp:=link;
    link:=findfreerec(link);
    setrat(temp,link);
    replaceratend(link);
  end;

procedure endmark(link:word);
  (* I}[N (ratsize)  (End of Chain) *)
  begin
    setrat(link,word(filesizeB(arcfil)));
    replaceratend(link);
  end;

procedure clearB;
  begin
    with cnarg[cn]^.FMT do begin
      filtypB  := closed;
      locktypB := closed;
    end;
  end;

function lookup(l:byte):string;
  begin
    case l of
      2:lookup:='t@CȂ';
      3:lookup:='pXȂ';
      4:lookup:='CONFIG.SYS  FILES Ȃ';
      6,102:lookup:='t@Cnhs';
      12:lookup:='t@C̕sv';
      100:lookup:='t@C[h̃I[o[';
      101:lookup:='fBXN̋󂫗eʂ';
      103:lookup:='t@CI[vĂȂ';
      104:lookup:='t@CI[vĂȂ';
      150:lookup:='fBXNCgveNgĂ';
      151:lookup:='ANZX悤ƂhCu';
      152:lookup:='hCȕoĂȂ';
      154:lookup:='fBXN̂bqbG[';
      156:lookup:='fBXÑV[NG[';
      158:lookup:='fBXÑZN^Ȃ';
      160:lookup:='fBXN݂̏Ɏs';
      161:lookup:='fBXN̓ǂݍ݂Ɏs';
      162:lookup:='n[hEFÃG[';
      200:lookup:='OŏZ';
      202:lookup:='X^bNȂ';
      251:lookup:='ϰײް  ޼ޮ K܂B';
      252:lookup:='t@C}l[W̋s  :'+fmerror;
      253:lookup:='RS232C ײް  ޼ޮ K܂B';
      254:lookup:='Ȃ';
      255:lookup:='JoȂ';
      else if l<200 then lookup:='t@C̓G['
      else lookup:=
        'siTRS ֘Aĉ    ̫Ұ:RTBBS.EXE /?j';
    end;
  end;

end.
