{
  "CHATSYS.PAS  ( UNIT : chatsys )  g[NE`bg

}

unit chatsys;

{----------------------------------------------------------------------}
interface

uses
  dos, jmpcall, header, rsdriver,
  kernel, filmangr, monitor, io;

procedure writememo;
procedure talks;
procedure who;
procedure who0;
procedure chat;
procedure gather;

{----------------------------------------------------------------------}
implementation


procedure writememo;
  begin
    lineout('');
    cnarg[cn]^.prompt:='[36m͂ĉ[m ([33m[RET]:clear[m) >';
    cnarg[cn]^.memo:=getinputguide(cnarg[cn]^.prompt,32,echo);
  end;


procedure who0;
  var i : integer;
  begin
    if cts then begin
      lineout('');
      lineout('[32mCh   ID       Handle   Command  Baud/ptcl Memo[m');
      lineout('[33m---- -------- -------- -------- --------- --------------------------------[m');
      for i := 0 to MaxCnNum do begin
        lineout(whereisCn(i));
      end;
    end;
    if cnarg[cn]^.cancelled then cnarg[cn]^.cancelled:=false;
  end;


procedure who;
  var i : integer;
  begin
    cnarg[cn]^.CnStat := zwho;
    if hoststat = 0 then dispstatus(cn);
    if cts then who0;
  end;


procedure gather;

  var
    loop:shortint;
    lin :shortint;
    temp:gatherrec;
    bkup:string;

  procedure addgather(s:gatherrec);
  var
    loop:shortint;
    temp:gatherrec;
  begin
    if islockB(gathfil,0) then transfernext;
    lockB(gathfil,0);
    loop:=filesizeB(gathfil)-1;
    if gathersize-1=loop then dec(loop);
    while loop>=0 do begin
      transfernext;
      seekB(gathfil,loop);
      readB(gathfil,@temp);
      transfernext;
      seekB(gathfil,loop+1);
      writeB(gathfil,@temp);
      dec(loop);
    end;
    seekB(gathfil,0);
    writeB(gathfil,@s);
    unlockB(gathfil);
  end;

begin
  cnarg[cn]^.CnStat := zgather;
  if hoststat = 0 then dispstatus(cn);
  if gathersize = 0 then begin
    lineout('');
    lineout('[33m`̓T|[gĂ܂B[m');
    exit;
  end;
  lineout('');
  lineout('[32mGather world[m');
  lineout('[33m------------------------------------------------------------------------[m');
  if islockB(gathfil,0) then transfernext;
  lockB(gathfil,0);
  loop:=filesizeB(gathfil)-1;
  if loop>=0 then
    while (loop>=0) and not cnarg[cn]^.cancelled do begin
      seekB(gathfil,loop);
      readB(gathfil,@temp);
      lineout('[32m'+temp.time+' [36m'+getname(temp.id)+' [33m'+
        gethandle(temp.id)+'[m');
      for lin:=0 to temp.lines do lineout('  '+temp.gather[lin]);
      dec(loop);
    end
  else lineout('[31mbZ[W͂܂B[m');
  unlockB(gathfil);
  if cnarg[cn]^.cancelled then cnarg[cn]^.cancelled:=false;
  lineout('[33m------------------------------------------------------------------------[m');
  lineout('');
  lineout('[36mGATHER[m :[36m`[32m 70[36m A[32m10[36m sȓłǂ[m ([33m//:quit[m)');
  lineout('');
  temp.id:=cnarg[cn]^.usernum;
  clock(year, month, date, hour, min, sec);
  temp.time:=time(year, month, date, hour, min, sec);
  lin:=0;
  lineout('        [36m1[34m---+---[36m10[34m----+---[36m20'+
    '[34m----+---[36m30[34m----+---[36m40[34m----+---[36m50'+
    '[34m----+---[36m60[34m----+---[36m70[m');
  cnarg[cn]^.prompt:='[36mGather[m >';
  repeat
    temp.gather[lin]:=getinput(cnarg[cn]^.prompt,70,echo);
    inc(lin);
  until (temp.gather[lin-1]='//') or (lin=10) or not cts;
  lineout('');
  if cts and (lin>1) then begin
    if temp.gather[lin-1]='//' then dec(lin);
    temp.lines:=lin-1;
    stringout('[32mۊǒ ...');
    addgather(temp);
    lineout(' [33mۊǂ܂B[m');
  end
  else lineout('[31m~܂B[m');
end;


procedure chat;
  var
  wpos    : integer;
  wkline  : string;
  prompt  : string;
  channel : integer;
  message : string;
  timemsg : string8;
  loop    : shortint;
  test    : integer;
  exts    : boolean;

  procedure initpos;
    begin
      cnarg[cn]^.rpos := spos;
    end;

  procedure addchatlog(s:string);
    var
      loop:shortint;
    begin
      loop:=nowchatlogsize-1;
      if ChatLogSize-1=loop then dec(loop)
      else inc(nowchatlogsize);
      while loop>=0 do begin
        chatlogbuf^[loop+1]:=chatlogbuf^[loop];
        dec(loop);
      end;
      chatlogbuf^[0]:='[['+messcolor[cfrom[cnarg[cn]^.rpos]]+'m'+
        copy(cnarg[cn]^.handle_name+'        ',1,8)+'[m] '+s;
    end;

begin {of chat}
  cnarg[cn]^.CnStat := zchat;
  if hoststat = 0 then dispstatus(cn);
  with cnarg[cn]^.TelgBuf do begin
    tocn := -1;
    usernum := 0;
    tonum := 0;
    recv := tsend;
  end;
  if cnarg[cn]^.expert=ebegin then begin
    lineout('');
    outfile(bmesdrive+j_chathelp);
  end;
  lineout('');
  showtime;
  lineout('');
  if nowchatlogsize>0 then begin
    lineout('[32mChat log[m');
    lineout('[33m---------- -------------------------------------------------------------------[m');
    for loop:=nowchatlogsize-1 downto 0 do lineout(chatlogbuf^[loop]);
    if cnarg[cn]^.cancelled then cnarg[cn]^.cancelled:=false;
    lineout('[33m---------- -------------------------------------------------------------------[m');
    lineout('');
  end;
  initpos;
  wpos := spos;
  incpos(spos);
  exts:=false;
  cfrom[wpos] := cn;
  wkline:=copy(cnarg[cn]^.caller+'        ',1,8)+' [36mis chat room in.[m';
  ChatBuf[wpos] := wkline;
  addchatlog(wkline);
  repeat
    if cts then begin
      wkline:=getinput('', 255, echo);
      if wkline='?' then begin
        lineout('');
        outfile(bmesdrive+j_chathelp);
        lineout('');
      end
      else if allcaps(wkline)='W' then begin
        who0;
        lineout('');
      end
      else if allcaps(wkline)='T' then talks
      else if allcaps(wkline)='D' then sysopcall
      else if wkline='#' then showstatus
      else if wkline='\' then writememo
      else if cts then begin
        if wkline='//' then begin
          wkline:=
            copy(cnarg[cn]^.caller+'        ',1,8) + ' [33mis room out.[m';
          lineout('[33m`bgI܂B[m');
          exts:=true;
        end;
        if wkline<>'' then begin
          wpos:=spos;
          incpos(spos);
          cfrom[wpos]:=cn;
          ChatBuf[wpos]:=wkline;
          addchatlog(wkline);
        end;
      end;
    end;
    wpos:=spos;
  until exts or not cts;
  if exts then begin
    exts:=false;
    for loop:=0 to MaxCnNum do
    if (loop<>cn) and (cnarg[loop]^.cnstat=zchat) then exts:=true;
    if not exts then nowchatlogsize:=0;
  end;
end;

procedure talks;
  var
    prompt  : string;
    channel : integer;
    message : string;
    userin  : name;
    test    : integer;
    conti   : boolean;
    bkup    : where;
  begin
    if cts and (cnarg[cn]^.access < reg) then begin
      lineout('');
      lineout('[31mQXg͎gpł܂B[m');
      exit;
    end;
    message:='';
    conti:=(cnarg[cn]^.inbuffer='') and
      not (cnarg[cn]^.cnstat in [zeditor,zchat,ztalkx]);
    repeat
      prompt:='[36mg[N`lw肵ĉ[m ([33m[RET]:quit[m) >';
      lineoutifneed;
      userin := getinput(prompt, 5, echo);
      val(userin, channel, test);
      if (test>0) and
        not (cnarg[cn]^.cnstat in [zeditor,zchat,ztalkx]) then conti:=true;
    until ((test=0) and (channel>=0) and (channel<=MaxCnNum)) or (userin='')
      or not cts;
    if userin='' then channel:=-1
    else if channel>=0 then begin
      if cnarg[channel]^.cnstat in
        [zoff, zawait, zout, zclose, zewait] then begin
        lineout('');
        lineout('[31m̃`l͐ڑĂ܂B[m');
      end
      else if cts then begin
        if conti then begin
          bkup := cnarg[cn]^.CnStat;
          cnarg[cn]^.CnStat := ztalkx;
          if hoststat = 0 then dispstatus(cn);
          if cnarg[cn]^.expert=ebegin then begin
            lineout('');
            outfile(bmesdrive+j_chathelp);
          end;
          lineout('');
          lineout('[33mg[N[hɓ܂B[m');
        end;
        lineoutifneed;
        repeat
          message:='';
          if conti then prompt := '[36m#[m '
          else prompt := '[36mү[m >';
          message := getinput(prompt,255, echo);
          if conti then begin
            if cnarg[channel]^.cnstat in [zoff, zawait, zclose] then begin
              lineout('');
              lineout('[31m肪OAEĝŏI܂B[m');
              message := '//';
              conti:=false;
            end
            else if message='?' then begin
              lineout('');
              outfile(bmesdrive+j_chathelp);
              lineout('');
            end
            else if allcaps(message)='W' then begin
              who0;
              lineout('');
            end
            else if allcaps(message)='D' then sysopcall
            else if allcaps(message)='T' then talks
            else if message = '#' then showstatus
            else if message = '\' then writememo
            else if message<>'//' then with cnarg[cn]^.TelgBuf do begin
              tocn := channel;
              usernum := cnarg[cn]^.usernum;
              tonum := cnarg[channel]^.usernum;
              msg := message;
            end;
          end
          else if message<>'//' then with cnarg[cn]^.TelgBuf do begin
            tocn := channel;
            usernum := cnarg[cn]^.usernum;
            tonum := cnarg[channel]^.usernum;
            msg := message;
          end;
        until not conti or (message='//') or not cts;
        if conti then begin
          lineout('');
          lineout('[33mg[N[hI܂B[m');
          cnarg[cn]^.CnStat :=bkup;
          if hoststat = 0 then dispstatus(cn);
        end;
      end;
    end;
  end;


end.

