{
  "BOARDSYS.PAS  ( UNIT : BOARDSYS )  {[hǗVXe
}

unit boardsys;

{----------------------------------------------------------------------}
interface

uses
  Dos, JmpCall, header, rsdriver,
  kernel, io, filmangr, editsys, transsys;

procedure writebdlog(logs:boardlog);
function  getdays(s:string):DateTime;
function  boardname(number: integer): string;
function  sectwithnum(buf:secttype): string;
procedure listsections;
procedure allsections;
function  issigop:boolean;
function  testin(buf:secttype;prt:boolean):boolean;
function  paththru(buf:secttype):boolean;
procedure outinfo;
procedure sectheader(s:string);
procedure putinfo;
procedure custboard;

{----------------------------------------------------------------------}
implementation


procedure writebdlog(logs:boardlog);
var
  i,n:integer;
  temp:boardlog;
begin
  if cnarg[cn]^.sect.logsize>0 then begin
    n:=filesizeB(bdlog);
    if islockB(bdlog,1) then transfernext;
    lockB(bdlog,1);
    if cnarg[cn]^.sect.logsize=n then begin
      for i:=0 to cnarg[cn]^.sect.logsize-2 do begin
        seekB(bdlog,i+1);
        readB(bdlog,@temp);
        transfernext;
        seekB(bdlog,i);
        writeB(bdlog,@temp);
        transfernext;
      end;
      seekB(bdlog,cnarg[cn]^.sect.logsize-1);
    end
    else seekB(bdlog,n);
    writeB(bdlog,@logs);
    unlockB(bdlog);
  end;
end;

function getdays(s:string):Datetime;
  var
    datefrom:Datetime;
    wk      :string;
    i       :byte;
    temp    :datetime;
  begin
    temp := getclock;

    (* V[^bZ[W^t@C̓tXV *)
    if cnarg[cn]^.CnStat=zfilenews then begin
      datefrom:=cnarg[cn]^.lastfile;
      if cnarg[cn]^.readfil='' then cnarg[cn]^.readfil:=temp;
    end
    else if cnarg[cn]^.sect.number>0 then begin
      datefrom:=cnarg[cn]^.lastboard;
      if cnarg[cn]^.readmes='' then cnarg[cn]^.readmes:=temp;
    end
    else begin
      datefrom := cnarg[cn]^.lastmail;
      cnarg[cn]^.readmail:=temp;
    end;

    cnarg[cn]^.prompt:=
      '[36m'+s+'[m :[36mtw[m ([33m[RET]:news[m) >';
    if cnarg[cn]^.access<reg then cnarg[cn]^.prompt:=
      '[36m'+s+'[m :[36mtw[m ([33m[RET]:from begin[m) >';
    wk := getinput(cnarg[cn]^.prompt, 8, echo);
    if (wk<>'') and cts then begin
      if (wk[2]='/') or (length(wk)=1) then wk:='0'+wk;
      if (length(wk)=4) or (wk[5]='/') then insert('0',wk,4);
      if (length(wk)=7) then insert('0',wk,7);
      for i:=1 to length(wk) do datefrom[8-length(wk)+i]:=wk[i];
      delete(datefrom,9,14);
      if not ((datefrom[3]='/') and (datefrom[6]='/') and
        (value(copy(datefrom,4,2))>0) and (value(copy(datefrom,7,2))>0))
        then begin
        lineout('');
        lineout('[31mႢ܂B[m');
        getdays:='';
        exit;
      end;
    end;
    datefrom:=datefrom+' 00:00:00';
    lineout('');
    lineout('[33mt [32m'+datefrom+
      ' [33mȍ~̂̂܂B[m');
    getdays:=datefrom;
  end;

function boardname(number: integer): string;
  (*{[h̃A[JCut@C𓾂("ARCMxx.BBS")*)
  var
    temp: string[3];
  begin
    str(number,temp);
    boardname := arcvdrive+'ARCM'+temp+'.BBS';
  end;


function sectname(buf:secttype): string; { use only boardsys.pas }
  begin
    sectname := '[32m'+copy(buf.bname+'         ',1,9)+'[m'+buf.nam;
  end;

function sectwithnum(buf:secttype): string;
  var temp : string8;
  begin
    str((10000+buf.number):5, temp);
    sectwithnum := '[32m#'+copy(temp, 3, 3)+' '+sectname(buf);
  end;

function ftype:filetypeB;
  begin
    if cnarg[cn]^.cnstat in [zboard,znews,zsearch,zkill] then ftype:=mbdfil
    else if cnarg[cn]^.cnstat in [zfile,zfilenews,zfilesearch,zbatch] then
      ftype:=fbdfil
    else ftype:=closed;  (* L蓾Ȃ͂ *)
  end;

procedure listsections;
  var
    i     : integer;
    found : boolean;
    buf   : secttype;
    temp  : string8;
  begin
    if cts and (cnarg[cn]^.inbuffer='') then begin
      found := false;
      lineout('');
      lineout('[32mSel Name     Board title[m');
      lineout('[33m--- -------- --------------------------------[m');
      if cnarg[cn]^.sect.number>1 then
        lineout('-[33m 0[32m ********[m wj[')
      else lineout('![33m 0[32m ********[m ZN^I');
      for i:=0 to 9 do begin
        seekB(ftype,cnarg[cn]^.sect.downb[i]);
        readB(ftype,@buf);
        if ((buf.r<=cnarg[cn]^.access) or (buf.w<=cnarg[cn]^.access)) and
          (buf.attrib<>anone) and (buf.number>0) then begin
          str((i+1):2, temp);
          if buf.attrib=amenu then stringout('+[34m')
          else stringout(' [36m');
          lineout(temp+' '+sectname(buf));
          found:=true;
        end;
      end;
      if cnarg[cn]^.cancelled then cnarg[cn]^.cancelled:=false;
      if not found then
        lineout('[31m*** ******** Y{[h͂܂B[m');
      lineout('[33m--- -------- --------------------------------[m');
    end;
  end;

procedure allsections;
  var
    found : boolean;
    buf   : secttype;
    num   : array[1..16] of byte;  (* 16Kw *)
    loop  : byte;
  begin
    if cts and (cnarg[cn]^.inbuffer='') then begin
      found := false;
      lineout('');
      lineout('[32mNo.  Name     Board title[m');
      lineout('[33m---- -------- --------------------------------[m');
      for loop:=1 to 16 do num[loop]:=0;
      loop:=1;
      seekB(ftype,1);
      readB(ftype,@buf);
      repeat
        case buf.attrib of
        amenu:if (num[loop]<10) and (buf.downb[num[loop]]>0) and
                testin(buf,false) then begin (* wްޗL *)
                seekB(ftype,buf.downb[num[loop]]);
                readB(ftype,@buf);              (* wްގ擾 *)
                inc(num[loop]);
                inc(loop);
              end
              else begin
                inc(num[loop]);
                if num[loop]>=10 then begin      (* wްނ͖̌ *)
                  num[loop]:=0;
                  dec(loop);
                  seekB(ftype,buf.back);
                  readB(ftype,@buf);             (* ްނ̎擾 *)
                end;
              end;
        aboard:begin (* ݂ްޑް޽ðȂΕ\ *)
              if ((buf.r<=cnarg[cn]^.access) or (buf.w<=cnarg[cn]^.access)) and
                (buf.attrib=aboard) then begin
                lineout(sectwithnum(buf));
                found:=true;
              end;
              seekB(ftype,buf.back);
              readB(ftype,@buf);     (* ްƭɖ߂ *)
              dec(loop);
              end;
        end;
      until (loop=0) or not cts;
      if cnarg[cn]^.cancelled then cnarg[cn]^.cancelled:=false;
      if not found then lineout('[31mY{[h͂܂B[m');
      lineout('[33m---- -------- --------------------------------[m');
    end;
  end;

function isforumsigopx(buf:secttype):boolean;
  var
    test:boolean;
    secb:secttype;
    loop:integer;
  begin
    test:=false;
    loop:=buf.back;
    if loop>0 then begin
      repeat
        seekB(ftype,loop);
        readB(ftype,@secb);
        if secb.sigop=cnarg[cn]^.caller then test:=true;
        loop:=secb.back;
        transfernext;
      until test or (secb.number=1) or (secb.back=0);
    end;                                    (*S *)
    isforumsigopx:=(cnarg[cn]^.access=sysop) or ((cnarg[cn]^.access=sigop) and
      test);
  end;

function isforumsigop:boolean;
  (* tH[rhfnoł邩 *)
  begin
    isforumsigop:=isforumsigopx(cnarg[cn]^.sect);
  end;

function issigopx(buf:secttype):boolean;
  begin
    issigopx:=(buf.sigop=cnarg[cn]^.caller) or isforumsigopx(buf);
  end;

function issigop:boolean;
  (* tH[rhfnoł邩A͂̃{[ĥ̕rhfno *)
  begin
    issigop:=issigopx(cnarg[cn]^.sect);
  end;

function testin(buf:secttype;prt:boolean):boolean;
  var
    instr:string8;
    temp :string8;
  procedure testout(s:string);
    begin
      if prt then lineout(s);
    end;
  begin
    if cts then begin
      testin:=false;
      if buf.attrib=anone then begin
        testout('');
        testout('[31m{[h܂B[m');
      end
      else if issigopx(buf) then testin:=true
      else if (buf.r>cnarg[cn]^.access) and
        (buf.w>cnarg[cn]^.access) then begin
        testout('');
        testout('[31m̃{[hɂ͓܂B[m');
      end
      else if (buf.group>0) and not cnarg[cn]^.groups[buf.group] then begin
        testout('');
        testout('[31m̃{[h̃O[vł͂܂B[m');
      end
      else if buf.pass<>'' then begin
        if prt then begin
          lineout('');
          str((10000+buf.number):5,temp);
          cnarg[cn]^.prompt:='[36mPASSWORD[m [[32m#'+copy(temp, 3, 3)+
            '[m/[32m'+buf.bname+
            '[m] :[36mpX[h[m ([33m[RET]:quit[m) >';
          instr:=getinputguide(cnarg[cn]^.prompt,8,echo);
          if instr<>'' then begin
            if instr<>buf.pass then begin
              lineout('');
              lineout('[31mpX[hႢ܂B[m');
            end
            else testin:=true;
          end;
        end;
      end
      else testin:=true;
    end;
  end;

function paththru(buf:secttype):boolean;
  type
    bufr=record
         rec :integer;
         test:boolean;
    end;
  var
    test:boolean;
    secb:secttype;
    buf1:array[1..16] of bufr;  (* 16Kw *)
    buf2:array[1..16] of integer;
    lp1 :byte;
    lp2 :byte;
  begin
    lp1:=1;
    secb:=buf;
    buf1[1].rec:=secb.number;
    buf1[1].test:=testin(secb,false);
    repeat
      seekB(ftype,secb.back);
      readB(ftype,@secb);
      inc(lp1);
      buf1[lp1].rec:=secb.number;
      buf1[lp1].test:=testin(secb,false);
      transfernext;
    until secb.number<=1;
    lp2:=1;
    secb:=cnarg[cn]^.sect;
    buf2[1]:=secb.number;
    repeat
      seekB(ftype,secb.back);
      readB(ftype,@secb);
      inc(lp2);
      buf2[lp2]:=secb.number;
      transfernext;
    until secb.number<=1;
    while (lp1>0) and (lp2>0) and (buf1[lp1].rec=buf2[lp2]) do begin
      dec(lp1);    (* _+1 ̎Zo *)
      dec(lp2);
    end;
    test:=true;
    while (lp1>0) and test and cts do begin
      if not buf1[lp1].test then begin  (* v`FbNȂ *)
        seekB(ftype,buf1[lp1].rec);
        readB(ftype,@secb);
        test:=testin(secb,true);  (* btfɓȂAٰ,߽ܰ *)
      end;
      dec(lp1);   (* `FCHĂ䂭 *)
    end;
    paththru:=test;
  end;

function isloop(buf:secttype):boolean;
  var
    secb:secttype;
    loop:byte;
  begin
    secb:=buf;
    loop:=16;  (* 16 Kw܂ *)
    if secb.number>1 then begin
      repeat
        seekB(ftype,secb.back);
        readB(ftype,@secb);
        transfernext;
        dec(loop);
      until (loop=0) or (secb.number<=1) or
        (secb.number=cnarg[cn]^.sect.number);
      isloop:=(secb.number=cnarg[cn]^.sect.number) and (secb.number>1);
    end
    else isloop:=true;
  end;

procedure outinfo;
  var temp:string;
  begin
    if cts then begin
      str(cnarg[cn]^.sect.number,temp);
      if cnarg[cn]^.cnstat=zboard then temp:='B'+temp
      else temp:='F'+temp;
      temp:=temp+'.TXT';
      if exists(profdrive+'INFO'+temp) then begin
        lineout('');
        lineout('[32mInfomation.[m');
        lineout('[33m-------------------------------------------------------------------------------[m');
        outfile(profdrive+'INFO'+temp);
        lineout('[33m-------------------------------------------------------------------------------[m');
      end
      else begin
        lineout('');
        lineout('[32m̫Ұ ͂܂B[m');
      end;
    end;
  end;

procedure sectheader(s:string);
  var temp:string;
  begin
    if cts then begin
      str((10000+cnarg[cn]^.sect.number):5,temp);
      lineout('[36m'+s+' board selector[m [[32m#'+
        copy(temp,3,3)+'[m/[32m'+
        copy(cnarg[cn]^.sect.bname+'        ',1,8)+'[m] '+
        cnarg[cn]^.sect.nam);
    end;
  end;

procedure putinfo;
  begin
    if cts then begin
      if (cnarg[cn]^.expert<>eexpert) and (cnarg[cn]^.inbuffer='') then begin
        if cnarg[cn]^.expert=ebegin then outinfo;
        if cnarg[cn]^.sect.attrib=amenu then begin
          listsections;
          if cnarg[cn]^.expert=ebegin then begin
            lineout('');
            outfile(bmesdrive+j_selmenu);
          end;
        end;
      end;
    end;
  end;


procedure custboard;
  const
    asattrib:array[sectattr] of string[5]=('None','Board','Menu');
  var
    inch:word;
    chk :boolean;
    temp:string;
    dumy:integer;
    bkupattr:sectattr;
    inq :char;
  procedure infowrite;
  var
    inch : char;
    rslt : byte;
    temp : string;
  begin
    if cts then begin
      str(cnarg[cn]^.sect.number,temp);
      if cnarg[cn]^.cnstat=zboard then temp:='B'+temp
      else temp:='F'+temp;
      temp:=temp+'.TXT';
      if not exists(profdrive+'INFO'+temp) then begin
        lineout('');
        lineout('[33mV ̫Ұ ݒ肵܂B[m');
      end
      else if not setfile(profdrive+'INFO'+temp) then begin
        lineout('');
        lineout('[31mGfBbgobt@܂B[m');
        exit;
      end;
      compose(eline);  (* ҏWpɃx^GfB^͎gȂ *)
      repeat
        lineout('');
        inch := getcap(
          '[36mINFO EDIT[m ([33mW:write  E:edit  0:quit[m) >');
        case inch of
          'E': compose(eline);  (* ҏWpɃx^GfB^͎gȂ *)
          'W': begin
             if cts then begin
               lineout('');
               stringout('[32mݒ ...');
               if not getfile(nametemp) then begin
                 lineout(' [31mGfBbgobt@܂B[m');
                 exit;
               end;
               FileCopy(nametemp, profdrive+'INFO'+temp, rslt);
               if rslt = 0 then lineout(' [33mI܂B[m')
               else lineout(' [31m݂Ɏs܂B[m');
             end;
          end;
          '0': begin
             lineout('');
             if getyesno(
               '[36m~Ă낵łH[m (Y/[33m[N][m) >')
               <>'Y' then begin
               lineout('');
               lineout('[33ms܂B[m');
               inch:=#$00;
             end
             else begin
               lineout('');
               lineout('[31m݂𒆎~܂B[m');
             end;
          end;
        end;
      until (inch = '0') or (inch = 'W') or not cts;
    end;
  end;
  procedure setchain;
    var
      temp:string;
      loop:byte;
      loc :byte;
      sectbuf:secttype;
      backbuf:secttype;
      test:boolean;
    begin
      if cnarg[cn]^.sect.number=1 then begin
        lineout('');
        lineout('[31mgbvj[̐ڑ͕ύXo܂B[m');
        exit;
      end;
      if cnarg[cn]^.inbuffer='' then begin
        lineout('');
        stringout('[33m݂̐ڑ[m : ');
        str((1000+cnarg[cn]^.sect.back):4,temp);
        seekB(ftype,cnarg[cn]^.sect.back);
        readB(ftype,@sectbuf);
        lineout('[[32m#'+copy(temp,2,3)+
          '[m/[32m'+sectbuf.bname+'[m]');
      end;
      repeat
        lineoutifneed;
        cnarg[cn]^.prompt:=
          '[36mChain[m ([33mM:movechain  0:quit[m) >';
        temp:=allcaps(getinput(cnarg[cn]^.prompt,1,echo));
        if temp='M' then begin
          lineoutifneed;
          cnarg[cn]^.prompt:=
            '[36m̃j[Ɛڑ܂H[m ([33m#nnn[m) >';
          temp:=getinput(cnarg[cn]^.prompt,5,echo);
          val(copy(temp,2,255),inch,dumy);
          if (length(temp)<2) or (temp[1]<>'#') or
            (dumy>0) or (inch=0) or (filesizeB(ftype)<=inch) then begin
            lineout('');
            lineout('[31mႢ܂[m ([33m`:#nnn[m)');
          end
          else begin
            while islockB(ftype,sectbuf.number) do transfernext;
            lockB(ftype,sectbuf.number);
            seekB(ftype,inch);
            readB(ftype,@sectbuf);
            if sectbuf.attrib<>amenu then begin
              lineout('');
              lineout('[31mw̔ԍ̓j[ł͂܂B[m');
              unlockB(ftype);
            end
            else if not isforumsigopx(sectbuf) or isloop(sectbuf) then begin
              (* tH[Oֈړ悤ƂiSYSOP ͉jA*)
              (* [vڑ悤ƂB                      *)
              lineout('');
              lineout('[31mw̔ԍɈړ鎖͏o܂B[m');
              unlockB(ftype);
            end
            else begin
              test:=false;
              for loop:=0 to 9 do
                if sectbuf.downb[loop]=0 then begin
                  if not test then begin
                    lineout('');
                    stringout('[33mj[󂫗̈[m : [32m');
                  end;
                  str(loop+1,temp);
                  stringout(temp+' ');
                  test:=true;
                end;
              if not test then begin
                lineout('');
                lineout('[31mj[ɋ󂫗̈悪܂B[m');
                unlockB(ftype);
              end
              else begin
                lineout('');
                lineout('');
                cnarg[cn]^.prompt:=
                  '[36mɐڑ܂H[m ([33m0:quit[m) >';
                loc:=getint(10,0,cnarg[cn]^.prompt)-1;
                if (loc<0) or (sectbuf.downb[loc]>0) then begin
                  lineout('');
                  lineout('[31m~܂B[m');
                  unlockB(ftype);
                end
                else begin   { Thanks to NOBUYA   }
                  if sectbuf.number<>cnarg[cn]^.sect.back then begin
                    if cnarg[cn]^.sect.back>0 then begin
                      seekB(ftype,cnarg[cn]^.sect.back);
                      readB(ftype,@backbuf);
                      for loop:=0 to 9 do
                        if backbuf.downb[loop]=cnarg[cn]^.sect.number then
                          backbuf.downb[loop]:=0;
                      seekB(ftype,backbuf.number);
                      writeB(ftype,@backbuf);
                    end;
                  end
                  else begin
                    for loop:=0 to 9 do
                      if sectbuf.downb[loop]=cnarg[cn]^.sect.number then
                        sectbuf.downb[loop]:=0;
                  end;
                  sectbuf.downb[loc]:=cnarg[cn]^.sect.number;
                  seekB(ftype,sectbuf.number);
                  writeB(ftype,@sectbuf);
                  unlockB(ftype);
                  cnarg[cn]^.sect.back:=sectbuf.number;
                  while islockB(ftype,cnarg[cn]^.sect.number) do
                    transfernext;
                  lockB(ftype,cnarg[cn]^.sect.number);
                  seekB(ftype,cnarg[cn]^.sect.number);
                  writeB(ftype,@cnarg[cn]^.sect);
                  unlockB(ftype);
                  lineout('');
                  lineout('[33mڑI܂B[m');
                  chk:=true;
                end;
              end;
            end;       (* AvO.... *)
          end;
        end;
      until (temp='0') or not cts;
    end;
  function menu:boolean;
    begin
      lineoutifneed;
      menu:=('Y'=getyesno('[36mj[ɐݒ肵܂B낵łH[m (Y/[33m[N][m) >'));
    end;
  function archive:boolean;
    var
      test:boolean;
      i   :byte;
    procedure Makearchive(fn:string;endmark:word);
      const
        nonuse :word=$0000;
        datause:word=$FFFF;
      var
        i,j,k   :byte;
        temp    :string;
        strm    :file;
        dumy    :byte;
        tempbuff:array[$00..$FF] of word;
      begin {$I-}
        for i:=$00 to $FF do tempbuff[i]:=nonuse;
        assign(strm,fn);
        rewrite(strm,1);
        if ioresult=0 then begin
          for k:=$00 to hi(endmark)+1 do begin
            for j:=0 to 29 do Transfernext;
            blockwrite(strm,tempbuff,sizeof(tempbuff));
          end;
          seek(strm,0);
          blockwrite(strm,endmark,2);
          seek(strm,128);
          blockwrite(strm,datause,2);
          close(strm);
          dumy:=ioresult;
        end;
      end; {$I+}
    procedure MakeDirectory(dir:string);
      var
        len     : integer;
        w       : char;
        DirInfo : SearchRec;
      begin
        if dir = '' then dir := ':';
        len := length(dir);
        w := dir[len];
        delete(dir, len, 1);
        case w of
          ':' : {nothing};
          '\' : if dir[length(dir)] <> ':' then begin
              dos.findfirst(dir, Directory, DirInfo);
              if DosError <> 0 then begin (*̃fBNg݂Ȃ*)
                {$I-} MkDir(dir) {$I+};
                if IOresult = 0 then begin
                  lineout('');
                  lineout('[33mfBNg[m [[32m'+dir+'[m][33m 쐬܂B[m');
                end
                else begin
                  lineout('');
                  lineout('[31mfBNg[m [[32m'+dir+'[m][33m 쐬o܂B[m');
                end;
              end;
          end;
        end;
      end;
    begin   { of archive }
      test:=false;
      for i:=0 to 9 do if cnarg[cn]^.sect.downb[i]>0 then test:=true;
      if test then begin
        lineout('');
        lineout('[31mwɃ{[h^j[ڑĂ̂ŕύXo܂B[m');
        archive:=false;
        exit;
      end;
      if cnarg[cn]^.cnstat=zboard then begin
        repeat
          lineoutifneed;
          cnarg[cn]^.prompt:='[36meʂw肵ĉ[m ([33m1-8:MByte  0:quit[m) >';
          i:=getint(8,0,cnarg[cn]^.prompt);
        until (i<9) or not cts
      end
      else begin
        lineoutifneed;
        if getyesno('[36m{[hɐݒ肵܂B낵łH[m (Y/[33m[N][m) >')='Y' then begin
          str(cnarg[cn]^.sect.number,temp);
          Makedirectory(filedrive+'FILE'+temp+'\');
          openboard(cnarg[cn]^.sect.number+1000);
          seekB(filfil,0);
          TruncateB(filfil);
          seekB(bdlog,0);
          TruncateB(bdlog);
          archive:=true;
          exit;
        end
        else begin
          archive:=false;
          exit;
        end;
      end;
      if i=0 then begin
        lineout('');
        lineout('[31m~܂B[m');
        archive:=false;
      end
      else begin
        lineout('');
        stringout('[32mA[JCut@C쐬 ...');
        makearchive(boardname(cnarg[cn]^.sect.number),(longword(i) shl 13)-1);
        openboard(cnarg[cn]^.sect.number);
        seekB(mesfil,0);
        TruncateB(mesfil);
        seekB(bdlog,0);
        TruncateB(bdlog);
        lineout(' [33mI܂B[m');
        archive:=true;
      end;
    end;
  procedure makeboard;
    var
      i,j :integer;
      next:integer;
      buf :secttype;
      test:boolean;
    begin
      test:=false;
      for i:=0 to 9 do
        if cnarg[cn]^.sect.downb[i]=0 then begin
          if not test then begin
            lineout('');
            stringout('[33mj[󂫗̈[m : [32m');
          end;
          str(i+1,temp);
          stringout(temp+' ');
          test:=true;
        end;
      if not test then begin
        lineout('');
        lineout('[31mj[ɋ󂫗̈悪܂B[m');
        exit;
      end;
      repeat
        lineoutifneed;
        cnarg[cn]^.prompt:=
          '[36mɐڑ܂H[m ([33m0:quit[m) >';
        i:=getint(10,0,cnarg[cn]^.prompt)-1;
      until (i<10) or not cts;
      if (i<0) or (cnarg[cn]^.sect.downb[i]>0) then begin
        lineout('');
        lineout('[31m~܂B[m');
      end
      else begin
        lineout('');
        stringout('[32mj[쐬 ...');
        next:=filesizeB(ftype);
        with buf do begin
          number:=next;
          back  :=cnarg[cn]^.sect.number;
          attrib:=amenu;
          bname :='--------';
          nam   :='';
          r     :=5;
          w     :=5;
          sigop :='';
          pass  :='';
          logsize:=0;
          group :=0;
          for j:=0 to 9 do downb[j]:=0;
        end;
        while islockB(ftype,next) do transfernext;
        lockB(ftype,next);
        seekB(ftype,next);
        writeB(ftype,@buf);
        unlockB(ftype);
        cnarg[cn]^.sect.downb[i]:=next;
        while islockB(ftype,cnarg[cn]^.sect.number) do transfernext;
        lockB(ftype,cnarg[cn]^.sect.number);
        seekB(ftype,cnarg[cn]^.sect.number);
        writeB(ftype,@cnarg[cn]^.sect);
        unlockB(ftype);
        lineout(' [33mI܂B[m');
      end;
    end;
  procedure boardloglist;
    const
      rw:array[boolean] of string[6]=('[33mR','[31mW');
    var
      loop: integer;
      n   : longint;
      temp: boardlog;
      rra : string;
    begin
      seekB(bdlog,0);
      lineout('');
      if not eofB(bdlog) then begin
        n:=filesizeB(bdlog);
        str(cnarg[cn]^.sect.number,rra);
        rra:=copy('00'+rra,length(rra),3);
        stringout('[36mBoard loglist of [m[[32m#'+rra+'[m/[32m');
        str(n,rra);
        lineout(copy(cnarg[cn]^.sect.bname+'        ',1,8)+
          '[m]  '+rra+' logs.');
        stringout('[32mID       Date     Time     R ');
        if ftype=fbdfil then begin
          lineout('File name    Protocol[m');
          lineout('[33m-------- -------- -------- - ------------ ----------------------------[m');
        end
        else begin
          lineout('Title[m');
          lineout('[33m-------- -------- -------- - -----------------------------------------[m');
        end;
        while cts and (not cnarg[cn]^.cancelled) and (n>0) do begin
          seekB(bdlog,n-1);
          readB(bdlog,@temp);
          with temp do begin
            stringout('[36m'+getname(user)+' [32m'+date+' '+rw[written]+
              ' [m'+article);
            if ftype=fbdfil then lineout(' [36mProtocol[m:[[33m'+
              ptstrn[protocol]+'[m]')
            else lineout('');
          end;
          dec(n);
        end;
        if cnarg[cn]^.cancelled then cnarg[cn]^.cancelled:=false;
        lineout('[33m-------- -------- -------- - -----------------------------------------[m');
      end
      else lineout('[31mO͋L^Ă܂B[m');
    end;
  procedure setusercullentgroup(src,des:byte);
    var
      loop:integer;
      i   :byte;
    begin
      lineout('');
      stringout('[32m ...');
      loop:=filesizeB(idfil);
      while loop>0 do begin
        while islockB(idfil,loop-1) do transfernext;
        lockB(idfil,loop-1);
        seekB(idfil,loop-1);
        readB(idfil,@cnarg[cn]^.idrec);
        if (cnarg[cn]^.idrec.group[src]=true) then begin    (* MOTO *)
          cnarg[cn]^.idrec.group[src]:=false;
          if des>0 then cnarg[cn]^.idrec.group[des]:=true;
        end;                                                (* MOTO *)
        seekB(idfil,loop-1);
        writeB(idfil,@cnarg[cn]^.idrec);
        unlockB(idfil);
        dec(loop);
        for i:=0 to 7 do transfernext;
      end;
      lineout(' [33mIB[m');
    end;
  procedure changegroupswitch(x:word);
    begin
      lockB(idfil,x-1);
      seekB(idfil,x-1);
      readB(idfil,@cnarg[cn]^.idrec);
      cnarg[cn]^.idrec.group[cnarg[cn]^.sect.group]:=
        not cnarg[cn]^.idrec.group[cnarg[cn]^.sect.group];
      seekB(idfil,x-1);
      writeB(idfil,@cnarg[cn]^.idrec);
      unlockB(idfil);
      lineout('');
      if cnarg[cn]^.idrec.group[cnarg[cn]^.sect.group] then
        lineout('[33mO[ṽ[UƂĐݒ肵܂B[m')
      else lineout('[32mO[v珜O܂B[m')
    end;
  procedure setgroupid;
    var
      buf:byte;
    begin
      repeat
        lineoutifneed;
        cnarg[cn]^.prompt:=
          '[36mGroup ID[m ([33mU:setuser  B:setboard  0:quit[m) >';
        inq:=getcap(cnarg[cn]^.prompt);
        case inq of
          'B':if cnarg[cn]^.access=sysop then begin
              lineoutifneed;
              cnarg[cn]^.prompt:=
                '[36mO[vhc͂ĉ[m ([33m0,1-100[m) >';
              buf:=getint(100,0,cnarg[cn]^.prompt);
              if buf<>cnarg[cn]^.sect.group then begin
                cnarg[cn]^.prompt:='';
                if buf=0 then cnarg[cn]^.prompt:='[36mO[vɑ郆[U[̐ݒ܂H[m (Y/[33m[N][m) >'
                else if cnarg[cn]^.sect.group>0 then
                  cnarg[cn]^.prompt:='[36mO[vɑ郆[U[̐ݒύX܂H[m (Y/[33m[N][m) >';
                if cnarg[cn]^.prompt<>'' then begin
                  lineoutifneed;
                  if getyesno(cnarg[cn]^.prompt)='Y' then
                    setusercullentgroup(cnarg[cn]^.sect.group,buf);
                end;
                cnarg[cn]^.sect.group:=buf;
                chk:=true;
                lineout('');
                lineout('[33mO[vhcύX܂B[m');
              end;
            end
            else begin
              lineout('');
              lineout('[31mrhfno͐ݒo܂B[m');
          end;
          'U':if cnarg[cn]^.sect.group>0 then begin
              lineoutifneed;
              cnarg[cn]^.prompt:='[36mΏۃ[U[̂hc͂ĉ[m ([33m?:userlist  [RET]:quit[m) >';
              dumy:=getID(cnarg[cn]^.prompt);
              if dumy>0 then changegroupswitch(dumy);
            end
            else begin
              lineout('');
              lineout('[31mO[vhcݒ肳Ă܂B[m');
          end;
        end;
      until (inq='0') or not cts;
    end;

  begin  { of custboard }
    if issigop and not islockB(ftype,cnarg[cn]^.sect.number) then begin
      lockB(ftype,cnarg[cn]^.sect.number);
      chk:=false;
      bkupattr:=cnarg[cn]^.sect.attrib;
      repeat
        if cnarg[cn]^.inbuffer='' then begin
          lineout('');
          lineout(' 1: [33mBoard name[m :[32m'+cnarg[cn]^.sect.bname+'[m');
          lineout(' 2: [33mBoard title[m:'+cnarg[cn]^.sect.nam);
          stringout(' 3: [33mInfomation[m :');
          str(cnarg[cn]^.sect.number,temp);
          if cnarg[cn]^.cnstat=zboard then temp:='B'+temp
          else temp:='F'+temp;
          temp:=temp+'.TXT';
          if exists(profdrive+'INFO'+temp) then
            lineout('[32mAlready set.[m')
          else lineout('[36mSet infomation...[m');
          str(cnarg[cn]^.sect.r,temp);
          if cnarg[cn]^.sect.attrib=amenu then
            lineout(' 4: [33mIsin level[m :[32m'+temp+'[m')
          else lineout(' 4: [33mRead level[m :[32m'+temp+'[m');
          str(cnarg[cn]^.sect.w,temp);
          if cnarg[cn]^.sect.attrib=aboard then
            lineout(' 5: [33mWrite level[m:[32m'+temp+'[m');
          stringout(' 6: [33mPassword[m   :');
          if cnarg[cn]^.sect.pass='' then lineout('[36mSet password...[m')
          else lineout('[32m'+cnarg[cn]^.sect.pass+'[m');
          if cnarg[cn]^.sect.group=0 then temp:='[36mSet group ID...[m'
          else begin
            str(cnarg[cn]^.sect.group,temp);
            temp:='[32m%'+temp;
          end;
          if cnarg[cn]^.sect.attrib=aboard then
            lineout(' 7: [33mBoard log[m  :[36mNext menu...[m');
          lineout(' 8: [33mGroup ID[m   :'+temp+'[m');
          stringout(' 9: [33mSigop[m      :');
          if cnarg[cn]^.sect.sigop='' then
            lineout('[36mSet (forum)sigop...[m')
          else lineout('[32m'+cnarg[cn]^.sect.sigop+'[m');
          lineout('10: [33mAttrib[m     :[32m'+
            asattrib[cnarg[cn]^.sect.attrib]+'[m');
          lineout('11: [33mChain[m      :[36mNext menu...[m');
          if (cnarg[cn]^.cnstat=zboard) and
            (cnarg[cn]^.sect.attrib=aboard) then begin
            dumy:=(filesizeB(arcfil)+1) div 8192;
            str(dumy,temp);
            lineout('12: [33mArchive[m    :[32m'+temp+' MB max[m');
          end
          else if cnarg[cn]^.sect.attrib=amenu then
	    lineout('12: [33mMake[m       :[36mNext menu...[m');
          lineout('');
        end;
        cnarg[cn]^.prompt:='[36mCUSTOMIZE[m ([33m0:quit[m) >';
        temp:=getinput(cnarg[cn]^.prompt,5,echo);
        val(temp,inch,dumy);
        if dumy=0 then case inch of
          1 : begin
                lineoutifneed;
                cnarg[cn]^.prompt:='[36mBoard name[m >';
                cnarg[cn]^.sect.bname:=
                  allcaps(getinputguide(cnarg[cn]^.prompt,8,echo));
                chk:=true;
          end;
          2 : begin
                lineoutifneed;
                cnarg[cn]^.prompt:='[36mBoard title[m >';
                cnarg[cn]^.sect.nam:=getinputguide(cnarg[cn]^.prompt,32,echo);
                chk:=true;
          end;
          3 : infowrite;
          4 : begin
                lineoutifneed;
                if cnarg[cn]^.sect.attrib=amenu then
                  cnarg[cn]^.prompt:='[36mIsin level[m ([33m0-5[m) >'
                else cnarg[cn]^.prompt:=
                  '[36mRead level[m ([33m0-5[m) >';
                cnarg[cn]^.sect.r:=getint(sysop,0,cnarg[cn]^.prompt);
                if cnarg[cn]^.sect.attrib=amenu then
                  cnarg[cn]^.sect.w:=cnarg[cn]^.sect.r;
                chk:=true;
          end;
          5 : if cnarg[cn]^.sect.attrib=aboard then begin
                lineoutifneed;
                cnarg[cn]^.prompt:='[36mWrite level[m ([33m0-5[m) >';
                cnarg[cn]^.sect.w:=getint(sysop,0,cnarg[cn]^.prompt);
                chk:=true;
          end;
          6 : begin
                lineoutifneed;
                cnarg[cn]^.prompt:=
                  '[36mPassword[m ([33m[RET]:nonuse[m) >';
                cnarg[cn]^.sect.pass:=getinputguide(cnarg[cn]^.prompt,8,echo);
                chk:=true;
          end;
          7 : if cnarg[cn]^.sect.attrib=aboard then begin
                repeat
                  lineoutifneed;
                  if cnarg[cn]^.sect.logsize=0 then temp:='----'
                  else str(cnarg[cn]^.sect.logsize:4,temp);
                  cnarg[cn]^.prompt:='[36mBoardlog[m [[32m'+temp+
                    '[m] ([33mL:loglist  S:logsize  0:quit[m) >';
                  inq:=getcap(cnarg[cn]^.prompt);
                  case inq of
                    'L':if cnarg[cn]^.sect.logsize>0 then boardloglist
                        else begin
                          lineout('');
                          lineout(
                            '[31mÕTCYݒ肳Ă܂B[m');
                    end;
                    'S':begin
                        lineoutifneed;
                        cnarg[cn]^.prompt:='[36mÕTCYw肵ĉ[m ([33m0,5-9999[m) >';
                        dumy:=getint(9999,0,cnarg[cn]^.prompt);
                        if (dumy>0) and (dumy<5) then dumy:=5;
                        if SearchSameBoard(cnarg[cn]^.sect.number)=-1
                          then begin
                          cnarg[cn]^.sect.logsize:=dumy;
                          seekB(bdlog,0);
                          truncateB(bdlog);
                          chk:=true;
                        end
                        else begin
                          lineout('');
                          lineout('[31m`lŎgp̂ߕύXo܂B[m');
                        end;
                    end;
                  end;
                until (inq='0') or not cts;
              end
              else begin
                lineout('');
                lineout('[31mݒo܂B[m');
          end;
          8 : setgroupid;
          9 : if isforumsigop then begin
                lineoutifneed;
                cnarg[cn]^.prompt:='[36mSigop[m >';
                cnarg[cn]^.sect.sigop:=
                  allcaps(getinputguide(cnarg[cn]^.prompt,8,echo));
                chk:=true;
                end
                else begin
                  lineout('');
                  lineout('[31mݒo܂B[m');
          end;
          10 : if isforumsigop then begin
                repeat
                  lineoutifneed;
                  cnarg[cn]^.prompt:='[36mAttribute[m ([33mM:menu  B:board  0:quit[m) >';
                  temp:=allcaps(getinput(cnarg[cn]^.prompt,1,echo));
                  if SearchSameBoard(cnarg[cn]^.sect.number)=-1 then begin
                    if (temp='M') and (cnarg[cn]^.sect.attrib=aboard) then
                      if menu then begin
                        cnarg[cn]^.sect.attrib:=amenu;
                        closeboard;
                        chk:=true;
                      end;
                    if (temp='B') and (cnarg[cn]^.sect.attrib=amenu) then
                      if archive then begin
                        cnarg[cn]^.sect.attrib:=aboard;
                        chk:=true;
                      end;
                  end
                  else begin
                    lineout('');
                    lineout(
                      '[31m`lŎgp̂ߕύXo܂B[m');
                  end;
                until chk or (temp='0') or not cts;
                end
                else begin
                  lineout('');
                  lineout('[31mݒo܂B[m');
          end;
          11 : if isforumsigop then begin
                  if SearchSameBoard(cnarg[cn]^.sect.number)=-1 then setchain
                  else begin
                    lineout('');
                    lineout(
                      '[31m`lŎgp̂ߕύXo܂B[m');
                  end;
                end
                else begin
                  lineout('');
                  lineout('[31mݒo܂B[m');
          end;
          12 : if isforumsigop and
                 (cnarg[cn]^.sect.attrib=amenu) then makeboard
                else begin
                  lineout('');
                  lineout('[31mݒo܂B[m');
          end;
        end;
      until ((inch=0) and (dumy=0)) or not cts;
      if chk then begin
        seekB(ftype,cnarg[cn]^.sect.number);
        writeB(ftype,@cnarg[cn]^.sect);
        lineout('');
        lineout('[32mݒύX܂B[m');
      end;
      unlockB(ftype);
      if (bkupattr=amenu) and (cnarg[cn]^.sect.attrib=aboard) then closeboard;
    end
    else if issigop then begin
      lineout('');
      lineout('[31mgpo܂B[m');
    end
    else begin
      lineout('');
      lineout('[31m`lŎgp̂ߎgpo܂B[m');
    end;
  end;

begin
end.
