
uses dos;

type
  DateTime      = string[17];
  string8       = string[8] ;
  name          = string[14];
  line          = string[255];
  kanji_type    = (ANK,MSkanji);
  escmode       = (ecut,ecolor,efull);
  expertmode    = (ebegin,enorm,eexpert);
  editormode    = (enone,ebeta,eline);
  grouprec      = array[1..100] of boolean;
  sysid     = record
                user    : string8;    (*[U[hc  ex:SYSOP, KPUC01,..   *)
                esc     : escmode;    (*drbJbg[h                  *)
                lsto    : DateTime;   (*last login (YY/MM/DD HH:MM:SS)      *)
                pass    : string8;    (*pX[h                          *)
                acc     : byte;       (*access level (0..5)                 *)
                exfl    : expertmode; (*GLXp[g[h                  *)
                lnf     : char;       (*slf̈                    *)
                lines   : byte;       (*Pʓ̍s                    *)
                kjt     : kanji_type; (*p銿R[hn (MSkanjî)  *)
                namae   : name;       (*Ŏ                              *)
                knamae  : name;       (*                            *)
                pasocon : string;     (*gpp\R                        *)
                syumi   : string;     (*                                *)
                address : string;     (*Z                                *)
                tel     : string[12]; (*dbԍ                            *)
                birthday: string[8];  (*a                              *)
                handle  : string8;    (*nhl[                      *)
                lstmes  : DateTime;   (*Messp O News                *)
                lstfile : DateTime;   (*Filep O News                *)
                group   : grouprec;   (*O[vID                          *)
                dumy    : array[0..7] of byte; (*gp                 *)
              end;
  sysidnew  = record
                user    : string8;    (*[U[hc  ex:SYSOP, KPUC01,..   *)
                esc     : escmode;    (*drbJbg[h                  *)
                lsto    : DateTime;   (*last login (YY/MM/DD HH:MM:SS)      *)
                pass    : string8;    (*pX[h                          *)
                acc     : byte;       (*access level (0..5)                 *)
                exfl    : expertmode; (*GLXp[g[h                  *)
                editor  : editormode; (*GfB^̑I                      *)
                lines   : byte;       (*Pʓ̍s                    *)
                kjt     : kanji_type; (*p銿R[hn (MSkanjî)  *)
                namae   : name;       (*Ŏ                              *)
                knamae  : name;       (*                            *)
                pasocon : string;     (*gpp\R                        *)
                syumi   : string;     (*                                *)
                address : string;     (*Z                                *)
                tel     : string[12]; (*dbԍ                            *)
                birthday: string[8];  (*a                              *)
                handle  : string8;    (*nhl[                      *)
                lstmail : DateTime;   (*Mailp O News                *)
                lstmes  : DateTime;   (*Messp O News                *)
                lstfile : DateTime;   (*Filep O News                *)
                group   : grouprec;   (*O[vID                          *)
                dumy    : array[0..7] of byte; (*gp                 *)
              end;

function allcaps(letters:string):string;
  var
    loop: byte;
    temp: string;
  begin
    temp := '';
    for loop := 1 to length(letters) do
      temp := temp + upcase(letters[loop]);
    allcaps := temp;
  end;

function addpath(s:string):string;
begin
  if s[length(s)]<>'\' then addpath:=s+'\'
  else addpath:=s;
end;


var
  id  :sysid;
  idn :sysidnew;
  idf :file of sysid;
  idfn:file of sysidnew;
  loop:longint;
  loop2:byte;

begin
  writeln('The resource Turbo-BBS  ver5.3a->ver5.3b ްķ');
  writeln('Copyright by Eskage/ComServe  1993/01/02  ver1.0');
  writeln;
  write('F[U[f[^C ...');
  assign(idf,'IDM.BBS');
  reset(idf);
  assign(idfn,'IDM.NEW');
  rewrite(idfn);
  loop:=filesize(idf)-1;
  while (loop>=0) do begin
    seek(idf,loop);
    read(idf,id);
    with idn do begin
      user:=id.user;
      esc:=id.esc;
      lsto:=id.lsto;
      pass:=id.pass;
      acc:=id.acc;
      exfl:=id.exfl;
      lines:=id.lines;
      kjt:=id.kjt;
      namae:=id.namae;
      knamae:=id.knamae;
      pasocon:=id.pasocon;
      syumi:=id.syumi;
      address:=id.address;
      tel:=id.tel;
      birthday:=id.birthday;
      handle:=id.handle;
      lstmes:=id.lstmes;
      lstfile:=id.lstfile;
      group:=id.group;
      if id.exfl=ebegin then editor:=ebeta
      else editor:=eline;
      lstmail:=id.lsto;
      for loop2:=0 to 7 do dumy[loop2]:=0;
    end;
    seek(idfn,loop);
    write(idfn,idn);
    dec(loop);
  end;
  close(idf);
  close(idfn);
  rename(idf,'IDM.OLD');
  rename(idfn,'IDM.BBS');
  writeln(' I');
  writeln;
  writeln('I܂B');
end.

