
uses dos;

type
  DateTime      = string[17];
  string8       = string[8] ;
  name          = string[14];
  line          = string[255];
  kanji_type    = (ANK,MSkanji);
  escmode       = (ecut,ecolor,efull);
  expertmode    = (ebegin,enorm,eexpert);
  grouprec      = array[1..100] of boolean;
  sysid      = record
                user    : string8;    (*[U[hc  ex:SYSOP, KPUC01,..   *)
                esc     : escmode;    (*drbJbg[h                  *)
                lsto    : DateTime;   (*last login (YY/MM/DD HH:MM:SS)      *)
                pass    : string8;    (*pX[h                          *)
                acc     : byte;       (*access level (0..5)                 *)
                exfl    : expertmode; (*GLXp[g[h                  *)
                lnf     : char;       (*slf̈                    *)
                lines   : byte;       (*Pʓ̍s                    *)
                kjt     : kanji_type; (*p銿R[hn (MSkanjî)  *)
                namae   : name;       (*Ŏ                              *)
                knamae  : name;       (*                            *)
                pasocon : line;       (*gpp\R                        *)
                syumi   : line;       (*                                *)
                address : line;       (*Z                                *)
                tel     : string[12]; (*dbԍ                            *)
                birthday: string[8];  (*a                              *)
                handle  : string8;    (*nhl[                      *)
                lstmes  : DateTime;   (*Messp O News                *)
                lstfile : DateTime;   (*Filep O News                *)
                group   : grouprec;   (*O[vID                          *)
                dumy    : array[0..7] of byte; (*gp                 *)
              end;

function allcaps(letters:string):string;
  var
    loop: byte;
    temp: string;
  begin
    temp := '';
    for loop := 1 to length(letters) do
      temp := temp + upcase(letters[loop]);
    allcaps := temp;
  end;

function addpath(s:string):string;
begin
  if s[length(s)]<>'\' then addpath:=s+'\'
  else addpath:=s;
end;


var
  id  :sysid;
  idf :file of sysid;
  deff:text;
  loop:longint;
  temp:string;
  dumy:integer;
  leng:byte;
  head:string;


begin
  writeln('The resource Turbo-BBS  ver5.3a->ver5.3b ްķ');
  writeln('Copyright by Eskage/ComServe  1991/07/29  ver1.1');
  writeln;
  assign(deff,'CONFIG.DEF');
  reset(deff);
  head:='BBS';
  leng:=8;
  repeat
    readln(deff,temp);
    temp:=allcaps(temp);
    if copy(temp,1,8)='IDLENGTH' then
      val(copy(temp,pos('=',temp)+1,255),leng,dumy);
    if copy(temp,1,6)='IDHEAD' then head:=copy(temp,pos('=',temp)+1,255);
  until eof(deff);
  close(deff);
  write('F[U[hc ...');
  assign(idf,'IDM.BBS');
  reset(idf);
  loop:=filesize(idf)-1;
  while (loop>=0) do begin
    seek(idf,loop);
    read(idf,id);
    str(100000+loop,temp);
    id.user:=head+copy(temp,length(temp)-(leng-length(head))+1,255);
    seek(idf,loop);
    write(idf,id);
    dec(loop);
  end;
  close(idf);
  writeln(' I');
  writeln;
  writeln('I܂B');
end.

