UNIT Windows;

  INTERFACE
    USES Crt,Dos,QBBS, StrStuff;
    PROCEDURE UpdateWindow (What : Window_Type);
    PROCEDURE InitWindow;
    PROCEDURE ReDrawWindow;

  IMPLEMENTATION

 PROCEDURE SmallWindowOn;

    BEGIN
       Window (1,21,80,25);
    END;

 PROCEDURE BigWindowOn;

    BEGIN
       Window (1,1,80,20);
    END;


 PROCEDURE InitWindow;

    VAR
       old_x : INTEGER;
       old_y : INTEGER;

    BEGIN
       old_x := WhereX;
       old_y := WhereY;
       GotoXY (1,21);
       SmallWindowOn;
       ClrScr;
       TextColor (Config.W_Color);
       Writeln ('Ŀ');
       Writeln ('                                                                            ');
       Writeln ('Name:                               Level:     TOn:     TLft:     TLgd:     ');
       Writeln ('                       Press Control-W For Online Menu                       ');
       BigWindowOn;
       GotoXY (old_x,old_y);
       TextColor (Config.F_Color);
    END;

    PROCEDURE SetLevel;

       VAR
          i : INTEGER;
          code : INTEGER;
          st : STRING [3];

       BEGIN
          REPEAT
             SmallWindowOn;
             TextColor (Config.W_Color);
             GotoXY (2,2);
             Writeln ('Temp. level (0..255):    ');
             GotoXY (24,2);
             Readln (st);
             Val (st, i, code);
          UNTIL (code = 0) AND (i >= 0) AND (i <= 255) OR (st = '');
          IF (st <> '') AND (code = 0) THEN level := i;
          GotoXY (2,2);            {clear out display}
          Writeln ('                         ');
          GotoXY (46,3);           {update level}
          Write (level,'  ');
          GotoXY (67,2);           {put up temp. level}
          Write (user.level);
       END;



    PROCEDURE OnlineKeys;
     BEGIN
       SmallWindowOn;
       ClrScr;
       Writeln;
       Writeln('Ŀ');
       Writeln('   ^B - Bell on/off   ^D - Hang up   ^E - Trash Key   ^F - Keyboard Lock     ');
       Writeln('   ^L - User Level    ^O - Import    ^P - Capture    ESC - Chat              ');
       Writeln('   ^T - Time Left     ^W - Window    ^Z - User Chat                          ');
       BigWindowOn;
     END;


    PROCEDURE SetTime;

       VAR
          st       : STRING [3];
          i        : INTEGER;
          code     : INTEGER;
          min      : INTEGER;
          time_left: INTEGER;

       BEGIN
          SmallWindowON;
          TextColor (Config.W_Color);
          time_left := time_limit - time_logged;
          REPEAT
             GotoXY (2,2);
             Write ('Enter time left (0..500 min):    ');
             GotoXY (32,2);
             Readln (st);
             Val (st, i, code);
          UNTIL (code = 0) AND (i >= 0) AND (i <= 500) OR (st = '');
          IF (st <> '') AND (code = 0) THEN BEGIN
             time_limit := time_logged + 60 * i;
             warning_time := time_limit - normal_warn_time;
          END;
          GotoXY (2,2);
          Writeln ('                                 ');
       END;

     PROCEDURE SetAlarm;

       BEGIN
         RedrawWindow;
         TextColor (Config.W_Color);
         SmallWindowOn;
         gotoxy (57,2);
         write ('ALARM');
         Alrm := TRUE;
       END;

     PROCEDURE SetBell;

        BEGIN
          RedrawWindow;
          TextColor (Config.W_Color);
          SmallWindowON;
          silence := NOT silence;
          GotoXY (42,2);
          IF NOT silence THEN Write ('BELL')
          ELSE Write ('    ');
        END;

     PROCEDURE SetYell;

        BEGIN
          RedrawWindow;
          TextColor (Config.W_Color);
          SmallWindowON;
          GotoXY (47,2);
          Write ('YELL');
          Yelling :=TRUE;
        END;

     PROCEDURE SetKeyb;

        BEGIN
          RedrawWindow;
          TextColor (Config.W_Color);
          SmallWindowON;
          keyboard := NOT keyboard;
          GotoXY (52,2);
          IF keyboard THEN Write ('KEYB')
          ELSE Write ('    ');
        END;


    PROCEDURE SetUsrc;

        BEGIN
          RedrawWindow;
          TextColor (Config.W_Color);
          SmallWindowOn;
          user_chat_enabled := NOT user_chat_enabled;
          GotoXY (62,2);
          IF user_chat_enabled THEN Write ('USRC')
          ELSE Write ('    ');
        END;

    PROCEDURE SetUtime;

        VAR
          Timestr      : STRING [4];

        BEGIN
          {RedrawWindow;}
          TextColor (Config.W_Color);
          SmallWindowOn;
          GotoXY (55,3);
          Str (time_on DIV 60,timestr);
          timestr := padr (timestr,3);
          Write (timestr);
          GotoXY (65,3);
          Str ((time_limit - time_logged) DIV 60,timestr);
          timestr := padr (timestr,3);
          Write (timestr);
          GotoXY (75,3);
          Str (time_logged DIV 60,timestr);
          timestr := padr (timestr,3);
          Write (timestr);
        END;


    PROCEDURE InitWindow2;

        BEGIN
          TextColor (Config.W_Color);
          SmallWindowOn;
          GotoXY (8,3);
          IF user.name = '' THEN Write ('                            ')
          ELSE Write (user.name);
          GotoXY (46,3);
          IF level <> 0 THEN Write (level)
          ELSE Write ('   ');
          GotoXY (55,3);
          IF time_on <> 0 THEN Write (time_on DIV 60)
          ELSE Write ('   ');
          GotoXY (65,3);
          IF (time_limit - time_logged) <> 0 THEN Write ((time_limit - time_logged) DIV 60)
          ELSE Write ('   ');
          GotoXY (75,3);
          IF time_logged <> 0 THEN Write (time_logged DIV 60)
          ELSE Write ('   ');
          GotoXY (67,2);
          Write ('   ');
          GotoXY (47,2);
          IF yelling THEN Write ('YELL')
          ELSE Write ('    ');
          GotoXY (42,2);
          IF NOT silence THEN Write ('BELL')
          ELSE Write ('    ');
          GotoXY (52,2);
          IF keyboard THEN Write ('KEYB')
          ELSE Write ('    ');
          gotoxy (57,2);
          IF Alrm Then Write ('ALARM') ELSE Write ('    ');
        END;

    PROCEDURE RedrawWindow;


        BEGIN
          InitWindow;
          InitWindow2;
        END;


 PROCEDURE UpdateWindow           {what : window_type};

    VAR
       old_x, old_y : INTEGER;





    BEGIN                          {of main routine}
       old_x := WhereX;
       old_y := WhereY;
       SmallWindowOn;
       TextColor (Config.W_Color);
       CASE what OF
              Redraw : RedrawWindow;
	  SetNewTime : SetTime;
         SetNewLevel : SetLevel;
               Alarm : SetAlarm;
	       Avail : SetBell;
               yell  : SetYell;
               keyb  : SetKeyb;
               usrc  : SetUsrc;
               Utime : SetUtime;
                init : InitWindow2;
            DrawMenu : OnLineKeys;
          ToggleMenu : BEGIN
                        WindowON := NOT WindowOn;
	                IF WindowON Then RedrawWindow
                          ELSE
			   OnLineKeys;
                       END;
       END;
       BigWindowOn;
       GotoXY (old_x,old_y);
       TextColor (Oldcolor);
    END;

END.
