UNIT Sysop;

INTERFACE
    Uses Dos,Crt,QBBS,Chario,Strstuff,SpaceStf,InitBBS,Message;

    PROCEDURE UserMaintenance;

IMPLEMENTATION

PROCEDURE UserMaintenance;
 var
  selection : anystring; {used for menu selection}
  user_pointer :  integer;
  newly_deleted : boolean;
  done          : boolean;
  user_changed  : boolean;
  code          : integer;
  tempint       : integer;
  funct_num     : integer;
  i             : integer;


{ALL SUB-PROCEDURES}

FUNCTION FHash(TargetName: STRING; VAR FilePointer : INTEGER) : BOOLEAN;
 var
  name : integer;
  found   : boolean;
  i       : integer;


 begin
   name := hash (targetname);
   found := false;
   i := 0;
      while (not found) and (i <= maxusers) do
       begin
       if name = userindex[i].name then
         begin
          seek(userfile,userindex [i].recordnumber);
          read(userfile,tempuser);
          if targetname = tempuser.name then found := true else i := i + 1;
         end
       else i := i + 1;
     end;
   FilePointer := i;
   FHash := found;
 end;

PROCEDURE LockUser;

 BEGIN
  WITH TempUser Do
   BEGIN
    CASE Locked Of
     TRUE : BEGIN
             Show_Error ('Unlocked');
             Locked := FALSE;
            END;
     FALSE :BEGIN
             Show_Error ('Locked');
             Locked := TRUE;
            END;
    END;
   END;
  User_Changed := TRUE;
 END;

PROCEDURE AddUsers;
 var
  drive : integer;
 begin
  maxusers := succ (maxusers);
  seek (userfile, filesize (userfile));
  write (userfile,tempuser);
  userindex [maxusers].recordnumber := filepos (userfile) -1;
  Close (Userfile);
  userindex [maxusers].name := hash (tempuser.name);
  Reset (Userfile);
  {drive := ord (Config.userpath [1]) - 64;
  disk_space (drive,drive_total_avail [drive],drive_space [drive]);}
 end;

PROCEDURE ToggleAlarm;

 BEGIN
  WITH TempUser Do
   BEGIN
    CASE Alarm Of
     TRUE : BEGIN
             Show_Error ('Caller Alarm Off');
             Alarm := FALSE;
            END;
     FALSE :BEGIN
             Show_Error ('Caller Alarm On');
             Alarm := TRUE;
            END;
    END;
   END;
  User_Changed := TRUE;
 END;

procedure rewrite_user;
 var
  tempstr : string[5];
 begin
  STR (user_pointer,tempstr);
  stringout ('Saving #' + tempstr);
  seek (userfile, UserIndex [User_Pointer].recordnumber);
  write (userfile, tempuser);
  user_changed := false;
  if user.name = tempuser.name then user := tempuser;
  lineout ('');
 end;





procedure ChangePassword;
 var
  tempinput : string[8];
 begin
   tempinput := getinput ('New password: ',ucase,echo,8);
   if tempinput <> '' then tempuser.password := tempinput;
   user_changed := true;
 end;

PROCEDURE ChangeAddress;

 VAR
  TempInput : STRING;
 BEGIN
   TempInput := GetInput ('New address: ',FALSE,echo,40);
   if TempInput <> '' then TempUser.Address := tempinput;
   User_Changed := true;
 END;

 PROCEDURE ChangeCityState;

 VAR
  TempInput : STRING;
 BEGIN
   TempInput := GetInput ('New City, State: ',FALSE,echo,40);
   if TempInput <> '' then TempUser.CityState := TempInput;
   User_Changed := TRUE;
 END;

PROCEDURE ChangeLevel;
  BEGIN
   WITH TempUser Do
    BEGIN
     Level := GetNumber ('New level (0-255): ',0,255,Level,FALSE);
     TimeLeftToday :=Level * 60;
     User_Changed := TRUE;
    END;
  END;

PROCEDURE ChangePosts;
  BEGIN
   WITH TempUser Do
    BEGIN
     PostTimes := GetNumber ('New Post Times: ',0,2147483647,PostTimes,FALSE);
     User_Changed := TRUE;
    END;
  END;

PROCEDURE ChangeCalls;
  BEGIN
   WITH TempUser Do
    BEGIN
     CallTimes := GetNumber ('New Call Times: ',0,2147483647,CallTimes,FALSE);
     User_Changed := TRUE;
    END;
  END;

PROCEDURE ChangeBytesPosted;
  BEGIN
   WITH TempUser Do
    BEGIN
     BytesPosted := GetNumber ('New Bytes Posted: ',0,2147483647,BytesPosted,FALSE);
     User_Changed := TRUE;
    END;
  END;

procedure change_board_access;
  var
   question : string[5];
   code     : integer;
   boardnumber : integer;
   access      : string[5];
   showSTR     : string[5];
  begin
   question := getinput ('Msg. Area: ',ucase,echo,5);
   if (question <> '') and (question <> '+') and (question <> '-') then
    begin
      Val (question,boardnumber,code);
      if (code = 0) and ((user.board_access [boardnumber] = 'C')
       or (level = Config.Sysoplevel))
       and (boardnumber >= 0) and (boardnumber <= maxboards) then
        begin
         if (tempuser.level < Config.Sysoplevel) or (level = Config.Sysoplevel) then
          begin
           access := getinput (tempuser.board_access [boardnumber] + ' -> ',ucase,echo,2);
           if access <> '' then
            begin
              if (access [1] in ['M','N','C','W','R','I']) then
                if level = Config.Sysoplevel then tempuser.board_access [boardnumber] := access[1]
                 else if access [1] in ['I','R','N','W'] then tempuser.board_access [boardnumber] := access[1]
                  else show_error ('You do not have access.');
              user_changed := true;
            end;
          end
         else show_error ('You can''t do that, bubs!');
        end
      else show_error ('Wrongo!');
    end;
  end;


procedure delete_user;
 var
  i : integer;
 begin
  tempuser.deleted := true;
  rewrite_user;
  usersdeleted := succ (usersdeleted);
  if userindex_pos > user_pointer then userindex_pos := pred (userindex_pos);
  for i := user_pointer to maxusers do userindex [i] := userindex [i + 1];
  maxusers := pred (maxusers);
 end;

procedure change_name;
 var
  tempSTR : string[25];
  dummy   : integer;
  dummyuser : UserRecord;
 begin
  tempSTR := getinput ('New name? ',ucase,echo,25);
  if tempSTR <> '' then
   begin
    dummyuser := tempuser;
    if not FHash (tempSTR,dummy) then
      begin
       tempuser := dummyuser;
       tempuser.name := tempSTR;
       userindex [dummy].name := hash (tempuser.name);
       user_changed := true;
      end
    else
     begin
      tempuser := dummyuser;
      show_error ('Name In Use.');
     end;
   end;
 end;

procedure get_user;
  begin
   seek (userfile, userindex [user_pointer].recordnumber);
   read (userfile, tempuser);
  end;


procedure enter_user;
 var
  I         : INTEGER;
  dummy     : INTEGER;
  dummyuser : UserRecord;

 begin
  dummyuser := tempuser;
  InitUser;
  tempuser.name := getinput ('Enter new user name: ',ucase,echo,25);
  if tempuser.name <> '' then
   begin
    if not FHash (tempuser.name,dummy) then
      begin
        tempuser.password := getinput ('Enter new user password: ',ucase,echo,25);
        if tempuser.password = '' then tempuser.password := 'NEWUSER';
        tempuser.width := 80;
        tempuser.phone.area_code :='000';
        tempuser.phone.prefix    :='000';
        tempuser.phone.suffix    :='0000';
        tempuser.address         := '123 Sample Street';
        tempuser.citystate       := 'Nowhere, NV';
        tempuser.level           := Config.UnValLevel;
        FOR I := 0 to Maxboards do
         TempUser.Board_Access [I] := boardpack [I].Default_Access;
        AddUsers;
      end
    else show_error ('Name already exists');
   end;
  tempuser := dummyuser;
 end;

PROCEDURE Show_User;

 VAR
  Date   : STRING;
  Time   : STRING[10];
  Number : STRING[10];
  i      : INTEGER;
  Tname  : STRING;

 BEGIN
  Tname := User.Name;
  WITH TempUser DO
   BEGIN
    EnableBreak;
    ReformatDate (date,month,day,year,DayOfWeek);
    Reformat_Time (time,hour,min);
    Str (User_Pointer,Number);
    LineOut(C('W2'));
    StringOut ('#');
    StringOut (C('R2') + Number);
    StringOut (C('G2') + '  ' +name);
    IF Locked then StringOut (C('R')+' [Lock] ');
    LineOut ('');
    StringOut (C('C2')+'Phone Number: ');
    WITH TempUser.Phone Do
     BEGIN
      IF (User.Level = Config.Sysoplevel) Then
       StringOut (C('G2')+Area_Code+'-'+Prefix+'-'+Suffix)
      ELSE StringOut (C('R')+'[Suppressed]');
     END;
     LineOut ('');
    END; {With}
    If Level = Config.SysopLevel Then
     BEGIN
      StringOut (C('C2')+'Address: ');
      LineOut (C('G2') + TempUser.Address);
     END;
    WITH TempUser do
     BEGIN
      StringOut (C('C2')+'City: ');
      LineOut  (C('G2')+CityState);
      Stringout (C('C2')+'D: ');
      StringOut (C('G2') + date);
      StringOut (C('C2') + '  T: ');
      LineOut (C('G2') + time);
      IF Locked then StringOut ('(Lock) ');
      StringOut(C('C2')+'PW: ');
      IF (User.Level = Config.Sysoplevel) and (User.Name = Config.sysopname) THEN
       Stringout (C('G2')+password + '  ')
       ELSE stringout (C('R')+'........');
      StringOut (C('C2')+'  L: ');
      StringOut (C('G2') + stri (level));
      StringOut (C('C2') + '  Dnld L: ');
      LineOut (C('G2') + stri (TempUser.d_level));
     END; {With}
      LineOut (C('Y2')+'Area#: 0123456789012345');
      StringOut ('Msgs.: ');
    FOR I := 0 to 15 do
    IF (level = Config.Sysoplevel) or (user.board_access [i] = 'C') then
     StringOut (C('M')+TempUser.Board_access [i])
      else stringout (C('B2')+'-');
    LineOut ('');
    WITH TempUser do
     BEGIN
      Str (CallTimes,Number);
      StringOut (C('C2')+'T.Called: ');
      StringOut (C('G2') + Number);
      Str (PostTimes,Number);
      StringOut (C('C2')+'   T.Posted: ');
      StringOut (C('G2') + Number);
      Str (Ratio:2:0,Number);
      StringOut (C('C2')+'   Ratio: ');
      StringOut (C('G2')+Number+'%');
      Str (BytesPosted,Number);
      StringOut (C('C2')+'   Bytes Posted: ');
      StringOut (C('G2') + Number);
      lineout ('');
      StringOut (C('C2')+' Caller Alarm: ');
      IF Alarm then StringOut (C('R')+'ON') ELSE StringOut (C('R')+'OFF');
      LineOut(C('W2'));
      DisableBreak;
     END; {With}
 END;


PROCEDURE ChangePhoneNumber;

 VAR
  TempSTR     : STRING;
  Ok          : BOOLEAN;
  Abort       : BOOLEAN;
  J           : INTEGER;

BEGIN

 REPEAT
       BEGIN
         Ok     := TRUE;
         Abort  := FALSE;
         LineOut ('');
         StringOut ('Enter New User Phone Number (XXX-XXX-XXXX) or <Return>: ');
         TempStr := GetInput ('',Ucase,Echo,13);
         IF TempStr = '' THEN ABORT := TRUE;
            For J := 1 to 12 do
             BEGIN
              IF (J=4) OR (J=8) THEN
               BEGIN
                IF (TempStr[J] <> '-' )THEN Ok := FALSE;
               END
              ELSE
               BEGIN
                Val (TempStr[J],TempInt,Code);
                IF Code <> 0 Then Ok := FALSE;
               END;
            END;
          END;
     UNTIL (OK) or (Not THERE) or (Abort);
    IF Not ABORT THEN
     BEGIN
     WITH TempUser.Phone DO
      BEGIN
       Area_Code :='';
       Prefix    :='';
       Suffix    :='';
       FOR J:=1 to 12 do
        BEGIN
          IF (J>0) And (J<4) THEN Area_Code := Area_Code + TempStr[J];
          IF (J>4) AND (J<8) THEN Prefix    := Prefix    + TempStr[J];
          IF (J>8)           THEN Suffix    := Suffix    + TempStr[J];
        END;
       END;
       IF OK THEN User_Changed := TRUE;
    END;
END;

procedure user_search;
 var
  i : integer;
  searchname : string[25];
 begin
  searchname := getinput ('Name for search for? ',ucase,echo,25);
  if searchname <> '' then
   if FHash (searchname,i) then
    begin
     Reset (UserFile);
     user_pointer := i;
     get_user;
     show_user;
    end
   else
    begin
     get_user;
     show_error ('User not found!');
    end
    ELSE Reset (UserFile);
 end;



function sysop_prompt : anystring;
 var
  tempSTR : string[50];
  tempSTR1: string[25];
  tempSTR2: string[25];
 begin
  case GoingForward of
   true : tempSTR := '+';
   false: tempSTR := '-';
  end;
  str (user_pointer,tempSTR1);
  str (maxusers,tempSTR2);
  tempSTR := tempSTR + ' User [' + tempSTR1 + '] (0-' + tempSTR2 + '), ?: ';
  sysop_prompt := tempSTR;
 end;




procedure level_check;
 var
  tempint : integer;
 begin
  tempint := getnumber ('Enter level to check for (0-255) or -1 to abort: ',-1,255,-1,false);
  if tempint <> -1 then
   begin
    rewrite_user;
    user_pointer := 0;
    ClearBreak;
    EnableBreak;
    repeat
     user_pointer := succ (user_pointer);
     get_user;
     if tempuser.level = tempint then show_user;
    until (break) or (not there) or (user_pointer = maxusers);
    DisableBreak;
   end;
 end;

procedure mass_access;
 var
  tempstr : anystring;
  tempstr1: anystring;
  tempint : integer;
  doit    : boolean;
 begin
  rewrite_user;
  tempint := getnumber ('Enter area # to change (0-'+stri(maxboards)+') or -1 to quit: ',-1,maxboards,-1,false);
  if tempint <> -1 then
   begin
    tempstr := getinput ('Enter original access or "A" for all users [W,N,C,M,R,I]: ',ucase,echo,2);
    tempstr1:= getinput ('Enter new access for users [W,N,C,M,R,I]: ',ucase,echo,2);
    if (tempstr = '') or (tempstr1 = '') or (not (tempstr1[1] in ['W','N','C','M','R','I']))
     then show_error ('Invalid Input')
    else
     begin
      user_pointer := -1;
      ClearBreak;
      EnableBreak;
      stringout ('Changing #   ');
      repeat
       user_pointer := succ (user_pointer);
       get_user;
       doit := false;
       if tempstr = 'A' then doit := true else
       if tempstr <> 'A' then
         if tempuser.board_access [tempint] = tempstr then doit := true;
       if doit then
        begin
         stringout (''+strif(user_pointer,3));
         tempuser.board_access [tempint] := tempstr1[1];
         seek (userfile, filepos (userfile) - 1);
         write (userfile, tempuser);
         user_changed := false;
         if user.name = tempuser.name then user := tempuser;
        end;
      until (break) or (not there) or (user_pointer = maxusers);
      DisableBreak;
      lineout('');
     end;
   end;
 end;

procedure access_check;
 var
  tempstr : anystring;
  tempint : integer;
 begin
  rewrite_user;
  tempint := getnumber ('Enter area # to check (0-'+stri(maxboards)+') or -1 to abort: ',-1,maxboards,-1,false);
  if tempint <> -1 then
   begin
    tempstr := getinput ('Enter access to check [W,N,C,M,R,I]: ',ucase,echo,2);
    if tempstr[1] in ['N','W','R','C','M','I'] then
     begin
      user_pointer := -1;
      ClearBreak;
      EnableBreak;
      repeat;
       user_pointer := succ (user_pointer);
       get_user;
       if tempuser.board_access [tempint] = tempstr then show_user;
      until (not there) or (break) or (user_pointer = maxusers);
      DisableBreak;
     end;
   end;
 end;




procedure validate_user;
 var
  i : integer;
 begin
  LineOut ('');
  LineOut ('User Validated.');
  LineOut ('');
  user_changed := true;
  tempuser.level := Config.ValLevel;
  tempuser.d_level := Config.d_level2;
  for i := 0 to maxboards do
   tempuser.board_access [i] := boardpack [i].validate_access;
 end;

procedure change_d_level;
 var
  tempnumber : byte;
 begin
  tempuser.d_level := getnumber ('Enter download level (1-255): ',0,255,tempuser.d_level,false);
  user_changed := true;
 end;


begin { of main routine }
  done := false;
  user_changed := false;
  GoingForward := true;
  user_pointer := maxusers;
  Reset (UserFile);
  get_user;
  repeat
   funct_num := 0;
   StringOut (C('W2'));
   selection := getinput (sysop_prompt,lcase,echo,80);
   selection := allcaps (selection);
   if selection = '' then
    begin
     case  GoingForward of
      true : funct_num := 67;
      false: funct_num := 68;
     end;
    end;
   val (selection, tempint, code);
   if (selection <> MenuChoices [67]) and (selection <> MenuChoices [68])
     and (code = 0) and (funct_num = 0) then
    begin
      if  (tempint >= 0) and (tempint <= maxusers) then
        begin
          if user_changed then rewrite_user;
          user_pointer := tempint;
          get_user;
          show_user;
        end
      else show_error ('Not a valid user #');
    end
   else
    begin
      i := 50;
      while (i <= 76) and (funct_num = 0) do
       begin
        if (selection = MenuChoices [i])  then funct_num := i;
        i := succ (i);
       end;
      case funct_num of
        71 : If User.Graphics Then FileOut (GR_user_menu_name,False)
               ELSE FileOut (User_Menu_Name,False);
        72 : if level = Config.Sysoplevel then validate_user;
        73 : if level = Config.Sysoplevel then change_d_level;
        63 : begin
               if user_changed then rewrite_user;
               done := true;
              end;
        70 : begin
               if user_changed then rewrite_user;
               user_search;
              end;
        60 : if level = Config.Sysoplevel then change_name;
        59 : if (level = Config.Sysoplevel) and (tempuser.name <> user.name) then
               begin
                if user_pointer > 0 then
                 begin
                   if not tempuser.locked then
                    begin
                     delete_user;
                     if user_pointer > maxusers then user_pointer := maxusers;
                     get_user;
                     show_user;
                    end
                   else show_error ('User locked');
                 end
                else show_error ('You cannot delete the SYSOP or YOURSELF');
               end;
        62  : change_board_access;
        69  : show_user;
        61  : if level = Config.Sysoplevel then ChangeLevel;
        64  : if level = Config.Sysoplevel then LockUser;
        58  : if level = Config.Sysoplevel then Post (0,tempuser.name,'',0,'',FALSE);
        50  : If Level = Config.Sysoplevel Then ChangeAddress;
        51  : IF Level = Config.Sysoplevel Then ChangeCityState;
        52  : IF Level = Config.SysopLevel Then ToggleAlarm;
        53  : IF Level = Config.SysopLevel Then ChangeBytesPosted;
        54  : IF Level = Config.SysopLevel Then ChangePosts;
        55  : If Level = Config.SysopLevel Then ChangeCalls;
        56  : If level = Config.Sysoplevel Then ChangePhoneNumber;
        57  : if level = Config.Sysoplevel then
                begin
                  if user_changed then rewrite_user;
                  enter_user;
                  get_user;
                end;
        65  : if level = Config.Sysoplevel then ChangePassword;
        74  : if level = Config.Sysoplevel then level_check;
        75  : if level = Config.Sysoplevel then access_check;
        76  : if level = Config.Sysoplevel then mass_access;
        67  : begin
               GoingForward := true;
               if user_pointer = maxusers then show_error ('Highest user')
               else
                begin
                 if user_changed then rewrite_user;
                 user_pointer := succ (user_pointer);
                 get_user;
                 show_user;
                end;
              end;
        68 : begin
               GoingForward := false;
               if user_pointer = 0 then show_error ('Lowest user')
               else
                begin
                 if user_changed then rewrite_user;
                 user_pointer := pred (user_pointer);
                 get_user;
                 show_user;
                end;
              end;
       end;
    end;
  until (done) or (not there);
  Close (UserFile);
end; {end of main routine}

END.