
UNIT StrStuff;


INTERFACE

USES Dos,Crt;

TYPE PickType = ARRAY [1..30] of STRING;



FUNCTION Padr    (InputSt : STRING; Num : INTEGER) : STRING;
FUNCTION Padl    (InputSt : STRING; Num : INTEGER) : STRING;
FUNCTION AllCaps (St: STRING): STRING;
FUNCTION Clipr   (St: STRING): STRING;
FUNCTION Clipl   (St: STRING): STRING;
FUNCTION Clip    (St: STRING): STRING;
FUNCTION Strr    (R: REAL) : STRING;
FUNCTION Stri    (I: INTEGER): STRING;
FUNCTION Strif   (I, P : INTEGER): STRING;
FUNCTION Striz   (I, P : INTEGER): STRING;
FUNCTION BackToI (INP: STRING): INTEGER;
PROCEDURE DrawBox(StartPosIn   : BYTE;
                  StartPosDown : BYTE;
                  LengthBox    : BYTE;
                  WidthBox     : BYTE;
                  Title        : STRING;
                  BorderCol    : BYTE;
                  BackCol      : BYTE);
FUNCTION PickList (InList :PickType;
                    Title    : STRING;
                    StartX   : BYTE;
                    StartY   : BYTE;
                    StartBar : BYTE;
                    Width    : BYTE;
                    Items    : BYTE;
                    BarCol   : BYTE;
                    BorderCol: BYTE;
                    BackCol  : BYTE) : BYTE;
FUNCTION StringBox (Title    : STRING;
                    Question : STRING;
                    AnswerLen: BYTE;
                    Default  : STRING;
                    Message  : STRING;
                    MessCol  : BYTE;
                    StartX   : BYTE;
                    StartY   : BYTE;
                    BorderCol: BYTE;
                    BackCol  : BYTE) : STRING;

IMPLEMENTATION



VAR CH        : CHAR;
    I         : LongINT;
    J         : INTEGER;
    Dud       : STRING;
    Picked    : PickType;
    Temp      : BYTE;


PROCEDURE DrawBox(StartPosIn   : BYTE;
                  StartPosDown : BYTE;
                  LengthBox    : BYTE;
                  WidthBox     : BYTE;
                  Title        : STRING;
                  BorderCol    : BYTE;
                  BackCol      : BYTE);

CONST
  DoubleHorizontal = #205;     (* M *)
  SingleVertical   = #179;     (* 3 *)
  CornerOne        = #213;     (* U *)
  CornerTwo        = #184;     (* 8 *)
  CornerThree      = #190;     (* > *)
  CornerFour       = #212;     (* T *)

VAR
  Count    : BYTE;
  I        : BYTE;
  TempByte : BYTE;

PROCEDURE CheckBox;

VAR
  TotalLength,
  TotalWidth,
  LeftOver         : Integer;

Begin
  TotalLength := StartPosIn + LengthBox;
  If TotalLength > 80 Then
    Begin
      LeftOver := TotalLength - 79;
      LengthBox := LengthBox - LeftOver
    End;

TotalWidth := StartPosDown + WidthBox;
  If TotalWidth > 25 Then
    Begin
      LeftOver := TotalWidth - 24;
      WidthBox := WidthBox - LeftOver;
    End
End;

Begin
  TextBackGround (0);
  TextColor(BorderCol);
  TextBackGround (BackCol);
  CheckBox;
  GotoXY(StartPosIn, StartPosDown);
  IF Length (Title) > 1 THEN
   BEGIN
    TempByte := LengthBox - Length (Title) - 3;
    Write ('  '+Title+' ');
   END
   ELSE TempByte := LengthBox;
  FOR Count := 1 To TempByte Do
    Write(DoubleHorizontal);
  Write(CornerTwo);

  FOR Count := 1 To WidthBox Do
    BEGIN
      GotoXY(StartPosIn, StartPosDown + Count);
      Write(SingleVertical);
      FOR I := 1 to LengthBox - 1 do Write (' ');
      Write(SingleVertical);
    END;

  GotoXY(StartPosIn, StartPosDown + WidthBox);
  For Count := 1 To LengthBox Do
  Begin
     Write(DoubleHorizontal)
  End;
  Write(CornerThree);

  GotoXY(StartPosIn, StartPosDown);
  Write(CornerOne);
  For Count := 2 To WidthBox Do
    Begin
      GotoXY(StartPosIn, StartPosDown + Count);
      Write(SingleVertical)
    End;
    GotoXY(StartPosIn, StartPosDown + Count);
    Write(CornerFour);
    TextBackGround (0);
End;


FUNCTION PickList (InList :PickType;
                    Title    : STRING;
                    StartX   : BYTE;
                    StartY   : BYTE;
                    StartBar : BYTE;
                    Width    : BYTE;
                    Items    : BYTE;
                    BarCol   : BYTE;
                    BorderCol: BYTE;
                    BackCol  : BYTE) : BYTE;

  VAR
      I      : BYTE;
      X      : BYTE;
      Y      : BYTE;
      CH     : CHAR;
      BarPos : BYTE;
      Exit   : BOOLEAN;

  BEGIN
   DrawBox(StartX,StartY,Width,Items+2,Title,BorderCol,BackCol);
   X      := StartX + 1;
   Y      := StartY + 2;
   Exit   := FALSE;
   FOR I := 1 to Items DO
    BEGIN
     GotoXY (X,Y);
     TextBackGround (BackCol);
     Write (InList[I]);
     Y := Y + 1;
     TextBackGround (0);
    END;
    BarPos := StartBar;
    GotoXY (StartX+1, (StartY+2)+(BarPos) - 1);
    TextBackGround (BarCol);
    Write (InList[BarPos]);
    For I := 1 to pred((Width - Length (inlist[BarPos]))) do write (' ');
    TextBackGround (0);
    REPEAT
     BEGIN
      CH := #00;
      If Keypressed Then
       BEGIN
        CH := READKEY;
        CASE CH OF
         #27 : BEGIN                   {Aborted Out/Pressed ESC}
                Exit := TRUE;
                PickList := 0;
                TextBackGround (0);
               END;

         #72: BEGIN
               TextBackGround (BackCol);
               GotoXY (StartX+1,(StartY+2)+(BarPos)-1);
               Write (InList[BarPos]);
               For I := 1 to pred((Width - Length (inlist[BarPos]))) do
                write (' ');
               If BarPos = 1 THEN BarPos := Items
                 ELSE BarPos := Pred(BarPos);
               TextBackGround (BarCol);
               GotoXY (StartX+1,(StartY+2)+(BarPos)-1);
               Write (InList[BarPos]);
               For I := 1 to pred((Width - Length (inlist[BarPos]))) do
                write (' ');
               TextBackGround (0);
              END;
         #80: BEGIN
               TextBackGround (BackCol);
               GotoXY (StartX+1,(StartY+2)+(BarPos)-1);
               Write (InList[BarPos]);
               For I := 1 to pred((Width - Length (inlist[BarPos]))) do
                write (' ');
               If BarPos = Items THEN BarPos := 1
                 ELSE BarPos := Succ(BarPos);
               TextBackGround (BarCol);
               GotoXY (StartX+1,(StartY+2)+(BarPos)-1);
               Write (InList[BarPos]);
               For I := 1 to pred((Width - Length (inlist[BarPos]))) do
                write (' ');
               TextBackGround (0);
              END;

         ^M: BEGIN
              PickList := BarPos;
              Exit := TRUE;
              TextBackGround (0);
             END;
         END; {of case}
       END;
      END;
    UNTIL (Exit);
  END;

FUNCTION StringBox (Title    : STRING;
                    Question : STRING;
                    AnswerLen: BYTE;
                    Default  : STRING;
                    Message  : STRING;
                    MessCol  : BYTE;
                    StartX   : BYTE;
                    StartY   : BYTE;
                    BorderCol: BYTE;
                    BackCol  : BYTE) : STRING;

  VAR
      I           : BYTE;
      J           : BYTE;
      K           : BYTE;
      X           : BYTE;
      Y           : BYTE;
      CH          : CHAR;
      OutStr      : STRING;
      Exit        : BOOLEAN;
      ExtendedKey : BOOLEAN;

  BEGIN
   I := AnswerLen + Length (Question) + 4;
   DrawBox(StartX,StartY,I,4,Title,BorderCol,BackCol);
   TextBackGround (BackCol);
   TextColor (BorderCol);
   IF Message <> '' THEN
    BEGIN
     TextColor (MessCol);
     GotoXY (StartX+1,StartY+1);
     Write (Message);
     TextColor (BorderCol);
    END;
   GotoXY (StartX+1,StartY+2);
   K := Length (Default);
   X := Length (Question) + Length (Default) + StartX+1;
   OutStr := '';
   Write (Question);
   If K > 0 Then
    BEGIN
     GotoXY(StartX+2+Length (Question),StartY+2);
     Write (Default);
     OutStr := Default;
    END;
   Exit   := FALSE;
   J      := 0;
    REPEAT
     BEGIN
      CH := #00;
      If Keypressed Then
       BEGIN
        CH := READKEY;
        IF (Ch = #00) Then
         BEGIN
          Ch          := ReadKey;
          CASE CH OF
             #75 : BEGIN
                   IF K > 0 THEN
                    BEGIN
                     GotoXY (X,StartY+2);
                     Write (' ');
                     GotoXY (X,StartY+2);
                     X := X - 1;
                     Delete (OutStr,Length (OutStr),1);
                     K := K - 1;
                    END;
                   END;
            END; {Of Case}
          END
         ELSE
        CASE CH OF
         #27 : BEGIN                   {Aborted Out/Pressed ESC}
                Exit := TRUE;
                OutStr := '@@@';
                TextBackGround (0);
               END;

  #32..#127 : BEGIN
               X := X + 1;
               K := K + 1;
               IF K <= AnswerLen THEN
                BEGIN
                 GotoXY (X,StartY+2);
                 Write (CH);
                 OutStr := OutStr + CH;
                END;
              END;

         #8 : BEGIN
               IF K > 0 THEN
                BEGIN
                 GotoXY (X,StartY+2);
                 Write (' ');
                 GotoXY (X,StartY+2);
                 X := X - 1;
                 Delete (OutStr,Length (OutStr),1);
                 K := K - 1;
                END;
               END;

         ^M: BEGIN
              Exit := TRUE;
              TextBackGround (0);
             END;
         END; {of case}
       END;
      END;
    UNTIL (Exit);
    StringBox := OutStr;
  END;



function padr (inputst : STRING; num : integer) : STRING;
 var
  i : integer;
  st: STRING;
 begin
  st := inputst;
  for i := (length (st) + 1) to num do st := st + ' ';
  padr := st;
 end;

function padl (inputst : STRING; num : integer) : STRING;
 var
  i : integer;
  st: STRING;
 begin
  st := inputst;
  for i := (length (st) + 1) to num do st := ' '+ st;
  padl := st;
 end;


FUNCTION allcaps (st: STRING): STRING;
VAR
  i: Byte;
BEGIN
  FOR i := 1 TO Length (st) DO st [i] := Upcase (st [i] );
  allcaps := st;
END;

FUNCTION clipr (st: STRING): STRING;
BEGIN
  WHILE (Length (st) > 0) AND (st [Length (st) ] = ' ') DO
    st [0] := Chr (Ord (st [0] ) - 1);
  clipr := st;
END;

FUNCTION clipl (st: STRING): STRING;
BEGIN
  WHILE (Length (st) > 0) AND (st [1] = ' ') DO
    st := Copy (st, 2, 255);
  clipl := st;
END;

FUNCTION clip (st: STRING): STRING;
BEGIN
  clip := clipr (clipl (st) );
END;


FUNCTION strr (r: Real): STRING;
VAR
  st: String [30];
BEGIN
  str (r:21:0, st);
  strr := clip (st);
END;

FUNCTION stri (i: Integer): STRING;
VAR
  st: String [6];
BEGIN
  str (i, st);
  stri := st;
END;

FUNCTION strif (i, p: Integer): STRING;
VAR
  st: String [80];
BEGIN
  str (i:p, st);
  strif := st;
END;

FUNCTION striz (i, p: Integer): STRING;
VAR
  st: String [80];
  j : Byte;
BEGIN
  str (i:p, st);
  FOR j := 1 TO Length (st) - 1 DO
    IF st [j] = ' ' THEN st [j] := '0';
  striz := st;
END;


FUNCTION backtoi (inp : STRING): integer;
 var
  code : integer;
  counter : integer;
  i       : integer;
 begin
  Val (inp,i,code);
  backtoi := i;
 end;


END. {Of UNIT}



