UNIT Initbbs;

INTERFACE


  Uses Dos,Crt,QBBS,Chario,Strstuff,SpaceStf,Ibmcom1d;

  PROCEDURE PackUserFile;
  PROCEDURE PackBoard;
  PROCEDURE OpenBoard (Number: INTEGER);
  PROCEDURE UpdateUserInfo;
  PROCEDURE GetConfig;
  PROCEDURE AssignStuff;
  PROCEDURE SignOn;
  PROCEDURE GetMenuSelections;
  PROCEDURE ReadBoardTables;
  PROCEDURE EmptyMessage;
  PROCEDURE InitBoardPack (Number : INTEGER);
  PROCEDURE ConfigureBBS2;
  PROCEDURE ConfigureBBS;
  PROCEDURE ConfigureBBS1;
  PROCEDURE AddUser (UserfileOpen : BOOLEAN);
  PROCEDURE InitUser;
  PROCEDURE Defaults;
  PROCEDURE CheckParams;
  PROCEDURE UpdateLog (Operation:STRING;StOut:STRING);
  PROCEDURE UpdateTopTen;
  PROCEDURE PackFileFileWowMan (RecFile:STRING);


IMPLEMENTATION


{**************  START OF SOMETHING TOTALLY DIFFERENT *******************}

var
 sysop_pw : string [8];

 PROCEDURE PackFileFileWowMan(RecFile: STRING);
 var
  i             : integer;
  drive         : integer;
  CurFile : File Of FileAreaRecord;
  NewFile : File Of FileAreaRecord;
  DeportersHead: FileAreaRecord;

 begin
  stringout ('Packing #');

  Assign (CurFile,RecFile);
  Assign (NewFile,RecFile);
  Reset (CurFile);
  Reset (NewFile);
  I := 0;
  REPEAT
   BEGIN
    stringout ( strif (i,3) + ^a + ^a + ^a);
    seek (CurFile, I);
    read (CurFile, DeportersHead);
    I := I + 1;
    If NOT (DeportersHead.Deleted) THEN
      write (NewFile, DeportersHead);
   END;
  UNTIL (EOF(Curfile));
  lineout ('DONE');
  close (CurFile);
  truncate (NewFile);
  close (NewFile);
  drive := ord (Config.UserPath [1]) - 64;
  DiskSpace (drive,drive_total_avail [drive],drive_space [drive]);
 end;

PROCEDURE PackUserFile;
 var
  new_user_file : file of UserRecord;
  i             : integer;
  drive         : integer;
 begin
  stringout ('Packing #');
  assign (new_user_file, Config.userpath + 'USERS.DAT');
  reset (userfile);
  reset (new_user_file);
  for i := 0 to maxusers do
   begin
    stringout ( strif (i,3) + ^a + ^a + ^a);
    seek (userfile, userindex [i].recordnumber);
    read (userfile, tempuser);
    write (new_user_file, tempuser);
    userindex [i].recordnumber := filepos (new_user_file) - 1;
   end;
  lineout ('DONE');
  close (userfile);
  truncate (new_user_file);
  close (new_user_file);
  usersdeleted := 0;
  drive := ord (Config.UserPath [1]) - 64;
  DIskSpace (drive,drive_total_avail [drive],drive_space [drive]);
  assign (userfile, Config.UserPath + 'USERS.DAT');
 end;



 PROCEDURE PackBoard;
 var
  new_header_file : file of MessageRecord;
  new_lib_file    : file;
  i               : integer;
  buffer          : array [1..6528] of byte;
  drive           : integer;
 begin
  WITH BoardPack[MsgAreaNumber] Do
   BEGIN
    IF Total_Msgs > 0 then
     BEGIN
      StringOUt (C('M2'));
      stringout ('Packing #');
      assign (new_header_file, Path + FileName + header_extension);
      assign (new_lib_file,Path + Filename + Lib_Extension);
      seek (headerfile,0);
      seek (libfile,0);
      reset (new_header_file);
      reset (new_lib_file,128);
      read (headerfile, messageheader);
      write (new_header_file, messageheader);
      for i := 1 to total_msgs do
       begin
         fillchar (buffer, 6528, 0);
         StringOut (C('R2'));
         stringout ( strif (i,3) + ^a + ^a + ^a);

         seek (headerfile, messageindex [i]);
         read (headerfile, messageheader);

         seek (libfile, messageheader.startblock);
         blockread (libfile, buffer, messageheader.totalblocks);

         messageheader.startblock := filepos (new_lib_file);
         write (new_header_file, messageheader);
         blockwrite (new_lib_file, buffer, messageheader.totalblocks);
         messageindex [i] := filepos (new_header_file) - 1;
       end;
     StringOut (C('R2'));
     lineout ('DONE');
     StringOut (C('G2'));
     stringout ('Cleaning up...');
     close (headerfile);
     close (libfile);
     truncate (new_header_file);
     truncate (new_lib_file);
     close (new_header_file);
     close (new_lib_file);
     OpenBoard (MsgAreaNumber);
     lineout ('');
     blocks_deleted := 0;
     total_deleted := 0;
     drive := ord (path [1]) - 64;
     DiskSpace (drive, drive_total_avail [drive], drive_space [drive]);
   end
  else show_error ('No messages to pack.')
 end;
 END;

PROCEDURE Defaults;

       BEGIN
          current_line      := '';
          IF DOS_error_level <> 2 THEN connect_mode := waiting;
          WindowON          := TRUE;
          chatting          := FALSE;
          BREAK             := FALSE;
          wrap              := FALSE;
          yelling           := FALSE;
          wrap_save         := '';
          current_line      := '';
          Done_chatting     := TRUE;
          yelling           := FALSE;
          DisableBreak;
          inactive          := 0;
          inactive_warned   := FALSE;
          importing         := FALSE;
          inactive_warn_time:= 240;
          timecheck         := FALSE;
          chat_key          := FALSE;
          inactive_time     := 320;
          term_width        := 80;
          logged_on         := FALSE;
          user.name         := '';
          user.locked       := FALSE;
          oldinput          := '';
          lastcmd           := '';
          composing         := FALSE;
          MaxLines          := 80;
          MaxLinesEntered   := 0;
          ChatTimes         := 0;
          user_chat_enabled := FALSE;
          there_triggered   := TRUE;
          ScanMode          := FALSE;
          CNum              := 0;
          door_num          := 0;
          keyboard          := TRUE;
          time_on           := 0;
          time_logged       := 0;
          time_limit        := 0;
          level             := 0;
          min_tick          := 0;
          Alrm              := FALSE;
          PageLength        := 24;
          MoreOn            := FALSE;


       END;

PROCEDURE CheckParams;

   VAR
	I : INTEGER;

   BEGIN
      Door_Ok      := FALSE;
      ConfigOnBoot := FALSE;
      NotInit      := FALSE;
      IF ParamCount > 0 THEN
	 BEGIN

	  FOR I := 1 to Paramcount Do
	    BEGIN
	     IF allcaps(ParamStr(I)) = '/B' THEN door_ok := TRUE;
	     IF allcaps(ParamStr(I)) = '/M' THEN NotInit :=TRUE;
	     IF allcaps (ParamStr(I)) = '/C' THEN ConfigOnBoot :=TRUE;
	    END;
	  END;
   END;

PROCEDURE OpenBoard (Number: INTEGER);

    BEGIN
       Assign (headerfile, boardpack [number].path + boardpack [number].filename + header_extension);
       IF existfile (boardpack [number].path + boardpack [number].filename + header_extension) THEN
   {then}
            Reset (headerfile);
       Assign (libfile, boardpack [number].path + boardpack [number].filename + lib_extension);
       IF boardpack [number].total_msgs > 0 THEN BEGIN
          IF existfile (boardpack [number].path + boardpack [number].filename + lib_extension) THEN
                                   {then}
               Reset (libfile,128);
       END;
    END;

PROCEDURE UpdateLog (Operation:STRING;StOut:STRING);

  VAR
   UserLog : TEXT;
   GrLog   : TEXT;
   DateSTR : STRING;
   drive   : INTEGER;
   CurDate : Date_Type;

   PROCEDURE ReWriteLog;
    BEGIN
     CurrentDate (CurDate);
      WITH CurDate Do
       BEGIN
        ReformatDate (DateSTR,month,day,year,DayOfWeek);
       END;
      ReWrite (UserLog);
      ReWrite (GrLog);
      Writeln (UserLog,'%KEYS');
      Write (CF('G2'));
      Writeln (GrLog,'%KEYS');
      Writeln (UserLog);
      Writeln (GrLog);
      Write   (UserLog, 'BBS Caller Log.  Starting at ');
      Writeln (GrLog,CF('C2'));
      Write (GrLog, 'BBS Caller Log. Starting at' );
      Write (GrLog,CF('B2'));
      Writeln (GrLog,DateSTR);
      Writeln (UserLog,DateSTR);
      Writeln (GrLog);
      Writeln (UserLog);
     END;

FUNCTION AppendLog:BOOLEAN;
  BEGIN
   {$I-}
   Append (userlog);
   Append (GrLog);
   {$I+}
    IF IOResult <> 0 then
     BEGIN
      Show_Error (C('R2')+'Error Writing Userlog. Please Tell Sysop.');
      {$I-}
      Close (UserLog);
      Close (GrLog);
      {$I+}
     END;
     IF IOResult <> 0 THEN AppendLog := FALSE ELSE AppendLog := TRUE;
   END;

   PROCEDURE UpdateLogOff;

    BEGIN
     Write (userlog,'NAME: ',user.name);
     Write (GrLog,CF('G2'));
     Write (GrLog,'NAME: ');
     Write (GrLog,CF('B2'));
     Write (GrLog,User.Name);
     Writeln (userlog,'  TIME ON: ',time_logged div 60);
     Write (GrLog,CF('G2'));
     Write (GrLog,' TIME ON: ');
     Write (GrLog,CF('M2'));
     Writeln(GrLog,Time_Logged Div 60);
     IF ChatTimes > 0 then
      BEGIN
       Writeln (userlog,'Chat Requests: ', strif (ChatTimes,2));
       Write (GrLog,CF('W2'));
       Write (GrLog,'Chat Requested: ');
       Write (GrLog,CF('Y2'));
       Writeln(GrLog,Strif (ChatTimes,2));
      END;
     Writeln (userlog);
     Writeln (GrLog);
    END;

   PROCEDURE UpdateConnect;

     VAR
      SpdSTR     : STRING;
      TimeSTR    : STRING;
      TempDate   : Date_Type;
      TempTime   : Time_Type;

   BEGIN
    IF Connect_Mode = LOCAL THEN SpdSTR :='(Local)'
     ELSE
      Case Current_Speed of
       Slow      : SpdSTR :='(300 Baud)';
       Fast      : SpdSTR :='(1200 Baud)';
       Very_Fast : SpdSTR :='(2400 Baud)';
       Locked    : SpdSTR :='(Locked)';
      END;
     CurrentTime(TempTime);
     CurrentDate(TempDate);
     WITH TempDate Do
      BEGIN
       ReformatDate (dateSTR,month,day,year,DayOfWeek);
      END;
     reformat_time (timeSTR,TempTime.hour, TempTime.min);
     Writeln (userlog,'CONN: ',DateSTR,'/',TimeSTR,' at ',SpdSTR);
     Write (GrLog,CF('G2'));
     Write (GrLog,'CONN: ');
     Write (GrLog,CF('M2'));
     Write (GrLog,DateStr);
     Write (GrLog,CF('C2'));
     Write (GrLog,'/');
     Write (GrLog,CF('M2'));
     Write (GrLog,TimeStr);
     Write (GrLog,CF('Y2'));
     Write (GrLog,' at ');
     Write (GrLog,CF('B2'));
     Writeln (GrLog,SpdSTR);
   END;

   PROCEDURE SuccFileUpload;
     BEGIN
      Writeln(UserLog,'~RECV: ',StOut,' (Successful)');
      Write(GrLog,'~');
      Write(GrLog,CF('G2'));
      Write(GrLog,'REVC: ');
      Write(GrLog,CF('R2'));
      Writeln(GrLog,StOut,' (Successful)');
     END;

   PROCEDURE OpenDoor;
     BEGIN
      Writeln(UserLog,'~DOOR: ',StOut,' Opened.');
      Write(GrLog,'~');
      Write(GrLog,CF('G2'));
      Write(GrLog,'DOOR: ');
      Write(GrLog,CF('M2'));
      Writeln(GrLog,StOut,' opened.');
     END;

   PROCEDURE Bull;
     BEGIN
      Writeln(UserLog,'~BULL: ',StOut,' Read.');
      Write(GrLog,'~');
      Write(GrLog,CF('G2'));
      Write(GrLog,'BULL: ');
      Write(GrLog,CF('M2'));
      Writeln(GrLog,StOut,' read.');
     END;

   PROCEDURE Post;
     BEGIN
      Writeln(UserLog,'~POST: message on board #',StOut,'.');
      Write(GrLog,'~');
      Write(GrLog,CF('G2'));
      Write(GrLog,'POST: ');
      Write(GrLog,CF('M2'));
      Write(GrLog,'Message on Board #');
      Write(GrLog,CF('G2'));
      Writeln(GrLog,StOut,'.');
     END;

  PROCEDURE UnScFileUpload;
     BEGIN
      Writeln(Userlog,'~RECV: ',StOut,' (UnSuccessful)');
      Write(GrLog,'~');
      Write(GrLog,CF('G2'));
      Write(GrLog,'REVC: ');
      Write(GrLog,CF('R2'));
      Writeln(GrLog,StOut,' (UnSuccessful)');
     END;

  PROCEDURE SuccFileDownload;
    BEGIN
     Writeln(Userlog,'~SEND: ',StOut,' (Successful)');
     Write(GrLog,'~');
     Write(GrLog,CF('G2'));
     Write(GrLog,'SEND: ');
     Write(GrLog,CF('R2'));
     Writeln(GrLog,StOut,' (Successful)');
    END;

  PROCEDURE UnScFileDownload;
    BEGIN
     Writeln(Userlog,'~SEND: ',StOut,' (Unsuccessful)');
     Write(GrLog,'~');
     Write(GrLog,CF('G2'));
     Write(GrLog,'SEND: ');
     Write(GrLog,CF('R2'));
     Writeln(GrLog,StOut,' (UnSuccessful)');
    END;

BEGIN
  Assign (Userlog, Config.MiscPath + Log_File_Name);
  Assign (GrLog, Config.MiscPath + GrLogfile);
  IF (NOT ExistFile (Log_File_Name))  or (NOT ExistFile (GRLogFile))
   then ReWriteLog
  ELSE
   BEGIN
    IF NOT (AppendLog) THEN Exit;
   END;
  IF Operation = 'CONNECT' THEN UpdateConnect
   ELSE
  IF Operation = 'LOGOFF'  THEN UpdateLogoff
   ELSE
  IF Operation = 'SUPLOAD' THEN SuccFileUpload
   ELSE
  IF Operation = 'UUPLOAD' THEN UnScFileUpload
   ELSE
  IF Operation = 'SDOWNLOAD' THEN SuccFileDownload
   ELSE
  IF Operation = 'UDOWNLOAD' THEN UnScFileDownload
   ELSE
  IF Operation = 'OPENDOOR' THEN OpenDoor
   ELSE
  IF Operation = 'BULL' Then Bull
   ELSE
  IF Operation = 'POST' Then Post
   ELSE
    Show_Error ('Bad parameter passed to PROCEDURE UpdateLog.  Please tell sysop!');
  {$I-}
  Close (Userlog);
  Close (GrLog);
  {$I+}
END;


PROCEDURE UpdateUserInfo;
 var
  i : integer;
  C_File : File of Config_Record;
 begin
  if logged_on then
   begin
    If (Com_Carrier) and (Dos_Error_Level = 0)  THEN Hangup;
    AssignStuff;
    Assign (C_file,Config.Miscpath + Config_Filename);
    {$I-}
    Reset (userfile);
    {$I+}
    IF IOresult <> 0 THEN
     BEGIN
      Close (Userfile);
      Reset (Userfile);
     END;
    Writeln ('-Updating User File.');
    Seek (userfile,userindex [userindex_pos].recordnumber);
    CurrentTime (LogOffTime);
    CurrentDate (logOffDate);
    WITH User Do
     BEGIN
      Month     := LogOffDate.Month;
      Day       := LogOffDate.Day;
      Year      := LogOffDate.Year;
      Hour      := LogOffTime.Hour;
      Min       := LogOffTime.Min;
      DayOfWeek := LogOffDate.DayOfWeek;
      TimeLeftToday := time_limit - time_logged;
     END;

      FOR I := 0 to MaxBoards do
       User.Highest_read [I] := Boardpack [I].highest_read;

    Write (userfile,user);
    Close (userfile);
    IF User.Name <> Config.SYSOPNAME THEN UpdateLog ('LOGOFF','');
    Writeln ('-Updating Configuration File');
    Config.LastCaller := User.Name;
    Rewrite (C_File);
    Write (C_File,Config);
    Close (C_File);
    UpdateTopTen;
   end;
 end;




PROCEDURE UpdateTopTen;

 VAR
  i       : INTEGER;
  J       : INTEGER;
  Result  : INTEGER;


 BEGIN
   Writeln ('-Updating Top Ten List');
   For I := 1 to 10 do
    BEGIN
     Config.TopTen[I] :='';
     Config.TopBytes [I] :=0;
    END;
   I := 0;
    Reset (UserFile);
     WHILE (i <= maxusers) do
      BEGIN
       Seek(userfile,i);
       Read(userfile,tempuser);
       Result := 0;
       J := 11;
       REPEAT
        BEGIN
         J := J - 1;
         IF (TempUser.BytesPosted > Config.TopBytes [J]) AND
          (TempUser.Name <> Config.SYSOPNAME) THEN Result := J;
        END;
       UNTIL (J = 1);
       IF Result <> 0 THEN
       IF Result = 10 then
        BEGIN
         Config.TopTen [Result] := TempUser.Name;
         Config.TopBytes [Result] := TempUser.BytesPosted;
        END
        ELSE
        BEGIN
         J := 10;
         REPEAT
          BEGIN
           J := J - 1;
           Config.TopTen[J] := Config.TopTen [J-1];
           Config.TopBytes[J] :=Config.TopBytes [J-1];
          END;
         UNTIL J = Result;
          Config.TopTen [Result] := TempUser.Name;
          Config.TopBytes [Result] := TempUser.BytesPosted;
        END;
      I := I + 1;
     END;
   Close (Userfile);
 END;

PROCEDURE AssignStuff;
 begin
   assign(userfile,Config.userpath + 'USERS.DAT');
 end;

PROCEDURE GetConfig;
 var
  c_file : File Of Config_Record;


 begin
  clrscr;
  writeln ('-Reading configuration.');
  assign (c_file,config_filename);
  {$I-}
  reset (c_file);
  {$I+}
  if IOResult <> 0 then
     begin
       writeln;
       writeln ('CONFIG.DAT not found. Please type Top /c to reconfigure.');
       halt;
     end
  else
   begin
     Config.on_2400 := '';
     Config.on_1200 := '';
     Config.on_300  := '';
     {$I-}
      Read (C_File,Config);
     {$I+}
     If IOResult <> 0 then
       begin
        close (c_file);
        writeln ('Error has been found in CONFIG.BBS');
        writeln ('Please erase Config.Dat and run Tconfig to reconfigure.');
        halt;
       end;
      close (c_file);
   end;
 end;







PROCEDURE SignOn;

BEGIN
 IF RegesteredTo = '[EVALUATION COPY]' THEN
  BEGIN
  clrscr;
  writeln;
  writeln;
  writeln ('TOPQuark (TQ-BBS) Bulletin Board Software');
  writeln ('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
  Writeln ('Thank you for using TQ-BBS bulletin board software. ');
  Writeln;
  Writeln ('The Rates are:');
  Writeln;
  Writeln ('  $30 - Single site (Non-Comercial)');
  Writeln (' $100 - Single site (Comercial)');
  Writeln (' CALL - Multi site License');
  Writeln;
  Writeln ('All copies will recieve a printed copy of the documentation in a binder');
  Writeln ('and the newest copy of TOPquark.  Major upgrades are $15.  Minor upgrades');
  Writeln ('are free.');
  Writeln;
  Writeln ('If you like this product, please pay for it.  This program represents ');
  Writeln ('hundreds of hours of work of many people.  There no such thing as a free');
  Writeln ('lunch.  Shareware will disappear if it is not supported.');
  Writeln;
  Writeln ('Fly-By-Night Software');
  Writeln ('600 East Solana Drive');
  Writeln ('Tempe, Arizona 85281');
  Writeln ('Support BBS - YoYoDyne - (602)-921-8239 - The authors BBS');
  Writeln;
  Delay (1000);
 END;
 END;

 PROCEDURE GetMenuSelections;
 var
  menufile : text;
  number   : integer;
  name     : string [6];
  i        : integer;
 begin
  for i := 1 to 120 do MenuChoices [i] := '';
  assign (menufile,Config.Miscpath + 'MENU.DEF');
  {$I-}
  reset (menufile);
  {$I+}
  if IOResult <> 0 then
     begin
      writeln;
      writeln ('Missing ',Config.Miscpath,'MENU.DEF file');
      halt;
     end;
  repeat
   {$I-}
   readln (menufile,number,name);
   {$I+}
   if IOresult <> 0 then
    begin
     writeln;
     writeln ('Error found in ',Config.Miscpath,'MENU.DEF file');
     close (menufile);
     halt;
    end;
   MenuChoices [number] := clip (name);
  until eof (menufile);
  close (menufile);
 end;



procedure EmptyMessage;
 begin
  messageheader.deleted := false;
  messageheader.locked  := false;
  messageheader.date    := 'NoDate';
  messageheader.time    := 'NoTime';
  messageheader.title := '';
  messageheader.personto := '';
  messageheader.from  := '';
  messageheader.number := 0;
  messageheader.startblock := 0;
  messageheader.totalblocks := 0;
end;

procedure InitBoardPack (Number : INTEGER);
 var
  i : integer;
 begin
  boardpack [number].total_msgs      := 0;
  boardpack [number].total_deleted   := 0;
  boardpack [number].new_msg_start   := 0;
  boardpack [number].msg_pointer     := 0;
  boardpack [number].new_since_pack  := 0;
  boardpack [number].blocks_deleted  := 0;
  for i := 1 to Max_msgs_possible do boardpack [number].messageindex [i] := 0;
 end;

 PROCEDURE ReadBoardTables;
 var
  i : integer;
 begin
   Writeln;
   write ('-Making Board Hash Tables...');
   for i := 0 to maxboards do
    begin
      write ('.');
      initboardpack (i);
      assign(headerfile,boardpack [i].path + boardpack [i].filename + header_extension);
      {$I-}
       reset (headerfile);
      {$I+}
      if IOresult <> 0 then
       begin
        emptymessage;
        {$I+}
        rewrite(headerfile);
        {$I-}
         IF IOResult <> 0 then
           BEGIN
             Writeln;
             WRiteln ('-Message file directory not found.');
             Writeln (' Please run Tconfig to reconfigure or create directory.');
             Halt;
            END;
        write (headerfile,messageheader);
        boardpack [i].new_msg_index [0] := 0;
       end
      else
       begin
        read (headerfile, messageheader);
        boardpack [i].new_msg_index [0] := messageheader.number;
        if not eof (headerfile) then
         begin
          with boardpack [i] do
           begin
            repeat
              read (headerfile, messageheader);
              if not messageheader.deleted then
                begin
                  total_msgs := succ (total_msgs);
                  messageindex [total_msgs] := filepos (headerfile) - 1;
                  new_msg_index [total_msgs] := messageheader.number;
                  if i = 0 then mail_to_hash [total_msgs] := hash (messageheader.personto);
                end
              else
                begin
                 total_deleted := succ (total_deleted);
                 blocks_deleted := blocks_deleted + messageheader.totalblocks;
                end;
            until eof (headerfile);
           end;
         end;
       end;
      close(headerfile);
    end;
   writeln;
 end;


PROCEDURE ConfigureBBS2;
BEGIN
   Signon;
   GetMenuSelections;
   ReadBoardTables;
 END;

PROCEDURE ConfigureBBS;
 var
  x : integer;


PROCEDURE GetBoards;
 var
  board_file : text;
  i          : integer;

PROCEDURE ClearBoards;
 var
  x : integer;
 begin
  for x := 0 to 15 do
   begin
    with boardpack [x] do
     begin
      name := '';
      path := '';
      tpath := '';
      Ipath := '';
      filename := '';
      validate_access := 'N';
      default_Access := 'N';
     end;
   end;
 end;

 begin
  maxboards := 0;
  ClearBoards;
  assign (board_file,Config.Miscpath + 'BOARDS.TXT');
  {$I-}
  reset (board_file);
  {$I+}
  if IOresult <> 0 then
   begin
    writeln;
    writeln (Config.Miscpath + 'BOARDS.TXT not found, please run Tconfig to reconfigure.');
    halt;
   end
  else
   begin
    repeat
     with boardpack [maxboards] do
      begin
       readln (board_file,name);
       readln (board_file,path);
       Readln (Board_File,Tpath);
       Readln (Board_File,Ipath);
       readln (board_file,filename);
       readln (board_file,default_access);
       readln (board_file,validate_access);
      end;
     if not eof (board_file) then maxboards := succ (maxboards);
    until eof (board_file);
    close (board_file);
   end;
 end;

{PROCEDURE GetEvents;
 var
  EventFile  : text;
  i          : integer;
  J          : INTEGER;

PROCEDURE ClearEvents;
 var
  x : integer;
 begin
  for x := 0 to 15 do
   begin
    with EventPack [x] do
     BEGIN
      Day        := 0;
      DayOfWeek  := 0;
      hour       := 0;
      min        := 0;
      ErrorLevel := 0;
      Done       := FALSE;
      Forced     := FALSE;
     end;
   end;
 end;

 begin
  MaxEvents := 0;
  ClearEvents;
  assign (EventFile,Config.Miscpath + 'EVENTS.TXT');
  $I-
  reset (EventFile);
  $I+
  if IOresult = 0 then
   begin
    MaxEvents :=1;
    repeat
     with EventPack [MaxEvents] do
      begin
       readln (EventFile,Day);
       readln (EventFile,DayOfWeek);
       readln (EventFile,Hour);
       readln (EventFile,Min);
       readln (EventFile,ErrorLevel);
       Readln (EventFile,J);
       IF J = 0 THEN Done := FALSE ELSE Done := TRUE;
       Readln (EventFile,J);
       IF J = 0 THEN Forced := FALSE ELSE Forced := TRUE;
      end;
     if not eof (Eventfile) then maxboards := succ (maxboards);
    until eof (Eventfile);
    close (Eventfile);
   end;
 end;  }


BEGIN {Configure_BBS}
   GetBoards;
END;






PROCEDURE ConfigureBBS1;

PROCEDURE CreateUserIndex;
 var
  create_date : date_type;
  create_time : time_type;
  counter     : integer;

PROCEDURE InitUser;

 VAR

  Create_Date : Date_Type;
  Create_Time : Time_Type;
  i           : INTEGER;

 BEGIN
   WITH Tempuser Do
     BEGIN
      D_Level    := Config.d_level1;
      Name       := '';
      Password   := '';
      Locked     := FALSE;
      Width      := 80;
      Level      := 40;
      Deleted    := FALSE;
      TimeLeftToday := level * 60;
      ScrnLines := 24;
      MorePrompt :=TRUE;
      FOR I := 0 to MaxBoards Do board_access [i] := boardpack [i].default_access;
      IF maxboards < 15 then FOR i := (maxboards + 1) to 15 Do board_access [i] := '-';
      FOR i := 0 to 15 Do Highest_Read [I] := 0;
      Dn_k := 0;
      Up_k := 0;
      F_d  := 0;
      Phone.Area_Code :='000';
      Phone.Prefix    :='000';
      Phone.Suffix    :='0000';
      CurrentDate(create_date);
      CurrentTime(create_time);
      Month       := create_date.month;
      Day         := create_date.day;
      Year        := create_date.year;
      Hour        := create_time.hour;
      Min         := create_time.min;
      Editor_Exit := '/EX';
      Graphics    := FALSE;
      PostTimes   := 0;
      CallTimes   := 1;
      Ratio       := 0;
      Alarm       := FALSE;
      BytesPosted := 0;
      CityState   := 'NoCity, NoState';
      Address     := 'No Address';
      Alais       := 'NONE';
      AlaisOn     := FALSE;
      FOR I := 0 to 15 Do Zip_Read [I] := TRUE;
     END; {Of With}
   END;




begin
   maxusers := -1;
   usersdeleted := 0;
   {$I-}
   reset(userfile);
   {$I+}
   if IOResult <> 0 then
    begin
      rewrite (userfile);
      inituser;
      tempuser.name := Config.SYSOPNAME;
      tempuser.password := Config.sysop_pw;
      tempuser.level := Config.sysoplevel;
      tempuser.width := 80;
      write(userfile,tempuser);
      seek(userfile,filepos (userfile) - 1);
    end;
   repeat
     read (userfile,tempuser);
     if not tempuser.deleted then
      begin
        maxusers := succ (maxusers);
        userindex [maxusers].recordnumber := filepos(userfile) - 1;
        userindex [maxusers].name := hash (tempuser.name);
      end
     else usersdeleted := succ (usersdeleted);
   until EOF (userfile) or (maxusers = max_users_possible);
   Close (Userfile);
   {IF Config.TopTen[1] = '' Then} UpdateTopTen;
end;

PROCEDURE CheckDoor;
 var
  b_file : text;
  Dummy  : STRING;

 begin
  DoorSpeed := '0';
  DoorName  :='';
  DoorHour  :=0;
  DoorMin   :=0;
  assign (b_file, Config.Miscpath + 'DOOR.DAT');
  {$I-}
  reset (b_file);
  {$I+}
  if IOResult = 0 then
   begin
    readln (b_file, DoorSpeed);
    readln (b_file, DoorName);
    Readln (B_File, DoorHour);
    Readln (B_File, DoorMin);
    close (b_file);
    erase (b_file);
   end
  else writeln ('-NO OPEN doors present');
 end;


PROCEDURE GetDiskSpace;
 var
  x : integer;
 begin
  for x := 1 to 26 do
   begin
    drive_space [x] := 0;
    drive_total_avail [x] := 0;
   end;
  if (ord (Config.Miscpath [1]) - 64) < 26 then drive_space [ord (Config.Miscpath [1]) - 64] := 1;
  if (ord (Config.userpath [1]) - 64) < 26 then drive_space [ord (Config.userpath [1]) - 64] := 1;
  for x := 1 to maxboards do
   if (ord (boardpack [x].path [1]) - 64) < 26 then drive_space [ord(boardpack [x].path [1]) - 64] := 1;

  for x := 1 to 26 do
    if drive_space [x] > 0 then DiskSpace (x,drive_total_avail [x],drive_space [x]);
 end;


 BEGIN  {Configure_BBS2}
  createuserindex;
  getdiskspace;
  checkdoor;
 end; {End of CONFIGURE ROUTINES}


PROCEDURE AddUser (UserfileOpen : BOOLEAN);
 var
  drive : integer;
 begin
  maxusers := succ (maxusers);
  {$I-}
  Reset (Userfile);
  {$I+}
  seek (userfile, filesize (userfile));
  write (userfile,tempuser);
  userindex [maxusers].recordnumber := filepos (userfile) -1;
  userindex [maxusers].name := hash (tempuser.name);
  {drive := ord (Config.userpath [1]) - 64;
  disk_space (drive,drive_total_avail [drive],drive_space [drive]);}
  Close (Userfile);
 end;


PROCEDURE InitUser;
 var
  create_date : date_type;
  create_time : time_type;
  i           : integer;
 begin
  tempuser.d_level := Config.d_level1;
  tempuser.name := '';
  tempuser.password := '';
  tempuser.locked := false;
  tempuser.width := 80;
  tempuser.level  := 40;
  tempuser.deleted := false;
  for i := 0 to maxboards do tempuser.board_access [i] := boardpack [i].default_access;
  if maxboards < 15 then for i := (maxboards + 1) to 15 do tempuser.board_access [i] := '-';
  for i := 0 to 15 do tempuser.highest_read [i] := 0;
  tempuser.dn_k := 0;
  tempuser.up_k := 0;
  tempuser.Timelefttoday:= 0;
  tempuser.f_d := 0;
  CurrentDate(create_date);
  CurrentTime(create_time);
  tempuser.month := create_date.month;
  tempuser.day := create_date.day;
  tempuser.year := create_date.year;
  tempuser.hour := create_time.hour;
  tempuser.min := create_time.min;
  TempUser.Graphics := FALSE;
  TempUser.Alarm    := FALSE;
  TempUser.CityState :='';
  TempUser.Address :='';
  TempUser.BytesPosted := 0;
  TempUser.PostTimes   := 0;
  TempUser.CallTimes   := 1;
  TempUser.Ratio       := 0;
 end;


END.
