
PROCEDURE edit (start_line : INTEGER; board_to_save : INTEGER);

    VAR
       working_line : STRING[80];
       current_linenum : INTEGER;
       done            : BOOLEAN;
       i               : INTEGER;


PROCEDURE WriteQuote;

  VAR
        I         : INTEGER;
        Counter   : INTEGER;
        Finished  : BOOLEAN;
        OldHeader : MessageRecord;
        TempFile  : TEXT;


    BEGIN
    Finished := FALSE;
    Assign (TempFile,'MSGTMP');
    If Exists ('MsgTmp') THEN Erase (TempFile);
    IF BoardPack[MsgAreaNumber].Msg_Pointer > 0 THEN
     BEGIN
      OldHeader := messageHeader;
      ReadHeader (BoardPack[MsgAreaNumber].Msg_Pointer);
      SuckInText (BoardPack[MsgAreaNumber].Msg_Pointer);
      MessageHeader := OldHeader;
      i       := 0;
      counter := 0;
      Rewrite (TempFile);
       REPEAT
        BEGIN
         i := 0;
          REPEAT
           BEGIN
            i := Succ (i);
            counter := Succ (counter);
            IF messagetext [counter] <> 0 THEN
            IF messagetext [counter] <> 13 THEN
             Write (TempFile,Chr (messagetext [counter]));
            IF messageText [Counter] = 13 THEN Writeln (TempFile);
            IF messagetext [counter] = 0 THEN Finished:= TRUE;
           END;
          UNTIL (messagetext [counter] = 13) OR (Finished);
         END;
        UNTIL (Finished);
       Close (TempFile);
       END;
      END;

PROCEDURE RecoverText;

  VAR
    TempFile : TEXT;
    I        : INTEGER;
    J        : INTEGER;
    Line     : STRING[80];
    Ch       : Char;

  BEGIN
   Assign(TempFile,'MSGTMP');
   IF Exists('MsgTmp') THEN
    BEGIN
     I := 1;
     Line := '';
     Reset (TempFile);
      REPEAT
       Read (TempFile,Ch);
       IF (ch <>^j) and (ch <>^m) and (CH<>'') then Line := Line + CH
        ELSE
         BEGIN
          IF (Ch=^m) or (CH='') THEN
           BEGIN
            MessBuff[i] := Line;
            Line :='';
            I := I + 1;
            Read (tempfile,ch);
            IF (Ch='') and (CH <> ' ') THEN Line := Line + CH;
           END;
         END;
     UNTIL (EOF(TempFile)) or (I = 80);

     Close (TempFile);
     MaxLinesEntered := I-1;
     SAVEmsg := TRUE;
     ABORTmsg := FALSE;
    END ELSE DONE :=TRUE;
   QUOTEmsg := FALSE;
  END;





PROCEDURE FullScreenEdit;

  VAR
   Dummy : WORD;

  BEGIN
   WriteQuote;
   IF Connect_Mode = REMOTE THEN Com_Deinstall;
   SwapVectors;
    IF Connect_Mode = REMOTE THEN Exec(Config.EditPath,'')
     ELSE Exec(Config.EditPath,'/l');
   SwapVectors;
   IF Connect_Mode = REMOTE THEN
    BEGIN
     Com_install (Config.Port_Num,Dummy);
     IF Not (Config.Locked) THEN
      BEGIN
       CASE Current_Speed OF
          Slow : Com_Set_Speed(300);
          Fast : Com_Set_Speed(1200);
          Very_fast : Com_Set_Speed(2400);
       END;
      END
       ELSE Com_Set_Speed (Config.LockedSpeed);
     END;
   ClrScr;
   InitWindow;
   UpdateWindow (Init);
   RecoverText;
  END;

PROCEDURE DisplayColors;

 BEGIN
  StringOut (C('Y2'));
  StringOut ('Color Changing Codes: ');
  StringOut (C('R'));
  StringOut ('~R ');
  StringOut (C('R2'));
  StringOut ('~R2 ');
  StringOut (C('G'));
  StringOut ('~G ');
  StringOut (C('G2'));
  StringOut ('~G2 ');
  StringOut (C('Y'));
  StringOut ('~Y ');
  StringOut (C('Y2'));
  StringOut ('~Y2 ');
  StringOut (C('B'));
  StringOut ('~B ');
  StringOut (C('B2'));
  StringOut ('~B2 ');
  StringOut (C('M'));
  StringOut ('~M ');
  StringOut (C('M2'));
  StringOut ('~M2 ');
  StringOut (C('C'));
  StringOut ('~C ');
  StringOut (C('C2'));
  StringOut ('~C2 ');
  StringOut (C('W'));
  StringOut ('~W ');
  StringOut (C('W2'));
  Lineout ('~W2 ');
  StringOut (C('G2'));
  LineOut ('                         [@ also works as a delimiter (IE: @R)]');
  Lineout ('');
 END;

PROCEDURE WriteDoorFile;

      VAR
       TempStr : STRING;
       TempStr1: STRING;
       TempInt : INTEGER;
       TempStr2: STRING;
       D_File  : TEXT;
       J       : INTEGER;
       Done    : BOOLEAN;

      BEGIN
       Assign (D_File,Config.Miscpath+'Dorinfo1.def');
       ReWrite (D_file);
       Writeln (D_File,Config.SystemName);
       Done := FALSE;
       TempStr :='';
       TempStr1:='';
       For J := 1 to Length (Config.SysopName) Do
        BEGIN
          IF Config.SysopName[J]=' ' THEN Done := TRUE;
          IF NOT DONE then TempStr:=TempStr+Config.SysopName[J]
          ELSE
           IF Config.SysopName[J] <> ' ' THEN
             TempStr1:=TempStr1+Config.SysopName[J];
        END;
        Writeln (D_File,TempStr);
        Writeln (D_File,TempStr1);
        Str (Config.Port_Num,TempStr);
        IF Connect_Mode = REMOTE THEN Writeln (D_File,'COM'+TempStr)
         ELSE
           Writeln (D_File,'COM0');
          Str (Config.LockedSpeed,TempStr2);
          CASE Current_Speed OF
            Slow      : TempStr :='300';
            Fast      : TempStr :='1200';
            Very_Fast : TempStr :='2400';
            Locked    : TempStr :=TempStr2; {locked speed}
          END;
         IF Connect_Mode = REMOTE THEN Writeln (D_File,TempStr+' BAUD,N,8,1')
          ELSE
           Writeln (D_File,'2400 BAUD,N,8,1');
         Writeln (D_File,'0');     {<---Find out what this does...}
         Done := FALSE;
         TempStr :='';
         TempStr1:='';
         For J := 1 to Length (User.Name) Do
          BEGIN
           IF User.Name[J]=' ' THEN Done := TRUE;
          IF NOT DONE then TempStr:=TempStr+User.Name[J]
          ELSE
           If User.Name[J] <> ' ' THEN TempStr1:=TempStr1+User.Name[J];
        END;
        Writeln (D_File,TempStr);
        Writeln (D_File,TempStr1);
        Writeln (D_File,User.CityState);
        IF User.Graphics Then Writeln (D_File,'1')
         ELSE Writeln (D_File,'0');
        Writeln (D_File,'0');   {<---Find out what this does!!!}
        Str ((Time_Limit-Time_Logged) Div 60,TempStr);
        Writeln(D_File,Tempstr);
        Close (D_file);
      END;

    BEGIN
     IF (User.FullEdit) and (Config.FullScreen) THEN
      BEGIN
       WriteDoorFile;
       FullScreenEdit;
      END
      ELSE
      BEGIN
       Cnum := 0;
       current_linenum := start_line;
       timecheck := FALSE;
       done := FALSE;
       wrap := TRUE;
       lineout (C('G2'));
       lineout ('Enter message text. ' + stri (MaxLines - start_line + 1) + ' lines maximum.');
       Stringout (C('R2'));
       lineout ('/EX for editor prompt, /S to save, /Q to quote, /A to abort.');
       IF User.Graphics THEN DisplayColors;
       lineout (C('C2'));

       IF current_linenum <= MaxLines THEN
          REPEAT
             IF Config.Show_Linenum THEN working_line :=
              getinput (strif(current_linenum,2) +': ',lcase,echo,user.width - 5)
             ELSE working_line := getinput ('' ,lcase,echo,user.width - 5);
             IF Working_Line[1] <> ' ' THEN
             working_line := clipr (working_line);

             IF (working_line <> '/ex') AND (working_line <> '/EX')
              AND (working_line <> '/s') AND (working_line <> '/S') AND
               (working_line <> '/A') AND (working_line <> '/a') AND
               (working_line <> '/Q') AND (working_line <> '/q') AND
               (working_Line <> User.Editor_Exit) THEN
               BEGIN
                IF MaxLinesEntered = 80 THEN
                 BEGIN
                   MessBuff [current_linenum] := working_line;
                   done := TRUE;
                END
                ELSE
                BEGIN
                   MaxLinesEntered := Succ (MaxLinesEntered);
                   IF MaxLinesEntered > current_linenum THEN
                      FOR i := MaxLinesEntered DOWNTO current_linenum DO MessBuff [i + 1] := MessBuff [i];
                   MessBuff [current_linenum] := working_line;
                   current_linenum := Succ (current_linenum);
                END;
             END
             ELSE done := TRUE;
             IF MaxLinesEntered = (MaxLines - 2) THEN lineout(' Two lines left!');
          UNTIL (MaxLinesEntered >= MaxLines) OR (done) OR (NOT there);
       wrap := FALSE;
       IF MaxLinesEntered > 80 THEN MaxLinesEntered := 80;
       MaxLines := 80;
       timecheck := TRUE;
       IF (working_line = '/S') OR (working_line = '/s') THEN SaveMsg := TRUE
       ELSE SaveMsg := FALSE;
       IF (working_line = '/A') OR (working_line = '/a') THEN AbortMsg := TRUE
       ELSE AbortMsg := FALSE;
       IF (working_line = '/Q') OR (working_line = '/q') THEN QuoteMsg := TRUE
       ELSE QuoteMsg := FALSE;
       IF (NOT there) AND (MaxLinesEntered > 0) THEN BEGIN
          IF MaxLinesEntered < 80 THEN BEGIN
             MaxLinesEntered := Succ (MaxLinesEntered);
             MessBuff [MaxLinesEntered] := '<CARRIER LOST>';
          END;
          SaveMessage (board_to_save);
       END;
    END;
  END;


PROCEDURE EditOptions (board_to_save : INTEGER);

    VAR
       option : STRING;
       done   : BOOLEAN;

PROCEDURE Quoter;

      VAR
        Lines     : INTEGER;
        Error     : BOOLEAN;
        QuoteText : ARRAY [1..80] of STRING [80];

 FUNCTION Get_Text: BOOLEAN;

  VAR
        I         : INTEGER;
        Counter   : INTEGER;
        Finished  : BOOLEAN;
        OldHeader : MessageRecord;

    BEGIN
    Finished := FALSE;
    IF BoardPack[MsgAreaNumber].Msg_Pointer > 0 THEN
     BEGIN
      Get_Text :=FALSE;
      FOR i := 1 TO 80 DO QuoteText [i] := '';
      OldHeader := messageHeader;
      ReadHeader (BoardPack[MsgAreaNumber].Msg_Pointer);
      SuckInText (BoardPack[MsgAreaNumber].Msg_Pointer);
      MessageHeader := OldHeader;
      i       := 0;
      counter := 0;
      Lines   := 0;
       REPEAT
        BEGIN
         Lines := Succ (Lines);
         i := 0;
          REPEAT
           BEGIN
            i := Succ (i);
            counter := Succ (counter);
            IF messagetext [counter] <> 0 THEN
            IF messagetext [counter] <> 13 THEN
             QuoteText [Lines] := QuoteText [Lines] + Chr (messagetext [counter]);
            IF messagetext [counter] = 0 THEN Finished:= TRUE;
           END;
          UNTIL (messagetext [counter] = 13) OR (Finished);
         END;
        UNTIL (Finished);
       END
       ELSE
        BEGIN
         LineOut (C('R'));
         LineOut ('Nothing to Quote!');
         LineOut ('');
         Get_Text :=TRUE;
        END;
      END;

  PROCEDURE list_Quote (min_line, max_line : INTEGER);

       VAR
          i : INTEGER;
          iSTR : STRING[5];

       BEGIN
          EnableBreak;
          IF min_line = max_line THEN
           BEGIN
             Str (min_line, iSTR);
             lineout (iSTR + ': ' + QuoteText [min_line]);
          END
          ELSE
           BEGIN
             i := min_line;
             WHILE (i <= max_line) AND (there) AND (NOT BREAK) DO
              BEGIN
                Str (i,iSTR);
                lineout (strif(i,2) + ': ' + QuoteText [i]);
                i :=  Succ (i);
             END;
          END;
          DisableBreak;
       END;

  PROCEDURE CutLines;

       VAR
          tempinput : STRING;
          tempint   : INTEGER;
          tempint2  : INTEGER;
          code      : INTEGER;
          tempSTR   : STRING;
          i         : INTEGER;
          Count     : INTEGER;
          Acid      : INTEGER;
          x         : INTEGER;

       BEGIN
          IF (p_min < 1) AND (p_max < 1) THEN
           BEGIN
             p_min := getnumber ('Starting line (1- ' + stri (Lines) + ') or 0 to abort? ',0,
                  Lines,0,FALSE);
             IF p_min <> 0 THEN p_max := getnumber ('Ending line (1- ' + stri (Lines) + ') or 0 to abort? ',
                  0,Lines,0,FALSE)
             ELSE p_max := 0;
             IF p_max = 0 THEN p_min := 0;
          END;
          IF (p_min <> 0) AND (p_max <> 0) AND (p_max <= Lines) THEN BEGIN
             IF p_min = -1 THEN p_min := 1;
             IF p_max = -1 THEN p_max := Lines;
             IF (p_min <= p_max) THEN
             BEGIN
              If (80 - MaxLinesEntered) >= (P_max-P_min+1) THEN
               BEGIN
                For I := P_min to P_max Do
                 BEGIN
                  If QuoteText[I][1] <> '>' THEN
                   QuoteText[I] := '>'+ QuoteText[I];
                  MaxLinesEntered := Succ (MaxLinesEntered);
                  MessBuff[MaxLinesEntered] := QuoteText[I];
                 END;
                lineout (stri(p_max - p_min + 1) + ' line(s) cut to editor.');
               END;
             END;
          END;
       END;

  BEGIN {MAIN}
   done := FALSE;
   p_abort := FALSE;
   Error :=Get_Text;
   REPEAT
    BEGIN
     IF Not ERROR THEN
      BEGIN
       option := getinput ('[C]ut/Paste [L]ist [R]eturn: ',ucase,echo,80);
       parse(option,p_cmd,p_min,p_max,p_abort);
      END
    ELSE p_cmd :='';
     IF (p_cmd <> '') AND (NOT p_abort) THEN
       CASE p_cmd [1] OF
                'C' : CutLines;
                'L' : BEGIN
                   IF (p_min = -1) AND (p_max = -1) THEN
                    BEGIN
                      p_min := 1;
                      p_max := Lines;
                   END;
                   IF (p_min < 1) AND (p_max <> -1) THEN p_min := 1;
                   IF (p_min <> -1) AND (p_max < 1) THEN p_max := Lines;
                   IF (p_min <= p_max) AND (p_min <= Lines) AND (p_max <= Lines) THEN
                        list_Quote(p_min, p_max);
                END;
             END;
         END;
       UNTIL (NOT there) OR (p_cmd [1] = 'R') or (error);
END;



    FUNCTION whichline : INTEGER;

       VAR
          tempstr : STRING [5];

       BEGIN
          IF (p_min > 0) AND (p_min < MaxLinesEntered) THEN whichline := p_min
          ELSE whichline  := getnumber ('Line (1- ' + stri (MaxLinesEntered) + ') or 0 to abort? ',0,
               MaxLinesEntered,0,FALSE);
       END;



    PROCEDURE insert_lines;

       VAR
          tempSTR : STRING[25];
          tempint : INTEGER;
          code    : INTEGER;
          i        : INTEGER;
          counter  : INTEGER;

       BEGIN
          code := 0;
          IF MaxLinesEntered < MaxLines THEN BEGIN
             IF (p_min > -1) AND (p_min < MaxLinesEntered) THEN tempint := p_min
             ELSE BEGIN
                tempSTR := getinput ('Insert after which line? ',ucase,echo,25);
                Val (tempSTR,tempint,code);
             END;
             IF (code = 0) AND (tempint <= (MaxLinesEntered)) AND (tempint >= 0) THEN BEGIN
                edit (tempint + 1,board_to_save);
             END
             ELSE show_error ('Invalid input!');
          END
          ELSE show_error ('No more room!');
       END;

    PROCEDURE list_message (min_line, max_line : INTEGER);

       VAR
          i : INTEGER;
          iSTR : STRING[5];

       BEGIN
          EnableBreak;
          IF min_line = max_line THEN BEGIN
             Str (min_line, iSTR);
             lineout (iSTR + ': ' + MessBuff [min_line]);
          END
          ELSE BEGIN
             i := min_line;
             WHILE (i <= max_line) AND (there) AND (NOT BREAK) DO BEGIN
                Str (i,iSTR);
                lineout (strif(i,2) + ': ' + MessBuff [i]);
                i :=  Succ (i);
             END;
          END;
          DisableBreak;
       END;

    PROCEDURE delete_lines;

       VAR
          tempinput : STRING;
          tempint   : INTEGER;
          tempint2  : INTEGER;
          code      : INTEGER;
          tempSTR   : STRING;
          i         : INTEGER;
          x         : INTEGER;

       BEGIN
          IF (p_min < 1) AND (p_max < 1) THEN BEGIN
             p_min := getnumber ('Starting line (1- ' + stri (MaxLinesEntered) + ') or 0 to abort? ',0,
                  MaxLinesEntered,0,FALSE);
             IF p_min <> 0 THEN p_max := getnumber ('Ending line (1- ' + stri (MaxLinesEntered) + ') or 0 to abort? ',
                  0,MaxLinesEntered,0,FALSE)
             ELSE p_max := 0;
             IF p_max = 0 THEN p_min := 0;
          END;
          IF (p_min <> 0) AND (p_max <> 0) AND (p_max <= MaxLinesEntered) THEN BEGIN
             IF p_min = -1 THEN p_min := 1;
             IF p_max = -1 THEN p_max := MaxLinesEntered;
             IF (p_min <= p_max) THEN BEGIN
                FOR i := 1 TO ((p_max - p_min) + 1) DO BEGIN
                   FOR x := p_min TO MaxLinesEntered DO
                      IF x < MaxLinesEntered THEN MessBuff [x] := MessBuff [x + 1];
                   MaxLinesEntered := PRED (MaxLinesEntered);
                END;
                lineout (stri(p_max - p_min + 1) + ' line(s) deleted');
             END;
          END;
       END;

    PROCEDURE replace_line;

       VAR
          newline : STRING [80];

       BEGIN
          IF (p_min < 1) OR (p_min > MaxLinesEntered) THEN BEGIN
             p_min := getnumber ('Replace line #(1-' + stri (MaxLinesEntered) + ') or 0 to abort? ',0,
                  MaxLinesEntered,0,FALSE);
          END;
          IF p_min <> 0 THEN BEGIN
             list_message (p_min,p_min);
             IF yes ('Replace this line(y/n)? ') THEN BEGIN
                lineout ('Enter new line or enter <RETURN> to abort: ');
                newline := getinput ('',lcase,echo,user.width);
                IF newline = '' THEN show_error ('Line NOT replaced')
                ELSE BEGIN
                   show_error ('Line REPLACED.');
                   MessBuff [p_min] := newline;
                END;
             END;
          END;
       END;

    PROCEDURE edit_line;

       VAR
          tempint  : INTEGER;
          newline  : STRING[80];
          x        : INTEGER;
          oldline  : STRING[80];

       BEGIN
          IF (p_min < 1) OR (p_min > MaxLinesEntered) THEN BEGIN
             p_min := getnumber ('Edit line #(1- ' + stri (MaxLinesEntered) + ') or 0 to abort? ',0,MaxLinesEntered,
                  0,FALSE);
          END;
          tempint := p_min;
          IF tempint <> 0 THEN BEGIN
             list_message (tempint,tempint);
             REPEAT
                oldline := getinput ('Enter old string: ',lcase,echo,80);
                IF oldline <> '' THEN BEGIN
                   x := Pos (oldline, MessBuff [tempint]);
                   IF x = 0 THEN lineout ('Not found!')
                   ELSE BEGIN
                      newline := getinput ('New string: ',lcase,echo, (user.width - Length (MessBuff [tempint])) +
                           Length (oldline));
                      IF newline <> '' THEN BEGIN
                         Delete (MessBuff [tempint],x, Length (oldline));
                         Insert (newline, MessBuff [tempint], x);
                         list_message (tempint,tempint);
                      END;
                   END;
                END;
             UNTIL (newline <> '') OR (oldline <> '') OR (NOT there);
          END;
       END;

    PROCEDURE search;

       VAR
          templine : STRING [80];
          replacew : STRING [80];
          x        : INTEGER;
          i        : INTEGER;
          y        : INTEGER;
          confirm  : BOOLEAN;
          replace  : BOOLEAN;

       BEGIN
          lineout ('');
          lineout ('Enter string to find below (EXACT MATCH) or <RETURN> to abort:');
          templine := getinput ('',lcase,echo,user.width);
          IF templine <> '' THEN BEGIN
             lineout ('');
             lineout ('Enter new string to replace with or <RETURN> for search only:');
             replacew := getinput ('',lcase,echo,user.width);
             confirm := FALSE;
             IF replacew <> '' THEN confirm := yes ('CONFIRM each(y/n)? ');
             lineout ('Searching...');
             x := 0;
             WHILE (x < MaxLinesEntered) AND (there) DO BEGIN
                i := 0;
                x := Succ (x);
                i := Pos (templine,MessBuff [x]);
                IF (i > 0) AND ((Length (replacew)  + Length (MessBuff [x])) - Length (templine) <= user.width) THEN
                     BEGIN
                   IF NOT confirm THEN lineout ('Found: Line #' + stri(x));
                   IF replacew <> '' THEN BEGIN
                      replace := TRUE;
                      IF confirm THEN BEGIN
                         list_message(x,x);
                         IF i > 1 THEN
                            FOR y := 1 TO (i-1) DO stringout (' ');
                         lineout ('    ^');
                         IF yes ('REPLACE(y/n)? ') THEN replace := TRUE
                         ELSE replace := FALSE;
                      END;
                      IF replace THEN BEGIN
                         Delete (MessBuff [x],i,Length (templine));
                         Insert (replacew,MessBuff [x],i);
                         x := PRED (x);
                      END;
                   END;
                END;
             END;
          END;
       END;                        {end of procedure}

    PROCEDURE change_title;

       VAR
          newtitle : STRING [28];

       BEGIN
          lineout('');
          lineout ('OLD title: ' + messageheader.title);
          newtitle := getinput ('Enter new title or <ENTER> to abort: ',lcase,echo,28);
          IF newtitle <> '' THEN messageheader.title := newtitle
          ELSE lineout ('** Title NOT changed **');
       END;




    BEGIN
       done := FALSE;
       p_abort := FALSE;
       REPEAT
          IF (NOT SaveMsg) AND (NOT AbortMsg) AND (NOT QuoteMsg) THEN
           BEGIN
             StringOut (C('G2'));
             option := getinput ('Edit option: ',ucase,echo,80);
             parse(option,p_cmd,p_min,p_max,p_abort);
             StringOut (C('W2'));
          END;
          IF SaveMsg THEN p_cmd := 'S';
          IF AbortMsg THEN p_cmd := 'A';
          IF QuoteMsg THEN P_Cmd := 'Q';
          IF (p_cmd <> '') AND (NOT p_abort) THEN
             CASE p_cmd [1] OF
                'A' : BEGIN
                   AbortMsg := FALSE;
                   IF yes ('Abort (y/n)? ') THEN done := TRUE;
                END;
                'I' : insert_lines;
                'F' : search;
                'D' : BEGIN
                   delete_lines;
                   IF MaxLinesEntered = 0 THEN done := TRUE;
                END;
                'E' : edit_line;
                'R' : replace_line;
                'T' : change_title;
                'S' : BEGIN
                       IF MaxLinesEntered > 0 THEN SaveMessage(board_to_save)
                       ELSE
                        BEGIN
                         LineOut ('');
                         LineOut (C('R')+'You must enter text to save a message!');
                         LineOut (C('W2'));
                        END;
                       END;
                'Q' : BEGIN
                       Quoter;
                       IF QuoteMsg THEN P_Cmd := 'C';
                       QuoteMsg := FALSE;
                      END;
                'C' : IF MaxLinesEntered < 80 THEN
                        edit (MaxLinesEntered + 1,board_to_save);
                'L' : BEGIN
                   IF (p_min = -1) AND (p_max = -1) THEN BEGIN
                      p_min := 1;
                      p_max := MaxLinesEntered;
                   END;
                   IF (p_min < 1) AND (p_max <> -1) THEN p_min := 1;
                   IF (p_min <> -1) AND (p_max < 1) THEN p_max := MaxLinesEntered;
                   IF (p_min <= p_max) AND (p_min <= MaxLinesEntered) AND (p_max <= MaxLinesEntered) THEN
                        list_message (p_min, p_max);
                END;
                '?' : BEGIN
                   lineout ('');
                   lineout ('(A)bort   (C)ontinue   (I)nsert (F)ind (and Replace)');
                   lineout ('(D)elete  (E)dit line  (L)ist   (R)eplace line');
                   lineout ('(T)itle   (S)ave       (Q)uote');
                   lineout ('');
                END;
             END;
       UNTIL (done) OR (NOT there) OR (p_cmd [1] = 'S');
       MaxLines := 80;
    END;




PROCEDURE post (board_number : integer; personto, alaisto: NameType; reference:LONGINT; oldtitle : nametype; Force: BOOLEAN);

    VAR
       i : INTEGER;
       numSTR : STRING[5];
       question : STRING[5];
       done     : BOOLEAN;
       title    : STRING[25];
       date     : date_type;
       time     : time_type;
       last_line: INTEGER;
       drive    : INTEGER;
       TempSTR  : STRING;


    BEGIN
       drive := Ord (boardpack [board_number].path [1]) - 64;
       IF ((drive_space [drive]) >= (6528 + 103)) AND (boardpack [board_number].total_msgs < max_msgs_possible) THEN
            BEGIN
          FillChar (MessBuff, MaxLines, 0);
          done := FALSE;
          MessageHeader.Reference := Reference;
          StringOut (C('C2'));
          IF personto = '' THEN BEGIN
             IF Config.To_Prompt THEN BEGIN
                messageheader.personto := getinput ('To (<ENTER> for ALL): ',lcase,echo,25);
                IF messageheader.personto = '' THEN messageheader.personto := 'ALL';
             END
             ELSE messageheader.personto := 'ALL';
          END
          ELSE messageheader.personto := personto;
          IF AlaisTo = '' Then AlaisTo := MessageHeader.PersonTo;
          MessageHeader.AlaisTo := AlaisTo;
          StringOut (C('G2'));
          IF (messageheader.personto = personto) AND (board_number <> 0) THEN lineout ('To: ' + messageheader.Alaisto);
          IF oldtitle = '' THEN BEGIN
             messageheader.title := getinput ('Title: ',lcase,echo,25);
             IF messageheader.title = '' THEN done := TRUE;
          END
          ELSE
           BEGIN
             If Cnum = 0 THEN lineout ('Title: ' + oldtitle);
             IF NOT Force THEN
              BEGIN
               StringOut (C('R2'));
               title := getinput ('Enter title (<ENTER> for old): ',lcase,echo,25);
              END
              ELSE Title := OldTitle;
             IF title = '' THEN
              BEGIN
                IF Pos ('(R)',messageheader.title) = 0 THEN messageheader.title := '(R)' + oldtitle
                ELSE messageheader.title := oldtitle;
             END
             ELSE messageheader.title := title;
          END;
          messageheader.locked := FALSE;
          messageheader.deleted := FALSE;
          messageheader.from := user.name;
          IF NOT done THEN BEGIN
             CurrentDate (date);
             CurrentTime (time);
             messageheader.date := strd (date);
             messageheader.time := strt (time);
             MaxLinesEntered := 0;
             STR (Board_Number,TempSTR);
             UpdateLog ('POST',TempStr);
             edit (1,board_number);
             EditOptions (board_number);
          END;
       END
       ELSE show_error ('Not enough disk space. Please try later');
    END;