(*****************************************************************************)
(*>  SysOp functions: System Configuration Editor -- "J" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit XEditor;

interface

uses
  OPcrt, dos, overlay,
  common;

Procedure ChangeEditors;

Implementation
Uses FilesAcc;

Procedure DeleteEditor(RecToDel : byte);
Var
 I : integer;
Begin
 With Systat Do
 Begin

if (RecToDel <> 5) then
 for I := RecToDel to 5 do
  Begin
   Editor[i].Commandline := Editor[i+1].Commandline;
   Editor[i].Name        := Editor[i+1].Name;
   Editor[i].Number      := Editor[i+1].Number;
  End;

   Editor[5].CommandLine := '';
   Editor[5].Name        := '';

 End;
End;

Procedure  ModifyEditor(i : integer);
Var
 Str : String;
Begin
 with systat do
 Begin
  nl;nl;
  sprint(#3#4+'Editor Name <'+Editor[i].Name+'>');
  sprompt('New :'); mpl(40);
  InputPre(Editor[i].Name,40);
  nl;nl;
  print('@B = BaudRate , @P ComPort , @N UserName.');
  sprint(#3#4+'Editor Commandline <'+Editor[i].Commandline+'>');
  sprompt('New :'); mpl(40);
  InputPre(Editor[i].CommandLine,50);
  nl;nl;
 end;
End;

Procedure ChangeEditors;
Var
 Abort,Next,
 Help,Changed,Done : Boolean;
 StrName,Str  : String;
 Ch           : Char;
 I,ii    : Integer;

Begin
  Done := False;
  Changed := False;
  Help := False;
 repeat
  cls;
  abort := False; Next := False;
  I := 1;
  printacr(#3#5+MakeLength(4,'Num')+MakeLength(30,'Name')+#3#4+(MakeLength(40,'Command Line')),abort,next);
  printacr(#3#4+'',abort,next);
  nl;
  readingmail := TRUE;   { This is so the information looks like @B not 2400 }
  while (I <= 5)  do
  Begin
   With Systat do
   Begin
   if (Systat.Editor[i].Name = '') then StrName := '*EMPTY*' else
      StrName := Systat.Editor[i].Name;
   printAcr(#3#5+MakeLength(4,Cstr(i))+MakeLength(30,StrName)+
               #3#4+MakeLength(40,Editor[i].Commandline),abort,next);

   Inc(i);
  End;
 End;
   readingmail := False;

if (Help) then
  Begin
    nl;nl;
    lcmds(15,3,'Modify Editor','Delete Editor');
    lcmds(15,3,'Quit Editor Change','');
    Help := False;
 end;
  nl;
  sprompt(#3#4+'(M,D or Q)uit ?=Help) :');
  onek(ch,'MDQ?'^M);
  nl;
  Case Ch of
      '?': Help := TRUE;
      'Q' : Done := True;
      'M' :Begin
              prt('Modify which Editor # ');
              inu(ii);
              if (ii > 0) and (ii <= I) then
               Begin
                  ModifyEditor(ii);
                  Changed := True;
               End;
              End;
      'D' : Begin
              prt('Delete which Editor # ');
              inu(ii);
              if (ii > 0) and (ii <= I) then
               Begin
                  DeleteEditor(ii);
                  Changed := True;
               End;
              nl;
              End;
    End;

 Until (Done) or (HangUp);
   If (Changed)
      then SaveSystat(Start_Dir);
End;



End.
