{$I OPDEFINE.INC}

uses
  Dos,
  OpInline,
  OpString,
  OpRoot,
  OpCrt,
  OpColor,
  {$IFDEF UseMouse}
  OpMouse,
  {$ENDIF}
  OpFrame,
  OpCmd,
  OpWindow,
  OpMenu,
  WinTTT5;

  {$IFDEF UseMouse}
const
  MouseChar : Char = #04;
  {$ENDIF}

{Color set used by menu system}
const
  MenuColors : ColorSet = (
    TextColor       : YellowOnBlue;       TextMono        : LtGrayOnBlack;
    CtrlColor       : YellowOnBlue;       CtrlMono        : WhiteOnBlack;
    FrameColor      : CyanOnBlue;         FrameMono       : LtGrayOnBlack;
    HeaderColor     : WhiteOnCyan;        HeaderMono      : BlackOnLtGray;
    ShadowColor     : DkGrayOnBlack;      ShadowMono      : WhiteOnBlack;
    HighlightColor  : WhiteOnRed;         HighlightMono   : BlackOnLtGray;
    PromptColor     : BlackOnCyan;        PromptMono      : LtGrayOnBlack;
    SelPromptColor  : BlackOnCyan;        SelPromptMono   : LtGrayOnBlack;
    ProPromptColor  : BlackOnCyan;        ProPromptMono   : LtGrayOnBlack;
    FieldColor      : YellowOnBlue;       FieldMono       : LtGrayOnBlack;
    SelFieldColor   : BlueOnCyan;         SelFieldMono    : WhiteOnBlack;
    ProFieldColor   : LtGrayOnBlue;       ProFieldMono    : LtGrayOnBlack;
    ScrollBarColor  : CyanOnBlue;         ScrollBarMono   : LtGrayOnBlack;
    SliderColor     : CyanOnBlue;         SliderMono      : WhiteOnBlack;
    HotSpotColor    : BlackOnCyan;        HotSpotMono     : BlackOnLtGray;
    BlockColor      : YellowOnCyan;       BlockMono       : WhiteOnBlack;
    MarkerColor     : WhiteOnMagenta;     MarkerMono      : BlackOnLtGray;
    DelimColor      : BlueOnCyan;         DelimMono       : WhiteOnBlack;
    SelDelimColor   : BlueOnCyan;         SelDelimMono    : WhiteOnBlack;
    ProDelimColor   : BlueOnCyan;         ProDelimMono    : WhiteOnBlack;
    SelItemColor    : YellowOnCyan;       SelItemMono     : BlackOnLtGray;
    ProItemColor    : LtGrayOnBlue;       ProItemMono     : LtGrayOnBlack;
    HighItemColor   : WhiteOnBlue;        HighItemMono    : WhiteOnBlack;
    AltItemColor    : WhiteOnBlue;        AltItemMono     : WhiteOnBlack;
    AltSelItemColor : WhiteOnCyan;        AltSelItemMono  : BlackOnLtGray;
    FlexAHelpColor  : WhiteOnBlue;        FlexAHelpMono   : WhiteOnBlack;
    FlexBHelpColor  : WhiteOnBlue;        FlexBHelpMono   : WhiteOnBlack;
    FlexCHelpColor  : LtCyanOnBlue;       FlexCHelpMono   : BlackOnLtGray;
    UnselXrefColor  : YellowOnBlue;       UnselXrefMono   : LtBlueOnBlack;
    SelXrefColor    : WhiteOnMagenta;     SelXrefMono     : BlackOnLtGray;
    MouseColor      : WhiteOnRed;         MouseMono       : BlackOnLtGray
  );

{Menu item constants}
const
  miInformatio1   = 1;
  miCaller6       = 6;
  miSysop7        = 7;
  miSystem8       = 8;
  miUsage9        = 9;
  miModem2        = 2;
  miAnswer10      = 10;
  miHang11        = 11;
  miOff12         = 12;
  miInit13        = 13;
  miConfig3       = 3;
  miMsgBase14     = 14;
  miEvent15       = 15;
  miFileBase16    = 16;
  miGTextFile17   = 17;
  miP18           = 18;
  miUser19        = 19;
  miXProtocol20   = 20;
  miMenu21        = 21;
  miEmail4        = 4;
  miM22           = 22;
  miRead23        = 23;
  miWrite24       = 24;
  miMisc5         = 5;
  miDrop25        = 25;
  miMini26        = 26;
  miSPACELogin27  = 27;
  miQuit28        = 28;

{$F+}
procedure ErrorHandler(UnitCode : Byte; var ErrCode : Word; Msg : string);
  {-Report errors}
begin
  RingBell;
end;

procedure DisplayHelp(UnitCode : Byte; IdPtr : Pointer; HelpIndex : Word);
  {-Display context sensitive help}
begin
end;

procedure CustomizeItemString(var Name : String; Key : LongInt;
                              Selected, Highlighted : Boolean;
                              WPtr : RawWindowPtr);
  {-Customize menu item strings}
begin
end;
{$F-}

function InitMenu(var M : Menu) : Word;
  {-Initialize menu system generated by MAKEMENU}
const
  {Frame constants}
  Frame1 : FrameArray = 'Ըͳ';
begin
  with M do begin
    if not InitCustom(3, 2, 76, 2, MenuColors,
                      wBordered+wClear+wUserContents+wSoundEffects+wCoversOnDemand, 
                      Horizontal) then
     begin
      InitMenu := InitStatus;
      Exit;
    end;
    mnOptionsOn(mnAlphaMatch+mnSelectOnMatch+mnArrowSelect+mnAllHotSpots+
                mnSelectOnClick);
    mnOptionsOff(mnAllowPending+mnPopOnSelect+mnUseItemForTopic);
    wFrame.SetFrameType(Frame1);
    EnableExplosions(10);
    AddShadow(shBR, shSeeThru);
    AddItem('Information', 2, 1, miInformatio1);
      AddFramedSubMenu(3, 5, 17, 8, Vertical, Frame1);
      EnableExplosions(10);
      AddShadow(shBR, shSeeThru);
      AddItem('Caller List', 1, 1, miCaller6);
      AddItem('Sysop Logs', 2, 7, miSysop7);
      AddItem('System Stats', 3, 1, miSystem8);
      AddItem('Usage Z-Stats', 4, 7, miUsage9);
      ItemsDone;
    AddItem('Modem', 22, 1, miModem2);
      AddFramedSubMenu(22, 4, 31, 7, Vertical, Frame1);
      EnableExplosions(10);
      AddShadow(shBR, shSeeThru);
      AddItem('Answer', 1, 1, miAnswer10);
      AddItem('Hang Up', 2, 1, miHang11);
      AddItem('Off Hook', 3, 1, miOff12);
      AddItem('+ Init', 4, 1, miInit13);
      ItemsDone;
    AddItem('Config', 40, 1, miConfig3);
      AddFramedSubMenu(35, 4, 56, 11, Vertical, Frame1);
      EnableExplosions(10);
      AddShadow(shBR, shSeeThru);
      AddItem('MsgBase Edit', 1, 4, miMsgBase14);
      AddItem('Event Edit', 2, 1, miEvent15);
      AddItem('FileBase Edit', 3, 1, miFileBase16);
      AddItem('G-TextFile Base Edit', 4, 1, miGTextFile17);
      AddItem('P System Edit', 5, 1, miP18);
      AddItem('User Edit', 6, 1, miUser19);
      AddItem('XProtocol Edit', 7, 1, miXProtocol20);
      AddItem('#Menu Edit', 8, 1, miMenu21);
      ItemsDone;
    AddItem('Email', 56, 1, miEmail4);
      AddFramedSubMenu(51, 4, 68, 6, Vertical, Frame1);
      EnableExplosions(10);
      AddShadow(shBR, shSeeThru);
      AddItem('M Read All Email', 1, 1, miM22);
      AddItem('Read User Email', 2, 1, miRead23);
      AddItem('Write Email', 3, 1, miWrite24);
      ItemsDone;
    AddItem('Misc', 68, 1, miMisc5);
      AddFramedSubMenu(64, 5, 76, 8, Vertical, Frame1);
      EnableExplosions(10);
      AddShadow(shBR, shSeeThru);
      AddItem('Drop to DOS', 1, 1, miDrop25);
      AddItem('!-Mini DOS', 2, 1, miMini26);
      AddItem('SPACE-Login', 3, 1, miSPACELogin27);
      AddItem('Quit', 4, 1, miQuit28);
      ItemsDone;
    ItemsDone;

    SetErrorProc(ErrorHandler);
    MenuCommands.SetHelpProc(DisplayHelp);
    SetCustomStringProc(CustomizeItemString);

    InitMenu := RawError;
  end;
end;

function InitHelpLine(var H : RawWindow) : Word;
  {-Initialize window for the help line}
var
  Row : Byte;
begin
  Row := 25;
  if not H.InitCustom(1, Row, ScreenWidth, Row,
                      MenuColors, wClear) then begin
    InitHelpLine := InitStatus;
    Exit;
  end;
  H.SetTextAttr(YellowOnBlue, LtGrayOnBlack);
  InitHelpLine := 0;
end;

{*** sample test code follows ***}

var
  Status : Word;
  M      : Menu;      {menu system}
  H      : RawWindow; {item help window}

{$F+}
procedure UpdateHelpLine(CurrentItem : MenuItemNodePtr; MPtr : MenuPtr);
  {-Update HelpLine for each menu item}
var
  S : String;
begin
  if CurrentItem = nil then
    S := ''
  else
    S := CurrentItem^.HelpString;
  H.wFastText(Pad(S, H.Width), 1, 1);
end;
{$F-}

begin
  ClrScr;
  Fillscreen(1,1,80,24,yellow,Blue,chr(177));
  Status := InitMenu(M);
  if Status <> 0 then begin
    WriteLn('Error initializing menu: ', Status);
    Halt(1);
  end;

  Status := InitHelpLine(H);
  if Status <> 0 then begin
    WriteLn('Error initializing help line: ', Status);
    Halt(1);
  end;
  M.SetCurrentItemProc(UpdateHelpLine);

  {$IFDEF UseMouse}
  if MouseInstalled then
    with MenuColors do begin
      {activate mouse cursor}
      SoftMouseCursor($0000, (ColorMono(MouseColor, MouseMono) shl 8)+
                             Byte(MouseChar));
      ShowMouse;
      {enable mouse support}
      MenuCommands.cpOptionsOn(cpEnableMouse);
    end;
  {$ENDIF}

   H.Draw;
   M.Draw;
{  M.Process;}
  {Skeleton for menu choice handling}
  if M.GetLastCommand = ccSelect then
   Begin
    case M.MenuChoice of
      miCaller6       : ;
      miSysop7        : ;
      miSystem8       : ;
      miUsage9        : ;
      miAnswer10      : ;
      miHang11        : ;
      miOff12         : ;
      miInit13        : ;
      miMsgBase14     : ;
      miEvent15       : ;
      miFileBase16    : ;
      miGTextFile17   : ;
      miP18           : ;
      miUser19        : ;
      miXProtocol20   : ;
      miMenu21        : ;
      miM22           : ;
      miRead23        : ;
      miWrite24       : ;
      miDrop25        : ;
      miMini26        : ;
      miSPACELogin27  : ;
      miQuit28        : ;
    end;
 End else
     Begin
       writeln('@@@');
     End;

  M.Erase;
  H.Erase;

  {$IFDEF UseMouse}
  HideMouse;
  {$ENDIF}
  WriteLn('Item ', M.MenuChoice);
  WriteLn('Command ', M.GetLastCommand);
  H.Done;
  M.Done;
end.
