{$A+,B+,D-,E+,F+,I+,L+,N-,O-,R-,S+,V-}
UNIT tmpcom;

INTERFACE

USES
  Dos,OpCrt;


CONST
  Com_Installed: Boolean = FALSE;

Var
  mpcoder:boolean;
  mpcode:array[1..6] of byte;
  fosport:byte;
  regs:registers;

procedure com_flush_rx;
procedure com_flush_tx;
procedure com_purge_tx;

function com_carrier:boolean;
function com_rx:char;
function com_tx_ready:boolean;
function com_tx_empty:boolean;
function com_rx_empty:boolean;
function CTS(cport : byte): boolean;

procedure com_tx (ch: Char);
procedure com_tx_string (st: String);
procedure com_lower_dtr;
procedure com_raise_dtr;
procedure com_installfos(portnum:word; var error:word; Baud : Longint);
procedure com_set_speed (speed: Longint);
procedure com_deinstall;
Function Fossil_Description(ComPort:Byte):String;


implementation
Var
 Exit_Save : Pointer;

  { flush (empty) the receive buffer. }
procedure com_flush_rx;
var ch:char;
begin
    regs.dx:=fosport;
    regs.ah:=$0A;
    intr($14,regs);
end;

  { flush (empty) transmit buffer. }
procedure com_flush_tx;
begin
    regs.dx:=fosport;
    regs.ah:=$08;
    intr($14,regs);
end;

  { purge (empty) transmit buffer. }
procedure com_purge_tx;
begin
    regs.dx:=fosport;
    regs.ah:=$09;
    intr($14,regs);
end;

  { this function returns TRUE if a carrier is present. }
function com_carrier:boolean;
begin
    regs.dx:=fosport;
    regs.ah:=$03;
    intr($14,regs);
    if (regs.ax and $0080) = 0 then
      com_carrier:=FALSE
    else
      com_carrier:=TRUE;
end;

  { get a character from the receive buffer.
    If the buffer is empty, return NULL (#0). }
function com_rx:char;
begin
    if (com_rx_empty) then com_rx:=#0
    else
    begin
      regs.dx:=fosport;
      regs.ah:=$02;
      intr($14,regs);
      com_rx:=chr(regs.al);
    end;
end;

CONST                               {COM1  COM2  COM3  COM4 }
 C_PortAddr : Array[1..4] Of Word = ($03F8,$02F8,$03E8,$02E8);
Function RIStat(ComPort:Byte) : Boolean;
        { Detects for the RING from the modem }
Begin   { 1-4 for max com port passed address }
   If (ComPort<1) Or (ComPort>4) Then
      RIStat := False
      Else
      RIStat := (Port[C_PortAddr[ComPort]+6] And $40) > 0;
End;



function CTS(cport : byte): boolean;
var         {0    ..    3}
fresult : word;
Procedure GETFSTATUS;
  begin {* GetFStatus *}
    regs.ah := $03;
    regs.dx := cport;
    Intr($14,regs);
    fresult := regs.ax
  end;  {* GetFStatus *}
Function OUTPUTREADY : boolean;
{ AH Bit 5 = THRE - room is available in output buffer }
  begin {* fOutputReady *}
    GetFStatus;
    OutputReady := hi(fresult) and $20 = $20
  end;  {* fOutputReady *}
begin
 CTS := OUTPUTREADY;
end;


  { this function returns TRUE if com_tx can accept a character. }
function com_tx_ready: Boolean;
begin
    com_tx_ready:=CTS(fosport);
end;

  { this function returns TRUE if the transmit buffer is empty. }
function com_tx_empty:boolean;
begin
    regs.dx:=fosport;
    regs.ah:=$03;
    intr($14,regs);
    com_tx_empty:=((regs.ax and $4000) <> 0);
end;

  { this function returns TRUE if the receive buffer is empty. }
function com_rx_empty:boolean;
begin
    regs.dx:=fosport;
    regs.ah:=$0C;
    intr($14,regs);
    com_rx_empty:=(regs.ax = $FFFF);
end;


  { send a character.  Waits until the transmit buffer isn't full,
    then puts the character into it.  The interrupt driver will
    send the character once the character is at the head of the
    transmit queue and a transmit interrupt occurs. }
procedure com_tx(ch:char);
var result:word;
begin
    { this should make sure the remote is ready for the character... }
    repeat {..}  until(com_tx_ready) or (not com_carrier);
    regs.dx:=fosport;
    regs.al:=ord(ch);
    regs.ah:=$01;
    intr($14,regs);
end;

  { send a whole string }
procedure com_tx_string(st:string);
var i:byte;
    result:word;
begin
  for i:=1 to length(st) do
     com_tx(st[i]);
end;

  { lower (deactivate) the DTR line.  Causes most modems to hang up. }
procedure com_lower_dtr;
begin
    regs.dx:=fosport;
    regs.al:=$00;
    regs.ah:=$06;
    intr($14,regs);
end;

  { raise (activate) the DTR line. }
procedure com_raise_dtr;
begin
    regs.dx:=fosport;
    regs.al:=$01;
    regs.ah:=$06;
    intr($14,regs);
end;

  { set the baud rate.  Accepts any speed between 2 and 65535.  However,
    I am not sure that extremely high speeds (those above 19200) will
    always work, since the baud rate divisor will be six or less, where a
    difference of one can represent a difference in baud rate of
    3840 bits per second or more. }

procedure com_set_speed (speed: Longint);
Var Tmp : Word;
begin
    Tmp := Speed;
    regs.dx:=fosport;
    case Tmp of
      300   : regs.al:=(2 shl 5)+3;
      600   : regs.al:=(3 shl 5)+3;
      1200  : regs.al:=(4 shl 5)+3;
      2400  : regs.al:=(5 shl 5)+3;
      4800  : regs.al:=(6 shl 5)+3;
      9600  : regs.al:=(7 shl 5)+3;
      19200 : regs.al:=(0 shl 5)+3;
      38400 : regs.al:=(1 shl 5)+3;
    end;
    regs.ah:=$00;
    intr($14,regs);
end;

Function Fossil_Installed(portnum:word) : Boolean;
begin
    fosport:=portnum-1;
    regs.dx:=fosport;
    regs.ah:=$04;
    intr($14,regs);
    if (regs.ax = $1954) then  { fossil driver installed }
     Fossil_Installed := TRUE else
       { fossil driver not installed }
     Fossil_Installed := False;
end;

procedure com_installfos(portnum:word; var error:word; Baud : Longint);
begin
    fosport:=portnum-1;
    regs.dx:=fosport;
    regs.ah:=$04;
    intr($14,regs);
    if (regs.ax = $1954) then
    begin
      regs.dx:=fosport;
      regs.al:=$F0;
      regs.ah:=$0F;
      intr($14,regs);
      com_set_speed (Baud);
    end else
    Begin
      ClrScr;
      TextAttr := 12;
      writeln('Fossil Driver required for this program!');
      Halt(254);
 End;
end;


  { Deinstall the interrupt driver completely.  It doesn't change
    the baud rate or mess with DTR; it tries to leave the interrupt
    vectors and enables and everything else as it was when the driver
    was installed.
    This procedure MUST be called by the exit procedure of this
    module before the program exits to DOS, or the interrupt driver
    will still be attached to its vector -- the next communications
    interrupt that came along would jump to the interrupt driver which
    is no longer protected and may have been written over. }

procedure com_deinstall;
begin
    regs.dx:=fosport;
    regs.ah:=$05;
    intr($14,regs);
end;

  { This procedure is called when the program exits for any reason.  It
    deinstalls the interrupt driver.}
{$F+} procedure exit_procedure; {$F-}
begin
  com_deinstall;
  exitproc:=exit_save;
end;


Function Fossil_Description(ComPort:Byte):String;


TYPE Fossil_Struct=RECORD
                     StructSize:WORD;
                     MajorVer:BYTE;
                     MinVer:BYTE;
                     FOS_ID:ARRAY[1..2]OF WORD;
                     Inp_Buffer:WORD;
                     Recv_Bytes:WORD;
                     Out_Buffer:WORD;
                     Send_Bytes:WORD;
                     SWidth:BYTE;
                     SHeight:BYTE;
                     BaudRate:BYTE
                   END;

  VAR Cnt:INTEGER;                          { Returns the Communications FOSSIL }
    Fos_Arry:Fossil_Struct;                 { Driver Utilizing the COMPORT      }
    First,Second:WORD;                      { Communications Port               }
    Kar:CHAR;                               { Returns the FOSSIL Driver         }
    S:STRING;                               { Description.                      }
  BEGIN
    if (Fossil_Installed(ComPort)) then
  Begin
    Regs.Ah:=$1B;
    Regs.Dx:=ComPort-1;
    Regs.ES:=SEG(Fos_Arry);
    Regs.DI:=OFS(Fos_Arry);
    Regs.Cx:=SIZEOF(Fos_Arry);
    Intr($14,Regs);
    First:=Fos_Arry.FOS_ID[2];
    Second:=Fos_Arry.FOS_ID[1];
    S:='';
    Kar:=#26;
    WHILE Kar<>#0 DO 
    BEGIN
      Kar:=CHR(Mem[First:Second]);
      S:=S+Kar;
      Second:=Second+1
    END;
 End else
    s := '-NONE-';
    Fossil_Description:=S
End;


  { This installs the exit procedure. }
begin
  exit_save:=exitproc;
  exitproc:=@exit_procedure;
end.

