{ This Unit contains the Info for the ECHOMAIL.EXP creating and reading  }
{ Written DEC 5 - 1992                                                   }
{                                                                        }
{ Added new QWK support to this section 01/06/93                         }
{                                                                        }
{ *** QWK INFORMATION                                                    }
{ Newly uploaded packets goto temp\1\                                    }
{ Newly created *.QWKS go into temp\2\                                   }
{ MESSAGES.DAT,CONTROL.DAT and other QWK packet files created in temp\3\ }

{$A+,B+,D-,E+,F+,I+,L-,N-,O+,R-,S+,V-}
Unit Msg5;

Interface

 Uses
   Dos,Overlay,Common;

const
 MAX_CONFS = 255;
 NLF       = #13;
type
  BufferSolidType = Array [1..20000] of Char;{ used for msg text }
  BType           = array [1..128] of char;

                { internal confs structure }

 IntConfRecord = Record
     name     : string[15];
    actualbrd : longint;
   confnum    : integer;
end;

 IConfRecord = Array [0..MAX_CONFS] of IntConfRecord;
             { end of internal conf stuff }

                  { XXX.NDX }
    MSSingle = array[0..3] of byte;

     QWKConfsRecord = Record
             rnum : MSSingle;
              extra: byte;
end;


                  { MESSAGES.DAT }
    QwkHdrRecord = Record                    { message header structure     }
    qprivate :char;                          { first byte is privacy flag   }
                                             { ' ' means mail has been read }
                                             { '-' means not read           }
                                             { '+' means private message    }
   qmsg  :array [1..7] of char;              { message number in ASCII      }
   qdate :array [1..8] of char;              { date in ASCII (mm-dd-yy)     }
   qtime :array [1..5] of char;              { time in ASCII (hh:mm)        }
   qto   :array [1..25] of char;             { name of receiver             }
   qfrom :array [1..25] of char;             { name of sender               }
   qsubj :array [1..25] of char;             { message subject              }
   qpass :array [1..12] of char;             { message password (obsolete)  }
   qref  :array [1..8] of char;              { msg refers to this msg #     }
   qcount :array [1..6] of char;             { # of 128-byte blocks in msg  }
   qAlive    : Byte;                         { ? }
   qLeastSig : Byte;                         { conf number }
   qMostSig  : Byte;                         { ? }
   qReserved : array [1..3] of Char;
end;

                                { USed for MMail }
Procedure EchoWritten(BoardNum : Word; MsgNumber : Longint);

                               { QWK Stuff }
function UnArcQWKPacket(pathandfilename : string) : boolean;
procedure UploadQWKMail;
procedure DownloadQWKMail;
procedure set_qwk_filename;
procedure select_qwkarctype;
procedure show_qwk_stats;

Implementation

Uses
    OpCrt,Msg1,TxtMsg,OpString,
     Date_tim,Archive1,File8,Common4,file2,msg2;

{   ScanEchoRecord = Record                    ECHOMAIL.EXP       }
{                  ScanBoardNum : Word;        MsgBoardNumber     }
{                  ScanMsgNum   : LongInt;     Msg number to scan }

Procedure EchoWritten(BoardNum : Word; MsgNumber : Longint);
Var
 ScanFile : File of ScanEchoRecord;
 Scan     : ScanEchoRecord;

Begin
 if (Systat.EchoErrorlevel) then
     eLevel := 3;                       { Echomail Exit = Error level 3 }

  assign(ScanFile,Start_Dir+'\ECHOMAIL.EXP');
  {$i-} reset(ScanFile); {$i+}
  if (IoResult <> 0) then
        rewrite(ScanFile);

  Scan.ScanBoardNum := BoardNum;
  Scan.ScanMsgNum   := MsgNumber;
  Seek(ScanFile,fileSize(ScanFile));
  write(Scanfile,Scan);

 Close(ScanFile);
End;


procedure select_qwkarctype;
var
 ii : integer;
 str  : string;
 c    :char;
 abort,next,
 done : boolean;

begin
if (not systat.filearcinfo[thisuser.arctype].active) then
 begin
   while (not systat.filearcinfo[ii].active) and (ii < MAXARCS) do
         inc(ii);
    thisuser.arctype := ii;
 end;

  done := false;
  abort:= false;
 repeat
  nl;
  sprompt(#3#4+' Select Arc type');
  nl;
  ii := 1;
  while (ii <= maxarcs) and (not abort)
        and (systat.filearcinfo[ii].ext <> '') do
  begin
   str := #3#2+cstr(ii)+') '+#3#0+systat.filearcinfo[ii].ext;
    if not systat.filearcinfo[ii].active then
       str := str+#3#8+' INACTIVE';
       printAcr(str,Abort,Next);

    inc(ii);
  end;

  str := ^M'Q?';
  for ii := 1 to MAXARCS do
   if ((systat.filearcinfo[ii].ext <> '')) then
       str := str+cstr(ii);

    nl;
    sprompt(#3#4+'Selection :');
      onek(c,str);
      case c of
       'Q',^M  : done := true;
       '1'..'9': if (systat.filearcinfo[value(c)].active) then
                 begin
                  thisuser.arctype := value(c);
                  done := true;
                 end else
                 sprompt(#3#0+systat.filearcinfo[value(c)].ext+
                         #3#5+' is an inactive arc type.');
       '?':;
       end; { end case }

 until (hangup) or (done);

 SaveUserNum(ThisUser,UserNum);    { should we save the user file here? }

end;

procedure set_qwk_filename;
begin
end;

(*
var
   str,
   str2 : string;
   i   : integer;
   done : boolean;
begin
    done := false;
    while (not done) and (not hangup) do
     begin
     nl;
     sprompt(#3#4+'Select a 8 character filename for your QWK packets.@M');
     prt(':');
     mpl(8); input(str,8);
     nl;
     str2 := '';
     for i := 1 to length(str) do
       if str[i] in ['A'..'Z','a'..'z','0'..'9','_'] then
         str2 := str2 + str[i];

  if (length(str2) >1) then
  done := pynq(#3#5+'Does '+#3#0+allcaps(str2)+'.QWK'+#3#5+' look okay? [y/N] ');

     if done then
       thisuser.qwkfilename := allcaps(str2);
  end; {while }

   SaveUserNum(ThisUser,UserNum);    { should we save the user file here? }
  nl;
end;
*)

procedure show_qwk_stats;
var
 abort,next : boolean;
begin
 abort:= false;
  nl;
   printacr(#3#0+' '+#3#5+'Your statitics for QWK type Packets',abort,next);
   nl;
   printacr(#3#4+'Arc Type ='+#3#0+systat.filearcinfo[thisuser.arctype].ext,abort,next);
   printacr(#3#4+'Filename ='+#3#0+systat.qwkfilename,abort,next);
   nl;nl;
end;

Function LZeroS(w : Word) : String;
Var
  S : String;
Begin
  Str(w:0,s);
  repeat
    S := '0' + S;
  until (Length(s) > 2);
  LZeros:= s;
End;


function read_control_dat(var IConf : ICOnfRecord;
                           var TotalConfs : integer;
                               DirPath    : string):boolean;
var
 t          : text;
 Str        : string;
 I          : integer;
begin
 assign(t,DirPath+'control.dat');
{$i-} reset(t); {$i+}
if IoResult <> 0 then Begin
  sprint(#3#8+'Fatal error with QWK, missing '+dirpath+'CONTROL.DAT!');
  delay(1000);
  read_control_dat := FALSE;
 end else
 begin
  readln(t,str);         { 1 bbs name }
  readln(t,Str);         { 2 city state of BBS }
  readln(t,Str);         { 3 BBS Phone }
  readln(t,Str);         { 4 SysOpName }
  readln(t,str);         { 5 Door Reg and BBS ID }
  readln(t,str);         { 6 date,time       }
  { parse date/time from '01/01/94,08:54'}
  readln(t,str);         { 7 This users name ALLCAPS }
  readln(t,str);         { 8 blank not used }
  readln(t,str);;        { 9 empty 0 value not used }
  readln(t,str);         { 10 total number of msgs in pkt }
  readln(t,str);         { 11 MAX # of confs  (1..MAX) }

  totalconfs := value(str);
  I := 0;
 while (i <= totalconfs) and (Not Eof(t)) do
  Begin
    readln(t,str);
    IConf[i].confnum := value(Str);
    readln(t,str);
    IConf[i].name := Str;
{   calc_max_msgs(IConf,i,dirpath); }
   inc(i);
  end;
  totalconfs := i-1;

                  { not needed so comment out. }
 { readln(t,str);           usless menus names }
 { readln(t,str);                              }
 { readln(t,str);                              }
 { readln(t,str);           ?                  }
  close(t);
  read_control_dat := true;
 end;
end;

{ converts TP real to Microsoft 4 bytes single }
procedure real_to_msb (preal : real; var b : MSSingle);
var
     r : array [0 .. 5] of byte absolute preal;
begin
     b [3] := r [0];
     move (r [3], b [0], 3);
end; { procedure real_to_msb }

{ returns the actual board num, you send the scan number, i.e. }
{ say his 5th scanned board ...}
function findboardnum(scannum : integer;L : LastPtrRecord): word;
var
 w: word;
 scanned : integer;
 Notfound : boolean;
begin
 scanned := 0;
 w       := 0;
 NotFound:= False;

  repeat
   inc(w);
      if (L.Scan[w]) then
         inc(scanned);
   if (scanned<>scannum) and (w >= maxboards)
       then NotFound := TRUE;
  until (scanned = scannum) or (w >= maxboards);

  if NotFound then findboardnum := 0 else
     findboardnum := w;
end;


procedure ImportUnPackedQWK(dirpath : string);
Var
  QWKFile         : file;
  QWKHdr          : QWKHdrRecord;         { msg header }
  Buf             : BufferSolidType;      { msg text   }
  MsgHdr          : MsgHdrRecord; { bbs msgbase hdr }
  MsgTxt          : MsgTxtRecord; { bbs msgbase text record }
  L               : LastPtrRecord;
  Str             : string;
  i               : longint;
  Result : integer;              { temp integers, loop counters, etc }
  BBSID    : array [1..8] of char;
  w,
  OldBoard : word;                     { users last board }
  done     : boolean;
  FILENAME : string;

begin
  oldboard := board;  { just incase we screw up and change the board }
  FILENAME := systat.qwkfilename;

   assign(QWKFile,dirpath+FILENAME+'.MSG');
{$i-} reset(QWKFile,1); {$i+}
   if IoResult <> 0 then
     begin
      sprint(#3#8+'Fatal error with QWK, missing '+dirpath+FILENAME+'.MSG !');
      delay(1000);
      exit;
     end;
 done := false;

   fillchar(QWKHdr,SizeOf(QWKHdr),#00);
   fillchar(Buf,SizeOf(Buf),#00);
   fillchar(BBSID,SizeOf(BBSID),#00);
{$I-} BlockRead(QWKFile,BBSID,Sizeof(BBSID));  {$I+}         { blank first}
     If IoResult <> 0 then
        done := true;
{$I-} BlockRead(QWKFile,QWKHdr,Sizeof(QWKHdr)-8);  {$I+}      { blank first}
     If IoResult <> 0 then
        done := true;

 if (trimspaces(BBSID) <> FILENAME) then
  begin
     done := true;
     sprompt(#3#0+trimspaces(BBSID)+'.MSG'+#3#7+' is not a valid reply file for this system!');
  end;

 i := Load_LastPtr(ThisUser,1,L);               { load scan stuff }
 while (not eof(qwkfile)) and (not done) do
 begin
   if (not done) then
 {$i-}  BlockRead(QWKFile,QWKHdr,Sizeof(QWKHdr));  {$I+}    { msg hdr }
     If IoResult <> 0 then
        done := true;


  if (qwkhdr.qleastsig > MAXBOARDS) then
   begin               { do not have this base ... }
       i :=value(QWKHdr.QCount);
   if (not done) then
{$i-}  BlockRead(QWKFile,Buf,SizeOf(QWKHdr)*(i-1),Result); {$i+} {text of message}
     If IoResult <> 0 then
        done := true;
   end else
 Begin
  w:=findboardnum(qwkhdr.qleastsig,L);
  if (w = 0) then
  begin
       i :=value(QWKHdr.QCount);
   if (not done) then
{$i-}  BlockRead(QWKFile,Buf,SizeOf(QWKHdr)*(i-1),Result); {$i+} {text of message}
     If IoResult <> 0 then
        done := true;
  end else
  begin
       actualloadmsgboard(brd,w,true);
       i :=value(QWKHdr.QCount);
   if (not done) then
{$i-}  BlockRead(QWKFile,Buf,SizeOf(QWKHdr)*(i-1),Result); {$i+} {text of message}
     If IoResult <> 0 then
        done := true;
  if (not done) then
 Begin
   with QWKHdr do begin
     MsgHdr.FromReal  := TrimSpaces(qfrom);
     MsgHdr.FromAlias := TrimSpaces(qfrom);
     MsgHdr.WhoTo     := TrimSpaces(Qto);
     MsgHdr.Sub       := TrimSpaces(qsubj);
   { grab the date/time from the packet }

    nl;
     sprint(#3#5+'Area '+#3#1+':'+#3#7+Brd.Tagname+' #'+cstr(board));
     sprint(#3#5+'From '+#3#1+':'+#3#7+qfrom);
     sprint(#3#5+'To   '+#3#1+':'+#3#7+qto);
     sprint(#3#5+'Subj '+#3#1+':'+#3#7+qsubj);
    nl;
   end; { do }
  If (EchoBase in Brd.MsgBaseType) then
      MsgHdr.MsgType   :=[EchoMail,Public,Validated];
   i := result;
 repeat
   if (buf[i] = #32) or (buf[i] = '') then
       dec(result);
   dec(i);
 until ((buf[i] <> #32) and (buf[i] <> ''))
                           or (i = 1);

  MsgTxt.TotalLines := 1;
  I := 0;
  str := '';
  NewBuffer(MsgTxt.TBuffer); { Make heap space }
  fillchar(msgtxt.tbuffer,sizeof(msgtxt.tbuffer),#00);
 while I < Result do
  Begin
   Inc(i);
   IF (Buf[I] = '') then          { convert this to HardCR }
      Str := str + #13 else
         Str := Str + Buf[i];
     if (Length(Str) >=254) or (I >= Result) then
      Begin
       AddToEnd(MsgTxt.TBuffer,Str);
       Inc(MsgTxt.TotalLines);
       Str  := '';
      End; { length }
 End; { while }
   MsgTxt.TotalLines := MsgTxt.TotalLines-1;
     If (EchoBase in Brd.MsgBaseType) then
        Begin                      { /- Since we -1 to the total this should work }
             EchoWritten(Board,Brd.TotalMsgs);
             AddToEnd(MsgTxt.TBuffer,Nlf);
             AddToEnd(MsgTxt.TBuffer,'--- '+SoftWareName+' '+ver+Nlf);
              Str:=' * Origin: '+getorigin+' (';
      if (Systat.Addr[Brd.AKA].Zone<>0) then
          Str:=Str+GetAddress(Systat.Addr[Brd.AKA].Zone,Systat.Addr[Brd.AKA].net,Systat.Addr[Brd.AKA].node
                           ,Systat.Addr[Brd.AKA].point)+')'+Nlf
           else Str:=Str+GetAddress(Systat.Addr[1].Zone,Systat.Addr[1].Net,Systat.Addr[1].Node,
                         Systat.Addr[1].Point)+')'+Nlf;
             AddToEnd(MsgTxt.TBuffer,Str);
     inc(msgtxt.totallines,3);
    end;

   WriteNewMsg(MsgHdr,MsgTxt,Brd,FALSE,0,MsgHdr,TRUE); { writenewmsg to base }
   DeleteBuffer(MsgTxt.TBuffer);                       { Clear Heap }
  If (EchoBase in Brd.MsgBaseType) then
      EchoWritten(Board,Brd.LastMsg);

    end;
   end;
  end;
 end ; { while not eof }

  close(QWKFile);
 Board := OldBoard;
 ActualLoadMsgBoard(Brd,Board,TRUE);
end;

function ArcTypeQWK(dirandfilename : string) : string;
var
 buf : array[1..128] of char;
 f   : file;
 I,
 numread : integer;
begin
 assign(f,dirandfilename);
 reset(f,1);
 blockread(f,buf,sizeof(buf),numread);
 close(f);
 if (buf[2] = '') then
  ArcTypeQWK :='ARJ'   else
 if (buf[1] = 'P') and (buf[2] = 'K') then
  ArcTypeQWK :='ZIP' else
 if (buf[3] = '-') and (buf[4] = 'l') and (buf[5] = 'h') then
   ArcTypeQWK := 'LZH' else
   ArcTypeQWK := 'UNKNOWN';
end;

function UnArcQWKPacket(pathandfilename : string) : boolean;
var
 i,
 arcnum : integer;
 ok     : boolean;
 str    : string;
begin
 Str := ArcTypeQWK(pathandfilename);
   if Str = 'UNKNOWN' then
    Begin
     sprint(#3#8+'Error with ArcType, aborting.');
     delay(1000);
     UnArcQWKPacket := FALSE;
     exit;
    end;
   i := 1;
   while (i < MAXARCS) and (Str <> systat.filearcinfo[i].ext) do
   inc(i);
   if (Str = systat.filearcinfo[i].ext) then
    arcnum := i else
    arcnum := -1;
  if (arcnum = -1) then begin
    sprint(#3#8+
     'Could not find <'+STR+'> arc type on this system, inform sysop!');
     delay(1000);
     UnArcQWKPacket := FALSE;
     exit;
   end;
   arcdecomp(ok,arcnum,pathandfilename,systat.temppath+'2\');
  if (ok) then
   UnArcQWKPacket := TRUE else
   UnArcQWKPacket := FALSE;
end;

const
  MAX_BUFFS = 50;

procedure write_messages_dat(Var MsgHdr   : MsgHdrRecord;
                             Var Brd      : MsgBoardsRecord;
                             var IConf    : IConfRecord;
                                 MsgTxt   : MsgTxtRecord;
                                 Confon   : integer;
                            messagenumber : integer;
                                 fnpath   : string);
  {  append to messages.dat    }
var
  QWKFile   : File of QWKHdrRecord;
  QWKHdr    : QWKHdrRecord;         { msg header SEKK}

  QConfFile : file of QWKConfsRecord;
  qconf     : QWKConfsRecord;

  BufFile   : File;
  Str       : String;

  Buf       : array [1..MAX_BUFFS] of BType; { make link list later.. }
  Step      : TextNodePtr;
  r         : real;
  I,ii,
  BufferSize: integer;
  MS        : MSSingle;

begin
 fillchar(QWKHdr,SizeOf(QWKHdr),#00);

 assign(QWKFile,fnpath+'messages.dat');
{$I-} reset(QWKFile); {$I+}
 if IoResult <> 0 then
   Begin
    rewrite(QWKFile);
    Write(QWKFile,QWKHdr);     {copyright}
   end;

    Str := cstr(MessageNumber);
    i := 0;
    while (I <= 7) do
    begin
     Inc(i);
     if (I > Length(Str)) then
     QWKHdr.QMsg[i]  := #0 else
     QWKHdr.QMsg[i]  := Str[i];
    end;

    Str := Date;
    i := 0;
    while (I <= 8) do
    begin
     Inc(i);
     if (I > Length(Str)) then
     QWKHdr.QDate[i]  := #0 else
     QWKHdr.QDate[i]  := Str[i];
    end;

    str := Copy(time,1,5); { hh:mm }
    i := 0;
    while (I <= 5) do
    begin
     Inc(i);
     if (I > Length(Str)) then
     QWKHdr.QTime[i]  := #0 else
     QWKHdr.QTime[i]  := Str[i];
    end;

    Str := MsgHdr.WhoTo;
    i := 0;
    while (I <= 25) do
    begin
     Inc(i);
     if (I > Length(Str)) then
     QWKHdr.Qto[i]  := #0 else
     QWKHdr.Qto[i]  := Str[i];
    end;

if (UseAlias in Brd.AnonType) or (UserSelect in Brd.AnonType)
              or (DearAbby in Brd.AnonType) then
    Str := MsgHdr.FromAlias else
    Str := MsgHdr.FromReal;
    i := 0;
    while (I <= 25) do
    begin
     Inc(i);
     if (I > Length(Str)) then
     QWKHdr.QFrom[i]  := #0 else
     QWKHdr.QFrom[i]  := Str[i];
    end;


    Str  := MsgHdr.Sub;
    i := 0;
    while (I <= 25) do
    begin
     Inc(i);
     if (I > Length(Str)) then
     QWKHdr.QSubj[i]  := #0 else
     QWKHdr.QSubj[i]  := Str[i];
    end;

    QWKHdr.QPrivate := ' '; { need to add private/recieved checking here }

    Str := #0;
    i := 0;
    while (I <= 12) do
    begin
     Inc(i);
     if (I > Length(Str)) then
     QWKHdr.QPass[i]  := #0 else
     QWKHdr.QPass[i]  := Str[i];
    end;
    Str := #0;
    i := 0;
    while (I <= 12) do
    begin
     Inc(i);
     if (I > Length(Str)) then
     QWKHdr.Qref[i]  := #0 else
     QWKHdr.Qref[i]  := Str[i];
    end;

{ we move the msgtxt stuff to buf 1..128 here }

 BufferSize := 1;
 i := 1;
 Step := FirstLine(MsgTxt.TBuffer);
 While (Step <> Nil) and (buffersize <= MAX_BUFFS) do
 Begin
 str := GetTextLine(MsgTxt.TBuffer,Step);
 str := stripch(#10,str);
 ii := 1;
    while (ii <= length(str)) and (buffersize <= MAX_BUFFS) do
     begin
       { grab text/ convert #13 to pie }
       if str[ii] = #13 then buf[buffersize][i] := '' else
          buf[buffersize][i] := str[ii];
          inc(ii); inc(i);
     if (i > 128) then begin
            inc(buffersize);
            i := 1;
          end;{ i > 128 }
    end; { i < length(str) && bufs < 100 }

  Step := NextLine(MsgTxt.TBuffer,Step);
 End; { while/step }

   if (I < 128) then            { null the rest all the way to 128 }
     for ii := i to 128 do
      buf[buffersize][ii] := #0;

{ end buf move stuff }

    Str := cstr(BufferSize+1);           { Correct! }
        i := 0;
    while (I <= 6) do
    begin
     Inc(i);
     if (I > Length(Str)) then
     QWKHdr.QCount[i]  := #0 else
     QWKHdr.QCount[i]  := Str[i];
    end;

    QWKHdr.QLEastSig := ConfOn;

     Seek(QWKFile,FileSize(QWKFile));
     Write(QWkFile,QWkHdr);

    fillchar(qconf,SizeOf(qconf),#00);
    assign(QConfFile,fnpath+lzeros(IConf[confon].confnum)+'.NDX');
    {$i-} reset(QConfFile); {$i+}
       if IoResult <> 0 then
          rewrite(QConfFile) else
          Seek(QConfFile,filesize(QConfFile));
          r  :=int(filepos(QWKFile));
          real_to_msb (r,qconf.rnum);

          Write (QConfFile,qconf);
          close(QConfFile);


    close(QWKFile);
        { now right the text }
    assign(buffile,fnpath+'messages.dat');
    reset(buffile,1);
    seek(buffile,filesize(buffile));
    BlockWrite(buffile,Buf,Buffersize*128);
    Close(buffile);

end;

Procedure DoBuf(Var Buf : BufferSolidType;
                Var BufSize : longint;
                    StrtoAdd : String);
Var
 W : Integer;

Begin
  W := 0;
  while (W < Length(StrToAdd)) do
 Begin
   Inc(BufSize);
   Inc(W);
   Buf[BufSize] := StrToAdd[W];
 End;
End;

procedure make_control_dat(iconf: iconfrecord;
                           dirpath : string;
                           totalconfs : integer);
var
 t : text;
 i : integer;
 str : string;
Begin
  assign(t,dirpath+'control.dat');
  rewrite(t);
  writeln(t,systat.bbsname);                  { 1 bbs name }
  writeln(t,allcaps(systat.bbsname));         { 2 city state of BBS }
  writeln(t,systat.bbsphone);                 { 3 BBS Phone }
  writeln(t,systat.sysopname);                { 4 SysOpName }
  writeln(t,'0,'+systat.qwkfilename);        { 5 Door Reg and BBS ID }
  str := date+','+copy(time,1,5);
  writeln(t,str);                             { 6 date,time   '01/01/94,08:54'}
  writeln(t,allcaps(thisuser.realname));      { 7 This users name ALLCAPS }
  writeln(t,'');                              { 8 blank not used }
  writeln(t,'0');                             { 9 empty 0 value not used }
  writeln(t,'0');                             { 10 total number of msgs in pkt }
  writeln(t,TotalConfs-1);                    { 11 MAX # of confs  (1..MAX) }
I := 0;
while (i < totalconfs) do                     { double check this later... }
 Begin
   writeln(t,IConf[i+1].confnum);
   writeln(t,IConf[i+1].name);
  inc(i);
 end;

 writeln(t,'HELLO');                          {   usless menus names        }
 writeln(t,'NEWS');                           {                             }
 writeln(t,'GOODBYE');                        {                             }
 writeln(t,'0');                              {          ?                  }
 close(t);
end;

procedure make_door_id(fnpath : string);
var
 t: text;
Begin
 assign(t,fnpath+'door.id');
 rewrite(t);
   writeln(t,softwarename);
   writeln(t,'VERSION = '+ver);
   writeln(t,'SYSTEM = '+softwarename+' '+ver);
   writeln(t,'CONTROLNAME = '+allcaps(softwarename));
   writeln(t,'CONTROLTYPE = ADD');
   writeln(t,'CONTROLTYPE = DROP');
  close(t);
end;










(*              MAIN QWK UPLOAD PROCEDURE               *)
{ *** QWK INFORMATION                                                    }
{ Newly uploaded packets goto temp\2\                                    }
{ Newly created *.QWKS go into temp\2\                                   }
{ MESSAGES.DAT,CONTROL.DAT and other QWK packet files created in temp\3\ }

procedure UploadQWKMail;
var
 s : string;
 done,dok,kabort,addbatch : boolean;
begin
 done := FALSE;
 kabort := false;
 s:= systat.qwkfilename+'.REP';

if (Not kabort) then
  begin
  printf('upqwk');
  if (localioonly) then
      dok := exist(systat.temppath+'2\'+s) else { remote }
      receive1(systat.temppath+'2\'+s,FALSE,dok,kabort,addbatch);
   if (dok) then
   begin
     sprint(#3#4+'Unarchiving packet...please wait.');
     if UnArcQWKPacket(systat.temppath+'2\'+s) then
     begin
     sprint(#3#4+'Tossing QWK packet...please wait...');
      ImportUnPackedQWK(systat.temppath+'2\');
      { clean up }
      purgedir(systat.temppath+'1\');
      purgedir(systat.temppath+'2\');
      purgedir(systat.temppath+'3\');
     sprint(#3#5+'Complete!@M@M');
     end;
    end else    { not dok}
     begin
       sprint(#3#8+'File not received, aborting.');
       delay(1000);
     end;
 end;

end;



(*              MAIN DOWNLOAD QWK PROCEDURE             *)

procedure DownloadQWKMail;
var
 MsgHdr   : MsgHdrRecord;
 MsgTxt   : MsgTxtRecord;

 L        : LastPtrRecord;
 IConf    : IConfRecord; { internally used confs records }

 OnMessage,
 i           : longint;
 ii,
 TotalConfs  : Integer;     { total areas packed            }

 GOTQWK,
 abort,
 next,
 NoSpace,
 Ok,dok,
 kabort      : boolean;
 SavedBoard,
 BoardToScan : word;
 Str         : String;

begin
  printf('downqwk');
  sprompt(#3#7+'Making QWK packet...please wait...');nl;

 SavedBoard := Board;
 ok     := true;
 dok    := true;
 kabort := false;
 abort := false;
 GOTQWK := FALSE;
 BoardToScan := 1;
 i := Load_LastPtr(ThisUser,BoardToScan,L); {* load qwk selected boards }

 TotalConfs  := 0;
 ii := 0;
 i := 1;
 Actualloadmsgboard(brd,i,true);
 repeat                 { build internal conf list }
 if (l.scan[i]) and (MsgBaseAc(Brd,i)) then
  begin
   inc(ii);
   ActualloadMsgBoard(brd,i,TRUE);
   Inc(TotalConfs);
   if (Echobase in Brd.MsgBaseType) and (brd.tagname <>'') then
    IConf[totalconfs].name      := Brd.Tagname else { conferance name    }
    IConf[totalconfs].name      := Brd.filename;    { conferance name    }
   IConf[totalconfs].actualbrd := i;                { actualbrd num      }
   IConf[totalconfs].confnum   := ii;               { conferance number  }
  end;
  inc(i)
 until (i > maxboards);


 ii := 0;
 while (ii < TotalConfs) and (not abort) do
 Begin
  inc(ii);
  I := Load_LastRead(ThisUser,IConf[ii].actualbrd);

  { we checked acs above }
  ActualLoadMsgBoard(Brd,iconf[ii].actualbrd,TRUE);
  sprint(#3#5+'Scanning '+brd.name);
  sprompt(fstring.newscan1);
  if (i < 0) then
     i := 1;
     Inc(I);

  If (I >= Brd.TotalMsgs) then
     sprint(#3#9+'No UnScanned Mail! ')
     else
  Begin
    sprint(#3#9+'Exporting mail in '+#3#5+brd.name);
    GOTQWK := true;
    OnMessage := 1;                              { counter            }
   repeat
   if GetMsgHdr(MsgHdr,Brd,OnMessage,False) then
     begin
      NewBuffer(MsgTxt.TBuffer); { Make heap space }
      if GetMsgtxt(MsgHdr,MsgTxt,Brd) then
    Begin
     if (not GOTQWK) then GOTQWK := true;
     write_messages_dat(
           MsgHdr,Brd,IConf,MsgTxt,ii,OnMessage,systat.temppath+'3\');
     DeleteBuffer(MsgTxt.TBuffer);     { Clear Heap }
     end; { got txt }
   end; { got hdr }

    Inc(OnMessage);
   wkey(abort,next);
   until (OnMessage > Brd.TotalMsgs) or (abort);
  END; { we have new mail in this base }
 if not (abort) then
   sprompt(fstring.newscan2);
 End; {while ii <= totalconfs }


 if (GOTQWK) and (not abort) then
  Begin
   make_control_dat(iconf,systat.temppath+'3\',totalconfs);
   make_door_id(systat.temppath+'3\');

   nl;
   while (not systat.filearcinfo[thisuser.arctype].active) and
         (not hangup) do select_qwkarctype;

   sprompt(#3#4+'Archiving your packet... please wait...USING '
          +#3#0+systat.filearcinfo[thisuser.arctype].ext);

  arccomp(ok,thisuser.arctype,
          systat.temppath+'2\'+systat.qwkfilename+'.QWK',
          systat.temppath+'3\'+'*.*');
  nl;
 if (not ok) then
    sprompt(#3#5+'Error archiving QWK files, contact the '+#3#8+'sysop.');

 if (not localioonly) and (ok) then
      send1(systat.temppath+'2\'+systat.qwkfilename+'.QWK',dok,kabort);
  nl;
  if (dok) and (ok) then
   if (pynq('Update last read pointers now? [y/N] ')) then
   begin
    BoardToScan := 1;
    while (BoardToScan <= MaxBoards) do
    Begin
    i := Load_LastPtr(ThisUser,BoardToScan,L); {* load qwk selected boards }
    if ((L.Scan[BoardTOScan])) then            { * if we scan this one then }
      begin
       ActualLoadMsgBoard(Brd,BoardToScan,TRUE);
       Save_LastRead(BoardToScan,Brd.TotalMsgs,ThisUser,UserNum);
       LoadURec(ThisUser,UserNum);
      end;
     inc(BoardToScan);
   end;
  end; { we updated pointers }

       { clean up }
      purgedir(systat.temppath+'1\');
     if (not localioonly) then           { leave this for sysop }
        purgedir(systat.temppath+'2\') else
        begin
        sprompt(#3#5+'Moving local download to '+systat.temppath+'@M');
         movefile(dok,nospace,TRUE,
          systat.temppath+'2\'+systat.qwkfilename+'.QWK',
          systat.temppath+systat.qwkfilename+'.QWK');
        if nospace then
          sprompt(#3#0+'No space to move your packet to temp dir.@M');
        if not dok then
          sprompt(#3#0+'Error occured while trying to move your packet.@M');
       if not nospace and dok then
         purgedir(systat.temppath+'2\');
        end;
      purgedir(systat.temppath+'3\');

 end else
 if (not GOTQWK) then { no new QWK mail }
    sprompt('@M@M'+#3#9+'No new QWK mail!') else
    begin                   { they aborted }
      purgedir(systat.temppath+'1\');
      purgedir(systat.temppath+'2\');
      purgedir(systat.temppath+'3\');
    end;


   nl;
  sprompt(#3#5+'Complete!@M@M');

  ActualLoadMsgBoard(Brd,SavedBoard,TRUE); { load the board they where last in }
end;

End.        { END OF UNIT }


