
{ Exports BBS msgs to fidonet }


{$A+,B+,D-,E+,F+,I+,L-,N-,O+,R-,S+,V-}

Unit Msg4;

Interface

Uses
   OverLay,Dos,Common, Msg1,TxtMsg;

Const
    MsgSize = 32768;
    MaxBuf  = 16384; {Maximum Buffer Size}
   { Errorlevel to Exit with... in import PKT's and *.MSG's}
     NoEL     = 0;        { No error                   }
     ErrorEL  = 1;        { error                      }
     UnScanEL = 2;        { Unscanned mail             }
     NEWLINE = #13;

Var
  ExitErrorLevel : byte;

Type
 Str36 = Array [1..36] of Char;
 Str72 = Array [1..72] of Char;
 Str20 = Array [1..20] Of Char;

 PtrType = ^RecType;
 RecType = array[1..20000] of Char;
  BufferType = PtrType;

  BufferSolidType = Array [1..20000] of Char;

type

  FidoMsgAttrib = (FPrivate,FCrashMail,FRcvd,FSent,FFAttach,FTransit,FOrphan,
                   FKillSent,FLocal,FHoldMail,FUnused,FFileRequest,
                   FReturnReceiptRequest,FIsReturnReceipt,FAuditRequest,
                   FFileUpdateReq);

  FidoAttribSet  = Set of FidoMsgAttrib;

  MsgHeaderType =    record
                       HFromUserName : Str36;
                       HToUserName   : Str36;
                       HSubject      : Str72;
                       HDateTime     : Str20;
                       HTimesRead    : word;
                       HDestNode     : word;
                       HOrigNode     : word;
                       HCost         : word;
                       HOrigNet      : word;
                       HDestNet      : word;
                       HFiller       : array[1..8] of char;
                       HReplyto      : word;
                       HAttribute    : FidoAttribSet;
                       HNextReply    : word;
                      end;


Type

  PktMsgHdrTypes = (PKtPrivate,PktCrash,PktRecieved,PktSent,PktFileAttach,
                    PktForward,PktOrphan,PktKillSent,PktLocal,PktHold,
                    PktFreq,pk12,pk13,pk14,pk15,pk16);

       PktHeader =        { Packet header-- appears only once at the top of }
       Record             { each packet. This program reads it and discards }
           OrigNode,      { the information since it does not serve this    }
           DestNode,      { example's purpose.                              }
           Year,
           Month,
           Day,
           Hour,
           Minute,
           Second,
           Baud,
           ID,
           OrigNet,
           DestNet      : Word;
           ProductCode  : Byte;
           Fill         : Array[1..33] of Byte;
       End;


       MsgHeader =        { Message header-- this appeas at the top of each }
       Record             { packetized message within the packet. This part }
           ID,            { is fixed in it's length... the 5 fields that    }
           OrigNode,      { follow it are of dynamic length and are null    }
           DestNode,      { terminated.                                     }
           OrigNet,
           DestNet,
           Attributes   : Set of PktMsgHdrTypes;
           Cost         : Word;
       End;

       MsgInfo =          { For reference use, not a literal struct         }
       Record
           DateTime     : String[20];
           To_Name,
           From_Name    : String[36];
           Subject      : String[72];
           Area         : String[25];
       End;

       HeapBufPtr       = ^HeapBuf;    { Used for temporary buffer storage }
       HeapBuf          = Array[1..MaxBuf] of Char;






procedure WriteFidoMsg(MsgHdr      : MsgHdrRecord;
                       MsgTxt      : MsgTxtRecord;
                       Brd         : MsgBoardsRecord;
                       BoardNumber : Word;
                       Bad_Msgs    : Boolean;
                       AreaName    : String);

Procedure ImportFidoMsgs(Brd : MsgBoardsRecord);

Procedure ImportPkt2BBS(BrdBuf : BrdBufType; BufCount : Word);


Implementation

Uses Date_Tim,OpString,OpCrt,APMisc;



function TotalyRandomNumber : String;
Begin
 TotalyRandomNumber := Cstrl(PackedDateTimeNow);
End;



procedure WriteFidoMsg(MsgHdr      : MsgHdrRecord;
                       MsgTxt      : MsgTxtRecord;
                       Brd         : MsgBoardsRecord;
                       BoardNumber : Word;
                       Bad_Msgs    : Boolean; { bad msgs? }
                       AreaName    : String); { if bad what area? }

Var
 Return : Word;
 I,ii,
 iii : integer;
 DateStr, TimeStr,
 Str , ThisDateTime : String;
 MsgFile    : File;
 MsgHead    : MsgHeaderType;
 Buf        : BufferType;

Procedure DoBuf(Var Buf : BufferType; StrtoAdd : String);
Var
 W : Integer;

Begin
  W := 0;
  while (W < Length(StrToAdd)) do
 Begin
   Inc(ii);
   Inc(W);
   Buf^[ii] := StrToAdd[W];
 End;
End;

Var
 Step : TextNodePtr;
 MsgPath : String;

Begin
   if (Bad_Msgs) then
      MsgPath := Systat.NetMailPath else
      MsgPath := Brd.Path;
  with MsgHead do
  begin

    i := 0;
    While (I <= 36)  do
    begin
      Inc(i);
      If (I > Length(MsgHdr.FromAlias))
         then HFromUserName[i] := #0 else
         HFromUserName[i] := MsgHdr.FromAlias[i];
    end;

    i := 0;
    while (I <= 36) do
    begin
     Inc(i);
     if (I > Length(MsgHdr.WhoTo)) then
     HToUserName[i] := #0 else
     HToUserName[i]:= MsgHdr.WhoTo[i];
    end;


    i := 0;
    while (I <= 72) do
    begin
    inc(i);
    if (I > Length(MsgHdr.Sub)) then
     HSubject[i] := #0 else
     HSubject[i] := MsgHdr.Sub[i];
    end;

    TimeStr := UnPackMYTime(MsgHdr.Date_Time);
    DateStr := UnPackMyDate(MsgHdr.Date_Time);
    ThisDateTime := DateStr +' '+TimeStr;

    I := 0;
    while (I < 20) do
    begin
      Inc(i);
       if (I >  Length(ThisDateTime)) then
       HDateTime[i] := #0 else
       HDateTime[i] := ThisDateTime[i];
    end;

     if (Not Bad_Msgs) then
     begin
       HdestNode := 0;
       HDestNet  := 0;
     End else
     Begin
      HDestNet  :=   Systat.Addr[1].Net;
      HDestNode :=   Systat.Addr[1].Node;
     End;


       HOrigNode := Systat.Addr[Brd.AKA].Node;
       HOrigNet  := Systat.Addr[Brd.AKA].Net;

   for I := 1 to 8 do
       HFiller[i] := ' ';
   HNextReply := 0;
   HCost      := 0;
   HTimesRead := 0;
   HAttribute := [FLocal];
   if (Bad_Msgs) then
       HAttribute := HAttribute+[FSent];
 End;

  I := 2;
  while (Exist(MsgPath+Cstr(i)+'.Msg') AND (I <= 32500)) do
         Inc(i);
  assign(MsgFile,MsgPath+Cstr(i)+'.MSG');
  rewrite(MsgFile,1);

  BlockWrite(MsgFile,MsgHead,Sizeof(MsgHead),Return);

 II := 0;
 iii := 0;
 New(Buf);
  if not (Bad_Msgs) then
    Begin
      if (Systat.Addr[Brd.Aka].Zone <> 0) then
   DoBuf(Buf,'MSGID: '+GetAddress(Systat.Addr[Brd.Aka].Zone,
                                   Systat.Addr[Brd.Aka].Net,
                                   Systat.Addr[Brd.Aka].Node,
                                   Systat.Addr[Brd.Aka].Point)+
                                   Systat.Addr[Brd.Aka].Domain+
                                   ' '+HexL(PackedDateTimeNow)+NEWLINE) else

   DoBuf(Buf,'MSGID: '+GetAddress(Systat.Addr[1].Zone,
                                   Systat.Addr[1].Net,
                                   Systat.Addr[1].Node,
                                   Systat.Addr[1].Point)+
                                   Systat.Addr[1].Domain+
                                   ' '+HexL(PackedDateTimeNow)+NEWLINE);

   DoBuf(Buf,'PID: MMail '+Ver+NEWLINE);
  End else
      DoBuf(Buf,AreaName+NEWLINE);

 Step := FirstLine(MsgTxt.TBuffer);
  While (Step <> Nil) do
  Begin
     DoBuf(Buf,
           StripCH(#10,StripColor(GetTextLine(MsgTxt.TBuffer,Step))));
    Step := NextLine(MsgTxt.TBuffer,Step);
  End; {While}

   BlockWrite(MsgFile,Buf^,ii,Return);
  Dispose(Buf);
 Close(MsgFile);

 if (Not Bad_Msgs) then
  Begin
   MsgHdr.Msgtype := MsgHdr.MsgType+[Sent];
   Save_HdrFile(MsgHdr,MsgHdr.Reply[ThisRec]);
  End;
End;


procedure LoadMsg(Var MsgHead : MsgHeaderType;
                  MsgFilePath : String;
                  Var Buf     : BufferSolidType;
                  var Result  : integer);

var
  i : word;
  ReadResult : word;
  MsgFile : file;

begin
  assign(MsgFile,MsgFilePath);
  reset(MsgFile,1);
  Result := IoResult;
  if result<>0 then exit;

  fillchar(MsgHead,SizeOf(MsgHead),#00);
  fillchar(Buf,SizeOf(Buf),#00);

  BlockRead(MsgFile,MsgHead,Sizeof(MsgHead));           {Read Header Info}
  BlockRead(MsgFile,Buf,SizeOf(Buf),ReadResult);
   close(MsgFile);
   Erase(MsgFile);

  while exist(MsgFilePath) do
  Begin
   writeln('.');
   assign(MsgFile,MsgFilePath);
   reset(MsgFile,1);
   close(MsgFile);
   erase(MsgFile);
  End;


  Result := ReadResult;
end;

Procedure ImportFidoMsgs(Brd : MsgBoardsRecord);

var
    OmitedLine,
    First          : Boolean;
    CurLine,Z,i    : Integer;     { CurentLine line count , and temp integers }
    Foo            : integer;     { Size Of Buffer! }
    Step           : TextNodePtr;
    Str,Str2       : string;      { Temp Vars }
    MSG            : MsgHeaderType;
    MsgHdr         : MsgHdrRecord;
    MsgTxt         : MsgTxtRecord;
    SearchThis     : searchrec;   { Search REc }
    Buf	           :  BufferSolidType; { Msg TXT Buffer }

 Var
  MsgPath : String;

begin
     First := TRUE;
     MsgPath := Brd.Path;
     findfirst(MsgPath+'*.MSG',Anyfile,SearchThis);
   while (DosError=0) do
    Begin
  if  (AllCaps(SearchThis.Name) = '1.MSG') then
        findnext(SearchThis)  else
   Begin
   LoadMsg(Msg,MsgPath+SearchThis.Name,Buf,Foo);   { Load it }
        With Msg do
         Begin
          if (First) then
         Begin
           First := False; writeln;
          End;
sprint(#3#5+'Message Number '+#3#9+MsgPath+SearchThis.Name);
          MsgHdr.FromReal  := StripCh(#0,TrimSpaces(HFromUserName));
          MsgHdr.FromAlias := StripCh(#0,TrimSpaces(HFromUserName));
          MsgHdr.WhoTo     := StripCh(#0,TrimSpaces(HToUserName));
          MsgHdr.Sub       := StripCh(#0,TrimSpaces(HSubject));
         If (EchoBase in Brd.MsgBaseType) then
             MsgHdr.MsgType   :=[EchoMail,Sent,Public,Validated];

  i := Foo;
  while Not (Buf[i] in [#26..#140]) do
  Begin                             { remove extra space on end... }
    Dec(foo);
    Dec(i);
  End;

  CurLine := 1;
  I := 0;
  NewBuffer(MsgTxt.TBuffer); { Make heap space }
 while I < Foo do
  Begin
   Inc(i);
    Str2 := Str2 + Buf[i];
     if (Length(Str2) >=254) or (I >= Foo) then
      Begin
       Str := Str2;
       AddToEnd(MsgTxt.TBuffer,Str);
       Inc(CurLine);
       Str2 := '';  Str  := '';
      End;
 End;

       MsgTxt.TotalLines := CurLine-1;
       WriteNewMsg(MsgHdr,MsgTxt,Brd,FALSE,0,MsgHdr,TRUE);
       DeleteBuffer(MsgTxt.TBuffer);     { Clear Heap }
      findnext(SearchThis);
     End;
    End;
   End;
End;


Procedure ImportPkt2BBS(BrdBuf : BrdBufType; BufCount : Word);
Var
    PHead    : PktHeader;
    MHead    : MsgHeader;
    MInfo    : MsgInfo;
    PktFile  : File;
    NumRead  : Word;
    MsgCount : Word;
    TextBuf  : Array[1..MaxBuf] Of Char;
    BufSize  : Word;
    OK       : Boolean;


Function ReadToFrom : Boolean;
          {-Parses out and reads the dynamic length fields of each message }
Var C : Char;
Begin

  FillChar(MInfo,SizeOf(MInfo),#0);

  BlockRead(PktFile,C,1,NumRead);
  While C <> #0 DO
  Begin
    MInfo.DateTime := Concat(MInfo.DateTime,C); { Grabs date time }
    BlockRead(PktFile,C,1,NumRead);
  End;

  BlockRead(PktFile,C,1,NumRead);
  While C <> #0 DO
  Begin
    MInfo.To_Name := Concat(MInfo.To_Name,C);   { Grabs To Name }
    BlockRead(PktFile,C,1,NumRead);
  End;

  BlockRead(PktFile,C,1,NumRead);
  While C <> #0 DO
  Begin
    MInfo.From_Name := Concat(MInfo.From_Name,C);   { Grabs from Name }
    BlockRead(PktFile,C,1,NumRead);
  End;

  BlockRead(PktFile,C,1,NumRead);
  While C <> #0 DO
  Begin
    MInfo.Subject := Concat(MInfo.Subject,C);     { Grabs Subject }
    BlockRead(PktFile,C,1,NumRead);
  End;

  BlockRead(PktFile,C,1,NumRead);
  While C <> #13 DO
  Begin
    MInfo.Area := Concat(MInfo.Area,C);           { Grabs msg area name }
    BlockRead(PktFile,C,1,NumRead);
  End;
   ReadToFrom := ((NumRead = 1));  { Report success }
End;


Function Reposition : Boolean;
  {-Positions file pointer to start of next packetized message }
Var C : Char;
Begin
  C := #0;

  While C <> #2 DO
  Begin
    BlockRead(PktFile,C,1,NumRead);
    IF NumRead = 0 Then C := #2;
  End;

  IF NumRead <> 0 Then
    Seek(PktFile,FilePos(PktFile)-1); {Back up one spot}

  Reposition := NumRead = 1;

End;

Function ReadBodyText : Boolean;
  {-Simply reads the text of the message after the header has been read }
Var C : Char;
Begin

  FillChar(TextBuf,SizeOf(TextBuf),#0);
  BufSize := 0;

  BlockRead(PktFile,C,1,NumRead);
  While C <> #0 DO
  Begin
    Inc(BufSize);
    TextBuf[BufSize] := C;
    BlockRead(PktFile,C,1,NumRead);
  End;

    { Report back success of all child process thus far... }
  IF NumRead = 0 Then ReadBodyText := False ELSE
    ReadBodyText := Reposition;

End;

Var
 MsgHdr : MsgHdrRecord;
 MsgTxt : MsgTxtRecord;
 D      : DownLinkRecord;
 I      : longint;
 LineCount,
 ii     : Word;
 PktPath,
 Str    : String;
 AlReadySent,
 Done,
 First  : Boolean;
 SearchThis     : searchrec;   { Search REc }

Begin  { Main Body }
  First := TRUE;
  PktPath:= Systat.NetFilePath;

  findfirst(PktPath+'*.PKT',Anyfile,SearchThis);
     while (DosError=0) do
 Begin
 if (First) then
     Begin
           First := False; writeln;
      End;

   FillChar(PHead,SizeOf(PHead),#0); { Initialize the structs }
   FillChar(MHead,SizeOf(MHead),#0);
   Assign(PktFile,PktPath+SearchThis.Name); { prepare to read the packet }
   Reset(PktFile,1);
  IF IOResult <> 0 Then
   Begin
    writeln('PKTFile not found,',PktPath+SearchThis.Name);
    writeln(IoResult);
    delay(2000);
   End;

  { Read in header... we discard it here and don't do anything with it. }
  BlockRead(PktFile,PHead,SizeOf(PHead),NumRead);
  IF NumRead <> SizeOf(PHead) Then
  Begin
   writeln('PKTHeader in filename ',PktPath+SearchThis.Name,' was corrupted!');
   delay(2000);
   Ok := FALSE;
  End else
   OK := True;

   if (Ok) then begin
    sprint(#3#5+'Processing packet '+PktPath+SearchThis.name);
    sprint(#3#5+'From '+Cstr(PHead.OrigNet)+'/'+Cstr(Phead.OrigNode));
   end;

   MsgCount := 0;

  While OK DO   { While more packets to read, do this... }
Begin
     Inc(MsgCount);

   II := 1;
      BlockRead(PktFile,MHead,SizeOf(MHead),NumRead);
      IF NumRead <> SizeOf(MHead) Then Halt(255);
      OK := ReadToFrom;
     Done := False;
     II := 1;
    while (Not Done) and (ii < BufCount) do
    begin
    if StripCh(' ',AllCaps(MInfo.Area)) =
       StripCh(' ','AREA:'+BrdBuf[ii].Bname) then
      Begin
        ii := BrdBuf[ii].BNumber;
        Done := TRUE;
        ActualLoadMsgBoard(Brd,ii,TRUE);
      End else
       Inc(ii);
    End;

  IF (OK) Then
      Begin
       OK := ReadBodyText;
        NewBuffer(MsgTxt.TBuffer); { Make heap space }
        I := 0;
        LineCount := 1;
   while I < BufSize do
 Begin
      Inc(i);
       Str := Str + TextBuf[i];
     if (Length(Str) >=254) or (I >= BufSize) then
   Begin
     AddToEnd(MsgTxt.TBuffer,Str);
     Inc(LineCount);
     Str  := '';
    End;
  End;
  with MsgHdr do
  Begin
   Date_Time := PackedDateTimeNow;
   Whoto     := TrimSpaces(MInfo.To_Name);
   FromReal  := TrimSpaces(MInfo.From_Name);
   FromAlias := TrimSpaces(MInfo.From_Name);
   SUB       := TrimSpaces(MInfo.Subject);
  If (EchoBase in Brd.MsgBaseType) then
      MsgType   :=[EchoMail,Sent,Public];
  End; { DO }
      MsgTxt.TotalLines := LineCount-1;

  if (Done) then
     Begin
      sprint(#3#9+'Importing into '+#3#5+MInfo.Area);
   if  Load_DownLinks(D,Brd) then
     Begin
       if (D.Addr[1].Zone <> 0) then
        Begin
           AlReadySent := False;
         I := 1;
         While (D.Addr[i].Zone <> 0) and (Not AlreadySent) do
           Begin       { So we don't dup it out to our HUB!!! }
             If (D.Addr[i].Net  = PHead.OrigNet) AND
                (D.Addr[i].Node = PHead.OrigNode)
                         then AlreadySent := TRUE;
             Inc(i);
           End;

          if (Not AlreadySent) then
          Begin
            ExitErrorLevel := UnScanEL;
            MsgHdr.MsgType :=[Validated]
          end else
         MsgHdr.MsgType :=[Validated,Sent];
     End else
         MsgHdr.MsgType :=[Validated,Sent];
     End else
         MsgHdr.MsgType :=[Validated,Sent];

      WriteNewMsg(MsgHdr,MsgTxt,Brd,FALSE,0,MsgHdr,TRUE);
      DeleteBuffer(MsgTxt.TBuffer);     { Clear Heap }
     End else
     Begin
        Sprint(#3#5+MInfo.Area+#3#9+' not found!');
        WriteFidoMsg(MsgHdr,MsgTxt,Brd,II,TRUE,MInfo.Area);
        DeleteBuffer(MsgTxt.TBuffer);     { Clear Heap }
     End;
    End;  { if OK }
  if (Not OK) then
     Begin
      Close(PktFile);
      Erase(PktFile);
    End;
   End;
    FindNext(SearchThis);
  End;   { While }
End;


End.   { END OF UNIT }
