{  MMAIL message base packing/Fidonet importing routines   }
{  Written by Mike Wilson on 5/5/1992`                     }
{ ******************************************************** }
{  /1 to go into debug mode                                }
{  /I to Import *.MSG into BBS                             }
{  /P to pack                                              }
{  /M to Mark Deleted using MSgBrds.DAT settings           }
{  /E to Export Echo/Netmail messages                      }
{  /U to use ECHOMAIL.EXP list                             }
{  /D to delete exported (ALL) *.MSG files except 1.msg    }
{  /A to make areas.lst                                    }
{  /X to import PKT files into BBS                         }
{  /F to FORCE all msgbases PACK!                          }
{  /Q to recreate GMAIL.DAT                                }

{$A+,B+,D-,E+,F+,I+,L-,N-,O-,R-,S+,V-}
{$M 65000,0,65000}      { Memory Allocation Sizes }

Uses
    Dos,OPCrt,Common,MyIo,
    Msg1,Msg2,Msg3,Msg4,OpString,
    Date_tim,FVType2,StartUp1,TxtMsg;


Var
 DebugMode,
 UseExportList,
 ForceAllPack   : Boolean;

Procedure Make_ProcessBase(brd : MsgBoardsREcord);
Var t: text;
Begin
 if (Not Exist(brd.path+brd.filename+'.@@@')) then
 Begin
  assign(t,brd.path+brd.filename+'.@@@');
  rewrite(t);
  Close(T);
                { SetFattr(T,Dos.Hidden);}
 End;
End;

Procedure Toggle(Str : String; Var MsgHdr : MsgHdrRecord);
Var
 XRecv,
 XSent,
 XDelete : Boolean;

Begin
  XRecv   := Pos(Str,'RECV') <> 0;
  XSent   := Pos(Str,'SENT') <> 0;
  XDelete := Pos(Str,'DELE') <> 0;

   If XRecv then
     if (Recieved in Msghdr.MsgType) then
         MsgHdr.MsgType := MsgHdr.Msgtype-[Recieved] else
         MsgHdr.MsgType := MsgHdr.Msgtype+[Recieved];

   If XSent then
      if (Sent in Msghdr.MsgType) then
             MsgHdr.MsgType := MsgHdr.Msgtype-[Sent] else
             MsgHdr.MsgType := MsgHdr.Msgtype+[Sent];

   If XDelete then
       if (MsgDeleted in Msghdr.MsgType) then
           MsgHdr.MsgType := MsgHdr.Msgtype-[MsgDeleted] else
           MsgHdr.MsgType := MsgHdr.Msgtype+[MsgDeleted];
End;

Procedure DeleteGfile;
Var Gfile : File;
Begin
 assign(Gfile,systat.msgpath+'GMAIL.DAT');
 {$I-} reset(Gfile); {$I+}
  if (Ioresult = 0) then
     Begin close(Gfile); Erase(Gfile); End;
End;

Procedure MarkDeleted;
Var
 L,MyMsgToGet       : Longint;
 W                  : word;
 Hdr     : MsgHdrRecord; { Old Hdr }
 BoardNameStr,
 Str                  : String;
 NumberToDel          : Integer;

Begin
 nl;
 sprint(#3#7+'Marking messages deleted...');
 nl;
 DeleteGfile;
 for w := 1 to MaxBoards do
  Begin
     ActualLoadMsgBoard(Brd,W,TRUE);
     BoardNameStr := #3#4+'Processing Base '+Brd.Name;
     sprompt(BoardNameStr);

     MyMsgToGet := Brd.FirstMsg;
    If (Brd.TotalMsgs >= Brd.MaxMessages) then
       NumberTodel := (Brd.TotalMsgs-(Brd.MaxMessages+1)) else
       NumberTodel := 0;
 if (DebugMode) then
    writeln(' -> Over the msgbase limit by ',NumberToDel);

  If (Brd.TotalMsgs > 10) then
    repeat
     if GetMsgHdr(Hdr,Brd,MyMsgToGet,TRUE) then
        Begin
if (Not (MsgDeleted in Hdr.MsgType)) and (NOT (PermMessage in Hdr.MsgType))
   then Begin
  if (Brd.KillRecieved) and (Recieved in Hdr.MsgType) then
            begin
              Make_ProcessBase(brd);
              Toggle('DELE',Hdr);
              Save_HdrFile(Hdr,MyMsgToGet);
             End else    { delete recieved msgs}
   if (NumberToDel > 0) then
        Begin
          Toggle('DELE',Hdr);
          Make_ProcessBase(brd);
          dec(NumberToDel);    { decrease number to delete (over limit) }
          Save_HdrFile(Hdr,MyMsgToGet);
        End else

        Begin
         l   := Hdr.Date_Time;
         Str := UnPackMyDate(l);     { check dates if overlimit delete }
    If (Since_Date(Str,DateNowMail,2) >= Brd.OldMail) then
              Begin
               Make_ProcessBase(brd);
               Toggle('DELE',Hdr);
               Save_HdrFile(Hdr,MyMsgToGet);
              End else
              Write_GMail(W,MyMsgToGet,Hdr.Whoto,Hdr.Sub)
          End;
    end else                      { Didn't get Hdr! }
  End;                            { Had Deleted in MsgHdr already..}
      Inc(MyMsgTOGet);
    Until (MyMsgToGet > Brd.TotalMsgs-1);
    BackUp(Length(BoardNameStr));

 End; { For }


End;



Procedure ReIndexQuickIDX;
Var
 MyMsgToGet       : Longint;
 W                : word;
 Hdr     : MsgHdrRecord; { Old Hdr }
 BoardNameStr,
 Str                  : String;

Begin
 nl;
 sprint(#3#7+'Reindexing the GMail IDX...');
 nl;
 DeleteGFile;

 for w := 1 to MaxBoards do
  Begin
     ActualLoadMsgBoard(Brd,W,TRUE);
     Board := W;
     BoardNameStr := #3#4+'Processing Base '+Brd.Name;
     sprompt(BoardNameStr);
     MyMsgToGet := Brd.FirstMsg;

  If (Brd.TotalMsgs > 1) then
    repeat
     if GetMsgHdr(Hdr,Brd,MyMsgToGet,TRUE) then
   Begin
    if Not (MsgDeleted in Hdr.MsgType) then
      Begin
        Write_GMail(W,MyMsgToGet,Hdr.Whoto,Hdr.Sub)
      End;
    end;                     { Didn't get Hdr! }

      Inc(MyMsgTOGet);
    Until (MyMsgToGet > Brd.TotalMsgs-1);
    BackUp(Length(BoardNameStr));
 End; { For }
End;


Procedure  AdjustLastReadPtrs(MsgNumDel: LongInt;
                                         Brd : MsgBoardsRecord;
                                         Oldtotal,
                                         NewTotal : longint);
var
 f    : file of LastReadRecord;
 Last : LastReadRecord;
 LoopCount,I    : Longint;
Begin
 assign(f,Brd.path+Brd.FileName+'.LRP');
 {$I-} reset(f); {$I+}
  if (IoResult = 0) then
  Begin
    Loopcount := filesize(f)-1;
    for I := 0 to LoopCount do
    Begin
     seek(f,i); read(f,Last);
      if (Last.LastMsg-MsgNumDel < 0) then
      begin
     if (debugmode) then
     sprint(#3#5+'Setting last read on record '+cstr(i)+' to -1 (none read).');
          Last.LastMsg := -1
      end else
   if (Last.LastMsg >= OldTotal) then
      begin
    if (debugmode) then
     sprint(#3#5+'Setting last read on record '+cstr(i)+' to LastMsg (ALL read).');
       last.lastmsg := NewTotal;
      end else
       begin
      if (Last.LastMsg-MsgNumDel) >= OldTotal then
          Last.LastMsg := NewTotal else
          Last.LastMsg :=(Last.LastMsg-MsgNumDel);
if (debugmode) then begin
sprint(#3#5+'Setting last read on record '+cstr(i)+' to '+
               cstr(Last.LastMsg)+'(thier last message read).');
writeln('Oldtotal:',oldtotal,' Newtotal:',newtotal,' MsgNumToDel:',MsgNumDel);
               end;
       end;

     seek(f,i); write(f,last);
     End;
   Close(f);
  End;
End;


Procedure ChangeFileNames(Brd : MsgBoardsRecord);
Var
 MsgNum1,
 MsgNum2,
 MsgNumDel  : Longint;
 I         : integer;
 hdrfile   : file of MsgHdrRecord;
 f         : file;
 Fn,fn2    : String;

Begin
 if (DebugMode) then
     writeln(brd.path+brd.filename);
 If (Brd.TotalMsgs-1 <= 1) then
   Begin
    Fn := Brd.Path+Brd.FileName+'.HDR';
    Fn2 :=Brd.Path+Brd.FileName+'.TXT';
    assign(f,fn);    rewrite(f);    close(f);    erase(f);
    assign(f,fn2);   rewrite(f);    close(f);    erase(f);
    assign(f,Brd.Path+brd.FileName+'.LRP');
    rewrite(f);    close(f);    erase(f);
    MsgNumDel := 0;
 End else
 Begin
  Fn := Brd.Path+Brd.FileName+'.HD2';
  fn2 :=Brd.Path+Brd.FileName+'.HDR';
  if Exist(fn2) and exist(fn) then
    Begin
         assign(hdrfile,fn2);
         reset(hdrfile);
         msgnum1 := filesize(hdrfile);  { old size }
         close(hdrfile);
         erase(hdrfile);

         assign(hdrfile,fn);
         reset(hdrfile);
         Msgnum2 := FileSize(hdrfile);  { new size }
       close(hdrfile);
       rename(hdrfile,brd.path+brd.filename+'.HDR');

    MsgNumDel := MsgNum1 - MsgNum2 ;          { old - new = difference }
    if (MsgNumDel < 0)
       then MsgNumDel := 0;
       AdjustLastReadPtrs(MsgNumDel,Brd,MsgNum1,MsgNum2);
    End;

  FN := Brd.Path+Brd.FileName+'.TX2';
  Fn2 :=Brd.Path+Brd.FileName+'.TXT';
  if Exist(fn2) and exist(fn) then
    Begin
         assign(f,fn2);
         reset(f);
         close(f);
         erase(f);
    end;
  If Exist(fn) then
     Begin
      assign(f,fn);
      reset(f);
     close(f);
      rename(f,brd.path+brd.filename+'.TXT');
     End;
  End;  { If Tot <= 0 }

    assign(f,brd.path+brd.filename+'.@@@');
    rewrite(f);  close(f);   erase(f);

{ End; FOR }

End;



Procedure PackBases;

Type
  TxtRecord = Record
     Txt : String[255];
End;

Var
 MsgHdrFile  : File of MsgHdrRecord;
 Hdr         : MsgHdrRecord;       { Old Hdr }
 MsgTxtFile  : File of TxtRecord;  { old     }
 MsgTxtFile2 : File of TxtRecord;  { new     }
 Txt         : TxtRecord;          { OldText }
 Txt2        : TxtRecord;          { NewTxt  }

 SeekPlace,
 L,
 MsgCount,
 tMsg        : LongInt;
 RecordsRead : Word;
 I           : Integer;
 Str         : String;

Begin
  nl;nl;
  For I := 1 to MaxBoards do
 Begin
  MsgCount := 0;
  ActualLoadMsgBoard(Brd,i,TRUE);
  Str:= #3#0+'Updating  =>'+#3#5+Brd.Name;
  sprompt(Str);
  Tmsg := Brd.TotalMsgs;
  MsgCount := 0;

 If ((TMsg -1 >= 1) and (Exist(Brd.Path+Brd.FileName+'.@@@'))) or
    ((TMsg -1 >= 1) and (ForceAllPack)) then
 Begin
   For L := 1 to TMsg do
    Begin
    if GetMsgHdr(Hdr,Brd,l-1,True) then
       Begin
      if Not (MsgDeleted in Hdr.MsgType) Then
         Begin
           Assign(MsgTxtFile,Brd.Path+Brd.fileName+'.TXT');
       {$i-}  reset(MsgTxtFile); {$I+}
         if Ioresult <> 0 then
         Begin
           writeln('Problem :'+Brd.Path+Brd.FileName+'.TXT');
          halt(1);
         End;
           Seek(MsgTxtFile,Hdr.MsgTxtPtr);
           Assign(MsgTxtFile2,Brd.Path+Brd.FileName+'.TX2');
           {$i-} reset(MsgTxtFile2); {$i+}
                if  (IoResult <> 0) then
                      rewrite(MsgTxtFile2);
               SeekPlace :=FileSize(MsgTxtFile2);
               Seek(MsgTxtFile2,SeekPlace);
           RecordsRead := 1;
         repeat
              read(MsgTxtFile,Txt);
              Txt2 := Txt;
              write(MsgTxtFile2,Txt2);
              Inc(RecordsRead);
         Until (Eof(MsgTxtFile)) or (RecordsRead-1 >= Hdr.MsgTxtRecs);

         Close (MsgTxtFile);
         Close(MsgTxtFile2);

         Hdr.MsgTxtPtr  := SeekPlace;
         Hdr.MsgTxtRecs := RecordsRead-1;
          Assign(MsgHdrFile,Brd.Path+Brd.FileName+'.HD2');
  {$I-}   reset(MsgHdrFile); {$I+}
        if (IoResult <> 0) then
           rewrite(MsgHdrFile);

           Seek(MsgHdrFile,FileSize(MsgHdrFile));
           write(MsgHdrFile,Hdr);
           Close(MsgHdrFile);
                Inc(MsgCount);
               End; { Get MsgTxt}
      End else { GetMsgHdr }     (* possible problems with all these *)
   End; { FOR MSGin Base }       (* End else so check them if a problem happens *)
         Brd.LastMsg   := MsgCount+1;
         Brd.TotalMsgs := MsgCount+1;
         Save_BrdFile(Brd,Board);
         ChangeFileNames(Brd);
 End;
         BackUp(Length(Str));
 End; { FOR }

End;



Procedure ReplyChains;
Var
 Hdr : MsgHdrRecord;
 i   : integer;
 l   : Longint;

Begin
 nl;
 sprint('^0R^9eply chains...');
 nl;
 for I := 1 to MaxBoards do
 Begin
    ActualLoadMsgBoard(Brd,i,TRUE);
         for L := 1 to Brd.TotalMsgs do  { Build reply chains here someday! }
         Begin
          if GetMsgHdr(Hdr,Brd,l-1,TRue) then
            Begin
             Hdr.Reply[ThisRec]    := l-1;
             Hdr.Reply[NextRec]    := -1;
             Hdr.Reply[PreviousRec]:= -1;
             Save_HdrFile(Hdr,l-1);
            End;
       End; { For }
  End; { For }
End;

Procedure ImportFido;
Var
 I : Word;
 Str : String;

Begin
 I := 0;
 nl;
 repeat
    Inc(i);
    ActualLoadMsgBoard(Brd,i,TRUE);
   if (EchoBase in Brd.MsgBaseType) then
   Begin
     Str :=#3#5+'Scanning for Incoming Messages '+Brd.Name;
       sprompt(Str);
       ImportFidoMsgs(Brd);
     BackUp(length(Str));
   End;
 Until (I >= MaxBoards);

End;


Procedure ImportFidoPkt;
Var
 BufCount,ii : Word;
 Str : String;
 BrdBuf : BrdBufType;

Begin
 nl;
 BufCount := 1;
 for II := 1 to MaxBoards do
  Begin
   ActualLoadMsgBoard(Brd,ii,False);
  if (EchoBase in Brd.MsgBaseType) then
   Begin
     BrdBuf[BufCount].BName   := TrimSpaces(Brd.TagName);
     BrdBuf[BufCount].BNumber := ii;
     Inc(BufCount);
   End;
  End;

  ImportPkt2BBS(BrdBuf,BufCount);

End;

Procedure ExportFidoWithScanFile;

 Var
  ScanFile : File of ScanEchoRecord;
  Scan     : ScanEchoRecord;
  Str          : String;
  iii,I        : Word;
  Done,
  FileOpen,
  UsingEXPList : Boolean;
  MyMsgToGet   : Longint;
  Hdr          : MsgHdrREcord;
  Txt          : MsgTxtRecord;

Begin
 I := 0;
 UsingEXPList :=  Exist(Start_dir+'\ECHOMAIL.EXP');
 FileOpen := False;
 nl;
 If (UsingExpList) then
 repeat

   If (Not FileOpen) then
   Begin
    Assign(ScanFile,Start_Dir+'\ECHOMAIL.EXP');
    {$I-} reset(ScanFile); {$I+}
   End;  { Not FileOpen }

    if (Ioresult = 0) then
   Begin
    Fileopen := TRUE;
    Read(ScanFile,Scan);
  If Eof(ScanFile) then
    begin
     FileOpen := False;
     Close(ScanFile);
     Erase(ScanFile);
    End;
   End else
    Begin      { IoResult <> 0 }
     FileOpen := False;
    End;

    I := Scan.ScanBoardNum;
    ActualLoadMsgBoard(Brd,i,TRUE);
    MyMsgToGet := Scan.ScanMsgNum-1;


   if (EchoBase in Brd.MsgBaseType) AND (Brd.TotalMsgs > 1) then
  begin
  Str := #3#4+'Checking for outgoing mail in '+Brd.Name;
  Sprompt(Str);
     if GetMsgHdr(Hdr,Brd,MyMsgToGet,TRue) then
        Begin
         if (Not (Sent in Hdr.MsgType)) then
         Begin
             NewBuffer(Txt.TBuffer);
          if GetMsgTxt(Hdr,Txt,Brd) then
           Begin
             WriteFidoMsg(Hdr,Txt,Brd,i,FALSE,'');
         If (DebugMode) then
            writeln(' Exporting message #',MyMsgToGet,' in ',Brd.TagName);
             ExitErrorLevel := UnScanEL;

           End;
          End;
         End;
      Inc(MyMsgTOGet);

     Done := Not FileOpen;
    BackUp(Length(Str));
   End;
    Until (Done);
End;


Procedure ExportFido;

 Var
  Str          : String;
  iii,I        : Word;
  MyMsgToGet   : Longint;
  Hdr          : MsgHdrREcord;
  Txt          : MsgTxtRecord;

Begin
 if (UseExportList) AND  (Exist(Start_dir+'\ECHOMAIL.EXP')) then
    Begin
     ExportFidoWithScanFile;
     Exit;
    End;

 I := 0;
 nl;
 repeat

    Inc(i);
    ActualLoadMsgBoard(Brd,i,TRUE);
    MyMsgToGet := Brd.FirstMsg;

   if (EchoBase in Brd.MsgBaseType) AND (Brd.TotalMsgs > 1) then
  begin
  Str := #3#4+'Checking for outgoing mail in '+Brd.Name;
  Sprompt(Str);
    repeat
     if GetMsgHdr(Hdr,Brd,MyMsgToGet,TRue) then
        Begin
         if (Not (Sent in Hdr.MsgType)) then
         Begin
             NewBuffer(Txt.TBuffer);
          if GetMsgTxt(Hdr,Txt,Brd) then
           Begin
             WriteFidoMsg(Hdr,Txt,Brd,i,FALSE,'');
         If (DebugMode) then
            writeln(' Exporting message #',MyMsgToGet,' in ',Brd.TagName);
           End;
          End;
         End;
      Inc(MyMsgTOGet);
    Until (MyMsgToGet > Brd.TotalMsgs-1);

    BackUp(Length(Str));
  End;
  Until (I >= MaxBoards);
End;


Procedure MakeAreasBBS;
Var
 D      : DownLinkRecord;
 I : longint;
 t : text;
 str :string;
Begin
 i := 0;
 assign(t,'areas.lst');
 rewrite(t);
 writeln(t);
  repeat
     Inc(i);
     ActualLoadMsgBoard(Brd,i,False);
   if  Load_DownLinks(D,Brd) then
     begin
     if (echobase in Brd.MsgBaseType) then
      Begin
     str := Cstr(d.addr[1].zone)+':'+Cstr(d.addr[1].net)+ '/'+
            Cstr(d.addr[1].node);
     writeln(t,AllCaps(Brd.Path)+' '+AllCaps(Brd.TagName)+' '+str);
     end;
     end;
   Until (I >= MaxBoards);
 close(t);
end;


Procedure PurgeFidoMsgs;
Var
 I,ii : longint;
 t : text;
 Done : Boolean;
Begin
 i := 0;
  sprompt(#3#4+'Purging old *.MSG''s ...');
  repeat
     Inc(i);
     ActualLoadMsgBoard(Brd,i,TRUE);
     ii := 0;
     Done := False;
  repeat
     inc(ii);
     If Exist(Brd.Path+'\'+Cstrl(ii)+'.MSG') then
      Begin
        assign(t,Brd.Path+'\'+Cstrl(ii)+'.MSG');
        rewrite(t);   close(t);       erase(t);
       End else
         Done := TRUE;
               {  if (I >= 32500) then  Done := True;   }
  until (Done);
  Until (I >= MaxBoards);
  nl;
end;

Procedure ShowCommands;
Var
 I : integer;
Begin
 window(1,1,80,25);
 TextAttr := 14;
 ClrScr;
 writeln('Usage for "MMail [COMMAND PARAMETERS]" ');
 writeln;
 writeln('  /I to Import Fido style *.MSG files.');
 writeln('  /A to create something simular to areas.bbs called areas.lst.');
 writeln('  /M to Mark Deleted using MsgBrds.DAT settings.');
 writeln('  /P to Pack message bases (remove deleted msgs).');
 writeln('  /E to Export Echo/Netmail messages to Fido Style *.MSG.');
 writeln('  /U to Export Using ECHOMAIL.EXP.');
 writeln('  /F to FORCE re-writting every message base *.TXT file.');
 writeln('  /D to delete (ALL) *.MSG files.');
 writeln('  /X to  import *.PKT''s into the BBs message base.(not complete)');
 writeln('  /Q to reindex the quickIDX file GMAIL.DAT. ');
 writeln('  /1 to force debug mode.');
 writeln;
 writeln('** A Nightly maint would look like this :');
 writeln('   MMAIL /M /P');
 writeln('** To EXPORT fidonet style mail :');
 writeln('   MMAIL /E');
 writeln('** To IMPORT fidonet style mail :');
 writeln('   MMAIL /I');
 TextAttr := 1;
End;


Procedure MMailStartUp;

Begin
 ExitErrorLevel := NoEl;
 Window(1,1,80,6);
 nl;
 sprompt(#3#5+centre('MashMail Mail Processor and MsgBase Packer!'));
 sprompt(#3#0+centre('Copyright by Mike Wilson 1991; ALL RIGHTS RESERVED!'));
 nl;
   GetBrdFileInfo;
 Window(1,7,80,25);
End;

                (* <<<<<<<<<<<<<<<<<< MAIN >>>>>>>>>>>>>>>>> *)

Var
 Str : String;
 I   : Integer;
 Vercs,VerType,
 OvrPath : String;

Begin
 FileMode := 66;  { Shareable }
 StartUp;
 MMailStartUp;
 findvertypeout(Ovrpath,vercs,vertype,vertypes,serialnumber,licenseinfo);
                  ver:=ver+' '+vertype;

  Str := '';
  for I := 1 to ParamCount do
    Str := Str + AllCaps(ParamStr(i));

  ForceAllPack  := (Pos('/F',Str)) <> 0;
  DebugMode     := (Pos('/1',Str)) <> 0;
  UseExportList := (Pos('/U',Str)) <> 0;

  if (Pos('/I',Str)) <> 0 then
                    ImportFido;
  if (Pos ('/X',Str)) <> 0 then
                 ImportFidoPkt;

  ForceAllPack :=
     (Pos('/F',Str)) <> 0;
  DebugMode :=
     (Pos('/1',Str)) <> 0;

  If (Pos('/E',Str)) <> 0 then
                    ExportFido;
  If (Pos('/D',Str)) <> 0 then
                 PurgeFidoMsgs;
  if (Pos('/M',Str)) <> 0 then
                   MarkDeleted;
  if (Pos('/P',Str)) <> 0 then
     Begin
      PackBases;
     { ReplyChains; }
     End;
  if (Pos('/A',Str)) <> 0 then
                 MakeAreasBBS;
  if (Pos('/Q',Str)) <> 0 then
              ReIndexQuickIDX;
     if (ParamCount <=0) then
               ShowCommands;
   CursorOn(TRUE);
   writeln;
   sprint(#3#8+'DONE!!! COMPLETE!!! FINISHED!!!  ENDING!!!');
   Halt(ExitErrorLevel);
End.


